/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Folger 12/30/09 GRAPHLAYER_UID_FIX											*
 *	Sophy 1/7/2010 ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION			*
 *	Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
 *	Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU				*
 *	Folger 01/12/09 QA81-14832 QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU
 *	Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
 *	Folger 01/12/09 QA81-14832 OUTPUT_QUICKFIT_PARAMETERS_TO_FIT_CURVE_COLUMN_PARAMETER_LABEL
 *	Folger 01/14/09 QA81-14832 SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS	*
 *	Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI		*
 *	Sophy 1/15/2010 QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG			*
 *	Sophy 1/15/2010 QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG			*
 *	Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS				*
 *  Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG										*
 *  Iris 1/19/2010 ADD_QUICK_FIT_MODE											*
 *	Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS			*
 *	Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT				*
 *  Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN					*
 *	Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI					*
 *	Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
 *  Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO					*
 *	Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST							*
 *  Iris 1/23/2010 REMOVE_APPLY_BUTTON_FROM_TEXT_BOX_TAB						*
 *	Folger 01/23/10 QA81-14903 NEW_ADDED_FUNCTION_SHOULD_BE_SHOWN_IN_FIRST_PLACE*
 *	Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN			*
 *  Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT										*
 *  Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES							*
 *  Iris 1/23/2010 CORRECT_SOPHY_FINDXY_SIGN_DIGITS_CODES						*
 *  Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY					*
 *  Iris 1/26/2010 TO_REMOVE_NOT_RELATED_CATEGORY								*
 *	Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT						*
 * 	Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB									*
 *	Hong 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX		*
 *	Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB		*
 *	Folger 01/27/10 REPORT_STRINGS_HAVE_EXTRA_TABS_WHEN_PASTE_TO_EXCEL			*
 *  Iris 1/29/2010 SET_QUICK_FIT_CURVE_COLOR									*
 *	Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
 *	Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
 *  Iris 2/01/2010 IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND					*
 *  Iris 2/01/2010 USE_COMMON_REPLACE_CHECK										*
 *	Sophy 2/1/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT					*
 *  Iris 2/01/2010 FIX_APPEAR_CONTEXT_MENU_WHEN_RIGHT_CLICK_COL_HEADER			*
 *	Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES			*
 *	Folger 02/02/10 QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN		*
 *	Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION*
 *	Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG					*
 *  Iris 2/03/2010 QA81-15078 FIX_FINDXY_BUG									*
 *	Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI		*
 *	Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU				*
 *  Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG						*
 *	Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE									*
 *  Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES				*
 *  Iris 2/10/2010 QA81-15099 FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO*
 *	CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED							*
 *	CPY 2/19/10 QUICK_FIT_REMOVE_REPLACE_LAST_CHK_WITH_2_CMD_MENU				*
 *	CPY 2/19/10 HIDE_BLACK_PANEL_BOUNDING_RECT_IN_PREFERENCE_DLG				*
 *  Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *  Iris 2/20/2010 QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT	*
 *	Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX*
 *	Iris 2/22/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR							*
 *  Iris 2/21/2010 FIX_RUNTIME_ERROR_WHEN_DATA_TYPE_IS_SHORT_INT				*
 *	CPY 2/22/2010 FIT_LINE_AUTO_COLOR_LEAD_TO_BLACK_FIT_ON_BLACK_DATA			*
 *	Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY		*
 *  Iris 2/25/2010 ONLY_SHOW_APPLY_BUTTON_ON_ROI_TAB							*
 *  Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE		*
 *	Sophy 2/25/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY			*
 *	Sophy 3/1/2010 UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG			*
 *	Sophy 3/1/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI					*
 *	Sophy 3/3/2010 ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE				*
 *	Sophy 3/3/2010 WRONG_LENGEND_DUE_TO_XYRANGE_SETOUTPUTCOMMENT_DELAY			*
 *	Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS		*
 *	Kyle 03/12/2010 FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL
 *	Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT							*
 *	Folger 03/19/10 QA81-15218 ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
 *	Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
 *	Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
 *	Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2			*
 *	Folger 04/12/10 QA81-15300-P2 QUICKFIT_OUTPUT_XVALUES_FAILED_FOR_LOOSE_DATASET
 *	Folger 04/20/10 HIDE_LAST_LABEL_BOX_ONLY_IF_REPLACE_LAST_REPORT				*
 *	Folger 09/19/2010 ORG-1095-P1 QUICK_FIT_CURVE_COLOR_FOLLOW_SOURCE_IF_SCATTER*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <stats_utils.h>
//---- CPY 10/27/2010 MAKING_851_BUILD_WITH_NO_VSFLEX
#include "DialogEx.h"
#include <TreeEditor.h>
//----
#include "GridControl.h"
#include "GridTableControl.h"			///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
#include "nlsf_utils.h"
#include "graph_utils.h"
#include "NLFitSession.h"

#include "grobj_utils.h"
#include "GraphObjTools.h"
#include "XFunctionEx.h"


#include "QuickFit.h"

#define XFNAME "addtool_quickfit"
#define	TOOLNAME	_L("Gadget Quick Fit")
#define	TOOL_PREFERENCES_TITLE	_L("Quick Fit")


#define STR_FUNC_NAME_NL		_L("NLFit")

//----Iris 1/27/2010 CHANGE_POLY_FUNCTION_LIST
//#define STR_MULTI_POLY_FUNC_NAME _L("th Order Polynomial")
#define STR_MULTI_POLY_FUNC_NAME _L("th Order")
#define STR_POLY				_L("Polynomial")
//----End CHANGE_POLY_FUNCTION_LIST
#define STR_APPARENT_FIT		_L("Apparent") /// Iris 2/04/2010 SHOW_APPARENT_FIT_IN_LABEL

/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
#define STR_NEW_FIT_CURVE_BOOK_NAME 	_L("QuickFit1")
#define STR_NEW_FIT_CURVE_SHEET_NAME 	_L("FitCurve1")
///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
////////////////Quick Fit Edit Dialog/////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
// The following category not want list in Add Function context menu.
#define	STR_QUICK_FIT_NLF_SECTION				"Quick Fit"
/// Iris 1/26/2010 TO_REMOVE_NOT_RELATED_CATEGORY
#define	STR_SURFACE_FIT_NLF_SECTION				"Surface Fitting"
#define	STR_PFW_NLF_SECTION						"PFW"
#define STR_BASELINE_NLF_SECTION				"Baseline"
#define STR_POLU_NLF_SECTION					"Polynomial"
///End TO_REMOVE_NOT_RELATED_CATEGORY

#define STR_FUNCTIONS_MENU_EMPTY_ITEM			_L("Empty")

/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
/*
#define TABLE_LABEL_DATETIME		_L("Operation Time")
#define TABLE_LABEL_FUNCTION		_L("Model")
*/
///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
#define TABLE_LABEL_EQUATION		_L("Equation")
/// Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
#define TABLE_LABEL_FUNCTION		_L("Function")
//----- CPY 2/16/2010 RENAME_INPUT_TO_SOURCE_PLOT
//#define TABLE_LABEL_INPUT			_L("Input")
//#define TABLE_LABEL_INPUT_ROW_INDEX			_L("Input Range Index") /// Hong 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
//#define TABLE_LABEL_OUTPUT			_L("Output")
/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
//#define TABLE_LABEL_INPUT_LEGEND			_L("Plot Legend")
//#define TABLE_LABEL_INPUT					_L("Input")
//#define TABLE_LABEL_INPUT_ROW_INDEX			_L("Range Indices")
//#define TABLE_LABEL_OUTPUT					_L("Output")
#define TABLE_LABEL_INPUT					_L("Input")
#define TABLE_LABEL_ADD_INPUT_RANGE			_L("Range")
#define TABLE_LABEL_OUTPUT					_L("Output")
#define TABLE_LABEL_LEGEND_SYMBOLS			_L("Add Legend Symbols")
/// end IMPROVE_GUI_OF_INPUT_OUTPUT
//-----
/// end QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
#define TABLE_LABEL_WEIGHTING		_L("Weighting")
#define TABLE_LABEL_VALUE			_L("Value")
#define TABLE_LABEL_ERROR			_L("Error")
/// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//#define TABLE_LABEL_REDUCE_CHISQ	_L("Reduced Chi-Sqr")
#define TABLE_LABEL_REDUCE_CHISQ	STR_SHOW_TOP_REDUCE_CHISQ
/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
#define TABLE_LABEL_ADJ_RSQR		STR_SHOW_TOP_ADJ_R_SQUARE

///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
#define	TABLE_LABEL_NUM_OF_ITER		_L("Number of Iterations")
#define	TABLE_LABEL_FIT_STATUS		_L("Fit Status")
///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS

//---CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
#define ID_REPORT_BOX_LAST_CNTRL	IDC_COMBO_SIGNIFICANT_DIGITS
//#define ID_2ND_GROUP_1ST_CNTRL		IDC_GROUP_OUTPUT_CONTENTS 
//---

///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
//#define STR_QFEDIT_COLS							_L("|Functions")
//----Iris 1/26/2010 change column name on wiki suggestion
//#define STR_QFEDIT_COLS							_L("|Function|Formula")
#define STR_QFEDIT_COLS							_L("|Function|Equation")
//----

/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
enum
{
	DATA_NONE,
	DATA_RANGE_SNAME,
	DATA_RANGE_LNAME,
	DATA_LONGNAME_ONLY,
	DATA_PLOT_LEGEND,
};
#define	STR_DATA_COMBO					_L("None|[Book]Sheet!Short Name|[Book]Sheet!Long Name|Long Name Only|Plot Legend")
enum
{
	ADDRANGE_NONE,
	ADDRANGE_INDICES,
	ADDRANGE_XVALUES,
};
#define	STR_ADD_RANGE_COMBO				_L("None|Indices|X Values")
/// end IMPROVE_GUI_OF_INPUT_OUTPUT

#define	QFEDIT_FUNCTION_COL_WIDTH				1200
///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN

#define QFEDIT_FIXED_COL_WIDTH					200

#define FINDX_MAX_NUM							10 /// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
enum 
{
	QFEDITCOLTYPE_FIXED,
	QFEDITCOLTYPE_FUNC,
	///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	QFEDITCOLTYPE_FORMULA,
	///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	QFEDITCOLTYPE_TOTAL,
};

enum
{
	LIST_CONTROL_CONTEXT_MENU_INVALID,
	LIST_CONTROL_CONTEXT_MENU_MOVE_UP,
	LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN,
	LIST_CONTROL_CONTEXT_MENU_REMOVE,
};

/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
/*
/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
enum {
	ADD_TEXTBOX_NONE,
	ADD_TEXTBOX_NEW,
	ADD_TEXTBOX_OVERWRITE_EXISTING
};
///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
*/
///End USE_COMMON_REPLACE_CHECK

/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT
enum {
	FINDXY_OUTPUT_TO_SCRIPT_WND,
	FINDXY_OUTPUT_TO_RESULT_LOG,
	FINDXY_OUTPUT_TO_WKS
};
///End IMPROVE_FINDXY_OUTPUT


class GridContextMenu : public Menu
{
public:
	GridContextMenu(const vector<int>& vnCmds, const vector<bool>& vbEnable)
	{
		for(int ii=0; ii<vnCmds.GetSize(); ii++)
		{
			int nFlags = MF_STRING;
			if(!vbEnable[ii])
				nFlags |= MF_GRAYED | MF_DISABLED;
			switch(vnCmds[ii])
			{
			case LIST_CONTROL_CONTEXT_MENU_INVALID:
				Add("", OnMenuItem, MF_SEPARATOR);
				break;

			case LIST_CONTROL_CONTEXT_MENU_MOVE_UP:
				Add(_L("Move Up"), OnMenuItem, nFlags, LIST_CONTROL_CONTEXT_MENU_MOVE_UP);
				break;
				
			case LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN:
				Add(_L("Move Down"), OnMenuItem, nFlags, LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN);
				break;
				
			case LIST_CONTROL_CONTEXT_MENU_REMOVE:
				Add(_L("Remove"), OnMenuItem, nFlags, LIST_CONTROL_CONTEXT_MENU_REMOVE);
				break;

			default:
				ASSERT(false);
			}
		}
	}
	void OnMenuItem(UINT nPos)
	{
	}
};

class FuncListControl : public GridListControl
{
public:
	FuncListControl()
	{
	}
	
	void Init(int nID, WndContainer &dlg)
	{
		GridListControl::Init(nID, dlg);

		SetReady(false);
		SetAllowSelection(true);
		SetSelection(flexSelectionListBox);
		SetEditable();
		SetupRowsCols(1, 1, -1, QFEDITCOLTYPE_TOTAL);
		SetColHeader(STR_QFEDIT_COLS);
		SetupColTypes();
		SetColWidth(QFEDITCOLTYPE_FIXED, QFEDIT_FIXED_COL_WIDTH);
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		SetColWidth(QFEDITCOLTYPE_FUNC, QFEDIT_FUNCTION_COL_WIDTH);
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		SetExtendLastCol(true);
		m_flx.ExplorerBar = flexExMoveRows;
		SetReady();
	}

	void UpdateList(const vector<string>& vsFuncs
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		, const vector<string>& vsFormulas
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		)
	{
		ClearAll();
		AddRows(vsFuncs
			///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			, vsFormulas
			///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			);
	}

	int GetList(vector<string> &vsFuncs, bool bSelected = false)
	{
		vector<uint> vnRows;
		if( bSelected )
		{
			GetSelRows(vnRows);
		}
		else
		{
			if( GetNumRows() == 0 )
				return 0;
			
			vnRows.Data(0, GetNumRows() - 1, 1);
			int nRowOffset = GetRowOffset();
			vnRows += nRowOffset;
		}
		vsFuncs.SetSize(vnRows.GetSize());

		int nColOffset = GetColOffset();
		for (int ii=vnRows.GetSize()-1; ii>=0; ii--)
		{
			vsFuncs[ii] = GetCell(vnRows[ii], QFEDITCOLTYPE_FUNC);
		}
		return vsFuncs.GetSize();
	}

	int RemoveSelected()
	{
		vector<uint> vnSelected;
		GetSelRows(vnSelected);
		vnSelected.Sort();
		
		for (int ii=vnSelected.GetSize()-1; ii>=0; ii--)
			DeleteRow(vnSelected[ii]);

		RemoveSelection();
		return vnSelected.GetSize();
	}
	
	int OnBeforeMouseDown(short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		int nRow = m_flx.MouseRow;
		int nCol = m_flx.MouseCol;
		/// Iris 2/01/2010 FIX_APPEAR_CONTEXT_MENU_WHEN_RIGHT_CLICK_COL_HEADER
		if( nRow < m_flx.FixedRows )
			return LIST_CONTROL_CONTEXT_MENU_INVALID;
		///End FIX_APPEAR_CONTEXT_MENU_WHEN_RIGHT_CLICK_COL_HEADER
		
		if(nButton != MK_RBUTTON || nShift != 0)
			return LIST_CONTROL_CONTEXT_MENU_INVALID;

		vector<uint> vnRows;
		GetSelRows(vnRows);
		if(nRow < 0 || nCol < 0)
		{
			RemoveSelection();
		}
		else
		{
			vector<uint> vec;
			if(vnRows.Find(vec, nRow) <= 0)
				SelRow(nRow);
		}
		GetSelRows(vnRows);
		if( vnRows.GetSize() <= 0 )		// no selection
			return LIST_CONTROL_CONTEXT_MENU_INVALID;

		vector<int> vnCmds;
		vector<bool> vbEnable;
		if( !GetValidCmds(vnRows, vnCmds, vbEnable) )
		{
			return LIST_CONTROL_CONTEXT_MENU_INVALID;
		}
		GridContextMenu myMenu(vnCmds, vbEnable);

		int    nx = XTwipsToPixels(X);
		int    ny = YTwipsToPixels(Y);
        ClientToScreen(nx, ny);

		int nCmd = 0;
		myMenu.TrackPopupMenu(0, nx, ny, GetDlgSafeHwnd(), &nCmd);
		switch(nCmd)
		{
		case LIST_CONTROL_CONTEXT_MENU_MOVE_UP:
		case LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN:
			{
				bool bMoveUp = nCmd == LIST_CONTROL_CONTEXT_MENU_MOVE_UP;
				MoveUpDown(vnRows, bMoveUp);
				if(bMoveUp)
					vnRows -= 1;
				else
					vnRows += 1;
				RemoveSelection();
				SelRows(vnRows);
			}
			break;

		case LIST_CONTROL_CONTEXT_MENU_REMOVE:
			RemoveSelected();
			break;
		default:
			return LIST_CONTROL_CONTEXT_MENU_INVALID;
		}

		return nCmd;
	}

	
	bool HasSelection()
	{
		vector<uint> vnSelected;
		GetSelRows(vnSelected);
		return vnSelected.GetSize() > 0;
	}

protected:
	bool GetValidCmds(const vector<uint>& vnSelRows, vector<int>& vnCmds, vector<bool>& vbEnable)
	{
		if(vnSelRows.GetSize() == 0)
			return false;

		vector<int> vnCmdList = {	LIST_CONTROL_CONTEXT_MENU_MOVE_UP, LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN, LIST_CONTROL_CONTEXT_MENU_INVALID, LIST_CONTROL_CONTEXT_MENU_REMOVE	};
		vnCmds = vnCmdList;
		vbEnable.SetSize(vnCmds.GetSize());
		vbEnable = false;

		vector<int> vnEnableCmds;
		BOOL bEnableMove = true;
		for(int ii=vnSelRows.GetSize()-1; ii>0; ii--)
		{
			if(vnSelRows[ii] != vnSelRows[ii-1] + 1)
			{
				bEnableMove = false;
				break;
			}
		}
		if(bEnableMove)
		{
			if( vnSelRows[0] > GetRowOffset() )
				vnEnableCmds.Add(LIST_CONTROL_CONTEXT_MENU_MOVE_UP);
			if( vnSelRows[vnSelRows.GetSize()-1] < GetRowOffset() + GetNumRows() - 1 )
				vnEnableCmds.Add(LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN);
		}
		vnEnableCmds.Add(LIST_CONTROL_CONTEXT_MENU_REMOVE);

		if(vnEnableCmds.GetSize())
		{
			vector<uint> vec;
			for(int ii=vnEnableCmds.GetSize()-1; ii>=0; ii--)
			{
				if(vnCmds.Find(vec, vnEnableCmds[ii]) > 0)
				{
					vbEnable[vec[0]] = true;
				}
				else
				{
					ASSERT(false);
				}
			}
		}

		return true;
	}

	void MoveUpDown(const vector<uint>& vnRows, bool bMoveUp)
	{
		if(vnRows.GetSize() == 0)
			return;

		for(int ii=vnRows.GetSize()-1; ii>0; ii--)		// check if continuous
			if(vnRows[ii] != vnRows[ii-1] + 1)
				return;

		vector<uint> vnTmpRows;
		vnTmpRows = vnRows;
		vector<string> vsCells;
		for(ii=0; ii<vnTmpRows.GetSize(); ii++)
		{
			string strFunc = GetCell(vnTmpRows[ii], QFEDITCOLTYPE_FUNC);
			vsCells.Add(strFunc);
		}

		if(bMoveUp)
		{
			int nUpperRow = vnTmpRows[0] - 1;
			string strFunc = GetCell(nUpperRow, QFEDITCOLTYPE_FUNC);
			vsCells.Add(strFunc);
			vnTmpRows.InsertAt(0, nUpperRow);
		}
		else
		{
			int nLowerRow = vnTmpRows[vnTmpRows.GetSize()-1] + 1;
			string strFunc = GetCell(nLowerRow, QFEDITCOLTYPE_FUNC);
			vsCells.InsertAt(0, strFunc);
			vnTmpRows.Add(nLowerRow);
		}

		for (ii=vnTmpRows.GetSize()-1; ii>=0; ii--)
			SetCell(vnTmpRows[ii], QFEDITCOLTYPE_FUNC, vsCells[ii]);
	}

	int AddRows(const vector<string>& vsFuncs
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		, const vector<string>& vsFormulas
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		)
	{
		int nSize = vsFuncs.GetSize();
		int nRow = GetRows();
		SetRows(nRow + nSize - GetRowOffset());
		int nColOffset = GetColOffset();
		
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		//for (int ii=0; ii<nSize; ii++)
		//{
			//SetCell(nRow + ii, QFEDITCOLTYPE_FUNC, vsFuncs[ii]);
		//}
		//SetCells(vsFuncs, QFEDITCOLTYPE_FUNC);
		//SetCells(vsFormulas, QFEDITCOLTYPE_FORMULA);
		SetCells(vsFuncs, QFEDITCOLTYPE_FUNC - nColOffset);
		SetCells(vsFormulas, QFEDITCOLTYPE_FORMULA - nColOffset);
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		return nSize;
	}

protected:
	void	SetupColTypes()
	{
		int nCol;
		for(nCol = 0; nCol < m_flx.Cols; nCol++)
		{
			switch(nCol)
			{
			case QFEDITCOLTYPE_FUNC:
				SetColDataType(nCol, flexDTString);
				break;
			default:
			}
		}		
	}
};


/*
class QuickFitEditMenu : public Menu
{
private:
	class CMapIDCategory
	{
	public:
		bool	Add(int nBegin, int nEnd, LPCSTR lpcszCategory)
		{
			if(nBegin > nEnd)
				return false;
			
			m_vnBegin.Add(nBegin);
			m_vnEnd.Add(nEnd);
			m_vsCategory.Add(lpcszCategory);
			return true;
		}
		
		bool	Find(int nID, string& strCategory)
		{
			for(int ii=m_vnBegin.GetSize()-1; ii>=0; ii--)
			{
				if(nID >= m_vnBegin[ii] && nID <= m_vnEnd[ii])
				{
					strCategory = m_vsCategory[ii];
					return true;
				}
			}
			return false;
		}
		
		void	Clear()
		{
			m_vnBegin.SetSize(0);
			m_vnEnd.SetSize(0);
			m_vsCategory.SetSize(0);
		}
	private:
		vector<int>			m_vnBegin;
		vector<int>			m_vnEnd;
		vector<string>		m_vsCategory;
	};
public:
	QuickFitEditMenu(HMENU &hMenu) : Menu(hMenu)
	{
		m_IDBegin = IDC_BASIC_FUNCTIONS_BEGIN;
		m_IDEnd = IDC_BASIC_FUNCTIONS_END;
		m_IDNext = m_IDBegin;
	}
	
	~QuickFitEditMenu()
	{
	}
	
	bool	GetFunction(UINT nID, string& strCategory, string& strFunction)
	{
		if( !m_map.Find(nID, strCategory) )
			return false;
		return GetMenuString(nID, strFunction, MF_STRING) > 0;
	}
	
	int		Construct()
	{
		Menu popupAdd(GetPopupHmenu(IDC_FUNCTION_MENU_FIT_FUNC));
		if( !popupAdd.GetSafeHmenu() )
		{
			ASSERT(false);
			return -1;			// error
		}
		popupAdd.RemoveAllItems();

		vector<string> vsCategories;
		vector<int> vnSeparatorIndices;
		nlsf_get_category_list(vsCategories, vnSeparatorIndices);

		vector<string> vsFuncs;
		for(int nCate = 0; nCate < vsCategories.GetSize(); nCate++)
		{
			if( vsCategories[nCate].CompareNoCase(STR_QUICK_FIT_NLF_SECTION)==0 )
				continue;

			vector<int> vn;
			if( vnSeparatorIndices.Find(vn, nCate) > 0 )		// separator
			{
				popupAdd.Add("", 0, MF_SEPARATOR);
				continue;
			}

			vector<string> vsFunctions;
			scan_fit_funcs(vsFunctions, vsCategories[nCate], false);

			Menu subMenu;
			if( vsFunctions.GetSize() > 0 )
			{
				int nBeginID = nextID(vsFunctions.GetSize());
				if(nBeginID <= 0)
				{
					return -11;
				}
				m_map.Add(nBeginID, nBeginID + vsFunctions.GetSize() - 1, vsCategories[nCate]);

				for(int nFunc=0; nFunc < vsFunctions.GetSize(); nFunc++)
					subMenu.Add(vsFunctions[nFunc], nBeginID++);
			}
			else
			{
				subMenu.Add(STR_FUNCTIONS_MENU_EMPTY_ITEM, nextID(), MF_GRAYED | MF_DISABLED);
			}
			popupAdd.AddPopup(vsCategories[nCate], subMenu);
		}

		return 0;
	}

private:
	int		nextID(int nSize = 1)
	{
		if(nSize <= 0 || m_IDNext + nSize - 1 > m_IDEnd)		// check the last id: m_IDNext + nSize - 1
		{
			ASSERT(false);
			return 0;
		}
		int nRet = m_IDNext;
		m_IDNext+=nSize;
		
		return nRet;
	}

private:
	int					m_IDBegin;
	int					m_IDEnd;
	int					m_IDNext;
	
	CMapIDCategory		m_map;
};
*/

class NLFFuncs
{
public:
	NLFFunc()
	{
		m_bReady = false;
	}
	
	void InitList()
	{
		if(m_bReady)
			return;
		m_bReady = true;

		vector<int> vnSeparatorIndices;
		nlsf_get_category_list(m_vsCategory, vnSeparatorIndices);
		m_vsFunction.SetSize(m_vsCategory.GetSize());

		for(int nCate = m_vsCategory.GetSize() - 1; nCate >= 0; nCate--)
		{
			if( m_vsCategory[nCate].CompareNoCase(STR_QUICK_FIT_NLF_SECTION)== 0 
				/// Iris 1/26/2010 TO_REMOVE_NOT_RELATED_CATEGORY
				|| m_vsCategory[nCate].CompareNoCase(STR_SURFACE_FIT_NLF_SECTION) == 0
				|| m_vsCategory[nCate].CompareNoCase(STR_PFW_NLF_SECTION) == 0
				|| m_vsCategory[nCate].CompareNoCase(STR_BASELINE_NLF_SECTION) == 0
				|| m_vsCategory[nCate].CompareNoCase(STR_POLU_NLF_SECTION) == 0
				///End TO_REMOVE_NOT_RELATED_CATEGORY
				)
			{
				m_vsCategory.RemoveAt(nCate);
				m_vsFunction.RemoveAt(nCate);
				continue;
			}

			vector<uint> vn;
			if( vnSeparatorIndices.Find(vn, nCate) > 0 )		// separator
			{
				m_vsCategory[nCate] = "";
				m_vsFunction[nCate] = "";
				continue;
			}

			vector<string> vsFuncs;
			scan_fit_funcs(vsFuncs, m_vsCategory[nCate], false);
			string strFuncs;
			strFuncs.SetTokens(vsFuncs, '|');
			m_vsFunction[nCate] = strFuncs;
		}
	}
public:
	vector<string>		m_vsCategory;
	vector<string>		m_vsFunction;
	
	bool				m_bReady;
};

class QuickFitEditAddMenu : public Menu
{
private:
	class CMapIDCateFunc
	{
	public:
		bool	Add(int nBegin, LPCSTR lpcszCategory, const vector<string>& vsFunctions)
		{
			if(vsFunctions.GetSize() <= 0)
				return false;

			m_vnBegin.Add(nBegin);
			m_vnEnd.Add(nBegin + vsFunctions.GetSize() - 1);
			m_vsCategory.Add(lpcszCategory);

			string strFunctions;
			strFunctions.SetTokens(vsFunctions, '|');
			m_vsFunctions.Add(strFunctions);
			return true;
		}
		
		bool	Find(int nID, string& strCategory, string& strFunction)
		{
			for(int ii=m_vnBegin.GetSize()-1; ii>=0; ii--)
			{
				if(nID >= m_vnBegin[ii] && nID <= m_vnEnd[ii])
				{
					strCategory = m_vsCategory[ii];
					
					vector<string> vsFuncs;
					m_vsFunctions[ii].GetTokens(vsFuncs, '|');
					int nIndex = nID - m_vnBegin[ii];
					if( nIndex < vsFuncs.GetSize() )
						strFunction = vsFuncs[nIndex];
					return true;
				}
			}
			return false;
		}
		
		void	Clear()
		{
			m_vnBegin.SetSize(0);
			m_vnEnd.SetSize(0);
			m_vsCategory.SetSize(0);
			m_vsFunctions.SetSize(0);
		}
	private:
		vector<int>			m_vnBegin;
		vector<int>			m_vnEnd;
		vector<string>		m_vsCategory;
		vector<string>		m_vsFunctions;
	};

public:
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	/*
	QuickFitEditAddMenu(const NLFFuncs &nlfFuncs)
	*/
	QuickFitEditAddMenu()
	{
	}
	
	void ConstructFunctions(const NLFFuncs &nlfFuncs)
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	{
		m_IDBegin = IDC_BASIC_FUNCTIONS_BEGIN;
		m_IDEnd = IDC_BASIC_FUNCTIONS_END;
		m_IDNext = m_IDBegin;
		
		Construct(nlfFuncs);
	}
	
	bool	GetFunction(UINT nID, string& strCategory, string& strFunction)
	{
		return m_map.Find(nID, strCategory, strFunction);
	}

	void OnMenuItem(UINT nPos)
	{
	}


protected:
	int		Construct(const NLFFuncs &nlfFuncs)
	{
		for(int nCate = 0; nCate < nlfFuncs.m_vsCategory.GetSize(); nCate++)
		{
			if( nlfFuncs.m_vsCategory[nCate].IsEmpty() )		// separator
			{
				Add("", OnMenuItem, MF_SEPARATOR);
				continue;
			}

			string strFunctions = nlfFuncs.m_vsFunction[nCate];
			vector<string> vsFunctions;
			strFunctions.GetTokens(vsFunctions, '|');

			BeginPopup(nlfFuncs.m_vsCategory[nCate]);

			if( vsFunctions.GetSize() > 0 )
			{
				int nBeginID = nextID(vsFunctions.GetSize());
				if(nBeginID <= 0)
				{
					return -11;
				}
				m_map.Add(nBeginID, nlfFuncs.m_vsCategory[nCate], vsFunctions);

				for(int nFunc=0; nFunc < vsFunctions.GetSize(); nFunc++)
					Add(vsFunctions[nFunc], OnMenuItem, MF_STRING, nBeginID++);
			}
			else
			{
				Add(STR_FUNCTIONS_MENU_EMPTY_ITEM, OnMenuItem, MF_GRAYED | MF_DISABLED, nextID());
			}
			EndPopup();
		}

		return 0;
	}

private:
	int		nextID(int nSize = 1)
	{
		if(nSize <= 0 || m_IDNext + nSize - 1 > m_IDEnd)		// check the last id: m_IDNext + nSize - 1
		{
			ASSERT(false);
			return 0;
		}
		int nRet = m_IDNext;
		m_IDNext+=nSize;
		
		return nRet;
	}

private:
	int					m_IDBegin;
	int					m_IDEnd;
	int					m_IDNext;
	
	CMapIDCateFunc		m_map;
};

///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
class QFitFuncListMngrBase
{
public:
	QFitFuncListMngrBase()
	{
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		//ScanFavFuncs(m_vsFunctions, m_vsFDFFiles);
		ScanFavFuncs(m_vsFunctions, m_vsFDFFiles, m_vsFormulas);
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		SetDirty(false);
	}
	
	bool	SetDirty(bool bDirty = true)
	{
		bool bOldDirty = m_bDirty;
		m_bDirty = bDirty;
		return bOldDirty;
	}

	bool	IsDirty()
	{
		return m_bDirty;
	}
	
	virtual bool Save() { ASSERT(false); return false; }	
	
	bool	Add(int nFitMode, LPCSTR lpcszCategory, LPCSTR lpcszFunction)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());
		
		string strCategory(lpcszCategory);
		string strFunction(lpcszFunction);
		string strFDFFile;
		if( !FindFDFName(strFDFFile, lpcszCategory, lpcszFunction) )
			return false;

		// check if duplicated
		int nIndex = m_vsFunctions.Find(lpcszFunction);
		if(nIndex >= 0)
		{
			if( strFDFFile.CompareNoCase(m_vsFDFFiles[nIndex]) )
			{
				SetDirty();
				m_vsFDFFiles[nIndex] = strFDFFile;
				return true;
			}
			else
				return false;
		}

		SetDirty();
		///------ Folger 01/23/10 QA81-14903 NEW_ADDED_FUNCTION_SHOULD_BE_SHOWN_IN_FIRST_PLACE
		//m_vsFunctions.Add(strFunction);
		//m_vsFDFFiles.Add(strFDFFile);
		m_vsFunctions.InsertAt(0, strFunction);
		m_vsFDFFiles.InsertAt(0, strFDFFile);
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		m_vsFormulas.InsertAt(0, GetFormula(strFunction));
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		///------ End NEW_ADDED_FUNCTION_SHOULD_BE_SHOWN_IN_FIRST_PLACE
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS		
		m_vnOrders.InsertAt(0, quick_fit_get_order(nFitMode, strFunction));
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		return true;
	}
	
	bool	Remove(const vector<string>& vsFunctions)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());
		for(int ii=vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			int nIndex = m_vsFunctions.Find(vsFunctions[ii]);
			if(nIndex >= 0)
			{
				SetDirty();
				m_vsFunctions.RemoveAt(nIndex);
				m_vsFDFFiles.RemoveAt(nIndex);
				///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				m_vsFormulas.RemoveAt(nIndex);
				///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				if( nIndex < m_vnOrders.GetSize() )
					m_vnOrders.RemoveAt(nIndex); 
				///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			}
			else
				ASSERT(false);
		}
		return true;
	}
	
	int		GetFunctions(vector<string>& vsFunctions)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());

		vsFunctions = m_vsFunctions;
		return vsFunctions.GetSize();
	}
	
	///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	int		GetFormulas(vector<string>& vsFormulas)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFormulas.GetSize());
		
		vsFormulas = m_vsFormulas;
		return m_vsFormulas.GetSize();
	}
	///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	
	bool	Reorder(const vector<string>& vsFunctions)			// vsFunctions is the new order
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());

		if(vsFunctions.GetSize() != m_vsFunctions.GetSize())
			return false;

		bool bChanged = false;
		vector<string> vsFDFFile(vsFunctions.GetSize());
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		vector<string>	vsFormulas(vsFunctions.GetSize());
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		vector<int> vnOrders(vsFunctions.GetSize()); ///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		for(int ii=vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			int nIndex = m_vsFunctions.Find(vsFunctions[ii]);
			if(nIndex < 0)
				return false;
			vsFDFFile[ii] = m_vsFDFFiles[nIndex];
			///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			vsFormulas[ii] = m_vsFormulas[nIndex];
			///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			if( nIndex < m_vnOrders.GetSize() )
				vnOrders[ii] = m_vnOrders[nIndex]; 
			///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			bChanged |= (ii != nIndex);
		}
		if( bChanged )
		{
			SetDirty();
			m_vsFunctions = vsFunctions;
			m_vsFDFFiles = vsFDFFile;
			///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			m_vsFormulas = vsFormulas;
			///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			m_vnOrders = vnOrders; ///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		}

		return true;
	}
	
	bool	FilterNotInList(const vector<string>& vsFunctions)
	{
		for(int ii=m_vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			if(vsFunctions.Find(m_vsFunctions[ii]) < 0)		// not in list
			{
				m_vsFunctions.RemoveAt(ii);
				m_vsFDFFiles.RemoveAt(ii);
				///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				m_vsFormulas.RemoveAt(ii);
				///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				if( ii < m_vnOrders.GetSize() )
					m_vnOrders.RemoveAt(ii); 
				///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			}
		}
		SetDirty();
		return true;
	}	
	
protected:
	virtual int ScanFavFuncs(vector<string>& vsFunctions, vector<string>& vsFDFFiles
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		, vector<string>& vsFormulas = NULL
		)
	{ 
		ASSERT(false); 
		return 0;
	}
	
	virtual bool	FindFDFName(string& strFDFName, LPCSTR lpcszCategory, LPCSTR lpcszFunction) 
	{
		strFDFName = "";
		return true;  // regression function not FDF file.
	}
	
	virtual string	GetFormula(LPCSTR lpcszFunction) { ASSERT(false); return ""; }
	
private:
	bool						m_bDirty;

protected:
	vector<string>				m_vsFunctions;
	vector<string>				m_vsFDFFiles;
	///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	vector<string>				m_vsFormulas;
	///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	
	vector<int>					m_vnOrders;
};

#define STR_QUICK_FIT_REGRESSION_SECTION  	"QuickFit"
#define STR_QUICK_FIT_REGRESSION_KEY	  	"Orders"

class QFitRegressionFuncListMngr: public QFitFuncListMngrBase
{	
public:
	QFitRegressionFuncListMngr()
	{
	}
	
	//virtual 
	bool Save() 
	{		
		vector<string> vsOrders;
		convert_int_vector_to_string_vector(m_vnOrders, vsOrders);
		
		string strOrders;
		strOrders.SetTokens(vsOrders, ',');
		
		INIFile iniFile("Origin.ini");
		iniFile.WriteString(STR_QUICK_FIT_REGRESSION_SECTION, STR_QUICK_FIT_REGRESSION_KEY, strOrders);
		return true; 
	}
	
protected:
	//virtual 
	int ScanFavFuncs(vector<string>& vsFunctions, vector<string>& vsFDFFiles
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		, vector<string>& vsFormulas = NULL
		)
	{		
		_get_lr_favorite_order_list(m_vnOrders);
		
		vsFunctions.RemoveAll();
		vsFormulas.RemoveAll();
		for(int nn = 0; nn < m_vnOrders.GetSize(); nn++)
		{
			int nOrder = m_vnOrders[nn];
			string strFunc = quick_fit_get_lr_function_name(nOrder);			
						
			vsFunctions.Add(strFunc);					
			vsFormulas.Add(GetFormula(strFunc));
		}
		vsFDFFiles.SetSize(vsFunctions.GetSize());
		
		return vsFunctions.GetSize();
	}
	
	
	//virtual 
	string	GetFormula(LPCSTR lpcszFunction) 
	{ 
		vector<string> vsParamNames;
		int nOrder = quick_fit_get_order(QUICK_FIT_MODE_LR, lpcszFunction);
		quick_fit_get_func_param_list(vsParamNames, nOrder, lpcszFunction);
		
		QuickFitResults st;
		st.vsParamNames = vsParamNames;
		return _get_equation_fomula(false, lpcszFunction, st, nOrder);
	}	
};
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS


///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
//class QFitFuncListMngr
class QFitNLfitFuncListMngr : public QFitFuncListMngrBase
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
{
public:
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	/*	
	QFitFuncListMngr()
	{
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		//ScanFavFuncs(m_vsFunctions, m_vsFDFFiles);
		ScanFavFuncs(m_vsFunctions, m_vsFDFFiles, m_vsFormulas);
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		SetDirty(false);
	}
	
	bool	SetDirty(bool bDirty = true)
	{
		bool bOldDirty = m_bDirty;
		m_bDirty = bDirty;
		return bOldDirty;
	}

	bool	IsDirty()
	{
		return m_bDirty;
	}
	*/
	QFitFuncListMngr() {}
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	
	// virtual
	bool	Save()
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());
		if( !IsDirty() )
			return true;

		vector<string> vsFunctions, vsFDFFiles;
		ScanFavFuncs(vsFunctions, vsFDFFiles);
		if(vsFunctions.GetSize())			// clear category
		{
			for(int ii=vsFunctions.GetSize()-1; ii>=0; ii--)
				nlsf_update_function(STR_QUICK_FIT_NLF_SECTION, NULL, vsFunctions[ii], NULL);
		}

		for(int ii=0; ii < m_vsFunctions.GetSize(); ii++)
			nlsf_update_function(STR_QUICK_FIT_NLF_SECTION, m_vsFunctions[ii], NULL, m_vsFDFFiles[ii]);

		SetDirty(false);
		return true;
	}
	
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	/*
	bool	Remove(const vector<string>& vsFunctions)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());
		for(int ii=vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			int nIndex = m_vsFunctions.Find(vsFunctions[ii]);
			if(nIndex >= 0)
			{
				SetDirty();
				m_vsFunctions.RemoveAt(nIndex);
				m_vsFDFFiles.RemoveAt(nIndex);
				///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				m_vsFormulas.RemoveAt(nIndex);
				///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			}
			else
				ASSERT(false);
		}
		return true;
	}
	
	bool	Add(LPCSTR lpcszCategory, LPCSTR lpcszFunction)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());
		
		string strCategory(lpcszCategory);
		string strFunction(lpcszFunction);
		string strFDFFile;
		if( !FindFDFName(strFDFFile, lpcszCategory, lpcszFunction) )
			return false;

		// check if duplicated
		int nIndex = m_vsFunctions.Find(lpcszFunction);
		if(nIndex >= 0)
		{
			if( strFDFFile.CompareNoCase(m_vsFDFFiles[nIndex]) )
			{
				SetDirty();
				m_vsFDFFiles[nIndex] = strFDFFile;
				return true;
			}
			else
				return false;
		}

		SetDirty();
		///------ Folger 01/23/10 QA81-14903 NEW_ADDED_FUNCTION_SHOULD_BE_SHOWN_IN_FIRST_PLACE
		//m_vsFunctions.Add(strFunction);
		//m_vsFDFFiles.Add(strFDFFile);
		m_vsFunctions.InsertAt(0, strFunction);
		m_vsFDFFiles.InsertAt(0, strFDFFile);
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		m_vsFormulas.InsertAt(0, GetFormula(strFunction));
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		///------ End NEW_ADDED_FUNCTION_SHOULD_BE_SHOWN_IN_FIRST_PLACE
		return true;
	}
	
	int		GetFunctions(vector<string>& vsFunctions)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());

		vsFunctions = m_vsFunctions;
		return vsFunctions.GetSize();
	}
	
	///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	int		GetFormulas(vector<string>& vsFormulas)
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFormulas.GetSize());
		
		vsFormulas = m_vsFormulas;
		return m_vsFormulas.GetSize();
	}
	///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	
	bool	Reorder(const vector<string>& vsFunctions)			// vsFunctions is the new order
	{
		ASSERT(m_vsFunctions.GetSize() == m_vsFDFFiles.GetSize());

		if(vsFunctions.GetSize() != m_vsFunctions.GetSize())
			return false;

		bool bChanged = false;
		vector<string> vsFDFFile(vsFunctions.GetSize());
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		vector<string>	vsFormulas(vsFunctions.GetSize());
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		for(int ii=vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			int nIndex = m_vsFunctions.Find(vsFunctions[ii]);
			if(nIndex < 0)
				return false;
			vsFDFFile[ii] = m_vsFDFFiles[nIndex];
			///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			vsFormulas[ii] = m_vsFormulas[nIndex];
			///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			bChanged |= (ii != nIndex);
		}
		if( bChanged )
		{
			SetDirty();
			m_vsFunctions = vsFunctions;
			m_vsFDFFiles = vsFDFFile;
			///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			m_vsFormulas = vsFormulas;
			///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		}

		return true;
	}
	
	bool	FilterNotInList(const vector<string>& vsFunctions)
	{
		for(int ii=m_vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			if(vsFunctions.Find(m_vsFunctions[ii]) < 0)		// not in list
			{
				m_vsFunctions.RemoveAt(ii);
				m_vsFDFFiles.RemoveAt(ii);
				///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				m_vsFormulas.RemoveAt(ii);
				///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			}
		}
		SetDirty();
		return true;
	}
	*/
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	
protected:
	//virtual
	bool	FindFDFName(string& strFDFName, LPCSTR lpcszCategory, LPCSTR lpcszFunction)
	{
		vector<int> vnPaths = {USER_FOLDER, ALL_USER_FOLDER};
		for(int ii=0; ii<vnPaths.GetSize(); ii++)
		{
			string strNLSFIniFilePath = nlf_get_ini_filepath(vnPaths[ii]);
			if(strNLSFIniFilePath.IsFile())
			{
				INIFile iniNLSF(strNLSFIniFilePath);
				strFDFName = iniNLSF.ReadString(lpcszCategory, lpcszFunction);
				if( !strFDFName.IsEmpty() )
					return true;
			}
		}
		strFDFName.Empty();
		return false;
	}
	
	// virtual
	int ScanFavFuncs(vector<string>& vsFunctions, vector<string>& vsFDFFiles
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		, vector<string>& vsFormulas = NULL
		)
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	{
		scan_fit_funcs(vsFunctions, STR_QUICK_FIT_NLF_SECTION, false);
		vsFDFFiles.SetSize(vsFunctions.GetSize());
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		if ( vsFormulas )
			vsFormulas.SetSize(vsFunctions.GetSize());
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		
		for(int ii=vsFunctions.GetSize()-1; ii>=0; ii--)
		{
			string strFDFName;
			if( FindFDFName(strFDFName, STR_QUICK_FIT_NLF_SECTION, vsFunctions[ii]) )
			{
				vsFDFFiles[ii] = strFDFName;
				///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				if ( vsFormulas )
					vsFormulas[ii] = GetFormula(vsFunctions[ii]);
				///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			}
			else
			{
				vsFunctions.RemoveAt(ii);
				vsFDFFiles.RemoveAt(ii);
				///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
				if ( vsFormulas )
					vsFormulas.RemoveAt(ii);
				///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
			}
		}
		ASSERT(vsFunctions.GetSize() == vsFDFFiles.GetSize());
		return vsFunctions.GetSize();
	}

	///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	//virtual
	string	GetFormula(LPCSTR lpcszFunction)
	{
		Tree	trFDF;
		string	strCategory;
		if ( !nlsf_get_FDF_tree_from_func_name(trFDF, lpcszFunction, strCategory) )
		{
			ASSERT(FALSE);
			return "";
		}

		string	strFormula = nlsf_get_formula(trFDF);
		strFormula.Remove('\n');
		strFormula.Remove('\r');
		return strFormula;
	}
	///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	
///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
/*
private:
	bool						m_bDirty;

	vector<string>				m_vsFunctions;
	vector<string>				m_vsFDFFiles;
	///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	vector<string>				m_vsFormulas;
	///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
*/
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
};

///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
enum {
	FUNC_EDIT_LR_TAB,
	FUNC_EDIT_NL_TAB
};

#define STR_FUNC_EDIT_LR_TAB		_L("Polynomial Fit")
#define STR_FUNC_EDIT_NL_TAB		_L("Nonlinear Curve Fit")
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS

class QuickFitEditDlg : public Dialog
{
public:
	QuickFitEditDlg(int nMode = QUICK_FIT_MODE_NL) : Dialog(IDD_QUICK_FIT_EDIT, "ODlg8")
	{
		//m_pDlgMenu = NULL;
		InitMsgMap();
		m_nMode = nMode;
	}

	~QuickFitEditDlg()
	{
		//if(m_pDlgMenu)
			//delete m_pDlgMenu;
	}

	///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
	string	GetSelectedFunc()
	{
		return m_strFuncSelected;
	}
	///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI

protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_OK(OnClickOK)
	ON_CANCEL(OnClickCancel)
	ON_BN_CLICKED(IDC_QUICK_FIT_EDIT_REMOVE, OnRemove)
	//ON_MENU_CMD_RANGE(IDC_BASIC_FUNCTIONS_BEGIN, IDC_BASIC_FUNCTIONS_END, OnAddFunction)
	ON_BN_CLICKED(IDC_QUICK_FIT_EDIT_ADD, OnAdd)
	ON_GRID_SEL_CHANGE(IDC_QUICK_FIT_FAV_GRID, OnGridSelChange)
	ON_GRID_AFTER_MOVE_ROWS(IDC_QUICK_FIT_FAV_GRID, OnAfterMoveRows)
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_QUICK_FIT_FAV_GRID, OnBeforeMouseDownListControl)
	ON_TAB_SEL_CHANGE(IDC_TAB, OnTabChange) ///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS


EVENTS_END

	BOOL OnInitDialog()
	{
		//HWND 	hWnd = GetSafeHwnd();
		//HMENU 	hMenu = GetMenu(hWnd);
		//vector<uint> vnCategoryIDs = {IDC_FUNCTION_MENU_FIT_FUNC};
		//m_pDlgMenu = new QuickFitEditMenu(hMenu);
		//m_pDlgMenu->Construct();
		Text = _L("Edit Quick Fit Function List"); //set window title
		
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		m_tab = GetItem(IDC_TAB);
		m_tab.InsertItem(FUNC_EDIT_LR_TAB, STR_FUNC_EDIT_LR_TAB);
		m_tab.InsertItem(FUNC_EDIT_NL_TAB, STR_FUNC_EDIT_NL_TAB);
		m_tab.SetCurSel(m_nMode);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS	
		
		m_ctrlFuncList.Init(IDC_QUICK_FIT_FAV_GRID, *this);
		UpdateFuncList();

		UpdateButtons();
		return TRUE;
	}
	
	bool saveChange()
	{
		vector<string> vsLRFuncs, vsNLFuncs;
		if( m_mngrQFRegressionFunc.GetFunctions(vsLRFuncs) == 0
			|| m_mngrQFNLfitFunc.GetFunctions(vsNLFuncs) == 0 )
		{
			string strMsg, str = _L("Please keep at least one function in %s list.");
			strMsg.Format(str, vsLRFuncs.GetSize() == 0 ? STR_FUNC_EDIT_LR_TAB : STR_FUNC_EDIT_NL_TAB);
			MessageBox(this->GetSafeHwnd(), strMsg, _L("Attention"));
			return false;
		}
		
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//m_mngrQFFunc.Save();		
		if( m_mngrQFRegressionFunc.IsDirty() )
			m_mngrQFRegressionFunc.Save();
		if( m_mngrQFNLfitFunc.IsDirty() )
			m_mngrQFNLfitFunc.Save();		
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		return TRUE;
	}

	BOOL OnClickOK()
	{
		return saveChange();
	}
	
	BOOL OnClickCancel()
	{
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//if( m_mngrQFFunc.IsDirty() )
		if( isDirty() )
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		{
			string strMsg = _L("Save your changes?");
			int nRet = MessageBox(this->GetSafeHwnd(), strMsg, _L("Attention"), MB_YESNOCANCEL);

			if(IDCANCEL == nRet)
				return false;
			else if(IDYES == nRet)
			{
				///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				//m_mngrQFFunc.Save();
				if( !saveChange() )
					return false;
				///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			}
		}
		return true;
	}

	/*
	BOOL OnAddFunction(int nID)
	{
		if(!m_pDlgMenu)
			return false;

		string strCategory, strFunction;
		if( !m_pDlgMenu->GetFunction(nID, strCategory, strFunction) )
			return false;

		if( m_mngrQFFunc.Add(strCategory, strFunction) )
		{
			UpdateFuncList();
			return true;
		}
		return false;
	}
	*/
	BOOL OnAdd(Control ctrl)
	{
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		/*
		m_nlfFuncs.InitList();
		QuickFitEditAddMenu myMenu(m_nlfFuncs);
		*/			
		Menu* pmyMenu;
		Menu lrMenu;		
		QuickFitEditAddMenu nlMenu;
		
		if( FUNC_EDIT_LR_TAB == m_tab.GetCurSel() )
		{
			vector<int> vnOrders;
			_get_lr_defaul_order_list(vnOrders);
			
			for(int index = 0; index < vnOrders.GetSize(); index++)
			{
				string strFunc = quick_fit_get_lr_function_name(vnOrders[index]);
				
				DWORD dwFlags = MF_STRING;
				lrMenu.Add(strFunc, index, dwFlags);
			}	
			pmyMenu = &lrMenu;			
		}
		else
		{
			m_nlfFuncs.InitList();
			nlMenu.ConstructFunctions(m_nlfFuncs);
			pmyMenu = &nlMenu;
		}
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		
		// right-bottom
		RECT rrAdd;
		Control ctrlAdd = GetItem(IDC_QUICK_FIT_EDIT_ADD);
		ctrlAdd.GetWindowRect(&rrAdd);
		int nx = rrAdd.right;
		int ny = rrAdd.bottom;

		int nCmd = 0;
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//myMenu.TrackPopupMenu(0, nx, ny, GetSafeHwnd(), &nCmd);
		pmyMenu->TrackPopupMenu(0, nx, ny, GetSafeHwnd(), &nCmd);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS

		string strCategory, strFunction;
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//if( myMenu.GetFunction(nCmd, strCategory, strFunction) )
		if( FUNC_EDIT_LR_TAB == m_tab.GetCurSel() )
		{
			int nOrder = nCmd+1;
			strFunction = quick_fit_get_lr_function_name(nOrder);
		}
		else		
		{
			nlMenu.GetFunction(nCmd, strCategory, strFunction);
		}
		if( !strFunction.IsEmpty() )
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS	
		{
			///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
			m_strFuncSelected = strFunction;
			///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
			///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			//if( m_mngrQFFunc.Add(strCategory, strFunction) )
			int nFitMode = FUNC_EDIT_LR_TAB == m_tab.GetCurSel()? QUICK_FIT_MODE_LR : QUICK_FIT_MODE_NL;
			if( getFitFuncListMngrPointer()->Add(nFitMode, strCategory, strFunction) )
			///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			{
				UpdateFuncList();
				return true;
			}
		}
				
		return false;
	}

	BOOL OnRemove(Control ctrl)
	{
		vector<string> vsSelected;
		m_ctrlFuncList.GetList(vsSelected, true);
		ASSERT(vsSelected.GetSize());

		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//m_mngrQFFunc.Remove(vsSelected);
		getFitFuncListMngrPointer()->Remove(vsSelected);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		m_ctrlFuncList.RemoveSelected();

		return TRUE;
	}

	void UpdateFuncList()
	{
		vector<string> vsFuncs;
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//m_mngrQFFunc.GetFunctions(vsFuncs);
		getFitFuncListMngrPointer()->GetFunctions(vsFuncs);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		///------ Folger 01/23/10 QA81-14903 EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
		//m_ctrlFuncList.UpdateList(vsFuncs);
		vector<string>	vsFormulas;
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//m_mngrQFFunc.GetFormulas(vsFormulas);
		getFitFuncListMngrPointer()->GetFormulas(vsFormulas);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		m_ctrlFuncList.UpdateList(vsFuncs, vsFormulas);
		///------ End EDIT_FUNCTION_DIALOG_SHOW_FORMULA_COLUMN
	}

	void OnGridSelChange(Control ctrl)
	{
		UpdateButtons();
	}
	
	void OnAfterMoveRows(Control ctrl, long nRow, long *pnPosition) 
	{
		vector<string> vsFuncs;
		m_ctrlFuncList.GetList(vsFuncs, false);
		if( vsFuncs.GetSize() )
		{
			///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			//m_mngrQFFunc.Reorder(vsFuncs);
			getFitFuncListMngrPointer()->Reorder(vsFuncs);
			///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		}
	}

	BOOL OnBeforeMouseDownListControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel)
	{
		BOOL bRet = false;
		switch( m_ctrlFuncList.OnBeforeMouseDown(nButton, nShift, X, Y, pCancel) )
		{
		case LIST_CONTROL_CONTEXT_MENU_MOVE_UP:
		case LIST_CONTROL_CONTEXT_MENU_MOVE_DOWN:
			{
				vector<string> vsFuncs;
				m_ctrlFuncList.GetList(vsFuncs, false);
				///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				//m_mngrQFFunc.Reorder(vsFuncs);
				getFitFuncListMngrPointer()->Reorder(vsFuncs);
				///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				bRet = true;
			}
			break;
			
		case LIST_CONTROL_CONTEXT_MENU_REMOVE:
			{
				vector<string> vsFuncs;
				m_ctrlFuncList.GetList(vsFuncs, false);
				///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				//m_mngrQFFunc.FilterNotInList(vsFuncs);
				getFitFuncListMngrPointer()->FilterNotInList(vsFuncs);
				///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				bRet = true;
			}
			break;
		}
		return bRet;
	}
	
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	BOOL OnTabChange(Control ctrl)
	{
		UpdateFuncList();
		return true;
	}
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	
	void UpdateButtons()
	{
		bool bHasSelection = m_ctrlFuncList.HasSelection();
		
		Control ctrlRemove = GetItem(IDC_QUICK_FIT_EDIT_REMOVE);
		if(ctrlRemove)
			ctrlRemove.Enable = bHasSelection;
	}
	
private:
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	QFitFuncListMngrBase* getFitFuncListMngrPointer()
	{
		if( FUNC_EDIT_LR_TAB == m_tab.GetCurSel() )
		{
			return (QFitFuncListMngrBase*)&m_mngrQFRegressionFunc;
		}
		else
		{
			return (QFitFuncListMngrBase*)&m_mngrQFNLfitFunc;
		}
	}
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	
	bool isDirty()
	{
		return m_mngrQFRegressionFunc.IsDirty() || m_mngrQFNLfitFunc.IsDirty();
	}
	
private:
	//QuickFitEditMenu*			m_pDlgMenu;
	NLFFuncs					m_nlfFuncs;

	FuncListControl				m_ctrlFuncList;
	
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	//QFitFuncListMngr			m_mngrQFFunc;
	QFitNLfitFuncListMngr		m_mngrQFNLfitFunc;
	QFitRegressionFuncListMngr		m_mngrQFRegressionFunc;
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS	
	TabControl					m_tab; 
	int							m_nMode;
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS

	///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
	string						m_strFuncSelected;
	///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
};

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
///////////////Output Preference Dialog///////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
#define TABLE_NAME 			"Table"

//////Theme Settings functions
string get_quick_fit_prefer_theme_file()
{	
	///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
	//string strThemeFile = okutil_theme_get_settings_file(THEME_FILENAME_LAST_USED, STR_QUICKFIT_CLASS_NAME_FOR_THEME);
	string strThemeFile = okutil_theme_get_settings_file(quick_fit_current_theme(), STR_QUICKFIT_CLASS_NAME_FOR_THEME);
	///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
	return strThemeFile;
}

//------ Iris 1/18/2010 not used any more, so comment out
/*
static bool _save_table_refer_theme_settings(TreeNode& tr)
{
 	string strThemeFile = get_quick_fit_prefer_theme_file();
	bool bRet = theme_save_settings(tr, strThemeFile);	
	if( !bRet )
		error_report("_save_table_refer_theme_settings fail to save quick fit table refer settings.");
	return bRet;
}
*/
//------

// 0 == nDigits mean Origin's global setting
static string _convert_float_to_str(double& dd, int nDigits = 0)
{
	string strFormat = "*";
	if( 0 != nDigits )
		strFormat += nDigits;
	
	return ftoa(dd, strFormat);
}

///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
// need get_value_by_format in graphobjtools.c
// moved to analysis_utils.c, rename _get_result_value_by_format to get_value_by_format
#define			_get_result_value_by_format			get_value_by_format
///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT

// return x column index, if not find, returns -1
static int _find_x_column(const DatasetObject& dsY, int& nYColIndex, Worksheet& wks)
{
	string strRange;
	dsY.GetRangeString(strRange);
	
	DataRange dr;
	dr.Add("Range1", strRange);
	
	int c1,c2;
	///Sophy 3/2/2010 REPORTED_QUICKFIT_SAVE_AS_OGG_GOT_RUNTIME_WHEN_OPEN_CONTEXT_MENU
	//dr.GetRange(wks, c1, c2);
	if ( !dr.GetRange(wks, c1, c2) )
		return -1;
	///end REPORTED_QUICKFIT_SAVE_AS_OGG_GOT_RUNTIME_WHEN_OPEN_CONTEXT_MENU
	ASSERT(c1==c2); // only one column	
	nYColIndex = c1;
	
	return wks.FindColIndex(nYColIndex, OKDATAOBJ_DESIGNATION_X); // find x column from y column	
}

static bool _get_dataplot_from_datasetobject(const GraphLayer& gl, DatasetObject& dsObj, DataPlot& dp)
{
	if( !gl || !dsObj )
		return false;	

	Worksheet wks;
	int nXColIndex, nYColIndex;
	nXColIndex = _find_x_column(dsObj, nYColIndex, wks);
	if( -1 == nXColIndex || -1 == nYColIndex )
		return false;
	
	XYRange xy;
	xy.Add(wks, nXColIndex, "X");
	xy.Add(wks, nYColIndex, "Y");
	
	vector<int> vnPlotIndices;
	if( check_has_plotted_in_graph(xy, gl, vnPlotIndices) <= 0 || 0 == vnPlotIndices.GetSize() )
		return false;
	
	dp = gl.DataPlots(vnPlotIndices[0]);
	return dp.IsValid();
}

static bool _get_quick_fit_plot(const DataPlot& dpSource, DataPlot& dpFit)
{
	if( !dpSource )
		return false;
	GraphLayer gl;
	dpSource.GetParent(gl);
	
	DatasetObject dsQuickFit;
	if( dpSource.GetRelatedDataset(STR_QUICK_FIT_RELATED_DATASET, dsQuickFit) && dsQuickFit.IsValid() )
	{		
		return _get_dataplot_from_datasetobject(gl, dsQuickFit, dpFit);
	}
	return false;
}

/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
//static bool _get_quick_fit_source_plot(DataPlot& dpSource, DataPlot* pPlotFit = NULL)
static bool _get_quick_fit_source_plot(DataPlot& dpSource, DataPlot* pPlotFit = NULL, GraphLayer& glSrc = NULL, int* pnFrom = NULL, int* pnTo = NULL)
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
{
	GraphLayer gl = Project.ActiveLayer();
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	if ( glSrc )
		gl = glSrc;
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	if( !gl )
		return false;
	
	//----Iris 12/29/2009 allow do separate quick fit on multiple data plots in one layer.
	/*
	DataPlot dp = gl.DataPlots(-1);
	if( !dp )
		return false; // no data plot on graph
	// go through all data plot to find related dataset
	int nCount = 0;
	DatasetObject dsQuickFit;
	foreach(dp in gl.DataPlots)
	{
		DatasetObject dsTemp;
		if( dp.GetRelatedDataset(STR_QUICK_FIT_RELATED_DATASET, dsTemp) )
		{
			if( 0 == nCount ) // if eixst multiple quick fit dataset, get the first one.
				dsQuickFit = dsTemp;
			nCount++;
		}
	}	
	ASSERT( 1 == nCount ); // ONLY allow one quick fit related dataset on graph layer. See quickfit XFunction the usage of DataPlot::ClearRelatedDatasets.
	if( 0 == nCount )
		return false;
	*/
	Tree trStorage;
	if( !gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) )
		return false;
	
	DataPlot dp;
	//dp = (DataPlot)Project.GetObject(trStorage.Results.nLastSourcePlotUID.nVal);
	QuickFitPlotInfo		stInfo;
	if ( quick_fit_source_plot_info_access(stInfo, gl) )
	{
		dp = (DataPlot)Project.GetObject(stInfo.nUID);
		if ( pnFrom )
			*pnFrom = stInfo.nFrom;
		if ( pnTo )
			*pnTo = stInfo.nTo;
	}
	if( !dp )
		return false;	
	//----
	
	if( pPlotFit )
	{
		_get_quick_fit_plot(dp, *pPlotFit);
	}
	
	dpSource = dp;
	return dpSource.IsValid();	
}


static bool _get_last_text_box_object(GraphLayer& gl, GraphObject& goTextBox)
{
	Tree trStorage;
	if( gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) )
	{
		TreeNode trTextBoxName = trStorage.TextBoxName;
		if( trTextBoxName && !trTextBoxName.IsEmpty() )
		{
			goTextBox = gl.GraphObjects(trTextBoxName.strVal);
		}
	}
	return goTextBox.IsValid();
}

#define STR_OUTPUT_REFER_DLG_NAME		"Quick Fit Preferences"

/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
//#define STR_QUICKFIT_PREFERENCE_OUTPUT		_L("Output")
#define STR_QUICKFIT_PREFERENCE_REPORT		_L("Report")
#define STR_QUICKFIT_PREFERENCE_FIT_CURVE		_L("Fit Curve")
///End REARRANGE_PREFERENCE_DLG_TABS
#define STR_QUICKFIT_PREFERENCE_TABLE		_L("Label Box")

enum
{
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//QUICKFIT_PREFERENCE_OUTPUT,
	///End REARRANGE_PREFERENCE_DLG_TABS
	QUICKFIT_PREFERENCE_TABLE,
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	QUICKFIT_PREFERENCE_REPORT,
	QUICKFIT_PREFERENCE_FIT_CURVE,
	///End REARRANGE_PREFERENCE_DLG_TABS
	QUICKFIT_PREFERENCE_ROI,
	QUICKFIT_PREFERENCE_TOTAL,
};	

///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST, moved to .h file
//enum
//{
	//ROI_TOP_SHOW_NONE,
	//ROI_TOP_SHOW_REDUCED_CHI_SQR,
	//ROI_TOP_SHOW_ADJ_R_SQR,
	//ROI_TOP_SHOW_PARAM
//};
///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST

enum
{
	CHECK_LIST_COLTYPE_NAME,
	CHECK_LIST_COLTYPE_SHOW,
	CHECK_LIST_COLTYPE_TOTAL,
};
#define STR_CHECK_LIST_COLS		_L("Parameter Names|Show")

class GridCheckListCtrl : public GridTableControl
{
public:
	GridCheckListCtrl()	{}

	//void Init(int nID, Dialog& dlg, LPCSTR lpcszDlgName)///---Jasmine 05/26/10 ORG-2 CHANGE_DLG_TYPE_FOR_PROPERTY_PAGE
	void Init(int nID, WndContainer& dlg, LPCSTR lpcszDlgName)
	{
		GridTableControl::Init(nID, dlg, lpcszDlgName);
	
		m_flx.ExtendLastCol = true;
		SetCols(CHECK_LIST_COLTYPE_TOTAL);
		SetColHeaderString(STR_CHECK_LIST_COLS);
		SetupColTypes();
	}
		
	void Update(const vector<string>& vsLabels, const vector<byte>& vbCheck)
	{
		ClearAll();
		CheckExpandRows(vsLabels.GetSize() - 1);
		SetCells(vsLabels, CHECK_LIST_COLTYPE_NAME);
		
		vector<string> vs;
		convert_byte_vector_to_string_vector(vbCheck, vs);
		SetCells(vs, CHECK_LIST_COLTYPE_SHOW);
	}
		
	void GetCheck(vector<byte>& vbCheck)
	{
		vbCheck.SetSize(GetNumRows());
		for(int nRow = vbCheck.GetSize()-1; nRow >=0; nRow--)
		{
			vbCheck[nRow] = GetCheck(nRow + GetRowOffset(), CHECK_LIST_COLTYPE_SHOW);
		}
	}

	virtual void OnBeforeEditParaControl(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{	
		switch(nCol - GetColOffset())
		{
		case CHECK_LIST_COLTYPE_NAME:
			if(pCancel)
				*pCancel = true;
			break;
		}
	}

protected:
	void SetupColTypes()
	{
		m_flx.Cols = CHECK_LIST_COLTYPE_TOTAL;
		int nCol;
		for(nCol = 0; nCol < m_flx.Cols; nCol++)
		{
			switch(nCol)
			{
			case CHECK_LIST_COLTYPE_NAME:
				SetColDataType(nCol, flexDTString);
				break;
			case CHECK_LIST_COLTYPE_SHOW:
				SetColDataType(nCol, flexDTBoolean);
				break;
			}
			SetColAlignment(nCol, flexAlignCenterCenter);
		}
	}
};
///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
//QuickFitOutputReferDlg::QuickFitOutputReferDlg(bool bROIUsed, int nOrder, LPCSTR lpcszFunc) : ResizeDialog(IDD_QUICKFIT_PREFERENCE, "ODlg8")
QuickFitOutputReferDlg::QuickFitOutputReferDlg(TreeNode& trSettings) : ResizeDialog(IDD_QUICKFIT_PREFERENCE, "ODlg8")
///End NEW_QUICKFIT_ROI_XF_DLG
{
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	m_bROIUsed = bROIUsed;
	if( m_bROIUsed )
	{		
		m_nOrder = nOrder;
		m_strFunction = lpcszFunc;
	}
	*/
	m_bROIUsed = true; // Preference dialog only open by ROI now.
	m_trSettings = trSettings;
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
	//quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(m_trSettings); 
	///End FIX_DUPLICATION_DATAID
	///End NEW_QUICKFIT_ROI_XF_DLG	
	m_pGridParamList = NULL;		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	m_bXPosChanged = false; ///Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB


	m_vbTabDirty.SetSize(QUICKFIT_PREFERENCE_TOTAL);
	m_vbTabDirty = false;	

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	m_bSharedControlMoved = FALSE;
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
}

void QuickFitOutputReferDlg::SaveSettings()
{
	SaveSetting("CurrentSelTab", m_tab.GetCurSel(), STR_OUTPUT_REFER_DLG_NAME);
}

void QuickFitOutputReferDlg::LoadSettings()
{
	int nSelTab = 0;
	//----- Iris 2/04/2010 update on wiki's comment "Everytime Preferences dialog opens, ROI Box tab is active. It should show the tab I used last time. "
	/*
	if(m_bROIUsed)
	{
		nSelTab = QUICKFIT_PREFERENCE_ROI;
	}
	else
	*/
	//-----
	{
		nSelTab = LoadSetting("CurrentSelTab", 0, STR_OUTPUT_REFER_DLG_NAME);
		if( nSelTab < 0 || nSelTab >= QUICKFIT_PREFERENCE_TOTAL )
			nSelTab = 0;
	}
	m_tab.SetCurSel(nSelTab);
}

int QuickFitOutputReferDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hWndParent);		
	return nRet;
}

BOOL QuickFitOutputReferDlg::OnDestroy()
{
	SaveSettings();
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	if(m_pGridParamList)
	{
		delete m_pGridParamList;
		m_pGridParamList = NULL;
	}
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	return true;
}

BOOL QuickFitOutputReferDlg::OnInitDialog()	
{
	//------ CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
	//ResizeDialog::OnInitDialog();
	ResizeDialog::OnInitDialog(IDC_QUICKFIT_PANEL);// allow a slightly bigger gap controlled by rc
	//-------
	//Text = STR_OUTPUT_REFER_DLG_NAME; // update dialog title	

	initControls();	
	//initControlPos();/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS will do this inside OnTabChange

	initControlValues();

	LoadSettings();
	//m_tab.SetCurSel(m_nActiveTab);
	OnTabChange(m_tab);

	checkEnableApply();

	return true;
}

void QuickFitOutputReferDlg::initControls()
{
	/// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	m_btnErrMsg = GetItem(IDC_STATIC_STATIC_ERR_MESSAGE_BOX); 
	m_btnErrMsg.Visible = false;
	m_btnErrMsg.Text = "";
	///End CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	
	m_tab = GetItem(IDC_QUICKFIT_PREFERENCE_TAB);
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//m_tab.InsertItem(QUICKFIT_PREFERENCE_OUTPUT, STR_QUICKFIT_PREFERENCE_OUTPUT);
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	m_tab.InsertItem(QUICKFIT_PREFERENCE_TABLE, STR_QUICKFIT_PREFERENCE_TABLE);
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	m_tab.InsertItem(QUICKFIT_PREFERENCE_REPORT, STR_QUICKFIT_PREFERENCE_REPORT);
	m_tab.InsertItem(QUICKFIT_PREFERENCE_FIT_CURVE, STR_QUICKFIT_PREFERENCE_FIT_CURVE);
	///End REARRANGE_PREFERENCE_DLG_TABS
	if(m_bROIUsed)
		m_tab.InsertItem(QUICKFIT_PREFERENCE_ROI, STR_ROI_LABEL);

	// Output
	m_btnOutputNone = GetItem(IDC_OUTPUT_TO_NONE);
	m_btnScript = GetItem(IDC_OUTPUT_TO_SCRIPT_WINDOW);
	m_btnResultLog = GetItem(IDC_OUTPUT_TO_RESULT_LOG);
	/// Iris 1/20/2010 SUPPORT_OUTPUT_REPORT_TO_WKS
	m_btnOutputToWks = GetItem(IDC_OUTPUT_TO_WKS); 
	m_edOutputWksName = GetItem(IDC_EDIT_WKS_NAME);
	///End SUPPORT_OUTPUT_REPORT_TO_WKS
	m_comboSignDigits = GetItem(IDC_COMBO_SIGNIFICANT_DIGITS);	
	m_btnSameAsInput = GetItem(IDC_FIT_CURVE_SAME_AS_SOURCE_DATA);
	m_btnUniform = GetItem(IDC_FIT_CURVE_UNIFORM_LINEAR);
	m_btnSourceGraphSameScale = GetItem(IDC_FIT_CURVE_SAME_AS_SOURCE_SCALE);
	m_btnNumPoints = GetItem(IDC_X_NUMBER_OF_POINTS);
	m_comboOutputFitCurveTo = GetItem(IDC_COMBO_OUTPUT_FIT_CURVE_TO); /// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	m_btnReplaceExistingCurve = GetItem(IDC_CHECK_REPLACE_EXISTING_CURVE);
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	*/
	//m_checkReplaceLastOutput = GetItem(IDC_CHECK_REPLACE_LAST_UPDATE);CPY 2/19/10 QUICK_FIT_REMOVE_REPLACE_LAST_CHK_WITH_2_CMD_MENU
	///End USE_COMMON_REPLACE_CHECK
	
	// Table
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	//m_btnAddToGraph = GetItem(IDC_ADD_TABLE_TO_GRAPH);
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//m_comboAddTableToGraph = GetItem(IDC_COMBO_ADD_TABLE_TO_GRAPH);
	m_checkAddTableToGraph = GetItem(IDC_CHECK_ADD_LABEL);
	///End USE_COMMON_REPLACE_CHECK
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	m_btnDateAndTime = GetItem(IDC_DATE_AND_TIME);
	m_btnFunctionName = GetItem(IDC_FUNCTION_NAME);
	*/
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	//m_btnEquation = GetItem(IDC_FUNCTION_FORMAT); /// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	m_comboEquationFormat = GetItem(IDC_COMBO_EQUATION_FORMAT);
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	/*
	m_btnParamValue = GetItem(IDC_COEFF_TABLE_VALUE);
	m_btnParamError = GetItem(IDC_COEFF_TABLE_ERROR);
	*/
	m_comboParams = GetItem(IDC_COMBO_PARAMS);
	m_checkShowError = GetItem(IDC_CHECK_SHOW_ERROR);			///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	m_checkFunction = GetItem(IDC_CHECK_FUNCTION);
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//m_checkInput = GetItem(IDC_CHECK_INPUT);
	//m_checkInputRangeIndex = GetItem(IDC_CHECK_INPUT_RANGE_INDEX); /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	//m_checkOutput = GetItem(IDC_CHECK_OUTPUT);
	m_comboInput = GetItem(IDC_CHECK_INPUT);
	_init_combobox(m_comboInput, STR_DATA_COMBO);
	m_comboInputRange = GetItem(IDC_CHECK_INPUT_RANGE_INDEX);
	_init_combobox(m_comboInputRange, STR_ADD_RANGE_COMBO);
	m_comboOutput = GetItem(IDC_CHECK_OUTPUT);
	_init_combobox(m_comboOutput, STR_DATA_COMBO);
	m_chkAddLegendSymbols = GetItem(IDC_CHECK_FITTED_CURVE_LEGEND);
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	///End 
	m_btnFitStatsRsqCod = GetItem(IDC_FIT_STATS_RSQCOD);
	m_btnFitStatsAdjRsq = GetItem(IDC_FIT_STATS_ADJRSQ);
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	m_btnFitStatsRSquare = GetItem(IDC_FIT_STATS_RSQUARE);
	m_btnFitStatsCorrelation = GetItem(IDC_FIT_STATS_PEARSON_R);
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	m_btnFitStatsNumIter = GetItem(IDC_FIT_STATS_NUM_ITER);
	m_btnFitStatsFitStatus = GetItem(IDC_FIT_STATS_FIT_STATUS);
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	//ROI
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	m_edROILeftX = GetItem(IDC_EDIT_ROI_LEFT_X);
	m_edROIRightX = GetItem(IDC_EDIT_ROI_RIGHT_X);
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/*
	///------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	m_checkAutoXFrom = GetItem(IDC_XSCALE_AUTO_FROM);
	m_checkAutoXTo = GetItem(IDC_XSCALE_AUTO_TO);
	///------ End SUPPORT_AUTO_FOR_X_SCALE
	*/
	m_checkXScaleFix = GetItem(IDC_CHECK_XSCALE_FIX);
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	m_checkAddToolName = GetItem(IDC_CHECK_ROI_SHOW_TOOL_NAME);
	m_edToolName = GetItem(IDC_EDIT_TOOL_NAME);
	m_edToolName.Enable = m_checkAddToolName.Value;
	m_checkCloneMainObj = GetItem(IDC_CHECK_CLONE_MAINOBJ);	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	m_comboROISignDigits = GetItem(IDC_COMBO_ROI_SIGNIFICANT_DIGITS);
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//m_btnROITopNone = GetItem(IDC_RADIO_ROI_NONE);
	//m_btnROITopChiSqr = GetItem(IDC_RADIO_ROI_REDUCED_CHISQ);
	//m_btnROITopAdjRSqr = GetItem(IDC_RADIO_ROI_ADJ_R_SQR);
	//m_btnROITopParam = GetItem(IDC_RADIO_ROI_PARAM);
	////m_comboParamIndex = GetItem(IDC_COMBO_ROI_PARAM_INDEX); /// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
//
	///// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	//m_btnROITopPearson	= GetItem(IDC_RADIO_ROI_PEARSONS_R);
	//m_btnROITOPRSquare	= GetItem(IDC_RADIO_ROI_R_SQUARE);
//
	//// move R-Square button to the same place of Adj.R-Sqr, only one of them will be visible later
	//RECT rtBtn;
	//GetControlClientRect(IDC_RADIO_ROI_ADJ_R_SQR, rtBtn);
	//m_btnROITOPRSquare.MoveWindow(&rtBtn);
	///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	m_chkROITopChiSqr = GetItem(IDC_CHECK_ROI_REDUCED_CHISQ);
	m_chkROITopAdjRSqr = GetItem(IDC_CHECK_ROI_ADJ_R_SQR);
	m_chkROITopPearson = GetItem(IDC_CHECK_ROI_PEARSONS_R);
	m_chkROITopRSquare = GetItem(IDC_CHECK_ROI_R_SQUARE);
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	
	if( m_bROIUsed )
	{
		/// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
		/*
		m_comboParamIndex.ResetContent();
		vector<string> vsParams;
		getFuncParamList(vsParams);
		for( int nItem = 0; nItem < vsParams.GetSize(); nItem++ )
		{
			string strLabel = (string)(nItem+1) + " " + vsParams[nItem];
			m_comboParamIndex.AddString(strLabel);
		}	
		*/
		///End SHOW_ALL_PARAMS_ON_ROI_TOP
		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		m_pGridParamList = new GridCheckListCtrl;
		m_pGridParamList->Init(IDC_GRID_PARAM_LIST, *this, STR_OUTPUT_REFER_DLG_NAME);
		///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		
		TreeNode trGUI = tree_check_get_node(m_trROI, "ROI");
	    GETN_USE(trGUI)    
	    GETN_COLOR(RectColor, _L("Fill Color"), SYSCOLOR_LTYELLOW) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE)
	    GETN_COLOR(FitLineColor, _L("Line Color"), /*SYSCOLOR_BLUE*/INDEX_COLOR_AUTOMATIC) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE | COLORLIST_AUTO)
	    
	    Control ctrlROI = GetItem(IDC_QUICK_FIT_ROI_PREFERENCE);
	    if( m_ctrlROI.CreateControl(ctrlROI.GetSafeHwnd()) )
	    {
	    	bool bRet = m_ctrlROI.SetTree(trGUI, DYNALAYOUT_BACKGROUND_GRAY);
			m_ctrlROI.SetEventCallback(NULL, _on_roi_getn_change);
	    }	    
	}
}

int QuickFitOutputReferDlg::getFuncParamList(vector<string>& vsParams)
{
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	/*
	vsParams.SetSize(0);
	if( m_nOrder >= 1 && m_nOrder <= 3 )
	{
		int nParams = m_nOrder + 1;
		for(int ii=0; ii<nParams; ii++)
		{
			if( 0 == ii )
				vsParams.Add("A");
			else
				vsParams.Add("B"+ii);
		}
	}
	else
	{
		ASSERT(m_nOrder == 0);
		nlsf_get_param_names(m_strFunction, STR_QUICK_FIT_NLF_SECTION, vsParams);	
	}

	return vsParams.GetSize();
	*/
	int nOrder = quick_fit_get_order(m_trSettings.mode.nVal, m_trSettings.func.strVal);
	return quick_fit_get_func_param_list(vsParams, nOrder, m_trSettings.func.strVal);
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
}


static int _on_roi_getn_change(TreeNode& tr, int nRow, int nEvent, DWORD& dwEnables, LPCSTR lpcszNodeName, WndContainer& getNContainer, string& strAux, string& strErrMsg)
{
	getNContainer.SendMessage(WM_USER_ON_ROI_GETN_CHANGE, 0, 0);
	return 0;
}

TreeNode QuickFitOutputReferDlg::getBranchNodeByTab(int nTab)
{
	if( -1 == nTab )
		nTab = m_tab.GetCurSel();
	
	switch(nTab)
	{
	case QUICKFIT_PREFERENCE_TABLE:
		return m_trSettings.Table;
		
	case QUICKFIT_PREFERENCE_REPORT:		
		return m_trSettings.Report;
	
	case QUICKFIT_PREFERENCE_FIT_CURVE:		
		return m_trSettings.FitCurve;
	
	case QUICKFIT_PREFERENCE_ROI:		
		return m_trSettings.ROI;
	
	default:
		ASSERT(0);
	}	
	TreeNode trJunk;
	return trJunk;	
}

/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
static int _init_combobox(ComboBox& cmb, LPCSTR lpcszCombo, LPCSTR lpcszSeparator = "|")
{
	vector<string>		vstrItems;
	str_separate(lpcszCombo, lpcszSeparator, vstrItems);
	for ( int ii = 0; ii < vstrItems.GetSize(); ii++ )
		cmb.AddString(vstrItems[ii]);
	return vstrItems.GetSize();
}

/// Hong 02/21/10 QA80-14832 PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
//static string _get_data_display_str(const DataRange& dr, int nMode)
static string _get_data_display_str(const DataRange& dr, int nMode, bool bParseLegendString = false)
/// end PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
{
	ASSERT(dr);
	string		str;
	switch ( nMode )
	{
	case DATA_RANGE_SNAME:
		str = dr.GetDescription(GETLC_COL_SHORT_NAME|GETLC_NO_ROWS);
		break;
	case DATA_RANGE_LNAME:
		str = dr.GetDescription(GETLC_COL_LONG_NAME|GETLC_NO_ROWS);
		break;
	case DATA_LONGNAME_ONLY:
		XYRange		iy(dr);
		ASSERT(iy);
		Column		col;
		iy.GetYColumn(col);
		///Sophy 3/3/2010 NICELY_SUBSTITUTE_SHORT_NAME_WHEN_LONGNAME_IS_EMPTY
		//str = col.GetLongName();
		str = get_column_name(col, true, true);
		///end NICELY_SUBSTITUTE_SHORT_NAME_WHEN_LONGNAME_IS_EMPTY
		break;
	case DATA_PLOT_LEGEND:
		vector<UINT>		vnUIDs;
		dr.GetPlots(vnUIDs);
		ASSERT(vnUIDs.GetSize());
		DataPlot		dp;
		dp = Project.GetObject(vnUIDs[0]);
		/// Hong 02/21/10 QA80-14832 PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
		//dp.GetLegend(str);
		str.Format("%%(%d)", dp.GetIndex() + 1);
		if ( bParseLegendString )
		{
			///Sophy 3/3/2010 WRONG_LENGEND_DUE_TO_XYRANGE_SETOUTPUTCOMMENT_DELAY
			//XYRange oy;
			//dp.GetDataRange(oy);
			//Column colY;
			//oy.GetYColumn(colY);
			//string strCmt = colY.GetComments();
			//GraphLayer		gl;
			//dp.GetParent(gl);
			//GraphPage		gp;
			//gl.GetParent(gp);
			//string			strLayerName;
			//strLayerName.Format("[%s]%d", gp.GetName(), gl.GetIndex() + 1);
			//okutil_arg_copy(&str, strLayerName);
			dp.GetLegend(str);
			///end WRONG_LENGEND_DUE_TO_XYRANGE_SETOUTPUTCOMMENT_DELAY
		}
		/// end PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
		break;
	case DATA_NONE:
	default:
		return "";
		break;
	}
	return str;
}

static string _get_range_display_str(const DataRange& dr, int nMode)
{
	ASSERT(dr);
	string		str;
	switch ( nMode )
	{
	case ADDRANGE_INDICES:
		string		strRangeWithoutRowIndex, strRangeWithRowIndex;
		strRangeWithoutRowIndex = dr.GetDescription(GETLC_NO_ROWS);
		strRangeWithRowIndex = dr.GetDescription();
		str = strRangeWithRowIndex.Right(strRangeWithRowIndex.GetLength() - strRangeWithoutRowIndex.GetLength());
		break;
	case ADDRANGE_XVALUES:
		str = dr.GetDescription(GETLC_COL_LONG_NAME|GETLC_NO_ROWS);
		XYRange		iy(dr);
		ASSERT(iy);
		///------ Folger 04/12/10 QA81-15300-P2 QUICKFIT_OUTPUT_XVALUES_FAILED_FOR_LOOSE_DATASET
		//Column		col;
		//iy.GetXColumn(col);
		///------ End QUICKFIT_OUTPUT_XVALUES_FAILED_FOR_LOOSE_DATASET
		Datasheet	ds;
		int			nR1, nR2, nC1, nC2;
		dr.GetRange(0, nR1, nC1, nR2, nC2, ds);
		///------ Folger 04/12/10 QA81-15300-P2 QUICKFIT_OUTPUT_XVALUES_FAILED_FOR_LOOSE_DATASET
		//if ( nR2 < 0 )
			//nR2 = ds.GetNumRows();
		//vectorbase&	vv = col.GetDataObject();
		//ASSERT(nR1 < vv.GetSize() );
		/////Sophy 3/1/2010 INDEX_OUT_OF_RANGE_RUNTIME_ERROR
		////if ( nR2 > vv.GetSize() )
		//if ( nR2 >= vv.GetSize() )
		/////end INDEX_OUT_OF_RANGE_RUNTIME_ERROR
			//nR2 = vv.GetSize() - 1;
		//str.Format("[x%s:%s]", _convert_float_to_str(vv[nR1]), _convert_float_to_str(vv[nR2]));
		
		LPCSTR		lpcszFormatStr = "[x%s:%s]";
		string	strX, strY;
		iy.GetDatasetNames(strY, strX);
		if ( strX.IsEmpty() )
		{
			if ( nR2 < 0 )
			{
				Dataset		ds(strY);
				nR2 = ds.GetSize() - 1;
			}
			
			double dX0 = NANUM;
			double dXInc = NANUM;
			double x1, x2;
			if( iy.IsEvenSampling(0, &dX0, &dXInc) )
			{
				x1 = dX0 + nR1 * dXInc;
				x2 = dX0 + nR2 * dXInc;
			}
			else
			{
				x1 = nR1 + 1;
				x2 = nR2 + 1;
			}
			str.Format(lpcszFormatStr, _convert_float_to_str(x1), _convert_float_to_str(x2));
		}
		else
		{
			Dataset		ds(strX);
			vectorbase&	vv = ds;
			if ( nR2 < 0 )
				nR2 = vv.GetSize() - 1;
			str.Format(lpcszFormatStr, _convert_float_to_str(vv[nR1]), _convert_float_to_str(vv[nR2]));
		}
		///------ End QUICKFIT_OUTPUT_XVALUES_FAILED_FOR_LOOSE_DATASET
		break;
	case ADDRANGE_NONE:
	default:
		return "";
		break;
	}
	return str;
}
/// end IMPROVE_GUI_OF_INPUT_OUTPUT

///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
#define		SET_CNTRL_VALUE_AND_VISIBILITY_BY_TREE(_cntrl, _tr, _node) \
			if ( _tr._node ) \
			{ \
				_cntrl.Value = _tr._node.nVal; \
				_cntrl.Visible = _tr._node.Show; \
			} \
			else \
			{ \
				_cntrl.Visible = FALSE; \
			}
///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS

void QuickFitOutputReferDlg::initSharedControlValues()
{	
	if( QUICKFIT_PREFERENCE_TABLE == m_tab.GetCurSel() || QUICKFIT_PREFERENCE_REPORT == m_tab.GetCurSel() )
	{
		TreeNode trBranch = getBranchNodeByTab();
		ASSERT(trBranch);
		
		if( trBranch )
		{
			m_comboSignDigits.SetCurSel( trBranch.SignDigits.nVal );
			//m_btnEquation.Value = trBranch.Equation.nVal;	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
			m_comboEquationFormat.SetCurSel(trBranch.EquationFormat.nVal);
			/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
			/*
			m_btnParamValue.Value = trBranch.Value.nVal;	
			m_btnParamError.Value = trBranch.Error.nVal;
			*/
			m_checkFunction.Value = trBranch.Function.nVal;
			/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
			//m_checkInput.Value = trBranch.Input.nVal;
			///// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
			//if( trBranch.InputRangeIndex.Show )
				//m_checkInputRangeIndex.Value = trBranch.InputRangeIndex.nVal;
			/////End OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
			//m_checkOutput.Value = trBranch.Output.nVal;
			m_comboInput.SetCurSel(trBranch.Input.nVal);
			if( trBranch.InputRange.Show )
				m_comboInputRange.SetCurSel(trBranch.InputRange.nVal);
			m_comboOutput.SetCurSel(trBranch.Output.nVal);
			if( trBranch.Legend.Show )
				m_chkAddLegendSymbols.Value = trBranch.Legend.nVal;
			/// end IMPROVE_GUI_OF_INPUT_OUTPUT
			//m_checkWeighting.Value = trBranch.Weighting.nVal; /// Iris 2/04/2010 GET_RID_OF_WEIGHTING_CHECKBOX
			m_comboParams.SetCurSel( trBranch.Params.nVal );
			m_checkShowError.Value = trBranch.ShowError.nVal;					///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
			///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
			m_btnFitStatsRsqCod.Value = trBranch.ReduChisq.nVal;
			m_btnFitStatsAdjRsq.Value = trBranch.AdjR.nVal;			
			///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
			m_btnFitStatsAdjRsq.Visible = trBranch.AdjR.Show;			
			
			m_btnFitStatsRSquare.Value = trBranch.RSqr.nVal;
			m_btnFitStatsRSquare.Visible = trBranch.Rsqr.Show;
			m_btnFitStatsCorrelation.Value = trBranch.Correlation.nVal;
			m_btnFitStatsCorrelation.Visible = trBranch.Correlation.Show;
			///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

			///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
			SET_CNTRL_VALUE_AND_VISIBILITY_BY_TREE(m_btnFitStatsNumIter, trBranch, NumIter)
			SET_CNTRL_VALUE_AND_VISIBILITY_BY_TREE(m_btnFitStatsFitStatus, trBranch, FitStatus)
			///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
		}
	}
}

void QuickFitOutputReferDlg::updateSharedSettings(int nTab)
{
	if( -1 == nTab )
		nTab = m_tab.GetCurSel();
	
	if( QUICKFIT_PREFERENCE_TABLE == nTab || QUICKFIT_PREFERENCE_REPORT == nTab )
	{
		TreeNode trBranch = getBranchNodeByTab(nTab);
		ASSERT(trBranch);
		
		if( trBranch )
		{
			convertOutputChoiceFromDlgToThemeTree(trBranch);
		}
	}
}

void QuickFitOutputReferDlg::initControlValues()
{
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	Tree tr;
	quick_fit_get_preference_settings(tr);
	*/
	TreeNode tr;
	tr = m_trSettings;
	///End NEW_QUICKFIT_ROI_XF_DLG		
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//TreeNode trOutput = tr.Output;
	TreeNode trOutput = tr.Report;
	///End REARRANGE_PREFERENCE_DLG_TABS

	// Output
	m_btnOutputNone.Value = (OUTPUT_TO_NONE == trOutput.OutputTo.nVal);
	m_btnScript.Value = (OUTPUT_TO_SCRIPT_WND == trOutput.OutputTo.nVal);
	m_btnResultLog.Value = (OUTPUT_TO_RESULT_LOG == trOutput.OutputTo.nVal);
	/// Iris 1/20/2010 SUPPORT_OUTPUT_REPORT_TO_WKS	
	m_btnOutputToWks.Value = (OUTPUT_TO_WORKSHEET == trOutput.OutputTo.nVal); 
	m_edOutputWksName.Text = trOutput.WksName.strVal;
	///End SUPPORT_OUTPUT_REPORT_TO_WKS
	//m_comboSignDigits.SetCurSel( trOutput.SignDigits.nVal ); /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	
	// Fit Curve
	TreeNode trFitCurve = tr.FitCurve;	
	m_btnSameAsInput.Value = (FIT_CURVE_TYPE_SAME_AS_INPUT == trFitCurve.FitCurve.nVal);
	m_btnSourceGraphSameScale.Value = (FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE == trFitCurve.FitCurve.nVal);
	m_btnUniform.Value = (FIT_CURVE_TYPE_UNIFORM == trFitCurve.FitCurve.nVal);
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//m_btnXFrom.Text = trOutput.XFrom.strVal;
	//m_btnXTo.Text = trOutput.XTo.strVal;
	///End REARRANGE_PREFERENCE_DLG_TABS
	/// Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	m_btnXAutoFrom.Value = trOutput.XAutoFrom.nVal;
	m_btnXAutoTo.Value = trOutput.XAutoTo.nVal;
	*/
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	/*
	TreeNode trXFrom = trOutput.XFrom, trXTo = trOutput.XTo;
	m_btnXAutoFrom.Value = (1 == octree_get_auto_support(&trXFrom));
	m_btnXAutoTo.Value = (1 == octree_get_auto_support(&trXTo));
	*/
	///End REARRANGE_PREFERENCE_DLG_TABS
	///End NEW_QUICKFIT_ROI_XF_DLG
	m_btnNumPoints.Text = trFitCurve.NumPoints.strVal;
	GetItem(IDC_STATIC_NUM_POINTS).Visible = m_btnNumPoints.Visible = !m_btnSameAsInput.Value;	///Sophy 3/1/2010 UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG

	/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	m_comboOutputFitCurveTo.SetCurSel( trFitCurve.OutputFitCurveTo.nVal ); 
	///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	m_btnReplaceExistingCurve.Value = trFitCurve.ReplaceExistingCurve.nVal;
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	*/
//	m_checkReplaceLastOutput.Value = tr.ReplaceLastOutput.nVal;CPY 2/19/10 QUICK_FIT_REMOVE_REPLACE_LAST_CHK_WITH_2_CMD_MENU remove
	///End USE_COMMON_REPLACE_CHECK	

	// Table
	TreeNode trTable = tr.Table;
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING		
	//m_btnAddToGraph.Value = trTable.TextTable.nVal;
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//m_comboAddTableToGraph.SetCurSel( trTable.TextTable.nVal );
	m_checkAddTableToGraph.Value = trTable.TextTable.nVal;
	///End USE_COMMON_REPLACE_CHECK
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	m_btnDateAndTime.Value = trTable.DateTime.nVal;
	m_btnFunctionName.Value = trTable.FuncName.nVal;
	*/
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	/*
	m_btnEquation.Value = trTable.Equation.nVal;	
	m_comboEquationFormat.SetCurSel(trTable.EquationFormat.nVal);
	m_btnParamValue.Value = trTable.Value.nVal;	
	m_btnParamError.Value = trTable.Error.nVal;	
	m_btnFitStatsRsqCod.Value = trTable.ReduChisq.nVal;
	m_btnFitStatsAdjRsq.Value = trTable.AdjR.nVal;	
	*/
	initSharedControlValues();
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING		
	//enableTablePreferCtrls(m_btnAddToGraph.Value);
	enableTablePreferCtrls();
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	
	// ROI
	if( m_bROIUsed )
	{
		TreeNode trROI = tr.ROI;
		/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
		int nShowToolName;
		trROI.toolname.GetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, nShowToolName);
		/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
		///Sophy 2/3/2010 SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
		//m_edROILeftX.Text = trROI.leftx.strVal;
		//m_edROIRightX.Text = trROI.rightx.strVal;
		///------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
		//GraphLayer gl = Project.ActiveLayer();
		//if ( gl )
		//{
			//int nIndex = -1;
			//string strRect;
			//if( get_gl_quick_fit_rect_go_name(gl, strRect) )
			//{
				//GraphObject goRect = gl.GraphObjects(strRect);
				//if( goRect )
				//{
					//nIndex = _get_source_data_plot_index(gl, goRect);
				//}
			//}
			//DataPlot dp = gl.DataPlots(nIndex);
			//m_edROILeftX.Text = get_value_by_format(dp, trROI.leftx.dVal);
			//m_edROIRightX.Text = get_value_by_format(dp, trROI.rightx.dVal);
		//}
		//else
		//{
			//m_edROILeftX.Text = trROI.leftx.strVal;
			//m_edROIRightX.Text = trROI.rightx.strVal;
		//}
		/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
		/*
		TreeNode	trLeftX = trROI.leftx;
		TreeNode	trRightX = trROI.rightx;
		quickfit_get_auto_x_range(trLeftX, trRightX);

		m_edROILeftX.Text = trLeftX.strVal;
		m_edROIRightX.Text = trRightX.strVal;
		m_edROILeftX.Enable = !(m_checkAutoXFrom.Check = octree_get_auto_support(&trLeftX) == 1);
		m_edROIRightX.Enable = !(m_checkAutoXTo.Check = octree_get_auto_support(&trRightX) == 1);
		*/
		m_edROILeftX.Text = trROI.XScale.leftx.strVal;
		m_edROIRightX.Text = trROI.XScale.rightx.strVal;
		m_checkXScaleFix.Value = trROI.XScale.fixscale.nVal;
		///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
		///------ End SUPPORT_AUTO_FOR_X_SCALE
		///end SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
		///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
		m_edToolName.Text = trROI.toolname.strVal;
		m_edToolName.Visible = m_checkAddToolName.Value = nShowToolName;
		m_checkCloneMainObj.Value = trROI.cloneROI.nVal;	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
		///End REARRANGE_PREFERENCE_DLG_TABS
		m_comboROISignDigits.SetCurSel(trROI.SignDigits.nVal);
		/// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
// 		m_btnROITopNone.Value = (ROI_TOP_SHOW_NONE == trROI.ShowTop.nVal);
// 		m_btnROITopChiSqr.Value = (ROI_TOP_SHOW_REDUCED_CHI_SQR == trROI.ShowTop.nVal);
// 		m_btnROITopAdjRSqr.Value = (ROI_TOP_SHOW_ADJ_R_SQR == trROI.ShowTop.nVal);
// 		m_btnROITopParam.Value = (ROI_TOP_SHOW_PARAM == trROI.ShowTop.nVal);
		TreeNode trShowTop = m_trSettings.ROI.ShowTop;
		///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
		//int nTopShow = quick_fit_get_roi_show_top_enum(trShowTop);
		//Button btnTopShow;
		//m_btnROITopNone.Value =
		//m_btnROITopChiSqr.Value = 
		//m_btnROITopAdjRSqr.Value = 
		//m_btnROITopParam.Value = 
		//m_btnROITopPearson.Value = 
		//m_btnROITOPRSquare.Value = FALSE;
		//switch (nTopShow)
		//{
		//case ROI_TOP_SHOW_NONE:
			//btnTopShow = m_btnROITopNone;
			//break;
		//case ROI_TOP_SHOW_REDUCED_CHI_SQR:
			//btnTopShow = m_btnROITopChiSqr;
			//break;
		//case ROI_TOP_SHOW_ADJ_R_SQR:
			//btnTopShow = m_btnROITopAdjRSqr;
			//break;
		//case ROI_TOP_SHOW_PARAM:
			//btnTopShow = m_btnROITopParam;
			//break;
		//case ROI_TOP_SHOW_PEARSON_R:
			//btnTopShow = m_btnROITopPearson;
			//break;
		//case ROI_TOP_SHOW_R_SQUARE:
			//btnTopShow = m_btnROITOPRSquare;
			//break;
		//default:
			//break;
		//}
		//if ( !btnTopShow )
		//{
			//// In case it's not available, force to choose this one since it's always applicable.
			//nTopShow = ROI_TOP_SHOW_REDUCED_CHI_SQR;
			//btnTopShow = m_btnROITopChiSqr;
		//}
		//btnTopShow.Value			= TRUE;
		///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
		//int dwTopShow = quick_fit_get_roi_show_top_enum(trShowTop);
//#define SET_ROI_TOP_SHOW(_val, _btn, _bit)		( _btn.Value = ( _val & _bit ) ? 1 : 0 )
		//SET_ROI_TOP_SHOW(dwTopShow, m_chkROITopChiSqr, ROI_TOP_SHOW_REDUCED_CHI_SQR);
		//SET_ROI_TOP_SHOW(dwTopShow, m_chkROITopAdjRSqr, ROI_TOP_SHOW_ADJ_R_SQR);
		//SET_ROI_TOP_SHOW(dwTopShow, m_chkROITopPearson, ROI_TOP_SHOW_PEARSON_R);
		//SET_ROI_TOP_SHOW(dwTopShow, m_chkROITopRSquare, ROI_TOP_SHOW_R_SQUARE);
 		m_chkROITopChiSqr.Value = trROI.ShowTop.ReduChisq.nVal;
 		m_chkROITopAdjRSqr.Value = trROI.ShowTop.AdjR.nVal;
 		m_chkROITopRSquare.Value = trROI.ShowTop.RSqr.nVal;
 		m_chkROITopPearson.Value = trROI.ShowTop.Correlation.nVal;
		///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
		/// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
		//m_comboParamIndex.SetCurSel(trROI.ParamIndex.nVal); 
		//m_comboParamIndex.Enable = m_btnROITopParam.Value;
		///End SHOW_ALL_PARAMS_ON_ROI_TOP
		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		vector<string> vsParams;
		getFuncParamList(vsParams);
		vector<byte> vbCheck(vsParams.GetSize());
		TreeNode trParam = trROI.Params.FirstNode;
		for( int nItem = 0; trParam && nItem < vsParams.GetSize(); nItem++ )
		{
			vbCheck[nItem] = trParam.nVal;
			trParam = trParam.NextNode;
		}
		m_pGridParamList->Update(vsParams, vbCheck);
		///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		m_trROI.ROI.RectColor.nVal = trROI.RectColor.nVal;
		m_trROI.ROI.FitLineColor.nVal = trROI.FitLineColor.nVal;
		/// Iris 2/22/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
		//m_ctrlROI.Update(DYNACONTROL_UPDATE_VALUE);
		int nAutoColor;
		if( INDEX_COLOR_AUTOMATIC == trROI.FitLineColor.nVal && trROI.FitLineColor.GetAttribute(STR_ATTRIB_AUTO_COLOR, nAutoColor) )
		{
			m_trROI.ROI.FitLineColor.SetAttribute(STR_ATTRIB_AUTO_COLOR, nAutoColor);
		}
		m_ctrlROI.Update(DYNACONTROL_UPDATE_VALUE | DYNACONTROL_UPDATE_CHOICES);
		///End ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
		//m_ctrlROIParamList.Update(DYNACONTROL_UPDATE_VALUE);
	}
}

//----- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
//return id for bottom-right corner of group if bSharedControls = false, but share is needed on next call
//return size of vnIDs otherwise	
int QuickFitOutputReferDlg::getCtrlIDs(vector<uint>& vnIDs, int nTab, bool bSharedControls)
{
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	// controls shared in Report and Text Box tab
	vector<uint> vnIDsOutputChoice = {
		 							//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
									//	IDC_TABLE_PREFER_SEPARATOR,
										IDC_GROUP_OUTPUT_CONTENTS, // 1st control is used to calculate offset, so make sure this is indeed the 1st control (top-left) in the grop
									//----
										IDC_STATIC_SIGNIFICANT_DIGITS, 
										IDC_COMBO_SIGNIFICANT_DIGITS,
										IDC_GROUP_FUNCTION, 
										/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
										//IDC_FUNCTION_FORMAT, 
										IDC_STATIC_EQUATION,
										///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
										IDC_COMBO_EQUATION_FORMAT, 
										/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
										//IDC_COEFF_TABLE_VALUE, 
										//IDC_COEFF_TABLE_ERROR,
										IDC_CHECK_FUNCTION,
										IDC_CHECK_INPUT,
										IDC_CHECK_INPUT_RANGE_INDEX, /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
										IDC_CHECK_OUTPUT,
										//IDC_CHECK_WEIGHTING,//---- CPY 2/19/10 to make Iris 2/04/2010 GET_RID_OF_WEIGHTING_CHECKBOX
										IDC_GROUP_PARAMETERS,
										IDC_COMBO_PARAMS,
										IDC_CHECK_SHOW_ERROR,			///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
										///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
										IDC_GROUP_FIT_STATS, 
										IDC_FIT_STATS_RSQCOD, 
										IDC_FIT_STATS_ADJRSQ,
										///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
										IDC_FIT_STATS_RSQUARE,
										IDC_FIT_STATS_PEARSON_R
										///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
										///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
										, IDC_FIT_STATS_NUM_ITER
										, IDC_FIT_STATS_FIT_STATUS
										///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
										/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
										//,IDC_STATIC_INPUT, IDC_STATIC_INPUT_RANGE, IDC_STATIC_OUTPUT, IDC_CHECK_FITTED_CURVE_LEGEND  //---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
										,IDC_STATIC_INPUT, IDC_STATIC_INPUT_RANGE, IDC_STATIC_OUTPUT
										/// end IMPROVE_GUI_OF_INPUT_OUTPUT
										};
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	switch(nTab)
	{										
	case QUICKFIT_PREFERENCE_TABLE:	
	case QUICKFIT_PREFERENCE_REPORT:		
		if( bSharedControls )
		{
			vnIDs = vnIDsOutputChoice;
		}
		else
		{		
			if(QUICKFIT_PREFERENCE_REPORT == nTab)
			{
				vector<uint> vnIDsReportPrefer = {	IDC_GROUP_OUTPUT_TO, 
									IDC_OUTPUT_TO_NONE, 
									IDC_OUTPUT_TO_SCRIPT_WINDOW, 
									IDC_OUTPUT_TO_RESULT_LOG, 
									IDC_OUTPUT_TO_WKS, 
									IDC_EDIT_WKS_NAME
								};
				vnIDs = vnIDsReportPrefer;
				return IDC_GROUP_OUTPUT_TO;	//----- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
			}
			else
			{
				vector<uint> vnIDsTablePrefer = {
													/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
													//IDC_STATIC_ADD_TABLE_TO_GRAPH, 
													//IDC_COMBO_ADD_TABLE_TO_GRAPH 
													IDC_CHECK_ADD_LABEL
													/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
													,IDC_CHECK_FITTED_CURVE_LEGEND
													/// end IMPROVE_GUI_OF_INPUT_OUTPUT
													///End USE_COMMON_REPLACE_CHECK													
												};
				vnIDs = vnIDsTablePrefer;
				return IDC_CHECK_ADD_LABEL;	//----- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
			}
		}
		break;
		
	case QUICKFIT_PREFERENCE_FIT_CURVE:
		if( bSharedControls ) return 0;//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
		vector<uint> vnIDsFitCurve = { 
										IDC_GROUP_X_DATA_TYPE,	
										IDC_FIT_CURVE_SAME_AS_SOURCE_DATA, 
										IDC_FIT_CURVE_SAME_AS_SOURCE_SCALE, 
										IDC_FIT_CURVE_UNIFORM_LINEAR, 
										IDC_STATIC_NUM_POINTS, 
										IDC_X_NUMBER_OF_POINTS,
										/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
										IDC_STATIC_OUTPUT_FIT_CURVE_TO,
										IDC_COMBO_OUTPUT_FIT_CURVE_TO
										///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
										//IDC_CHECK_REPLACE_EXISTING_CURVE /// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
										};
		vnIDs = vnIDsFitCurve;
		break;
	///End REARRANGE_PREFERENCE_DLG_TABS	

		
	case QUICKFIT_PREFERENCE_ROI:
		if( bSharedControls ) return 0;//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
		vector<uint> vnIDsROIPrefer = {	
										/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
										IDC_GROUP_X_RANGE,
										IDC_STATIC_ROI_LEFT_X,
										IDC_STATIC_ROI_RIGHT_X,
										IDC_EDIT_ROI_LEFT_X,
										IDC_EDIT_ROI_RIGHT_X,
										///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
										
										IDC_CHECK_ROI_SHOW_TOOL_NAME, 
										IDC_EDIT_TOOL_NAME,
										IDC_CHECK_CLONE_MAINOBJ,	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
										/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
										/*
										///------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
										IDC_XSCALE_AUTO_FROM,
										IDC_XSCALE_AUTO_TO,
										///------ End SUPPORT_AUTO_FOR_X_SCALE
										*/
										IDC_CHECK_XSCALE_FIX,
										///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
										IDC_STATIC_ROI_SIGNIFICANT_DIGITS,
										IDC_COMBO_ROI_SIGNIFICANT_DIGITS,
										IDC_QUICK_FIT_ROI_PREFERENCE, 
										IDC_GROUP_ROI_TOP_TEXT, 
										///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
										//IDC_RADIO_ROI_NONE, 
										//IDC_RADIO_ROI_REDUCED_CHISQ, 
										//IDC_RADIO_ROI_ADJ_R_SQR, 
										//IDC_RADIO_ROI_PARAM, 
										///// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
										//IDC_RADIO_ROI_PEARSONS_R,
										//IDC_RADIO_ROI_R_SQUARE,
										///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
										IDC_CHECK_ROI_REDUCED_CHISQ,
										IDC_CHECK_ROI_ADJ_R_SQR,
										IDC_CHECK_ROI_PEARSONS_R,
										IDC_CHECK_ROI_R_SQUARE,
										IDC_STATIC_ROI_PARAM,
										///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
										///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
										//IDC_FRAME_PARAM_LIST
										IDC_GRID_PARAM_LIST
										///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
										/*, IDC_COMBO_ROI_PARAM_INDEX*/
										, IDC_APPLY /// Iris 2/25/2010 ONLY_SHOW_APPLY_BUTTON_ON_ROI_TAB
										};
		vnIDs = vnIDsROIPrefer;
		break;
		
	default:
		ASSERT(0);
		break;
	}
	
	return vnIDs.GetSize();
}

/// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
/*
BOOL QuickFitOutputReferDlg::showHideROIControls(int nTab)
{
	bool bIsROIPreferTab = QUICKFIT_PREFERENCE_ROI == nTab;
	vector<uint> vnROICtrls = 
	{
		IDC_APPLY,
		IDC_GROUP_X_RANGE,
		IDC_STATIC_ROI_LEFT_X,
		IDC_EDIT_ROI_LEFT_X,
		IDC_STATIC_ROI_RIGHT_X,
		IDC_EDIT_ROI_RIGHT_X,
		IDC_XSCALE_AUTO_FROM,
		IDC_XSCALE_AUTO_TO,
		IDC_CHECK_ROI_SHOW_TOOL_NAME,
		IDC_EDIT_TOOL_NAME,
		IDC_STATIC_ROI_SIGNIFICANT_DIGITS,
		IDC_COMBO_ROI_SIGNIFICANT_DIGITS,
		IDC_GROUP_ROI_TOP_TEXT,
		IDC_RADIO_ROI_NONE,
		IDC_RADIO_ROI_REDUCED_CHISQ,
		IDC_RADIO_ROI_ADJ_R_SQR,
		IDC_RADIO_ROI_PARAM,
		IDC_GRID_PARAM_LIST,
		IDC_QUICK_FIT_ROI_PREFERENCE,
		IDC_RADIO_ROI_PEARSONS_R,
		IDC_RADIO_ROI_R_SQUARE
	};
	ShowControls(vnROICtrls, bIsROIPreferTab);
	if ( bIsROIPreferTab )
	{
		int nFitMode = m_trSettings.mode.nVal;
		m_btnROITopAdjRSqr.Visible	= QUICK_FIT_MODE_NL == nFitMode;	//nlfit
		m_btnROITOPRSquare.Visible	= QUICK_FIT_MODE_LR == nFitMode;	//polynomial
		m_btnROITopPearson.Visible	= quick_fit_get_order(nFitMode, m_trSettings.func.strVal) == 1;	// linear
	}
	return TRUE;
}*/
//----
/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI

BOOL QuickFitOutputReferDlg::showHideControls(int nTab, bool bShow)
{
	//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
	// we should reuse the moving ID list to hide show
	vector<uint> vnIDs;
	getCtrlIDs(vnIDs, nTab, false);
	ShowControls(vnIDs, bShow);
	if(getCtrlIDs(vnIDs, nTab, true)) // if has shared controls
		ShowControls(vnIDs, bShow);
	
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	if ( QUICKFIT_PREFERENCE_ROI == nTab && bShow )
	{
		TreeNode trBranch = getBranchNodeByTab(nTab);
		ASSERT(trBranch);
		
		if( trBranch )
		{
			TreeNode trShowTop = trBranch.ShowTop;
			if ( trShowTop )
			{
				m_chkROITopChiSqr.Visible = trShowTop.ReduChisq.Show;			
				m_chkROITopAdjRSqr.Visible = trShowTop.AdjR.Show;			
				m_chkROITopRSquare.Visible = trShowTop.RSqr.Show;
				m_chkROITopPearson.Visible = trShowTop.Correlation.Show;
			}
		}		
	}
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
		
	return true;
	//---- 
	// old code begins here
	/*
	// Report tab
	bool bReport = QUICKFIT_PREFERENCE_REPORT == nTab;
	GetItem(IDC_GROUP_OUTPUT_TO).Visible =
	//m_checkInputRangeIndex.Visible =  /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX //---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED, should always show, commentted this out
	m_btnOutputNone.Visible =
	m_btnScript.Visible =
	m_btnResultLog.Visible =
	m_btnOutputToWks.Visible =
	GetItem(IDC_EDIT_WKS_NAME).Visible = bReport;
	
	// Fit Curve tab
	bool bFitCurve = QUICKFIT_PREFERENCE_FIT_CURVE == nTab;
	GetItem(IDC_GROUP_X_DATA_TYPE).Visible = 
	m_btnSameAsInput.Visible =
	m_btnUniform.Visible =
	m_btnSourceGraphSameScale.Visible =
	GetItem(IDC_STATIC_NUM_POINTS).Visible =
	m_btnNumPoints.Visible =
	/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	GetItem(IDC_STATIC_OUTPUT_FIT_CURVE_TO).Visible =
	m_comboOutputFitCurveTo.Visible =
	///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	//m_btnReplaceExistingCurve.Visible = /// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	bFitCurve;
	///End REARRANGE_PREFERENCE_DLG_TABS
	

	bool bTablePrefer = QUICKFIT_PREFERENCE_TABLE == nTab;
	GetItem(IDC_STATIC_ADD_TABLE_TO_GRAPH).Visible = 
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//m_comboAddTableToGraph.Visible = bTablePrefer;
	m_checkAddTableToGraph.Visible = bTablePrefer;
	///End USE_COMMON_REPLACE_CHECK
	///End REARRANGE_PREFERENCE_DLG_TABS

	// for controls shared in Text Box tab and Report tab
	//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
	//GetItem(IDC_TABLE_PREFER_SEPARATOR).Visible =
	GetItem(IDC_GROUP_OUTPUT_CONTENTS).Visible =
	//----
	GetItem(IDC_STATIC_SIGNIFICANT_DIGITS).Visible =
	m_comboSignDigits.Visible =
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	m_checkFunction.Visible = 
	m_checkInput.Visible = 
	m_checkOutput.Visible = 
	//m_checkWeighting.Visible =  /// Iris 2/04/2010 GET_RID_OF_WEIGHTING_CHECKBOX
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	GetItem(IDC_GROUP_FUNCTION).Visible =
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	//m_btnEquation.Visible = 
	GetItem(IDC_STATIC_EQUATION).Visible =
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	m_comboEquationFormat.Visible =
	m_comboParams.Visible = 
	m_checkShowError.Visible =				///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	GetItem(IDC_GROUP_PARAMETERS).Visible = 
	GetItem(IDC_STATIC_PARAMETER_TABLE).Visible = 
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	GetItem(IDC_GROUP_FIT_STATS).Visible =
	m_btnFitStatsRsqCod.Visible =
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	//m_btnFitStatsAdjRsq.Visible = bReport || bTablePrefer;	
	bReport || bTablePrefer;
	/// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
// 	m_btnFitStatsAdjRsq.Visible = m_btnFitStatsRsqCod.Visible && (0 == m_trSettings.mode.nVal); //nlfit
// 	m_btnFitStatsRSquare.Visible = m_btnFitStatsRsqCod.Visible && (0 != m_trSettings.mode.nVal); //polynomial
	m_btnFitStatsAdjRsq.Visible		= m_btnFitStatsRsqCod.Visible && (QUICK_FIT_MODE_NL		== m_trSettings.mode.nVal); //nlfit
	m_btnFitStatsRSquare.Visible	= m_btnFitStatsRsqCod.Visible && (QUICK_FIT_MODE_LR		== m_trSettings.mode.nVal); //polynomial
	/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	m_btnFitStatsCorrelation.Visible = m_btnFitStatsRsqCod.Visible && (1 == quick_fit_get_order(m_trSettings.mode.nVal, m_trSettings.func.strVal)); //linear
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

	showHideROIControls(nTab);
	/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	
	m_checkReplaceLastOutput.Visible = bFitCurve || bTablePrefer;
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	// to hidden unuseful controls, in order to not update rc file temp
	GetItem(IDC_GROUP_DIGITS).Visible = 
	GetItem(IDC_STATIC_AUTO_FROM).Visible = 
	GetItem(IDC_CHECK_AUTO_FROM).Visible = 
	GetItem(IDC_X_LOWER).Visible = 
	GetItem(IDC_STATIC_X_FROM_TO).Visible = 
	GetItem(IDC_X_UPPER).Visible = 
	GetItem(IDC_STATIC_AUTO_TO).Visible = 
	GetItem(IDC_CHECK_AUTO_TO).Visible = 
	GetItem(IDC_EDIT_HINT_X_RANGE).Visible = 
	GetItem(IDC_DATE_AND_TIME).Visible = 
	GetItem(IDC_FUNCTION_NAME).Visible =
	GetItem(IDC_THEMESAVE_SAVE_AS).Visible =
	GetItem(IDC_CHECK_REPLACE_EXISTING_CURVE).Visible =
	GetItem(IDC_STATIC_ADD_TABLE_TO_GRAPH).Visible =
	GetItem(IDC_COMBO_ADD_TABLE_TO_GRAPH).Visible =
	m_checkWeighting.Visible =  /// Iris 2/04/2010 GET_RID_OF_WEIGHTING_CHECKBOX
	false;
	///End REARRANGE_PREFERENCE_DLG_TABS
	return true;
	*/
	// old code ends here
	//---- end CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED

}

//----- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
/*
void QuickFitOutputReferDlg::updateSharedControlPos(int n1stGroupLastControl, int nCurrentTab, int nXOffset, int nGap)
{
	RECT rr1stGroupLastControl;
	GetControlClientRect(n1stGroupLastControl, rr1stGroupLastControl);
	
	RECT rr2ndGroupFirstControl;
	//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
	//int n2ndGroupFirstControl = IDC_TABLE_PREFER_SEPARATOR;
	//GetControlClientRect(n2ndGroupFirstControl, rr2ndGroupFirstControl);	// IDC_COMBO_SIGNIFICANT_DIGITS is the topest control in all shared control, so use hard code here.
	GetControlClientRect(ID_2ND_GROUP_1ST_CNTRL, rr2ndGroupFirstControl);
	//----
	
	int nYOffset = rr1stGroupLastControl.bottom + nGap - rr2ndGroupFirstControl.top;
	vector<uint> vnIDs;
	getCtrlIDs(vnIDs, nCurrentTab, true); 
	moveCtrlOffset(vnIDs, nXOffset, nYOffset);		
	
}*/
void QuickFitOutputReferDlg::moveControlsToTab(int nGap, int nTab, const RECT& rBounds)
{
	int nX = rBounds.left;
	int nY = rBounds.top;
	RECT rrLeftTop;
	vector<uint> vnIDs;
	int nG1Last = getCtrlIDs(vnIDs, nTab, false);
	int nG1C1 = vnIDs[0];
	GetControlClientRect(nG1C1, rrLeftTop);
	int	nXOffset = nX - rrLeftTop.left;
	int	nYOffset = nY - rrLeftTop.top;
	moveCtrlOffset(vnIDs, nXOffset, nYOffset);

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	if ( m_bSharedControlMoved )
		nXOffset = 0;
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS

	// move the shared controls if present
	if(getCtrlIDs(vnIDs, nTab, true))
	{
		RECT rr1stGroupLastControl;
		GetControlClientRect(nG1Last, rr1stGroupLastControl);
		int n2ndGroup1stID = vnIDs[0];
		RECT rr2ndGroupFirstControl;
		GetControlClientRect(n2ndGroup1stID, rr2ndGroupFirstControl);
		
		nYOffset = rr1stGroupLastControl.bottom + nGap - rr2ndGroupFirstControl.top;
		//printf("moving shared controls in tab %d:%d, nG1Last=%d, n2ndGroup1stID=%d, dx=%d, dy=%d\n", nTab, vnIDs.GetSize(), nG1Last, n2ndGroup1stID, nXOffset, nYOffset);
		moveCtrlOffset(vnIDs, nXOffset, nYOffset);

		///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
		m_bSharedControlMoved = TRUE;
		///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	}
}
//----- end QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
void QuickFitOutputReferDlg::initControlPos()
{
	RECT rr;
	Control ctrlTab;
	GetControlClientRect(IDC_QUICKFIT_PREFERENCE_TAB, rr, &ctrlTab);
	int nDlgWidth = RECT_WIDTH(rr);
	int nDlgHeight = GetDlgExtent(true);
	int nGap = GetControlGap();

	MoveControlsHelper	_temp(this);

	RECT rTab;
	rTab.left = nGap;
	rTab.top = 0;
	rTab.right = rTab.left + nDlgWidth;
	rTab.bottom = rTab.top + nDlgHeight;
	m_tab.AdjustRect(FALSE, &rTab);
	MoveControl(ctrlTab, rTab);

	int nCurrentTab = m_tab.GetCurSel(); /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	 
	RECT rrPanel;
	rrPanel.left = rTab.left;
	rrPanel.right = rTab.right;
	rrPanel.top = rTab.top + nGap;
	rrPanel.bottom = rTab.bottom;
	MoveControl(GetItem(IDC_QUICKFIT_PANEL), rrPanel);
	//---- CPY 2/19/10 HIDE_BLACK_PANEL_BOUNDING_RECT_IN_PREFERENCE_DLG
	moveControlsToTab(nGap, nCurrentTab, rrPanel);
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	if ( QUICKFIT_PREFERENCE_REPORT == nCurrentTab || QUICKFIT_PREFERENCE_TABLE == nCurrentTab )
	{
		RECT rc;
		GetControlClientRect(IDC_FIT_STATS_ADJRSQ, rc);
		MoveControl(GetItem(IDC_FIT_STATS_RSQUARE), rc);
		
		///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
		int		nIDBottom = IDC_FIT_STATS_ADJRSQ;
		//if ( QUICKFIT_PREFERENCE_REPORT == nCurrentTab && QUICK_FIT_MODE_NL == m_trSettings.mode.nVal )
		//{
			//nIDBottom = IDC_FIT_STATS_NUM_ITER;
		//}
		GetControlClientRect(nIDBottom, rc);

		RECT	rectGroupFitStats;
		GetControlClientRect(IDC_GROUP_FIT_STATS, rectGroupFitStats);
		int		nOldBottom = rectGroupFitStats.bottom;
		rectGroupFitStats.bottom = rc.bottom + nGap;
		int		nOffset = rectGroupFitStats.bottom - nOldBottom;

		vector<int>		vnIDs = { IDC_STATIC_SIGNIFICANT_DIGITS
			, IDC_COMBO_SIGNIFICANT_DIGITS
		};
		vector<int>		vnIDsBottomOnly = { IDC_GROUP_FIT_STATS
			, IDC_GROUP_OUTPUT_CONTENTS
		};
		moveContrlsVertical(vnIDs, vnIDsBottomOnly, nOffset);

		nIDBottom = IDC_CHECK_FITTED_CURVE_LEGEND;
		if ( QUICKFIT_PREFERENCE_REPORT == nCurrentTab )
		{
			nIDBottom = IDC_CHECK_OUTPUT;
		}
		GetControlClientRect(nIDBottom, rc);
		
		RECT	rrComboEquation;
		GetControlClientRect(IDC_COMBO_EQUATION_FORMAT, rrComboEquation);
		int		nOldTop = rrComboEquation.top;
		rrComboEquation.top = rc.bottom + nGap;
		nOffset = rrComboEquation.top - nOldTop;
		
		vector<int>		vnIDs2 = { IDC_STATIC_EQUATION
			, IDC_COMBO_EQUATION_FORMAT
			, IDC_COMBO_PARAMS
			, IDC_CHECK_SHOW_ERROR
			, IDC_FIT_STATS_RSQCOD
			, IDC_FIT_STATS_RSQUARE
			, IDC_FIT_STATS_ADJRSQ
			, IDC_FIT_STATS_PEARSON_R
			, IDC_FIT_STATS_NUM_ITER
			, IDC_FIT_STATS_FIT_STATUS
			, IDC_STATIC_SIGNIFICANT_DIGITS
			, IDC_COMBO_SIGNIFICANT_DIGITS

			, IDC_GROUP_PARAMETERS
			, IDC_GROUP_FIT_STATS
		};
		vector<int>		vnIDsBottomOnly2 = { IDC_GROUP_FUNCTION
			, IDC_GROUP_OUTPUT_CONTENTS
		};

		moveContrlsVertical(vnIDs2, vnIDsBottomOnly2, nOffset);
		///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	}
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	if ( QUICKFIT_PREFERENCE_ROI == nCurrentTab )
	{
		RECT rc;
		GetControlClientRect(IDC_CHECK_ROI_ADJ_R_SQR, rc);
		MoveControl(GetItem(IDC_CHECK_ROI_R_SQUARE), rc);
	}
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX

	// ROI tab special handling
	if( nCurrentTab == QUICKFIT_PREFERENCE_ROI ) /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	{
		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		Control ctrlGrid = GetItem(IDC_GRID_PARAM_LIST);				// move the grid control to top, no idea why it sink to the bottom(Z)
		if( ctrlGrid )
		{
			SetWindowPos(ctrlGrid.GetSafeHwnd(), HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		}
		///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	}
	//----
	/* old code
	int nX = rrPanel.left + nGap;
	int nY = rrPanel.top + nGap;
	RECT rrLeftTop;
	vector<uint> vnIDs;
	int nXOffset, nYOffset;
	// Report tab
	if( nCurrentTab == QUICKFIT_PREFERENCE_REPORT ) /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	{
		GetControlClientRect(IDC_GROUP_OUTPUT_TO, rrLeftTop);
		int nGroupWidth = RECT_WIDTH(rrLeftTop);	
		nXOffset = nX - rrLeftTop.left;
		nYOffset = nY - rrLeftTop.top;
		/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
		//getCtrlIDs(vnIDs, QUICKFIT_PREFERENCE_OUTPUT);
		getCtrlIDs(vnIDs, nCurrentTab, false);
		///End REARRANGE_PREFERENCE_DLG_TABS
		moveCtrlOffset(vnIDs, nXOffset, nYOffset);
		
		/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
		// move the shared controls
		updateSharedControlPos(IDC_GROUP_OUTPUT_TO, nCurrentTab, nXOffset, nGap);
		///End REARRANGE_PREFERENCE_DLG_TABS
	}
	
	// Text Box tab
	if( nCurrentTab == QUICKFIT_PREFERENCE_TABLE ) /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	{
		// 1st group controls
		/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
		GetControlClientRect(IDC_CHECK_ADD_LABEL, rrLeftTop);
		nXOffset = nX - rrLeftTop.left;
		nYOffset = nY - rrLeftTop.top;
		///End USE_COMMON_REPLACE_CHECK
		
		///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
		getCtrlIDs(vnIDs, nCurrentTab, false);
		moveCtrlOffset(vnIDs, nXOffset, nYOffset);
		
		/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
		// move 2nd group: the shared controls
		//updateSharedControlPos(IDC_COMBO_ADD_TABLE_TO_GRAPH, nCurrentTab, nXOffset, nGap);
		updateSharedControlPos(IDC_CHECK_ADD_LABEL, nCurrentTab, nXOffset, nGap);
		///End REARRANGE_PREFERENCE_DLG_TABS
	}
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	// Fit Curve tab
	if( nCurrentTab == QUICKFIT_PREFERENCE_FIT_CURVE ) /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	{
		GetControlClientRect(IDC_GROUP_X_DATA_TYPE, rrLeftTop);
		nXOffset = nX - rrLeftTop.left;
		nYOffset = nY - rrLeftTop.top;
		getCtrlIDs(vnIDs, nCurrentTab);
		moveCtrlOffset(vnIDs, nXOffset, nYOffset);
	}
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	if ( QUICKFIT_PREFERENCE_REPORT == nCurrentTab || QUICKFIT_PREFERENCE_TABLE == nCurrentTab )
	{
		RECT rc;
		GetControlClientRect(IDC_FIT_STATS_ADJRSQ, rc);
		MoveControl(GetItem(IDC_FIT_STATS_RSQUARE), rc);
	}
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

	// ROI tab
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	if( nCurrentTab == QUICKFIT_PREFERENCE_ROI ) /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	{
		/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
		GetControlClientRect(IDC_GROUP_X_RANGE, rrLeftTop);	
		nXOffset = nX - rrLeftTop.left;
		nYOffset = nY - rrLeftTop.top;
		///End USE_COMMON_REPLACE_CHECK
		///End REARRANGE_PREFERENCE_DLG_TABS
		getCtrlIDs(vnIDs, nCurrentTab);
		moveCtrlOffset(vnIDs, nXOffset, nYOffset);
		
		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		Control ctrlGrid = GetItem(IDC_GRID_PARAM_LIST);				// move the grid control to top, no idea why it sink to the bottom(Z)
		if( ctrlGrid )
		{
			SetWindowPos(ctrlGrid.GetSafeHwnd(), HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		}
		///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	}
	*/
	//---- end CPY 2/19/10 HIDE_BLACK_PANEL_BOUNDING_RECT_IN_PREFERENCE_DLG
}

///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
void	QuickFitOutputReferDlg::moveContrlsVertical(vector<int>& vnIDs, vector<int>& vnIDsBottomOnly, int nOffset)
{
	for ( int ii=0; ii<vnIDs.GetSize(); ++ii )
	{
		RECT	rr;
		GetControlClientRect(vnIDs[ii], rr);
		rr.top += nOffset;
		rr.bottom += nOffset;
		MoveControl(GetItem(vnIDs[ii]), rr);
	}

	for ( ii=0; ii<vnIDsBottomOnly.GetSize(); ++ii )
	{
		RECT	rr;
		GetControlClientRect(vnIDsBottomOnly[ii], rr);
		rr.bottom += nOffset;
		MoveControl(GetItem(vnIDsBottomOnly[ii]), rr);
	}
}
///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS

void QuickFitOutputReferDlg::moveCtrlOffset(const vector<uint>& vnIDs, int nXOffset, int nYOffset)
{
	if(nXOffset == 0 && nYOffset == 0)
		return;

	RECT rr;
	Control ctrl;
	for(int ii=0; ii<vnIDs.GetSize(); ii++)
	{
		GetControlClientRect(vnIDs[ii], rr, &ctrl);
		if(ctrl)
		{
			rr.left += nXOffset;
			rr.right += nXOffset;
			rr.top += nYOffset;
			rr.bottom += nYOffset;
			MoveControl(ctrl, rr);
		}
	}
}

BOOL QuickFitOutputReferDlg::resizeDlgToFitControls(int nTab)
{
	int nGap = GetControlGap();
	RECT rPanel;
	Control ctrlPanel;
	GetControlClientRect(IDC_QUICKFIT_PANEL, rPanel, &ctrlPanel);
	
	int nFirstControlID, nLastControlID;
	switch(nTab)
	{	
	case QUICKFIT_PREFERENCE_REPORT:
		nFirstControlID = IDC_GROUP_OUTPUT_TO;
		nLastControlID = ID_REPORT_BOX_LAST_CNTRL;
		break;
		
	case QUICKFIT_PREFERENCE_TABLE:	
		nFirstControlID = IDC_CHECK_ADD_LABEL;
		nLastControlID = ID_REPORT_BOX_LAST_CNTRL;
		break;
		
	case QUICKFIT_PREFERENCE_FIT_CURVE:
		nFirstControlID = IDC_GROUP_X_DATA_TYPE;
		nLastControlID = IDC_COMBO_OUTPUT_FIT_CURVE_TO;
		break;
		
	case QUICKFIT_PREFERENCE_ROI:
		nFirstControlID = IDC_GROUP_X_RANGE;
		nLastControlID = IDC_QUICK_FIT_ROI_PREFERENCE;		
		break;		
	}
	
	RECT rrTopCtrl, rrBottomCtrl;
	GetControlClientRect(nFirstControlID, rrTopCtrl);
	GetControlClientRect(nLastControlID, rrBottomCtrl);
	
	rPanel.top = rrTopCtrl.top - nGap;
	rPanel.bottom = rrBottomCtrl.bottom + nGap;
	int nPanelWidth = RECT_WIDTH(rPanel);
	rPanel.left = rrTopCtrl.left - nGap;
	rPanel.right = rPanel.left + nPanelWidth;
	
	//	SetWindowPos(ctrlPanel.GetSafeHwnd(), GetSafeHwnd(), rPanel.left, rPanel.top, RECT_WIDTH(rPanel), RECT_HEIGHT(rPanel), SWP_NOZORDER);
	SetWindowPos(ctrlPanel.GetSafeHwnd(), NULL, rPanel.left, rPanel.top, RECT_WIDTH(rPanel), RECT_HEIGHT(rPanel), SWP_NOZORDER);
	//SetWindowPos(ctrlPanel.GetSafeHwnd(), NULL, rPanel.left, rPanel.top, RECT_WIDTH(rPanel), RECT_HEIGHT(rPanel), SWP_NOZORDER);

	
	RECT rTab;
	rTab = rPanel;	
	m_tab.AdjustRect(TRUE, &rTab);
	//SetWindowPos(m_tab.GetSafeHwnd(), GetSafeHwnd(), rTab.left, rTab.top, RECT_WIDTH(rTab), RECT_HEIGHT(rTab), SWP_NOZORDER);
	//SetWindowPos(m_tab.GetSafeHwnd(), HWND_BOTTOM, rTab.left, rTab.top, RECT_WIDTH(rTab), RECT_HEIGHT(rTab), 0);
	SetWindowPos(m_tab.GetSafeHwnd(), NULL, rTab.left, rTab.top, RECT_WIDTH(rTab), RECT_HEIGHT(rTab), SWP_NOZORDER);
	
	RECT rrOK, rrCancel, rrApply, rrReplace;
	Control ctrlOK, ctrlCancel, ctrlApply;
	GetControlClientRect(IDOK, rrOK, &ctrlOK);
	GetControlClientRect(IDCANCEL, rrCancel, &ctrlCancel);
	GetControlClientRect(IDC_APPLY, rrApply, &ctrlApply);
	int nBtnWidth = RECT_WIDTH(rrOK);
	int nBtnHeight = RECT_HEIGHT(rrOK);

	/// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	RECT rrErrMsg;
	bool bShowErrMsg = setErrorMsgShow(rTab, rrErrMsg);
	///End CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG

	rrCancel.right = rTab.right;
	rrCancel.left = rrCancel.right - nBtnWidth;
	/// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	//rrCancel.top = rTab.bottom + nGap;
	rrCancel.top = bShowErrMsg? rrErrMsg.bottom : rTab.bottom + nGap;
	///End CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	rrCancel.bottom = rrCancel.top + nBtnHeight;
	MoveControl(ctrlCancel, rrCancel);

	rrOK = rrCancel;
	rrOK.right = rrCancel.left - nGap;
	rrOK.left = rrOK.right - nBtnWidth;
	MoveControl(ctrlOK, rrOK);		
		
	rrApply = rrCancel;
	int		nApplyWitdth = RECT_WIDTH(rrApply);
	rrApply.left = rTab.left + nGap;
	rrApply.right = rrApply.left + nApplyWitdth;
	MoveControl(ctrlApply, rrApply);	
	
	//-------CPY 2/19/10 QUICK_FIT_REMOVE_REPLACE_LAST_CHK_WITH_2_CMD_MENU
	/*
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	int nReplaceCheckWidth = RECT_WIDTH(rrReplace);
	int nReplaceCheckHeight = RECT_HEIGHT(rrReplace);
	rrReplace.left = rrApply.left;
	rrReplace.right = rrReplace.left + nReplaceCheckWidth;
	rrReplace.bottom = rrApply.top + nBtnHeight/2.0 + nReplaceCheckHeight/2.0;
	rrReplace.top = rrReplace.bottom - nReplaceCheckHeight;
	MoveControl(ctrlReplace, rrReplace); 
	///End USE_COMMON_REPLACE_CHECK
	*/
	//-------

	RECT rrClient;
	GetClientRect(&rrClient);
	//rrClient.right = rrClient.left + nGap + RECT_WIDTH(rTab) + nGap;
	rrClient.right = rrClient.left + nGap + RECT_WIDTH(rTab);
	rrClient.bottom = rrClient.top + rrOK.bottom - rTab.top + nGap;
	ClientToScreen(&rrClient);
	
	RECT rtDlg;
	GetWindowRect(&rtDlg);
	rtDlg.right = rrClient.right;
	rtDlg.bottom = rrClient.bottom;
	MoveWindow(&rtDlg, true);

	InvalidateRect(GetSafeHwnd(), NULL, TRUE);

	return true;
}

/// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
bool QuickFitOutputReferDlg::setErrorMsgShow(RECT rTab, RECT& rrErrMsg)
{
	Control ctrlErrMsg;
	GetControlClientRect(IDC_STATIC_STATIC_ERR_MESSAGE_BOX, rrErrMsg, &ctrlErrMsg);
	int nWidth = RECT_WIDTH(rrErrMsg);
	int nHeight = RECT_HEIGHT(rrErrMsg);
	
	rrErrMsg.left = rTab.left;
	rrErrMsg.right = RECT_WIDTH(rTab);
	rrErrMsg.top = rTab.bottom + GetControlGap();
	rrErrMsg.bottom = rrErrMsg.top + nHeight;
	MoveControl(ctrlErrMsg, rrErrMsg);
	//----- CPY 2/19/10 QUICK_FIT_REMOVE_REPLACE_LAST_CHK_WITH_2_CMD_MENU
	//vector<uint> vnLastRowButtonIDs = {IDOK, IDCANCEL, IDC_APPLY, IDC_CHECK_REPLACE_LAST_UPDATE};
	vector<uint> vnLastRowButtonIDs = {IDOK, IDCANCEL, IDC_APPLY};
	//-----
	if( m_strErrMsg.IsEmpty() )
	{
		m_btnErrMsg.Visible = false;
		
		for(int nn = 0; nn < vnLastRowButtonIDs.GetSize(); nn++)
		{
			RECT rrButton;
			Control btn;
			GetControlClientRect(vnLastRowButtonIDs[nn], rrButton, &btn);
			
			int nBtnHeight = RECT_HEIGHT(rrButton);
			rrButton.top = rrErrMsg.top;
			rrButton.bottom = rrButton.top + nBtnHeight;
			MoveControl(btn, rrButton); 
		}
	}
	else
	{
		m_btnErrMsg.Visible = true;
		m_btnErrMsg.Text = m_strErrMsg;
		
		for(int nn = 0; nn < vnLastRowButtonIDs.GetSize(); nn++)
		{
			RECT rrButton;
			Control btn;
			GetControlClientRect(vnLastRowButtonIDs[nn], rrButton, &btn);
			
			int nBtnHeight = RECT_HEIGHT(rrButton);
			rrButton.top = rrErrMsg.bottom + GetControlGap();
			rrButton.bottom = rrButton.top + nBtnHeight;
			MoveControl(btn, rrButton); 
		}
	}
	return (!m_strErrMsg.IsEmpty());
}
///End CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG

BOOL QuickFitOutputReferDlg::OnTabChange(Control ctrl)
{
	int nTab = m_tab.GetCurSel();
	
	initControlPos(); /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS	
	resizeDlgToFitControls(nTab);
	//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
	//showHideControls(nTab);
	for(int nn = QUICKFIT_PREFERENCE_TABLE; nn < QUICKFIT_PREFERENCE_TOTAL; nn++)
	{
		if(nn==nTab) continue;
		showHideControls(nn, false);
	}
	showHideControls(nTab, true);
	
	GetItem(IDC_QUICKFIT_PANEL).Visible=true;	//---- CPY 2/19/10 HIDE_BLACK_PANEL_BOUNDING_RECT_IN_PREFERENCE_DLG

	//----
	checkEnableApply();
	
	initSharedControlValues();// update output choice controls when switch Report tab and Text Box tab
	enableTablePreferCtrls();
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	/*
	/// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	if( QUICKFIT_PREFERENCE_TABLE == m_tab.GetCurSel() || QUICKFIT_PREFERENCE_REPORT == m_tab.GetCurSel() )
	{
		//----- CPY 2/16/2010 RENAME_INPUT_TO_SOURCE_PLOT
		//	m_checkInput.Text = QUICKFIT_PREFERENCE_TABLE == m_tab.GetCurSel()? _L("Input") : _L("Input Legend");
		m_checkInput.Text = QUICKFIT_PREFERENCE_TABLE == m_tab.GetCurSel()? TABLE_LABEL_INPUT : TABLE_LABEL_INPUT_LEGEND;
		//-----
	}
	//	///End OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	*/
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	return true;
}

void QuickFitOutputReferDlg::setTabDirty(int nTab, bool bDirty)
{
	if(nTab >= 0 && nTab < QUICKFIT_PREFERENCE_TOTAL)
	{
		m_vbTabDirty[nTab] = bDirty;
		checkEnableApply();
	}
}

void QuickFitOutputReferDlg::checkEnableApply()
{
	int nTab = m_tab.GetCurSel();
	if(nTab == QUICKFIT_PREFERENCE_TABLE || nTab == QUICKFIT_PREFERENCE_ROI)
	{
		bool bEnable = m_vbTabDirty[nTab];

		// always disable Apply button when no Table or ROI on graph
		GraphLayer gl = Project.ActiveLayer();
		if( gl && bEnable )
		{
			if(nTab == QUICKFIT_PREFERENCE_TABLE)
			{
				GraphObject goTextBox;
				bEnable = _get_last_text_box_object(gl, goTextBox);			
			}
			else if(nTab == QUICKFIT_PREFERENCE_ROI)
			{
				string strRect;
				if( !get_gl_quick_fit_rect_go_name(gl, strRect) || !gl.GraphObjects(strRect).IsValid())
					bEnable = false;
			}
		}
		
		Control ctrlApply = GetItem(IDC_APPLY);
		if(ctrlApply)
			ctrlApply.Enable = bEnable;
	}
}

BOOL QuickFitOutputReferDlg::OnDlgResize(int nType, int cx, int cy)
{
	return true;
}	

BOOL QuickFitOutputReferDlg::OnRestoreSize(DWORD dwSizeInfo)
{

	void * p = (void*)dwSizeInfo;
	DLGSIZEINFO *pSz = (DLGSIZEINFO*)p;
	
	lstrcpyn(pSz->szDialogName, STR_OUTPUT_REFER_DLG_NAME, MAXLINE);
	
	pSz->top = -1;
	pSz->left = -1;
	pSz->width = 450;  //hard code, will change later
	pSz->height = 300;  //hard code, will change later
	return TRUE;
}

BOOL QuickFitOutputReferDlg::OnOutputResultToChange(Control ctrl)
{
	enableTablePreferCtrls();	
	return true;
}

//X Data Type
///Sophy 3/1/2010 UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG
BOOL QuickFitOutputReferDlg::OnXDataTypeChange(Control ctrl)
{
	bool bSameAsInput = (1 == m_btnSameAsInput.Value);
	if ( bSameAsInput )
	{
		int nNumPts;
		getSourceFromTo(NULL, NULL, &nNumPts);
		m_btnNumPoints.Text = nNumPts;
	}
	GetItem(IDC_STATIC_NUM_POINTS).Visible = m_btnNumPoints.Visible = !bSameAsInput;
	return true;
}
///end UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG

// Table
/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
//BOOL QuickFitOutputReferDlg::OnAddTableToGraph(Control ctrl)
BOOL QuickFitOutputReferDlg::OnAddTableToGraphSelChange(Control ctrl)
///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
{
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING		
	//enableTablePreferCtrls(m_btnAddToGraph.Value);
	enableTablePreferCtrls();
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	setTabDirty(QUICKFIT_PREFERENCE_TABLE);
	return true;
}

void QuickFitOutputReferDlg::enableTablePreferCtrls()
{
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	bool bEnable = true;	
	if(	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
		/*QUICKFIT_PREFERENCE_TABLE == m_tab.GetCurSel() && ADD_TEXTBOX_NONE == m_comboAddTableToGraph.GetCurSel() ||*/
		QUICKFIT_PREFERENCE_TABLE == m_tab.GetCurSel() && 0 == m_checkAddTableToGraph.Value ||
		///End USE_COMMON_REPLACE_CHECK
		QUICKFIT_PREFERENCE_REPORT == m_tab.GetCurSel() && m_btnOutputNone.Value )
		bEnable = false;	
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	m_btnDateAndTime.Enable =
	m_btnFunctionName.Enable =
	*/
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	/*
	m_btnEquation.Enable =
	m_btnParamValue.Enable =
	m_btnParamError.Enable =
	*/
	m_comboSignDigits.Enable = 
	m_checkFunction.Enable = 
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//m_checkInput.Enable = 
	//m_checkInputRangeIndex.Enable = /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	//m_checkOutput.Enable = 
	m_comboInput.Enable = 
	m_comboInputRange.Enable =
	m_comboOutput.Enable = 
	m_chkAddLegendSymbols.Enable = 
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	//m_checkWeighting.Enable =  /// Iris 2/04/2010 GET_RID_OF_WEIGHTING_CHECKBOX
	m_comboEquationFormat.Enable = 
	m_comboParams.Enable = 
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	m_btnFitStatsRSquare.Enable =
	m_btnFitStatsCorrelation.Enable =
	m_btnFitStatsRsqCod.Enable =
	m_btnFitStatsAdjRsq.Enable = bEnable;
	m_checkShowError.Enable = bEnable && (PARAMETER_TABLE_NONE != m_comboParams.GetCurSel());			///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	
	//m_comboEquationFormat.Enable = bEnable && m_btnEquation.Value; /// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	m_edOutputWksName.Enable = m_btnOutputToWks.Value;

}

/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
/*
BOOL QuickFitOutputReferDlg::OnDateAndTime(Control ctrl)
{
	setTabDirty(QUICKFIT_PREFERENCE_TABLE);
	return true;
}

BOOL QuickFitOutputReferDlg::OnCheckFuncName(Control ctrl)
{
	setTabDirty(QUICKFIT_PREFERENCE_TABLE);
	return true;
}
*/
///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME

/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
/*
BOOL QuickFitOutputReferDlg::OnCheckFuncFormat(Control ctrl)
{
	//m_comboEquationFormat.Enable = m_btnEquation.Value; /// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	setTabDirty(QUICKFIT_PREFERENCE_TABLE);
	return true;
}
*/
///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
bool QuickFitOutputReferDlg::onSharedControlChange(Control ctrl)
{
	updateSharedSettings(m_tab.GetCurSel());
	setTabDirty(m_tab.GetCurSel());
	return true;
}

BOOL QuickFitOutputReferDlg::OnSignDigitsChange(Control ctrl)
{
	return onSharedControlChange(ctrl);
}

BOOL QuickFitOutputReferDlg::OnEquationFormatChange(Control ctrl)
{
	return onSharedControlChange(ctrl);
}

/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
/*
BOOL QuickFitOutputReferDlg::OnCheckValue(Control ctrl)
{
	setTabDirty(QUICKFIT_PREFERENCE_TABLE);
	return true;
}

BOOL QuickFitOutputReferDlg::OnCheckError(Control ctrl)
{
	setTabDirty(QUICKFIT_PREFERENCE_TABLE);
	return true;
}
*/
BOOL QuickFitOutputReferDlg::OnParamTableChange(Control ctrl)
{
	m_checkShowError.Enable = PARAMETER_TABLE_NONE != m_comboParams.GetCurSel();///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	return onSharedControlChange(ctrl);
}

///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
BOOL QuickFitOutputReferDlg::OnShowErrorChange(Control ctrl)
{
	return onSharedControlChange(ctrl);
}
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB

BOOL QuickFitOutputReferDlg::OnCheckFunction(Control ctrl)
{
	return onSharedControlChange(ctrl);
}
BOOL QuickFitOutputReferDlg::OnCheckInput(Control ctrl)
{
	return onSharedControlChange(ctrl);
}

BOOL QuickFitOutputReferDlg::OnCheckOutput(Control ctrl)
{
	return onSharedControlChange(ctrl);
}
///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
///Sophy 1/23/2010 SET_DIRTYBIT_FOR_SHOW_TOOLNAME_EVENT
BOOL QuickFitOutputReferDlg::OnShowToolName(Control ctrl)
{
	m_edToolName.Enable = m_checkAddToolName.Value;
	setTabDirty(m_tab.GetCurSel());
	return TRUE;
}

BOOL QuickFitOutputReferDlg::OnToolNameChange(Control ctrl)
{
	setTabDirty(m_tab.GetCurSel());
	return TRUE;
}
///end SET_DIRTYBIT_FOR_SHOW_TOOLNAME_EVENT

///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
BOOL QuickFitOutputReferDlg::OnCheckCloneMainObj(Control ctrl)
{
	setTabDirty(m_tab.GetCurSel());
	return TRUE;
}
///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
///Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
BOOL QuickFitOutputReferDlg::OnAfterReportWksChange(Control ctrl, UINT nMsg, UINT wParam, UINT lParam)
{
	if ( WM_KEYDOWN != nMsg )
		return FALSE;
	switch(wParam)
	{
	case VK_RETURN:
		return OnReportWksNameChange(ctrl);
		break;
		
	default:
		return FALSE;
	}
	return TRUE;
}

BOOL QuickFitOutputReferDlg::OnReportWksNameChange(Control ctrl)
{
	ROIToolOptionAccessHelper clHelper(ROI_OPTION_IGNORE_EVENT);
	string strBookSheetName = m_edOutputWksName.Text;
	/// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	//check_update_worksheet_name(strBookSheetName);
	//m_edOutputWksName.Text = strBookSheetName;	
	string strOldErrMsg = m_strErrMsg;
	if( !check_update_worksheet_name(strBookSheetName) )
	{
		m_edOutputWksName.Text = strBookSheetName;
		ocu_load_err_msg_str(CER_SHEET_NAME_ILLEGAL_CHAR, &m_strErrMsg);
	}
	else
	{
		m_strErrMsg.Empty();
	}
	if( strOldErrMsg.GetLength() == 0 && m_strErrMsg.GetLength() != 0 
			|| strOldErrMsg.GetLength() != 0 && m_strErrMsg.GetLength() == 0 )
	{
		resizeDlgToFitControls(m_tab.GetCurSel());
	}
	///End CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	return TRUE;
}
///end CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS

BOOL QuickFitOutputReferDlg::OnCheckRSQCOD(Control ctrl)
{
	return onSharedControlChange(ctrl);
}

BOOL QuickFitOutputReferDlg::OnCheckADJRSQ(Control ctrl)
{
	return onSharedControlChange(ctrl);
}

///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
BOOL QuickFitOutputReferDlg::OnCheckRSQuare(Control ctrl)
{
	return onSharedControlChange(ctrl);
}
BOOL QuickFitOutputReferDlg::OnCheckCorrelation(Control ctrl)
{
	return onSharedControlChange(ctrl);
}
///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
BOOL	QuickFitOutputReferDlg::OnCheckNumIter(Control ctrl)
{
	return onSharedControlChange(ctrl);
}

BOOL	QuickFitOutputReferDlg::OnCheckFitStatus(Control ctrl)
{
	return onSharedControlChange(ctrl);
}
///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS

void QuickFitOutputReferDlg::convertOutputChoiceFromDlgToThemeTree(TreeNode& tr)
{
	tr.SignDigits.nVal = m_comboSignDigits.GetCurSel();
	//tr.Equation.nVal = m_btnEquation.Value; /// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	tr.EquationFormat.nVal = m_comboEquationFormat.GetCurSel();
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	/*
	tr.Value.nVal = m_btnParamValue.Value;
	tr.Error.nVal = m_btnParamError.Value;
	*/
	tr.Function.nVal = m_checkFunction.Value;
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//tr.Input.nVal = m_checkInput.Value;
	///// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	//if( tr.InputRangeIndex.Show )
		//tr.InputRangeIndex.nVal = m_checkInputRangeIndex.Value;
	/////End OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	//tr.Output.nVal = m_checkOutput.Value;
	tr.Input.nVal = m_comboInput.GetCurSel();
	if( tr.InputRange.Show )
		tr.InputRange.nVal = m_comboInputRange.GetCurSel();
	tr.Output.nVal = m_comboOutput.GetCurSel();
	if( tr.Legend.Show )
		tr.Legend.nVal = m_chkAddLegendSymbols.Value;
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	//tr.Weighting.nVal = m_checkWeighting.Value; /// Iris 2/04/2010 GET_RID_OF_WEIGHTING_CHECKBOX
	tr.Params.nVal = m_comboParams.GetCurSel();
	tr.ShowError.nVal = m_checkShowError.Value;			///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	tr.ReduChisq.nVal = m_btnFitStatsRsqCod.Value;
	tr.AdjR.nVal = m_btnFitStatsAdjRsq.Value;		
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	tr.RSqr.nVal = m_btnFitStatsRSquare.Value;
	tr.Correlation.nVal = m_btnFitStatsCorrelation.Value;
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	if ( tr.NumIter )
		tr.NumIter.nVal = m_btnFitStatsNumIter.Value;
	if ( tr.FitStatus )
		tr.FitStatus.nVal = m_btnFitStatsFitStatus.Value;
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
}


void QuickFitOutputReferDlg::convertTableSettingsFromDlgToThemeTree(TreeNode& trTableTheme)
{
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING		
	//trTableTheme.TextTable.nVal = m_btnAddToGraph.Value;
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//trTableTheme.TextTable.nVal = m_comboAddTableToGraph.GetCurSel();
	trTableTheme.TextTable.nVal = m_checkAddTableToGraph.Value;
	///End USE_COMMON_REPLACE_CHECK
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING	
	
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	trTableTheme.DateTime.nVal = m_btnDateAndTime.Value;
	trTableTheme.FuncName.nVal = m_btnFunctionName.Value;
	*/
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	/*
	trTableTheme.Equation.nVal = m_btnEquation.Value;
	trTableTheme.EquationFormat.nVal = m_comboEquationFormat.GetCurSel();
	trTableTheme.Value.nVal = m_btnParamValue.Value;
	trTableTheme.Error.nVal = m_btnParamError.Value;
	trTableTheme.ReduChisq.nVal = m_btnFitStatsRsqCod.Value;
	trTableTheme.AdjR.nVal = m_btnFitStatsAdjRsq.Value;	
	*/
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	// once shared control change, immediately update m_trSetting from dialog
	//convertOutputChoiceFromDlgToThemeTree(trTableTheme);
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	///End REARRANGE_PREFERENCE_DLG_TABS
}

/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
/*
void QuickFitOutputReferDlg::convertOutputSettingsFromDlgToThemeTree(TreeNode& trOutput)
{	
	trOutput.OutputTo.nVal = m_btnOutputNone.Value? OUTPUT_TO_NONE : trOutput.OutputTo.nVal;
	trOutput.OutputTo.nVal = m_btnScript.Value? OUTPUT_TO_SCRIPT_WND : trOutput.OutputTo.nVal;
	trOutput.OutputTo.nVal = m_btnResultLog.Value? OUTPUT_TO_RESULT_LOG : trOutput.OutputTo.nVal;
	trOutput.SignDigits.nVal = m_comboSignDigits.GetCurSel();
	trOutput.FitCurve.nVal = 1 == m_btnSameAsInput.Value? FIT_CURVE_TYPE_SAME_AS_INPUT : trOutput.FitCurve.nVal;
	trOutput.FitCurve.nVal = 1 == m_btnUniform.Value? FIT_CURVE_TYPE_UNIFORM : trOutput.FitCurve.nVal;
	trOutput.FitCurve.nVal = 1 == m_btnSourceGraphSameScale.Value? FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE : trOutput.FitCurve.nVal;
	trOutput.XFrom.strVal = m_btnXFrom.Text;
	trOutput.XTo.strVal = m_btnXTo.Text;
	/// Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG	
	//trOutput.XAutoFrom.nVal = m_btnXAutoFrom.Value;
	//trOutput.XAutoTo.nVal = m_btnXAutoTo.Value;	
	TreeNode trXFrom = trOutput.XFrom, trXTo = trOutput.XTo;
	octree_set_auto_support(&trXFrom, m_btnXAutoFrom.Value? 1 : -1);
	octree_set_auto_support(&trXTo, m_btnXAutoTo.Value? 1 : -1);
	///End NEW_QUICKFIT_ROI_XF_DLG
	trOutput.NumPoints.strVal = m_btnNumPoints.Text;
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	trOutput.ReplaceExistingCurve.nVal = m_btnReplaceExistingCurve.Value;
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT	
}
*/
void QuickFitOutputReferDlg::convertReportSettingsFromDlgToThemeTree(TreeNode& tr)
{
	tr.OutputTo.nVal = m_btnOutputNone.Value? OUTPUT_TO_NONE : tr.OutputTo.nVal;
	tr.OutputTo.nVal = m_btnScript.Value? OUTPUT_TO_SCRIPT_WND : tr.OutputTo.nVal;
	tr.OutputTo.nVal = m_btnResultLog.Value? OUTPUT_TO_RESULT_LOG : tr.OutputTo.nVal;	
	tr.OutputTo.nVal = m_btnOutputToWks.Value? OUTPUT_TO_WORKSHEET : tr.OutputTo.nVal;
	tr.WksName.strVal = m_edOutputWksName.Text;
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	// once shared control change, immediately update m_trSetting from dialog
	//convertOutputChoiceFromDlgToThemeTree(trTableTheme);
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN

}

void QuickFitOutputReferDlg::convertFitCurveSettingsFromDlgToThemeTree(TreeNode& tr)
{
	tr.FitCurve.nVal = 1 == m_btnSameAsInput.Value? FIT_CURVE_TYPE_SAME_AS_INPUT : tr.FitCurve.nVal;
	tr.FitCurve.nVal = 1 == m_btnUniform.Value? FIT_CURVE_TYPE_UNIFORM : tr.FitCurve.nVal;
	tr.FitCurve.nVal = 1 == m_btnSourceGraphSameScale.Value? FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE : tr.FitCurve.nVal;
	tr.NumPoints.strVal = m_btnNumPoints.Text;
	/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	tr.OutputFitCurveTo.nVal = m_comboOutputFitCurveTo.GetCurSel();
	///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	tr.ReplaceExistingCurve.nVal = m_btnReplaceExistingCurve.Value;
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	*/
	///End USE_COMMON_REPLACE_CHECK
}
///End REARRANGE_PREFERENCE_DLG_TABS

void QuickFitOutputReferDlg::convertROISettingsFromDlgToThemeTree(TreeNode& trROI)
{
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/*
	///------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	///// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	//trROI.leftx.strVal = m_edROILeftX.Text;
	//trROI.rightx.strVal = m_edROIRightX.Text;	
	/////End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	TreeNode	trLeftX = trROI.leftx;
	TreeNode	trRightX = trROI.rightx;
	trLeftX.strVal = m_edROILeftX.Text;
	trRightX.strVal = m_edROIRightX.Text;
	octree_set_auto_support(&trLeftX, m_checkAutoXFrom.Check ? 1 : -1);
	octree_set_auto_support(&trRightX, m_checkAutoXTo.Check ? 1 : -1);
	///------ End SUPPORT_AUTO_FOR_X_SCALE
	*/
	trROI.XScale.leftx.strVal = m_edROILeftX.Text;
	trROI.XScale.rightx.strVal = m_edROIRightX.Text;
	trROI.XScale.fixscale.strVal = m_checkXScaleFix.Value;	
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	trROI.toolname.strVal = m_edToolName.Text;
	trROI.toolname.SetAttribute(STR_ATTRIB_DYNACONTROL_USE_CHECK, m_checkAddToolName.Value);
	trROI.cloneROI.nVal = m_checkCloneMainObj.Value;	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	trROI.SignDigits.nVal = m_comboROISignDigits.GetCurSel();
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	///// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//// 	trROI.ShowTop.nVal = m_btnROITopNone.Value? ROI_TOP_SHOW_NONE : trROI.ShowTop.nVal;
//// 	trROI.ShowTop.nVal = m_btnROITopChiSqr.Value? ROI_TOP_SHOW_REDUCED_CHI_SQR : trROI.ShowTop.nVal;
//// 	trROI.ShowTop.nVal = m_btnROITopAdjRSqr.Value? ROI_TOP_SHOW_ADJ_R_SQR : trROI.ShowTop.nVal;
//// 	trROI.ShowTop.nVal = m_btnROITopParam.Value? ROI_TOP_SHOW_PARAM : trROI.ShowTop.nVal;	
	//int nTopShow = -1;
//#define GET_ROI_TOP_SHOW(_val, _btn, _enum)		(_val = _btn.Value ? _enum : _val)
	//GET_ROI_TOP_SHOW(nTopShow, m_btnROITopNone,		ROI_TOP_SHOW_NONE);
	//GET_ROI_TOP_SHOW(nTopShow, m_btnROITopChiSqr,	ROI_TOP_SHOW_REDUCED_CHI_SQR);
	//GET_ROI_TOP_SHOW(nTopShow, m_btnROITopAdjRSqr,	ROI_TOP_SHOW_ADJ_R_SQR);
	//GET_ROI_TOP_SHOW(nTopShow, m_btnROITopParam,	ROI_TOP_SHOW_PARAM);
	//GET_ROI_TOP_SHOW(nTopShow, m_btnROITopPearson,	ROI_TOP_SHOW_PEARSON_R);
	//GET_ROI_TOP_SHOW(nTopShow, m_btnROITOPRSquare,	ROI_TOP_SHOW_R_SQUARE);
//
	//ASSERT(-1 != nTopShow);	// at least one radio must have been selected!
	//quick_fit_set_roi_show_top_enum(trROI.ShowTop, nTopShow);
	///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	//DWORD dwTopShow = 0;
//#define GET_ROI_TOP_SHOW(_val, _btn, _bit)		( _val |= _btn.Value ? _bit : 0 )
	//GET_ROI_TOP_SHOW(dwTopShow, m_chkROITopChiSqr,	ROI_TOP_SHOW_REDUCED_CHI_SQR);
	//GET_ROI_TOP_SHOW(dwTopShow, m_chkROITopAdjRSqr,	ROI_TOP_SHOW_ADJ_R_SQR);
	//GET_ROI_TOP_SHOW(dwTopShow, m_chkROITopPearson,	ROI_TOP_SHOW_PEARSON_R);
	//GET_ROI_TOP_SHOW(dwTopShow, m_chkROITopRSquare,	ROI_TOP_SHOW_R_SQUARE);
	//quick_fit_set_roi_show_top_enum(trROI.ShowTop, dwTopShow);
 	trROI.ShowTop.ReduChisq.nVal = m_chkROITopChiSqr.Value;
 	trROI.ShowTop.AdjR.nVal = m_chkROITopAdjRSqr.Value;
 	trROI.ShowTop.RSqr.nVal = m_chkROITopRSquare.Value;
 	trROI.ShowTop.Correlation.nVal = m_chkROITopPearson.Value;
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//trROI.ParamIndex.nVal = m_comboParamIndex.GetCurSel(); /// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	vector<byte> vbShow;
	m_pGridParamList->GetCheck(vbShow);
	TreeNode trParam = trROI.Params.FirstNode;
	for(int ii=0; trParam && ii<vbShow.GetSize(); ii++)
	{
		trParam.nVal = vbShow[ii];
		trParam = trParam.NextNode;
	}
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

	trROI.RectColor.nVal = m_trROI.ROI.RectColor.nVal;
	trROI.FitLineColor.nVal = m_trROI.ROI.FitLineColor.nVal;
}

/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
BOOL QuickFitOutputReferDlg::OnROIXPositionChange(Control ctrl)
{
	m_bXPosChanged = true;
	setTabDirty(m_tab.GetCurSel());
	return true;
}
///End ADD_LEFTX_RIGHTX_IN_ROI_TAB

/// Iris 2/21/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
BOOL QuickFitOutputReferDlg::OnXScaleFixChange(Control ctrl)
{
	setTabDirty(m_tab.GetCurSel());
	return true;
}
///End ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR

BOOL QuickFitOutputReferDlg::OnROISignDigitsChange(Control ctrl)
{
	setTabDirty(m_tab.GetCurSel());
	return true;
}

BOOL QuickFitOutputReferDlg::OnROITopInfoChange(Control ctrl)
{
	setTabDirty(QUICKFIT_PREFERENCE_ROI, true);
	//m_comboParamIndex.Enable = m_btnROITopParam.Value; /// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//GetItem(IDC_GRID_PARAM_LIST).Enable = m_btnROITopParam.Value;				///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	GetItem(IDC_GRID_PARAM_LIST).Enable = true;
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	return true;
}

/// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
/*
BOOL QuickFitOutputReferDlg::OnROITopInfoParamIndexChange(Control ctrl)
{
	setTabDirty(QUICKFIT_PREFERENCE_ROI, true);
	return true;
}
*/
///End SHOW_ALL_PARAMS_ON_ROI_TOP
///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
void QuickFitOutputReferDlg::OnBeforeEditParamListControl(Control flxControl, long nRow, long nCol, BOOL* pCancel)
{
	if( m_pGridParamList )
	{
		m_pGridParamList->OnBeforeEditParaControl(flxControl, nRow, nCol, pCancel);
	}
}

void QuickFitOutputReferDlg::OnAfterEditParamListControl(Control flxControl, int nRow, int nCol)
{
	setTabDirty(QUICKFIT_PREFERENCE_ROI, true);
}
///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

void QuickFitOutputReferDlg::OnROIGetNChange(uint wParam, uint lParam)
{
	setTabDirty(QUICKFIT_PREFERENCE_ROI, true);
}

/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
/*
///------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
BOOL	QuickFitOutputReferDlg::OnCheckAutoXScaleFrom(Control cntrl)
{
	Tree	tr;
	m_edROILeftX.Enable = !m_checkAutoXFrom.Check;
	if ( !m_edROILeftX.Enable )
	{
		string		str;
		_quickfit_get_auto_x_range(&str, NULL);
		m_edROILeftX.Text = str;
	}

	return TRUE;
}
BOOL	QuickFitOutputReferDlg::OnCheckAutoXScaleTo(Control cntrl)
{
	Tree	tr;
	m_edROIRightX.Enable = !m_checkAutoXTo.Check;
	if ( !m_edROIRightX.Enable )
	{
		string		str;
		_quickfit_get_auto_x_range(NULL, &str);
		m_edROIRightX.Text = str;
	}
	
	return TRUE;
}
///------ End SUPPORT_AUTO_FOR_X_SCALE
*/
///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX

/// Iris 1/22/2010 COMMENT_OUT_UNUSEFUL_CODES
/*
void QuickFitOutputReferDlg::saveThemeSettings(bool bCurrentTab, LPCSTR lpcszFunction, LPCSTR lpcszThemeFile)
{
	Tree tr;
	quick_fit_get_preference_settings(tr);

	int nTab = m_tab.GetCurSel();
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//// Output Tab
	//if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_OUTPUT )
	//{
		//TreeNode trOutput = tr.Output;
		///// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG		
		////trOutput.OutputTo.nVal = m_btnOutputNone.Value? OUTPUT_TO_NONE : trOutput.OutputTo.nVal;
		////trOutput.OutputTo.nVal = m_btnScript.Value? OUTPUT_TO_SCRIPT_WND : trOutput.OutputTo.nVal;
		////trOutput.OutputTo.nVal = m_btnResultLog.Value? OUTPUT_TO_RESULT_LOG : trOutput.OutputTo.nVal;
		////trOutput.SignDigits.nVal = m_comboSignDigits.GetCurSel();
		////trOutput.FitCurve.nVal = 1 == m_btnSameAsInput.Value? FIT_CURVE_TYPE_SAME_AS_INPUT : trOutput.FitCurve.nVal;
		////trOutput.FitCurve.nVal = 1 == m_btnUniform.Value? FIT_CURVE_TYPE_UNIFORM : trOutput.FitCurve.nVal;
		////trOutput.FitCurve.nVal = 1 == m_btnSourceGraphSameScale.Value? FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE : trOutput.FitCurve.nVal;
		////trOutput.XFrom.strVal = m_btnXFrom.Text;
		////trOutput.XTo.strVal = m_btnXTo.Text;
		////trOutput.XAutoFrom.nVal = m_btnXAutoFrom.Value;
		////trOutput.XAutoTo.nVal = m_btnXAutoTo.Value;
		////trOutput.NumPoints.strVal = m_btnNumPoints.Text;
		///////------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
		////trOutput.ReplaceExistingCurve.nVal = m_btnReplaceExistingCurve.Value;
		///////------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT		
		//convertOutputSettingsFromDlgToThemeTree(trOutput);
		/////End NEW_QUICKFIT_ROI_XF_DLG
		//setTabDirty(QUICKFIT_PREFERENCE_OUTPUT, false);
	//}	
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_REPORT )
	{
		TreeNode trReport = tr.Report;
		convertReportSettingsFromDlgToThemeTree(trReport);
	}	

	// Table Tab
	if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_TABLE )
	{
		TreeNode trTable = tr.Table;
		convertTableSettingsFromDlgToThemeTree(trTable);
	}
	
	// ROI Tab
	if( m_bROIUsed && (!bCurrentTab || nTab == QUICKFIT_PREFERENCE_ROI) )
	{
		TreeNode trROI = tr.ROI;
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		//trROI.ShowTop.nVal = m_btnROITopNone.Value? ROI_TOP_SHOW_NONE : trROI.ShowTop.nVal;
		//trROI.ShowTop.nVal = m_btnROITopChiSqr.Value? ROI_TOP_SHOW_REDUCED_CHI_SQR : trROI.ShowTop.nVal;
		//trROI.ShowTop.nVal = m_btnROITopAdjRSqr.Value? ROI_TOP_SHOW_ADJ_R_SQR : trROI.ShowTop.nVal;
		//trROI.ShowTop.nVal = m_btnROITopParam.Value? ROI_TOP_SHOW_PARAM : trROI.ShowTop.nVal;	
		////trROI.ParamIndex.nVal = m_comboParamIndex.GetCurSel(); /// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
	//
		//trROI.RectColor.nVal = m_trROI.ROI.RectColor.nVal;
		//trROI.FitLineColor.nVal = m_trROI.ROI.FitLineColor.nVal;		
		convertROISettingsFromDlgToThemeTree(trROI);
		///End NEW_QUICKFIT_ROI_XF_DLG
	}
	
	///------ Folger 01/14/09 QA81-14832 SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
	if ( lpcszFunction )
	{	
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		//TreeNode	trFunction = tr.Function;
		TreeNode	trFunction = tr.func;
		///End NEW_QUICKFIT_ROI_XF_DLG
		if ( trFunction )
			trFunction.strVal = lpcszFunction;
	}
	///------ End SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
	
	save_preference_settings(tr, lpcszThemeFile);	
}
*/
///End COMMENT_OUT_UNUSEFUL_CODES

BOOL QuickFitOutputReferDlg::OnOK()
{
	return applyPreferSettings(false);
}

BOOL QuickFitOutputReferDlg::OnApply(Control ctrl)
{	
	BOOL bRet = applyPreferSettings(true);
	checkEnableApply();
	return bRet;
}

TreeNode QuickFitOutputReferDlg::GetSettings()
{
	return m_trSettings;
}

bool QuickFitOutputReferDlg::applyPreferSettings(bool bCurrentTab)
{
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	// not update last used theme file, just apply settings
	//saveThemeSettings(bCurrentTab);
	///End NEW_QUICKFIT_ROI_XF_DLG

	int nTab = m_tab.GetCurSel();
	if( bCurrentTab )
		setTabDirty(nTab, false);
	
	if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_TABLE )
	{
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		//Tree tr;
		//TreeNode trTable = _get_table_preference_settings(tr);
		//TreeNode trOutput = _get_output_preference_settings(tr);	
		TreeNode trTable = m_trSettings.Table;
		convertTableSettingsFromDlgToThemeTree(trTable);
		
		/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
		/*
		TreeNode trOutput = m_trSettings.Output;
		convertOutputSettingsFromDlgToThemeTree(trOutput);
		///End NEW_QUICKFIT_ROI_XF_DLG
		_table_refer_dlg_apply_event(trTable, trOutput);
		*/
		/// Iris 1/23/2010 REMOVE_APPLY_BUTTON_FROM_TEXT_BOX_TAB
		//_table_refer_dlg_apply_event(trTable);
		///End REMOVE_APPLY_BUTTON_FROM_TEXT_BOX_TAB
		///End REARRANGE_PREFERENCE_DLG_TABS
	}
	if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_REPORT )
	{
		TreeNode trReport = m_trSettings.report;
		convertReportSettingsFromDlgToThemeTree(trReport);		
	}	
	
	if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_FIT_CURVE )
	{
		TreeNode trFitCurve = m_trSettings.FitCurve;
		convertFitCurveSettingsFromDlgToThemeTree(trFitCurve);		
	}	
	
	if( !bCurrentTab || nTab == QUICKFIT_PREFERENCE_ROI )
	{
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		//Tree tr;
		//TreeNode trROI = get_ROI_preference_settings(tr);
		TreeNode trROI = m_trSettings.ROI;
		convertROISettingsFromDlgToThemeTree(trROI);
		///End NEW_QUICKFIT_ROI_XF_DLG
		
		/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
		//_roi_prefer_dlg_apply_event(trROI);
		if( _roi_prefer_dlg_apply_event(trROI, m_bXPosChanged) )
		{
			if( m_bXPosChanged ) 
			{
				// x position will be auto adjust if leftx or rightx over layer x range,
				// so need show the adjusted value back to Preference dialog.
				m_edROILeftX.Text = trROI.XScale.leftx.strVal;
				m_edROIRightX.Text = trROI.XScale.rightx.strVal;
				
				m_bXPosChanged = false; // after apply changed position, set status as false
			}			
		}
		///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	}
	
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
//	m_trSettings.ReplaceLastOutput.nVal = m_checkReplaceLastOutput.Value;CPY 2/19/10 QUICK_FIT_REMOVE_REPLACE_LAST_CHK_WITH_2_CMD_MENU remove
	///End USE_COMMON_REPLACE_CHECK

	return true;
}

bool quick_fit_get_source_from_to(double* pdFrom, double* pdTo, int* pnNumPoints)
{
	/// Hong 02/20/10 QA80-14832 CENTRALIZE_CODE
	/*
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;	
		
	DataPlot dp = gl.DataPlots(-1); // active data plot
	string strRect;
	if( get_gl_quick_fit_rect_go_name(gl, strRect) )
	{
		GraphObject goRect = gl.GraphObjects(strRect);
		if( goRect )
		{
			int index = _get_source_data_plot_index(gl, goRect);
			dp = gl.DataPlots(index);
		}
		if( !dp )
			dp = gl.DataPlots(-1);
	}
	if( !dp )
		return false; // no data plot	
	*/
	DataPlot		dp;
	if ( !quickfit_get_source_dataplot(dp) )
		return false;
	/// end CENTRALIZE_CODE
	
	/// Iris 2/21/2010 FIX_RUNTIME_ERROR_WHEN_DATA_TYPE_IS_SHORT_INT
	/*
	Curve crv(dp);
	vector vx, vy;
	crv.CopyData(vx, vy);
	*/
	XYRange dr;
	dp.GetDataRange(dr);
	
	vector vx, vy;
	dr.GetData(vy, vx);
	///End FIX_RUNTIME_ERROR_WHEN_DATA_TYPE_IS_SHORT_INT
	
	double min, max;
	vx.GetMinMax(min, max);
	int nSize = vx.GetSize();
	
	if(pdFrom)
		*pdFrom = min;
	if(pdTo)
		*pdTo = max;
	if(pnNumPoints)
		*pnNumPoints = nSize;
	return true;
}	
///End NEED_DISPLAY_SOURCE_DATA_POINTS_WHEN_CHOOSE_SAVE_AS_INPUT_DATA_IN_XF_DLG

///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
#define		SHOW_TREENODE(_tr, _node, _show) \
			if ( _tr._node ) \
				_tr._node.Show = _show;
///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	
///Sophy 2/2/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
bool quick_fit_update_output_choice_on_mode_change(TreeNode& trGUI, TreeNode trTable)
{
	if ( !trGUI || !trTable )
		return false;
	
	trTable.AdjR.Show = true;
	trTable.Correlation.Show = false;
	trTable.RSqr.Show = false;

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	SHOW_TREENODE(trTable, NumIter, TRUE)
	SHOW_TREENODE(trTable, FitStatus, TRUE)
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	if ( QUICK_FIT_MODE_LR == trGUI.mode.nVal ) //LR category
	{
		trTable.AdjR.Show = false;
		trTable.RSqr.Show = true;
		if ( 1 == quick_fit_get_order(QUICK_FIT_MODE_LR, trGUI.func.strVal) ) //Linear
			trTable.Correlation.Show = true;

		///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
		SHOW_TREENODE(trTable, NumIter, FALSE)
		SHOW_TREENODE(trTable, FitStatus, FALSE)
		///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	}
	return true;
}
///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

/// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
//static vector<string>& _get_quick_fit_show_top_string_array()
//{
	//static bool bIsFirst = true;
	//static vector<string> vsShowTops;
	//if ( bIsFirst )
	//{
		//vsShowTops.Add(STR_SHOW_TOP_NONE);
		//vsShowTops.Add(STR_SHOW_TOP_REDUCE_CHISQ);
		//vsShowTops.Add(STR_SHOW_TOP_ADJ_R_SQUARE);
		//vsShowTops.Add(STR_PEARSON_R);
		//vsShowTops.Add(STR_R_SQR);
		//vsShowTops.Add(STR_SHOW_TOP_PARAMETERS);
		//bIsFirst = false;
	//}
	//return vsShowTops;
//}
//
//int		quick_fit_get_roi_show_top_enum(TreeNode& trShowTop)
//{
	//if ( !trShowTop || trShowTop.nVal < 0 )
	//{
		//ASSERT(0);
		//return -1;
	//}
	//string strCombo;
	//trShowTop.GetAttribute(STR_COMBO_ATTRIB, strCombo);
	//int nShowTop = trShowTop.nVal;
	//string strItem = strCombo.GetToken(nShowTop, '|');
//
	//vector<string>& vsShowTops = _get_quick_fit_show_top_string_array();
	//int nFindIndex = vsShowTops.Find(strItem);
	//if ( nFindIndex >= 0 )
	//{
		//return nFindIndex;
	//}
	//return -1;
//}
//
//bool	quick_fit_set_roi_show_top_enum(TreeNode& trShowTop, int nShowTop)
//{
	//if ( !trShowTop || nShowTop < 0 || nShowTop >= ROI_TOP_SHOW_MAX )
		//return false;
	//
	//vector<string>& vsShowTops = _get_quick_fit_show_top_string_array();
//
	//string strItem = vsShowTops[nShowTop];
//
	//string strCombo;
	//trShowTop.GetAttribute(STR_COMBO_ATTRIB, strCombo);
//
	//int nFindIndex = strCombo.FindToken(strItem, '|');
	//if ( nFindIndex >= 0 )
	//{
		//trShowTop.nVal = nFindIndex;
		//return true;
	//}
	//return false;
//}
//
//bool quick_fit_update_roi_show_top(TreeNode& trShowTop, TreeNode& trTable, int nSelRoiTop /*= QFROI_UPDATESHOWTOP_SEL_KEEP_LAST_ONE*/)
//{
	//if ( !trShowTop || !trTable )
	//{
		//ASSERT(false);
		//return false;
	//}
//
	//string strNewCombo		= _L("None|Reduced Chi-Sqr");
	//int nCurIndex		= 1;
	//int nAdjRIndex		= -1;
	//int nPearsonIndex	= -1;
	//int nRSqrIndex		= -1;
//
	//vector<uint> vnShowTopIndices(ROI_TOP_SHOW_MAX);
	//vnShowTopIndices = -1;
	//vnShowTopIndices[ROI_TOP_SHOW_NONE]				= 0;
	//vnShowTopIndices[ROI_TOP_SHOW_REDUCED_CHI_SQR]	= 1;
//
	//if ( trTable.AdjR.Show )
	//{
		//strNewCombo += "|" + STR_SHOW_TOP_ADJ_R_SQUARE;
		//vnShowTopIndices[ROI_TOP_SHOW_ADJ_R_SQR]	= ++nCurIndex;
	//}
//
	//if ( trTable.RSqr.Show )
	//{
		//strNewCombo += "|" + STR_R_SQR;
		//vnShowTopIndices[ROI_TOP_SHOW_R_SQUARE]		= ++nCurIndex;
	//}
//
	//if ( trTable.Correlation.Show )
	//{
		//strNewCombo += "|" + STR_PEARSON_R;
		//vnShowTopIndices[ROI_TOP_SHOW_PEARSON_R]	= ++nCurIndex;
	//}
//
	//strNewCombo += _L("|Parameters");
//
	//vnShowTopIndices[ROI_TOP_SHOW_PARAM]			= ++nCurIndex;
//
	//int nNewSelItem = ROI_TOP_SHOW_REDUCED_CHI_SQR;
//
	//if ( QFROI_UPDATESHOWTOP_SEL_KEEP_LAST_ONE == nSelRoiTop )	// Keep selection
	//{
		//string strOldCombo;
		//trShowTop.GetAttribute(STR_COMBO_ATTRIB, strOldCombo);
		//int nOldSelItem = trShowTop.nVal;
//
		//if ( 0 <= nOldSelItem && nOldSelItem < strOldCombo.GetNumTokens('|') )
		//{
			//string strOldItem = strOldCombo.GetToken(nOldSelItem, '|');
			//int nFindIndex = strNewCombo.FindToken(strOldItem, '|');
			//if ( nFindIndex >= 0 )
				//nNewSelItem = nFindIndex;
		//}
	//}
	//else if ( 0 <= nSelRoiTop && nSelRoiTop < ROI_TOP_SHOW_MAX && vnShowTopIndices[nSelRoiTop] >= 0 )
	//{
		//nNewSelItem = vnShowTopIndices[nSelRoiTop];
	//}
//
	//trShowTop.SetAttribute(STR_COMBO_ATTRIB, strNewCombo);
//
	//if ( QFROI_UPDATESHOWTOP_SEL_IGNORE != nSelRoiTop )
		//trShowTop.nVal = nNewSelItem;
//
	//return true;
//}
/*
DWORD		quick_fit_get_roi_show_top_enum(TreeNode& trShowTop)
{
	if ( !trShowTop )
	{
		ASSERT(FALSE);
		return 0;
	}

	if (	!trShowTop.ReduceChiSqr
		||	!trShowTop.AdjRSquare
		||	!trShowTop.PearsonR
		||	!trShowTop.RSquare
		)
	{
		ASSERT(FALSE);
		return 0;
	}

	DWORD dwShowTop = 0;
	
#define _GET_ROI_TOP_SHOW(_val, _tn, _bit)		( _val |= _tn.nVal ? _bit : 0 )
	_GET_ROI_TOP_SHOW(dwShowTop, trShowTop.ReduceChiSqr, ROI_TOP_SHOW_REDUCED_CHI_SQR);
	_GET_ROI_TOP_SHOW(dwShowTop, trShowTop.AdjRSquare, ROI_TOP_SHOW_ADJ_R_SQR);
	_GET_ROI_TOP_SHOW(dwShowTop, trShowTop.PearsonR, ROI_TOP_SHOW_PEARSON_R);
	_GET_ROI_TOP_SHOW(dwShowTop, trShowTop.RSquare, ROI_TOP_SHOW_R_SQUARE);
	
	return dwShowTop;
}
bool	quick_fit_set_roi_show_top_enum(TreeNode& trShowTop, DWORD dwShowTop)
{
	if ( !trShowTop )
	{
		ASSERT(FALSE);
		return false;
	}

	if (	!trShowTop.ReduceChiSqr
		||	!trShowTop.AdjRSquare
		||	!trShowTop.PearsonR
		||	!trShowTop.RSquare
		)
	{
		ASSERT(FALSE);
		return false;
	}
	
#define _SET_ROI_TOP_SHOW(_val, _tn, _bit)		( _tn.nVal = ( _val & _bit ) ? 1 : 0 )
	_SET_ROI_TOP_SHOW(dwShowTop, trShowTop.ReduceChiSqr, ROI_TOP_SHOW_REDUCED_CHI_SQR);
	_SET_ROI_TOP_SHOW(dwShowTop, trShowTop.AdjRSquare, ROI_TOP_SHOW_ADJ_R_SQR);
	_SET_ROI_TOP_SHOW(dwShowTop, trShowTop.PearsonR, ROI_TOP_SHOW_PEARSON_R);
	_SET_ROI_TOP_SHOW(dwShowTop, trShowTop.RSquare, ROI_TOP_SHOW_R_SQUARE);

		return true;
}

bool quick_fit_update_roi_show_top(TreeNode& trShowTop, TreeNode& trTable, DWORD dwCtrl)// = 0
{
	if ( !trShowTop || !trTable )
	{
		ASSERT(false);
		return false;
	}

	tree_set_attribute_to_all_nodes(trShowTop, STR_SHOW_ATTRIB, "0");
	trShowTop.Show = true;

	trShowTop.ReduceChiSqr.Show = true;
	if ( trTable.AdjR.Show )
		trShowTop.AdjRSquare.Show = true;
	if ( trTable.RSqr.Show )
		trShowTop.RSquare.Show = true;
	if ( trTable.Correlation.Show )
		trShowTop.PearsonR.Show = true;

	if ( QFROI_UPDATESHOWTOP_SEL_IGNORE & dwCtrl )
	{
		// to do
	}

	return true;
}
*/
///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI

bool QuickFitOutputReferDlg::getSourceFromTo(double* pdFrom, double* pdTo, int* pnNumPoints)
{
	/// Iris 2/01/2010 NEED_DISPLAY_SOURCE_DATA_POINTS_WHEN_CHOOSE_SAVE_AS_INPUT_DATA_IN_XF_DLG
	/*	
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;	
	DataPlot dp = gl.DataPlots(-1); // active data plot
	if( !dp )
		return false; // no data plot	
	
	Curve crv(dp);
	vector vx, vy;
	crv.CopyData(vx, vy);
	
	double min, max;
	vx.GetMinMax(min, max);
	int nSize = vx.GetSize();
	
	if(pdFrom)
		*pdFrom = min;
	if(pdTo)
		*pdTo = max;
	if(pnNumPoints)
		*pnNumPoints = nSize;
	
	return true;
	*/
	return quick_fit_get_source_from_to(pdFrom, pdTo, pnNumPoints);
	///End NEED_DISPLAY_SOURCE_DATA_POINTS_WHEN_CHOOSE_SAVE_AS_INPUT_DATA_IN_XF_DLG
}

/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
/*
void construct_quick_fit_output_refer_gui(TreeNode& tr)
{
	GETN_USE(tr)
	
	GETN_LIST(OutputTo, _L("Output To"), OUTPUT_TO_SCRIPT_WND, "None|Script Window|ResultLog|Worksheet") GETN_ID(QUICK_FIT_OUTPUT_TO)
	GETN_LIST(SignDigits, _L("Significant Digits"), 0, "Free|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15") GETN_ID(QUICK_FIT_SIGNIFICANT_DIGITS)
	GETN_LIST(FitCurve, _L("X Data Type"), 1, "Same X as Source Data|Use Source Graph Scale Type|Uniform Linear X") GETN_ID(QUICK_FIT_OUTPUT_FIT_CURVE_OPTION)
	/// Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG	
	//GETN_CHECK(XAutoFrom, "X Auto From", 1) GETN_ID(QUICK_FIT_OUTPUT_X_AUTO_FROM)
	//GETN_CHECK(XAutoTo, "X Auto To", 1) GETN_ID(QUICK_FIT_OUTPUT_X_AUTO_TO)
	//GETN_STR(XFrom, "X From", "1") GETN_ID(QUICK_FIT_OUTPUT_X_FROM)
	//GETN_STR(XTo, "X To", "100") GETN_ID(QUICK_FIT_OUTPUT_X_TO)	
	///End NEW_QUICKFIT_ROI_XF_DLG
	GETN_STR(XFrom, _L("X From"), "1") GETN_ID(QUICK_FIT_OUTPUT_X_FROM) GETN_ADD_AUTO(1)
	GETN_STR(XTo, _L("X To"), "100") GETN_ID(QUICK_FIT_OUTPUT_X_TO) GETN_ADD_AUTO(1)
	GETN_STR(NumPoints, _L("Number Points"), "100") GETN_ID(QUICK_FIT_OUTPUT_NUM_POINTS)
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	GETN_CHECK(ReplaceExistingCurve, _L("Replace Existing Fit Curve"), 0) GETN_ID(QUICK_FIT_OUTPUT_REPLACE_EXISTING_CURVE)
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
}
*/
void construct_quick_fit_report_refer_gui(TreeNode& tr)
{
	GETN_USE(tr)
	
	GETN_LIST(OutputTo, _L("Output To"), OUTPUT_TO_RESULT_LOG, _L("None|Script Window|Result Log|Worksheet")) GETN_ID(QUICK_FIT_OUTPUT_TO)
	GETN_STR(WksName, _L("Worksheet Name"), "[Qkfit]Result") GETN_ID(QUICK_FIT_OUTPUT_WKS_NAME)
	
	_construct_quick_fit_output_choice_gui(tr, TRUE);
}

/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
enum {
	OUTPUT_FIT_CURVE_TO_INPUT_SHEET,
	OUTPUT_FIT_CURVE_TO_INPUT_BOOK_NEW_SHEET,
	OUTPUT_FIT_CURVE_TO_NEW_BOOK
};
///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO

void construct_quick_fit_curve_refer_gui(TreeNode& tr)
{
	GETN_USE(tr)
	GETN_LIST(FitCurve, _L("X Data Type"), FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE, _L("Same X as Source Data|Use Source Graph Scale Type|Uniform Linear X")) GETN_ID(QUICK_FIT_OUTPUT_FIT_CURVE_OPTION)
	GETN_STR(NumPoints, _L("Number Points"), "100") GETN_ID(QUICK_FIT_OUTPUT_NUM_POINTS)
	
	/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	//----- CPY 2/16/2010 RENAME_INPUT_TO_SOURCE_PLOT
	//GETN_LIST(OutputFitCurveTo, _L("Output Fit Curve To"), OUTPUT_FIT_CURVE_TO_INPUT_SHEET, _L("Input Sheet|Input Book, New Sheet|New Book")) GETN_ID(QUICK_FIT_OUTPUT_FIT_CURVE_TO_ID)
	GETN_LIST(OutputFitCurveTo, _L("Output Fit Curve To"), OUTPUT_FIT_CURVE_TO_INPUT_SHEET, _L("Source Sheet|Source Book, New Sheet|New Book")) GETN_ID(QUICK_FIT_OUTPUT_FIT_CURVE_TO_ID)
	//-----
	///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	GETN_CHECK(ReplaceExistingCurve, _L("Replace Existing Fit Curve"), 0) GETN_ID(QUICK_FIT_OUTPUT_REPLACE_EXISTING_CURVE)
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	*/
	///End USE_COMMON_REPLACE_CHECK
}
///End REARRANGE_PREFERENCE_DLG_TABS

////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
//////////////////Table Preference Dialog///////////////
////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
enum {
	UPDATE_TEXT_BOX_FROM_QUICK_FIT,
	UPDATE_TEXT_BOX_FROM_ROI,
	UPDATE_TEXT_BOX_FROM_PREFERENCE_DLG
};

void construct_quick_fit_table_prefer_gui(TreeNode& tr)
{
	GETN_USE(tr)
	
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	//GETN_CHECK(TextTable, "Add Table to Graph", 1) 		GETN_ID(QUICK_FIT_TABLE_ID)
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//GETN_LIST(TextTable, _L("Add Table to Graph"), ADD_TEXTBOX_NEW, "None|Create New|Overwirte Existing") 		GETN_ID(QUICK_FIT_TABLE_ID)
	GETN_CHECK(TextTable, _L("Add Label Box to Graph"), 1) 		GETN_ID(QUICK_FIT_TABLE_ID)
	///End USE_COMMON_REPLACE_CHECK
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING	
	
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	GETN_CHECK(DateTime, "Date and Time", 1) GETN_ID(QUICK_FIT_DATETIME_ID)	
	
	GETN_CHECK(FuncName, "Function Name", 1) GETN_ID(QUICK_FIT_FUNC_NAME_ID)
	*/
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	_construct_quick_fit_output_choice_gui(tr, FALSE);
	///End REARRANGE_PREFERENCE_DLG_TABS	

	//----Iris 1/27/2010 set input and output default as unchecked on wiki
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//tr.Input.nVal = 0;
	//tr.Output.nVal = 0;
	tr.Input.nVal = DATA_NONE;
	tr.Output.nVal = DATA_NONE;
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	//----	
	
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//tr.InputRangeIndex.Show = 0; /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	tr.InputRange.nVal = ADDRANGE_NONE;
	tr.Legend.Show = 1;
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
}

enum {
	EQUATION_NONE,
	EQUATION_WITH_VALUES,
	EQUATION_WITH_NAMES
};

///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
//enum {
	//PARAMETER_TABLE_NONE,
	//PARAMETER_TABLE_SHOW_VALUE,
	//PARAMETER_TABLE_SHOW_VALUE_AND_ERROR
//};
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
#define _GET_ADD_FIT_STATS \
	GETN_CHECK(ReduChisq, STR_SHOW_TOP_REDUCE_CHISQ, 0)	GETN_ID(IDE_FIT_REDUCED_CHI_SQUARE)	\
	GETN_CHECK(AdjR, STR_SHOW_TOP_ADJ_R_SQUARE, 0) GETN_ID(IDE_FIT_ADJ_RSQUARE)	\
	GETN_CHECK(RSqr, STR_R_SQR, 0)					GETN_ID(IDE_FIT_RSQUARE_COD) \
	GETN_CHECK(Correlation, STR_PEARSON_R, 0)		GETN_ID(IDE_FIT_CORRELATION)
///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX

/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
static void _construct_quick_fit_output_choice_gui(TreeNode& tr, BOOL bReport)
{
	GETN_USE(tr)
	
	GETN_LIST(SignDigits, _L("Significant Digits"), 0, "System|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15") GETN_ID(QUICK_FIT_SIGNIFICANT_DIGITS)
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	/*	
	GETN_CHECK(Equation, _L("Equation"), 1) GETN_ID(QUICK_FIT_EQUATION_ID)
	GETN_LIST(EquationFormat, _L("Format"), 0, _L("Equation with Values|Equation with Names") ) GETN_ID(QUICK_FIT_EQUATION_FORMAT_ID)
	
	GETN_CHECK(Value, _L("Value"), 1) GETN_ID(QUICK_FIT_VALUE_ID)			
	GETN_CHECK(Error, _L("Error"), 1) GETN_ID(QUICK_FIT_ERROR_ID)
	*/
	GETN_CHECK(Function, _L("Function"), 1) GETN_ID(QUICK_FIT_OUTPUT_FUNCTION_ID)
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//GETN_CHECK(Input, TABLE_LABEL_INPUT, 1) GETN_ID(QUICK_FIT_OUTPUT_INPUT_ID)
	//GETN_CHECK(InputRangeIndex, TABLE_LABEL_INPUT_ROW_INDEX, 1) GETN_ID(QUICK_FIT_OUTPUT_INPUT_RANGE_INDEX_ID) /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX	
	//GETN_CHECK(Output, TABLE_LABEL_OUTPUT, 1) GETN_ID(QUICK_FIT_OUTPUT_OUTPUT_ID)
	GETN_LIST(Input, TABLE_LABEL_INPUT, DATA_PLOT_LEGEND, STR_DATA_COMBO) GETN_ID(QUICK_FIT_OUTPUT_INPUT_ID)
	GETN_LIST(InputRange, TABLE_LABEL_ADD_INPUT_RANGE, ADDRANGE_INDICES, STR_ADD_RANGE_COMBO) GETN_ID(QUICK_FIT_OUTPUT_INPUT_RANGE_INDEX_ID)
	GETN_LIST(Output, TABLE_LABEL_OUTPUT, DATA_PLOT_LEGEND, STR_DATA_COMBO) GETN_ID(QUICK_FIT_OUTPUT_OUTPUT_ID)
	GETN_CHECK(Legend, TABLE_LABEL_LEGEND_SYMBOLS, 0) GETN_ID(QUICK_FIT_OUTPUT_LEGEND_ID)
	GETN_CURRENT_SUBNODE.Show = false;
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	GETN_CHECK(Weighting, _L("Weighting"), 1) GETN_ID(QUICK_FIT_OUTPUT_WEIGHTING_ID) 
	GETN_CURRENT_SUBNODE.Show = false;
	GETN_LIST(EquationFormat, _L("Equation"), EQUATION_WITH_NAMES, _L("None|Equation with Values|Equation with Names") ) GETN_ID(QUICK_FIT_EQUATION_FORMAT_ID)
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	//GETN_LIST(Params, _L("Parameter Table"), PARAMETER_TABLE_SHOW_VALUE_AND_ERROR, _L("None|Show Value|Show Value and Error")) GETN_ID(QUICK_FIT_PARAMETER_ID)	
	GETN_LIST(Params, _L("Parameter Table"), PARAMETER_TABLE_ALL_PARAMS, _L("None|All Parameters|Use ROI Box Tab Settings"))	GETN_ID(QUICK_FIT_PARAMETER_ID)
	GETN_CHECK(ShowError, _L("Show Error in Parameter Table"), 1)			GETN_ID(QUICK_FIT_SHOW_ERROR_ID)
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//GETN_CHECK(ReduChisq, _L("Reduced Chi-Sqr"), 1)	GETN_ID(IDE_FIT_REDUCED_CHI_SQUARE)	
	///// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	////GETN_CHECK(AdjR, _L("Adj. R-Sqr"), 1) GETN_ID(IDE_FIT_ADJ_RSQUARE)	 
	//GETN_CHECK(AdjR, STR_SHOW_TOP_ADJ_R_SQUARE, 1) GETN_ID(IDE_FIT_ADJ_RSQUARE)	 
	///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	//
	/////Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	//GETN_CHECK(RSqr, STR_R_SQR, 1)					GETN_ID(IDE_FIT_RSQUARE_COD)
	//GETN_CHECK(Correlation, STR_PEARSON_R, 1)		GETN_ID(IDE_FIT_CORRELATION)
	/////end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	_GET_ADD_FIT_STATS
	tr.ReduChisq.nVal = 1;
	tr.AdjR.nVal = 1;
	tr.RSqr.nVal = 1;
	tr.Correlation.nVal = 1;
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	//if ( bReport )
	//{
		//GETN_CHECK(NumIter, TABLE_LABEL_NUM_OF_ITER, FALSE) 	GETN_ID(IDE_FIT_NUMBER_ITER)
		//GETN_CHECK(FitStatus, TABLE_LABEL_FIT_STATUS, FALSE)	GETN_ID(IDE_FIT_STATUS)
	//}	
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
}
///End REARRANGE_PREFERENCE_DLG_TABS

void construct_quick_fit_roi_refer_gui(TreeNode& tr)
{
	GETN_USE(tr)

	GETN_BEGIN_BRANCH(XScale, _L("X Scale"))
	
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	GETN_STR(leftx, _L("From"), "") GETN_ID(QUICK_FIT_ROI_LEFT_X)
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	//GETN_ADD_AUTO(1)
	/////------ End SUPPORT_AUTO_FOR_X_SCALE
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	GETN_STR(rightx, _L("To"), "") GETN_ID(QUICK_FIT_ROI_RIGHT_X)	
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	//GETN_ADD_AUTO(1)
	/////------ End SUPPORT_AUTO_FOR_X_SCALE
	GETN_CHECK(fixscale, _L("Fixed (Prevent moving by ROI)"), 0) GETN_ID(IDC_CHECK_XSCALE_FIX)
	GETN_END_BRANCH(XScale)
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX	
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	
	GETN_STR(toolname, STR_TOOLNAME, TOOLNAME) GETN_ID(QUICK_FIT_ROI_TOOL_NAME_ID) GETN_CONTROL_OPTION_BOX(0)	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	GETN_CHECK(cloneROI, _L("Show Rectangle after Fit"), 0) GETN_ID(QUICK_FIT_ROI_CLONE_MAINOBJ_ID)	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	GETN_LIST(SignDigits, _L("Significant Digits"), 0, _L("System|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15")) GETN_ID(QUICK_FIT_SIGNIFICANT_DIGITS)
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	///// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	////GETN_LIST(ShowTop, _L("Show on Center-Top of ROI Box"), ROI_TOP_SHOW_PARAM, "None|Reduced Chi-Sqr|Adj. R-Sqr|Parameters")	GETN_ID(QUICK_FIT_ROI_CENTER_TEXT_ID)
//#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
	//// Assumption: Fit Mode should be "Polynomial Fit" and Function should be "Linear" by default
	//// Select Parameters by default ( don't use the enumeration ROI_TOP_SHOW_PARAM here )
	//GETN_LIST(ShowTop, _L("Show on Center-Top of ROI Box"), 4, _L("None|Reduced Chi-Sqr|R-Square|Pearsons' r|Parameters") )
//#else
	//GETN_LIST(ShowTop, _L("Show on Center-Top of ROI Box"), ROI_TOP_SHOW_PARAM, _L("None|Reduced Chi-Sqr|Adj. R-Square|Parameters") )
//#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
		//GETN_ID(QUICK_FIT_ROI_CENTER_TEXT_ID)
	GETN_BEGIN_BRANCH(ShowTop, _L("Show on Center-Top of ROI Box"))
		//GETN_CHECK(ReduceChiSqr, STR_SHOW_TOP_REDUCE_CHISQ, 0) GETN_ID(QUICK_FIT_ROI_CENTER_TEXT_REDUCED_CHISQ_ID)
		//GETN_CHECK(AdjRSquare, STR_SHOW_TOP_ADJ_R_SQUARE, 0) GETN_ID(QUICK_FIT_ROI_CENTER_TEXT_ADJ_R_SQR_ID)
		//GETN_CHECK(PearsonR, STR_PEARSON_R, 0) GETN_ID(QUICK_FIT_ROI_CENTER_TEXT_PEARSONS_R_ID)
		//GETN_CHECK(RSquare, STR_R_SQR, 0) GETN_ID(QUICK_FIT_ROI_CENTER_TEXT_R_SQUARE_ID)
		_GET_ADD_FIT_STATS
	GETN_END_BRANCH(ShowTop)
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	//GETN_NUM(ParamIndex, "Parameter Index", 0) GETN_ID(QUICK_FIT_ROI_PARAM_INDEX) /// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID, this ID repeat with trGUI.ROI node, cause theme cannot be applied.
	//GETN_BEGIN_BRANCH(Params, _L("Parameter List"))	GETN_ID(XF_TREENODE_VAR_ID_ROI)
	GETN_BEGIN_BRANCH(Params, _L("Parameter List"))
	///End FIX_DUPLICATION_DATAID
	TreeNode trParams = tr.Params;
	for(int ii = 0; ii < MAX_NUM_PARAMS; ii++)
	{
		TreeNode trParam = trParams.AddNumericNode(1, "Param" + ii, TRGP_CHECK);
		trParam.SetAttribute(STR_LABEL_ATTRIB, "Param" + ii);				// labels will be updated on func selected
		trParam.DataID = QUICK_FIT_ROI_PARAM_BEGIN + ii;
	}
	GETN_END_BRANCH(Params)
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	GETN_COLOR(RectColor, STR_FILL_COLOR, SYSCOLOR_LTYELLOW)	GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE)	GETN_ID(QUICK_FIT_ROI_RECT_COLOR_ID)
	/// Iris 2/21/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
	//GETN_COLOR(FitLineColor, _L("Fit Curve Color"), SYSCOLOR_BLUE) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE) GETN_ID(QUICK_FIT_ROI_FITCURVE_COLOR_ID)
	GETN_COLOR(FitLineColor, _L("Fit Curve Color"), INDEX_COLOR_AUTOMATIC) GETN_COLOR_CHOICE_OPTIONS(COLORLIST_CUSTOM | COLORLIST_SINGLE | COLORLIST_AUTO) GETN_ID(QUICK_FIT_ROI_FITCURVE_COLOR_ID)
	GETN_CURRENT_SUBNODE.SetAttribute(STR_ATTRIB_AUTO_COLOR, SYSCOLOR_BLUE);
	///End ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
	
}

//-----Iris 2/01/2010 Apply button has been hidden in Text Box tab, so comment out.
/*
/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
//static bool _table_refer_dlg_apply_event(TreeNode& trTable, TreeNode& trOutput)
///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
//static bool _table_refer_dlg_apply_event(TreeNode& trTable)
static bool _table_refer_dlg_apply_event(TreeNode& trTable, TreeNode& trROI)
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
///End REARRANGE_PREFERENCE_DLG_TABS
{
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
	{
		return error_report("_table_refer_dlg_apply_event: no graph active");
	}
	
	int i1 = 0, i2 = -1;
	DataPlot dpSource;
	///Sophy 1/20/2010 IMPROVE_GET_QUICK_FIT_SOURCE_PLOT
	//if( !_get_quick_fit_source_plot(dpSource, NULL, gl, &i1, &i2) )
	if( !_get_quick_fit_source_plot(dpSource, NULL, gl, &i1, &i2) )
	{
		QuickFitPlotInfo qfInfo;
		if ( quick_fit_source_plot_info_access(qfInfo, gl) )
			dpSource = Project.GetObject(qfInfo.nUID);
	}
	if ( !dpSource )
	///end IMPROVE_GET_QUICK_FIT_SOURCE_PLOT
	{
		return error_report("_table_refer_dlg_apply_event: Fail to find source data plot");
	}
	
	XYRange iy;
	if( !dpSource.GetDataRange(iy, i1, i2) )
	{
		return error_report("_table_refer_dlg_apply_event: fail to get xyrange from source plot");
	}
	
	Tree trStorage;
	if( !gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) )
	{
		return error_report("_table_refer_dlg_apply_event: no storage");
	}
	
	QuickFitResults stFitResults;
	stFitResults = trStorage.Results;
	string strFunctionName = trStorage.FunctionName.strVal;
	int nOrder =  trStorage.Order.nVal;
	
	///Sophy 1/20/2010 IMPROVE_GET_QUICK_FIT_SOURCE_PLOT
	if ( !trStorage.TextBoxName )
		return false;
	///end IMPROVE_GET_QUICK_FIT_SOURCE_PLOT
	GraphObject goTextBox = gl.GraphObjects(trStorage.TextBoxName.strVal);

	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//_quick_fit_output_text_table(trTable, gl, iy, stFitResults, strFunctionName, nOrder, UPDATE_TEXT_BOX_FROM_PREFERENCE_DLG, goTextBox, true, NULL, trOutput.SignDigits.nVal);	
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	//_quick_fit_output_text_table(trTable, gl, iy, stFitResults, strFunctionName, nOrder, UPDATE_TEXT_BOX_FROM_PREFERENCE_DLG, goTextBox, true, NULL, trTable.SignDigits.nVal);	
	_quick_fit_output_text_table(trTable, trROI, gl, iy, stFitResults, strFunctionName, nOrder, UPDATE_TEXT_BOX_FROM_PREFERENCE_DLG, goTextBox, true, NULL, trTable.SignDigits.nVal);
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	GraphPage gp = gl.GetPage();	
	gp.Refresh(true);	
	
	return true;
}
*/
//-----

/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
//static bool _roi_prefer_dlg_apply_event(TreeNode& tr)
static bool _roi_prefer_dlg_apply_event(TreeNode& tr, bool bXPosChanged)
///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
{
	GraphLayer gl = Project.ActiveLayer();
	if( !gl )
		return false;

	string strRect;
	if( get_gl_quick_fit_rect_go_name(gl, strRect) )
	{
		QuickFitTool qtool;
		qtool.Init(strRect);
		if(!qtool.IsValidLayer())
		{
			error_report("invalid layer!");
			return false;
		}
		roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);	///Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES
		/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
		//return qtool.ApplySettings(tr, true);
		return qtool.ApplySettings(tr, true, bXPosChanged);
		///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	}
	return false;
}

/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
//void quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(TreeNode& tr, int* pBranchDataID)
void quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(TreeNode& tr, int nBranchDataID)
///End FIX_DUPLICATION_DATAID
{
	if( tr.GetNodeCount() > 0 )
	{
		foreach(TreeNode trSub in tr.Children)
		{
			/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
			//quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(trSub, pBranchDataID);
			quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(trSub, nBranchDataID);
			///End FIX_DUPLICATION_DATAID
		}
	}
	else
	{
		int nOldID = tr.DataID;
		if( nOldID < (XF_TREENODE_VAR_ID_BEGIN << 16) )
		{
			/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
			/*
			TreeNode trBranch = tr.Parent();			
			
			int nBranchID;
			if( trBranch && trBranch.GetAttribute(STR_DATAID_ATTRIB, nBranchID) || pBranchDataID)
			{
				if( pBranchDataID )
					nBranchID = *pBranchDataID;
				
				int nNewID = (nBranchID << 16) | nOldID;
				tr.DataID = nNewID;
			}
			*/
			int nNewID = (nBranchDataID << 16) | nOldID;
			tr.DataID = nNewID;			
			///End FIX_DUPLICATION_DATAID
		}
	}		
	
}

static bool _quick_fit_theme_loading(TreeNode& tr, LPCSTR lpcszThemeFile = NULL)
{
	string strThemeFile;
	if( lpcszThemeFile )
		strThemeFile = lpcszThemeFile;
	else
		strThemeFile = get_quick_fit_prefer_theme_file();
	if( strThemeFile.IsFile() )
	{
		/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
		/*
		// changed QuickFit dialog to xf based dialog now, Output, Table, ROI changed as xf TreeNode variable.
		// need convert id of the sub nodes according to TreeNode variable ID(repeat ID)
		quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(tr);
		*/
		///End FIX_DUPLICATION_DATAID
		return theme_load_settings(tr, strThemeFile);
	}
	return false;
}
/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
/*
static TreeNode _construct_quick_fit_output_refer_gui_ex(TreeNode& tr)
{
	TreeNode trOutputPrefer = tr.AddNode("Output");
	trOutputPrefer.DataID = QUICK_FIT_OUTPUT_PREFER_BRANCH_ID;
	construct_quick_fit_output_refer_gui(trOutputPrefer);	
	return trOutputPrefer;
}
*/
static TreeNode _construct_quick_fit_report_refer_gui_ex(TreeNode& tr)
{
	TreeNode trBranch = tr.AddNode("Report");
	trBranch.DataID = XF_TREENODE_VAR_ID_REPORT;
	construct_quick_fit_report_refer_gui(trBranch);	
	
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
	// changed QuickFit dialog to xf based dialog now, Output, Table, ROI changed as xf TreeNode variable.
	// need convert id of the sub nodes according to TreeNode variable ID(repeat ID)
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(trBranch, XF_TREENODE_VAR_ID_REPORT); 
	///End FIX_DUPLICATION_DATAID
	return trBranch;
}

static TreeNode _construct_quick_fit_curve_refer_gui_ex(TreeNode& tr)
{
	TreeNode trBranch = tr.AddNode("FitCurve");
	trBranch.DataID = XF_TREENODE_VAR_ID_FITCURVE;
	construct_quick_fit_curve_refer_gui(trBranch);	
	
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
	// changed QuickFit dialog to xf based dialog now, Output, Table, ROI changed as xf TreeNode variable.
	// need convert id of the sub nodes according to TreeNode variable ID(repeat ID)
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(trBranch, XF_TREENODE_VAR_ID_FITCURVE); 
	///End FIX_DUPLICATION_DATAID
	return trBranch;
}

static TreeNode _construct_quick_fit_table_prefer_gui_ex(TreeNode& tr)
{
	TreeNode trTablePrefer = tr.AddNode("Table");
	trTablePrefer.DataID = XF_TREENODE_VAR_ID_TABLE;
	construct_quick_fit_table_prefer_gui(trTablePrefer);
	
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
	// changed QuickFit dialog to xf based dialog now, Output, Table, ROI changed as xf TreeNode variable.
	// need convert id of the sub nodes according to TreeNode variable ID(repeat ID)
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(trTablePrefer, XF_TREENODE_VAR_ID_TABLE);
	///End FIX_DUPLICATION_DATAID
	return trTablePrefer;
}

static TreeNode _construct_quick_fit_roi_refer_gui_ex(TreeNode& tr)
{
	TreeNode trROIPrefer = tr.AddNode("ROI");
	trROIPrefer.SetAttribute(STR_LABEL_ATTRIB, STR_ROI_LABEL);
	trROIPrefer.DataID = XF_TREENODE_VAR_ID_ROI;
	construct_quick_fit_roi_refer_gui(trROIPrefer);
	
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
	// changed QuickFit dialog to xf based dialog now, Output, Table, ROI changed as xf TreeNode variable.
	// need convert id of the sub nodes according to TreeNode variable ID(repeat ID)
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(trROIPrefer, XF_TREENODE_VAR_ID_ROI);
	///End FIX_DUPLICATION_DATAID
	return trROIPrefer;
}

bool quick_fit_get_preference_settings(TreeNode& tr, LPCSTR lpcszThemeFile)
{
	if(!tr)
		return tr;
	tr.Reset();
	
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	TreeNode trOutputPrefer = tr.AddNode("Output");
	trOutputPrefer.DataID = QUICK_FIT_OUTPUT_PREFER_BRANCH_ID;
	construct_quick_fit_output_refer_gui(trOutputPrefer);
	
	TreeNode trTablePrefer = tr.AddNode("Table");
	trTablePrefer.DataID = QUICK_FIT_TABLE_PREFER_BRANCH_ID;
	construct_quick_fit_table_prefer_gui(trTablePrefer);
	
	TreeNode trROIPrefer = tr.AddNode("ROI");
	trROIPrefer.DataID = QUICK_FIT_ROI_PREFER_BRANCH_ID;
	construct_quick_fit_roi_refer_gui(trROIPrefer);
	*/
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//_construct_quick_fit_output_refer_gui_ex(tr);
	_construct_quick_fit_report_refer_gui_ex(tr);
	_construct_quick_fit_curve_refer_gui_ex(tr);
	///End REARRANGE_PREFERENCE_DLG_TABS
	_construct_quick_fit_table_prefer_gui_ex(tr);
	_construct_quick_fit_roi_refer_gui_ex(tr);
	///End NEW_QUICKFIT_ROI_XF_DLG

	/// Iris 1/15/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	///------ Folger 01/14/09 QA81-14832 SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
	TreeNode	trFunction = tr.AddTextNode("", "Function");
	trFunction.DataID = QUICK_FIT_FUNCTION;
	///------ End SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
	*/
	tr.func.DataID = QUICK_FIT_FUNCTION_ID;
	/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(tr.func, XF_TREENODE_VAR_ID_FUNC);

	tr.mode.DataID = QUICK_FIT_MODE_ID;
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(tr.mode, XF_TREENODE_VAR_ID_MODE);
	///End FIX_DUPLICATION_DATAID
	///End NEW_QUICKFIT_ROI_XF_DLG
	
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	/*
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	tr.ReplaceLastOutput.DataID = QUICK_FIT_REPLACE_LAST_OUTPUT_ID;
	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(tr.ReplaceLastOutput, XF_TREENODE_VAR_ID_REPLACE);
	///End USE_COMMON_REPLACE_CHECK
	*/
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	
	/// Iris 1/15/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	string strThemeFile = lpcszThemeFile ? lpcszThemeFile : get_quick_fit_prefer_theme_file();
	if( !strThemeFile.IsFile() )
		return false;
	return theme_load_settings(tr, strThemeFile);	
	*/
	return _quick_fit_theme_loading(tr, lpcszThemeFile);
	///End NEW_QUICKFIT_ROI_XF_DLG
}

bool save_preference_settings(TreeNode& tr, LPCSTR lpcszThemeFile = NULL)
{
	if(!tr)
		return tr;	

	string strThemeFile = lpcszThemeFile ? lpcszThemeFile : get_quick_fit_prefer_theme_file();
	bool bRet = theme_save_settings(tr, strThemeFile);	
	if( !bRet )
		error_report("save_preference_settings fail to save quick fit prefer settings.");
	return bRet;
}

static TreeNode _get_table_preference_settings(TreeNode& tr)
{
	TreeNode trTableRef = _construct_quick_fit_table_prefer_gui_ex(tr);
	
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
 	string strThemeFile = get_quick_fit_prefer_theme_file();
 	if( strThemeFile.IsFile() )
 	{
		bool bRet = theme_load_settings(trTableRef, strThemeFile); // if return false, this function print out error msg to Output wnd. If no theme file, will use default settings			
 	}
 	*/
 	_quick_fit_theme_loading(trTableRef);
 	///End NEW_QUICKFIT_ROI_XF_DLG
	return trTableRef;
}

/*
static TreeNode _get_output_preference_settings(TreeNode& tr)
{
	TreeNode trOutputRef = tr.AddNode("Output");
	construct_quick_fit_output_refer_gui(trOutputRef);
	
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG	
 	//string strThemeFile = get_quick_fit_prefer_theme_file();
 	//if( strThemeFile.IsFile() )
 	//{
		//bool bRet = theme_load_settings(trOutputRef, strThemeFile); // if return false, this function print out error msg to Output wnd. If no theme file, will use default settings			
 	//} 	
 	_quick_fit_theme_loading(trOutputRef);
 	///End NEW_QUICKFIT_ROI_XF_DLG
	return trOutputRef;
}
*/

static TreeNode _get_report_preference_settings(TreeNode& tr)
{
	TreeNode trReport = _construct_quick_fit_report_refer_gui_ex(tr);
 	_quick_fit_theme_loading(trReport);
 	return trReport;	
}

static TreeNode _get_fit_curve_preference_settings(TreeNode& tr)
{
	TreeNode trFitCurve = _construct_quick_fit_curve_refer_gui_ex(tr);
 	_quick_fit_theme_loading(trFitCurve);
 	return trFitCurve;	
}
static TreeNode _get_ROI_preference_settings(TreeNode& tr)
{
	if(!tr)
		return tr;
	TreeNode trROIRef = _construct_quick_fit_roi_refer_gui_ex(tr);
	
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	string strThemeFile = get_quick_fit_prefer_theme_file();
	if( strThemeFile.IsFile() )
	{
		bool bRet = theme_load_settings(trROIRef, strThemeFile); // if return false, this function print out error msg to Output wnd. If no theme file, will use default settings			
	}
	*/
	_quick_fit_theme_loading(trROIRef);
	///End NEW_QUICKFIT_ROI_XF_DLG
	return trROIRef;
}

///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
//string _quick_fit_output_text_table(const TreeNode& trTable, GraphLayer& gl, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFunc, int nOrder, int nUpdatedFrom, GraphObject& goTable, bool bFromApplyButton = false, LPCSTR lpcszTable = NULL, int nSignDigits = 0)
/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
//string _quick_fit_output_text_table(const TreeNode& trTable, const TreeNode& trROI, GraphLayer& gl, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFunc, int nOrder, int nUpdatedFrom, GraphObject& goTable, bool bFromApplyButton = false, LPCSTR lpcszTable = NULL, int nSignDigits = 0)
string _quick_fit_output_text_table(const TreeNode& trTable, const TreeNode& trROI, GraphLayer& gl, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFunc, int nOrder, int nUpdatedFrom, GraphObject& goTable, bool bReplaceLastOutput = false, bool bFromApplyButton = false, LPCSTR lpcszTable = NULL, int nSignDigits = 0)
///End USE_COMMON_REPLACE_CHECK
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
{
	// build output string table
	string strTable(lpcszTable);
	if( NULL == lpcszTable )
	{
		///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
		//strTable = 	_get_table_str(true, trTable, iy, stFitResults, lpcszFunc, nOrder, nUpdatedFrom, nSignDigits);
		strTable = 	_get_table_str(true, trTable, trROI, iy, stFitResults, lpcszFunc, nOrder, nUpdatedFrom, nSignDigits);
		///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	}
	
	// get text table
	//----Iris 12/31/2009 From US feedback, each time do quick fit, always create a new Text Box.
	/*
	GraphObject goTable;
	if( bFromApplyButton )
	{
		goTable = gl.GraphObjects(TABLE_NAME);
	}
	*/
	//----
	
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK, from wiki's suggestion "It should only replace the last fit, not any previous fits"
	/*
	if( goTable && ADD_TEXTBOX_OVERWRITE_EXISTING == trTable.TextTable.nVal )
	{		
		foreach(GraphObject go in gl.GraphObjects)
		{
			if( 0 != strcmp(go.GetName(), goTable.GetName()) )
			{
				char szPrefix[255];
				string_to_prefix_end_number(szPrefix, go.GetName());
				
				if( 0 == strcmp(szPrefix, TABLE_NAME) )
					gl.RemoveGraphObject(go.GetName());
				
			}
		}
	}
	*/	
	///End USE_COMMON_REPLACE_CHECK
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	
	// output text table
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING		
	//bool bTextTable = trTable.TextTable.nVal;
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//bool bTextTable = ADD_TEXTBOX_NONE != trTable.TextTable.nVal;
	bool bTextTable = trTable.TextTable.nVal;
	///End USE_COMMON_REPLACE_CHECK
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	if( bTextTable  )
	{	
		/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING		
		//bool bCreateNewTable = !goTable.IsValid();
		/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
		/*
		bool bCreateNewTable;
		switch(trTable.TextTable.nVal)
		{
		case ADD_TEXTBOX_OVERWRITE_EXISTING:
			bCreateNewTable = !goTable.IsValid();
			break;
		case ADD_TEXTBOX_NONE:
			bCreateNewTable = false;
			break;
		case ADD_TEXTBOX_NEW:
			bCreateNewTable = true;
			break;
		}
		*/
		bool bCreateNewTable = !goTable.IsValid() || !bReplaceLastOutput;
		///End USE_COMMON_REPLACE_CHECK
		///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
		
		// create text table
		if( bCreateNewTable )
		{
			goTable = gl.CreateGraphObject(GROT_TEXT, TABLE_NAME);
			goTable.Attach = 0; // attach to layer
		}
		else
		{
			if( !goTable.Show )
			{
				goTable.Show = true;
			}
		}
		
		goTable.Text = strTable;	
		if( bCreateNewTable ) // set format need wait after Text updated
		{			
			Tree tr;
			int nUnits = UNITS_PIXEL;
			tr.Root.Dimension.Units.nVal = nUnits;
			tr.Root.Font.Size.nVal = 14;
			
			///Sophy 1/12/2010 SHOW_LEGEND_IN_RESULT_TABLE
			//check link to variable as to show legend
			tr.Root.LinkToVars.nVal = 1;
			///end SHOW_LEGEND_IN_RESULT_TABLE
			// the space between of text and border line
			const double dSpace = 2.4; 
			tr.Root.Background.Dimension.Left.dVal = dSpace;
			tr.Root.Background.Dimension.Top.dVal = dSpace;
			tr.Root.Background.Dimension.Right.dVal = dSpace;
			tr.Root.Background.Dimension.Bottom.dVal = dSpace;
			
			// set Background as "Black line"
			tr.Root.Background.Border.Width.dVal = 1;
			tr.Root.Background.Border.Color.nVal = SYSCOLOR_BLACK;
			tr.Root.Background.Fill.Color.nVal = SYSCOLOR_WHITE;
			if( 0 == goTable.UpdateThemeIDs(tr.Root) )
			{
				goTable.ApplyFormat(tr, true, true);
			}
			
			_set_text_box_init_position_with_offset(gl, goTable, nUnits, TABLE_NAME);
		}
	}
	else
	{
		///------ Folger 04/20/10 HIDE_LAST_LABEL_BOX_ONLY_IF_REPLACE_LAST_REPORT
		if ( bReplaceLastOutput )
		///------ End HIDE_LAST_LABEL_BOX_ONLY_IF_REPLACE_LAST_REPORT
		{
			if( goTable.IsValid() )
			{
				goTable.Show = false;
			}
		}
	}
	return goTable.IsValid()? goTable.GetName() : "";
}

static int _convert_go_unit_to_layer_unit(int nGraphObjectUnits)
{
	int nLayerUnit = M_INCH;
    switch(nGraphObjectUnits)
    {
    case UNITS_INCH:
    	nLayerUnit = M_INCH;
    	break;
    case UNITS_CM:
    	nLayerUnit = M_CM;
    	break;
    case UNITS_MM:
    	nLayerUnit = M_MM;
    	break;
    case UNITS_PIXEL:
    	nLayerUnit = M_PIXEL;
    	break;
    case UNITS_POINT:
    	nLayerUnit = M_PT;
    	break;
    default:
    	ASSERT(0);
    	break;
  }
  return nLayerUnit;
}

static void _set_text_box_init_position_with_offset(GraphLayer& gl, GraphObject& goText, int nGraphObjectUnits, LPCSTR lpcszNamePrefix)
{
	double dTextLeft, dTextTop;
	
	// set init position
    int unit;
    double left, top, width, height;
	bool bPos = layer_get_position(gl, &left, &top, NULL, NULL, &unit);
	bool bSize = layer_get_size(gl, width, height, &unit);
    ASSERT( bPos && bSize );			

	int nLayerUnit = _convert_go_unit_to_layer_unit(nGraphObjectUnits);    
    
	int nParentLayer;
	if( layer_get_link(gl, nParentLayer) && unit == M_LINK )
	{
		GraphPage gp = gl.GetPage();
		GraphLayer glParent = gp.Layers(nParentLayer);
		ASSERT(gp && glParent);
		
		double dPos[TOTAL_POS];
		int nRefUnit = glParent.GetPosition(dPos);
		
		double dRefWidth = dPos[WIDTH_POS];
		double dRefHeight = dPos[HEIGHT_POS];
		double dRefTop = dPos[TOP_POS];
		double dRefLeft = dPos[LEFT_POS];
		
		width = dRefWidth * width / 100;
		height = dRefHeight * height / 100;
		left = dRefLeft * left / 100 + dRefLeft;
		top = dRefHeight * top / 100 + dRefTop;
		
		if( nRefUnit != nLayerUnit )
		{
			gl.UnitsConvert(nLayerUnit, &width, nRefUnit);
			gl.UnitsConvert(nLayerUnit, &height, nRefUnit);
			gl.UnitsConvert(nLayerUnit, &left, nRefUnit);
			gl.UnitsConvert(nLayerUnit, &top, nRefUnit);
		}
		
	}	
	else if( unit != nLayerUnit )
	{
		gl.UnitsConvert(nLayerUnit, &left, unit);
		gl.UnitsConvert(nLayerUnit, &top, unit);
		gl.UnitsConvert(nLayerUnit, &width, unit);
		gl.UnitsConvert(nLayerUnit, &height, unit);
		
	}
    
    const double dSpacePrecent = 0.02;
    double dLeftSpace = width * dSpacePrecent;
    double dTopSpace = height * dSpacePrecent;
    dTextLeft = left + dLeftSpace;
    dTextTop = top + dTopSpace;
    
    foreach(GraphObject go in gl.GraphObjects)
    {
    	char szPrefix[255];
    	string_to_prefix_end_number(szPrefix, go.GetName());
    	if( 0 != lstrcmp(szPrefix, lpcszNamePrefix) )
    		continue;
    	
 		if( go.GetName() == goText.GetName() )   	
 			continue;
 		
 		double dSep = dLeftSpace < dTopSpace? dLeftSpace : dTopSpace; // uint is pixel
 		if( go.Left - dTextLeft <= dSep || go.Top - dTextTop <= dSep )
 		{
 			dTextLeft += dLeftSpace;
 			dTextTop += dTopSpace;
 		}
    }
    
    goText.Left = dTextLeft;
    goText.Top = dTextTop;
	
}

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
////////////////Global Functions Called in OGS////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
/*
BOOL OpenQuickFitOutputPreferDlg(bool bROIUsed = false, int nOrder = 0, string strFunc = "")
{
	QuickFitOutputReferDlg dlg(bROIUsed, nOrder, strFunc);
	return (IDOK == dlg.DoModalEx());
}
*/
BOOL OpenQuickFitOutputPreferDlg(TreeNode& trROISettings)
{
	QuickFitOutputReferDlg dlg(trROISettings);
	if( IDOK == dlg.DoModalEx() )
	{
		trROISettings = dlg.GetSettings();
		return true;
	}
	return false;
}
///End NEW_QUICKFIT_ROI_XF_DLG

///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
//BOOL OpenQuickFitEditDlg(HWND hWndParent, int nMode)
//{
	//QuickFitEditDlg dlg(nMode);
	//return (IDOK == dlg.DoModal(hWndParent));
//}
BOOL OpenQuickFitEditDlg(HWND hWndParent, int nMode, string* pstrSelectedFunc/* = NULL*/)
{
	QuickFitEditDlg dlg(nMode);
	BOOL	bRet = dlg.DoModal(hWndParent);
	if ( bRet && pstrSelectedFunc )
		*pstrSelectedFunc = dlg.GetSelectedFunc();
	return bRet;
}
///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
/////////Global Functions Called in quickfit XF///////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
int		nlsf_quick_fit(const GraphLayer& glSource, QuickFitResults& stFitResults, vector& vFitX, vector& vFitY, LPCSTR lpcszFuncName, int nOrder, const XYRange& iy, DWORD dwCntrl/* = 0*/)
{
	vector	vX, vY, vW;
	vector	vApparentX, vApparentY, vApparentW;
	bool bGetData = true;
	if( nOrder != 0 ) // nOrder > 0 means Linear/Polynomial 
	{
		iy.GetData(vY, vX, &vW);			// get this to construct the fit x vector

		DWORD 	dwRules = DRR_GET_DEPENDENT;
		dwRules |= DRR_APPARENT; //default always be Apparent Fit
		dwRules |= DRR_DEPERR_TO_WEIGHT; //default always be instrumental weight mdoe
		
		DWORD	dwPlotUID;
		bGetData = (iy.GetData(dwRules, 0, &dwPlotUID, NULL, &vApparentY, &vApparentX, NULL, NULL, &vApparentW) >= 0 );
	}
	else
	{
		bGetData = iy.GetData(vY, vX, &vW);
	}
	if( !bGetData || vX.GetSize() == 0 || vY.GetSize() == 0 ||
		(nOrder!=0 && (vApparentX.GetSize()==0 || vApparentY.GetSize()==0)) )
	{
		return CER_INVALID_RANGE;
	}
	
	if ( 0 == nOrder && (NULL == lpcszFuncName || '\0' == *lpcszFuncName) )
	{
		ASSERT(0);//should not come here
		return NLSF_QUICKFIT_ERROR_INVALID_FUNCTION;
	}
	
	/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
	/*
	if( 0 != nOrder && NULL != lpcszFuncName && '\0' != *lpcszFuncName || nOrder > 3 )
	{
		ASSERT(0);//should not come here
		return NLSF_QUICKFIT_ERROR_INVALID_PARAMS;
	}
	*/
	///End ADD_QUICK_FIT_MODE
	
	double dWeightSum;
	vW.Sum(dWeightSum);
	if( is_equal(vW.GetSize(), dWeightSum) )
	{
		stFitResults.strWeighting = _L("No Weighting");
	}
	else
	{
		stFitResults.strWeighting = _L("Instrumental");
	}
	
	_get_fit_curve_x_data(vX, vFitX, glSource, dwCntrl);

	if( 0 == nOrder ) // nlfit /// Iris 12/15/09 QA81-14832 QUICK_NLSF_FITTING_TABLE
	{
		NLFitSession 		nlfit;
		nlfit.SetAutoInitParams(false);
	
		if ( !nlfit.SetFunction(lpcszFuncName) )
			return XF_QUICKFIT_SET_FUNC_FAILED;
	
		if ( !nlfit.SetData(vY, vX, NULL, 0, 1, INVALID_DATA_MODE, vW) )
			return XF_QUICKFIT_SET_DATA_FAILED;
		
		if ( vW.GetSize() > 0 )
			nlfit.SetWeightData(WEIGHT_INSTRUMENTAL, 0.0, 0.0, 0.0);
	
		if ( !nlfit.ParamsInitValues() )
			return XF_QUICKFIT_INIT_PARAM_FAILED;
	
		stFitResults.bGoodFit = nlfit.Fit();	
			
		if ( !nlfit.GetFitResultsParams(stFitResults.vParams, stFitResults.vErrors) )
			return XF_QUICKFIT_FAIL_GET_FIT_RESULT;
		
		if ( !nlfit.GetFitResultsStats(&stFitResults.stRegStats, NULL) )
			return XF_QUICKFIT_FAIL_GET_FIT_RESULT;
	
		nlsf_evaluate(lpcszFuncName, NULL, vFitX, vFitY, stFitResults.vParams);
		
		/// Iris 12/15/09 QA81-14832 QUICK_NLSF_FITTING_TABLE
		if ( 0 == nlfit.GetParamNamesInFunction(stFitResults.vsParamNames) )
			return XF_QUICKFIT_FAIL_GET_FIT_RESULT;
		///End QUICK_NLSF_FITTING_TABLE	
		
		/// Iris 2/01/2010 IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND
		//stFitResults.strFitOutcome = nlfit.GetFitOutCome(nlfit.GetLastIterateOutCome());		
		stFitResults.nNumIteration = nlfit.GetNumberItersPerformed();
		stFitResults.nFitOutcome = nlfit.GetLastIterateOutCome();
		stFitResults.strFitOutcome = nlfit.GetFitOutCome(stFitResults.nFitOutcome);
		///End IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND
		
		stFitResults.bIsApparentFit = false; /// Iris 2/04/2010 SHOW_APPARENT_FIT_IN_LABEL
	}
	/// Iris 12/15/09 QA81-14832 QUICK_NLSF_FITTING_TABLE
	else
	{
		/// Iris 2/04/2010 SHOW_APPARENT_FIT_IN_LABEL
		//glSource.ConvertByAxis(vFitX, vFitX.GetSize(), OKAXISTYPE_X, true, vFitX); // convert the fit x by axis before fitting
		stFitResults.bIsApparentFit = glSource.ConvertByAxis(vFitX, vFitX.GetSize(), OKAXISTYPE_X, true, vFitX)
										|| glSource.ConvertByAxis(vY, vY.GetSize(), OKAXISTYPE_Y, true, vY);
		///End SHOW_APPARENT_FIT_IN_LABEL
		vFitX.Trim();				// trim missing

		LROptions 		sLROptions;
		sLROptions.UseReducedChiSq = true;
		FitParameter 	psFitParameter[255];
		int				nSizeFitParams = nOrder + 1;
		RegStats		sRegStats;
		RegANOVA	 	sRegANOVA;
		///Sophy 2/1/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
		//int	nRet = stats_polynomial_fit(vApparentX, vApparentY, vApparentW, nOrder, sLROptions, psFitParameter, nSizeFitParams, &sRegStats, &sRegANOVA);
		int nRet = STATS_NO_ERROR;
		if ( 1 == nOrder ) //linear fit
			nRet = stats_linear_fit(vApparentX, vApparentY, vApparentW, sLROptions, psFitParameter, &sRegStats, &sRegANOVA);
		else
			nRet = stats_polynomial_fit(vApparentX, vApparentY, vApparentW, nOrder, sLROptions, psFitParameter, nSizeFitParams, &sRegStats, &sRegANOVA);
		ASSERT(STATS_NO_ERROR == nRet);
		///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

		stFitResults.stRegStats = sRegStats;		
		stFitResults.vParams.RemoveAll();
		stFitResults.vErrors.RemoveAll();
		stFitResults.vsParamNames.RemoveAll();			
		vFitY.SetSize(vFitX.GetSize());
		vFitY = 0;
		
		for(int nParam  = nSizeFitParams-1; nParam >= 0; nParam--)
		{				
			stFitResults.vParams.InsertAt(0, psFitParameter[nParam].Value);
			stFitResults.vErrors.InsertAt(0, psFitParameter[nParam].Error);
			
			///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
			//if( 0 == nParam )
				//stFitResults.vsParamNames.InsertAt(0, "Intercept");
			//else
			//{
				//if( 2 == nSizeFitParams )//  linear
					//stFitResults.vsParamNames.InsertAt(0, "Slope");
				//else
					//stFitResults.vsParamNames.InsertAt(0, "B"+nParam);
			//}
			///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

			double dd = psFitParameter[nParam].Value;
			vFitY = dd + (vFitY) * (vFitX);
		}
		quick_fit_get_func_param_list(stFitResults.vsParamNames, nOrder, NULL);		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
		
		// convert data by axis type for apparent fit
		glSource.ConvertByAxis(vFitX, vFitX.GetSize(), OKAXISTYPE_X, false, vFitX);
		glSource.ConvertByAxis(vFitY, vFitY.GetSize(), OKAXISTYPE_Y, false, vFitY);			
		
	}	
	///End QUICK_NLSF_FITTING_TABLE	
	
	// put result to source layer storage
	if( !(dwCntrl & NLSF_QUICKFIT_ROI_PREVIEW) )
	{
		Tree trStorage;
		glSource.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage);
	
		TreeNode trResults = tree_check_get_node(trStorage, "Results");
		trResults += stFitResults;
		
		trStorage.Order.nVal = nOrder;
		trStorage.FunctionName.strVal = lpcszFuncName;
		
		glSource.PutBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage);
	}
	
	return NLSF_QUICKFIT_ERROR_NONE;	
}

////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
///////////////////Output Table Begin///////////////////
////////////////////////////////////////////////////////
////////////////////////////////////////////////////////

#define STR_NEXT_LINE		"\r\n"
#define STR_NEXT_COL		"\t"

enum {
	TABLE_BASIC_INFO,
	TABLE_PARAMS_RESULT,
	TABLE_STATS_RESULT
};


///------ Folger 01/12/09 QA81-14832 OUTPUT_QUICKFIT_PARAMETERS_TO_FIT_CURVE_COLUMN_PARAMETER_LABEL
static	BOOL	_output_parameters_info_to_fit_curve_column(const XYRange& xy, const QuickFitResults& stFitResults)
{
	if ( !xy )
		return FALSE;

	Worksheet	wks;
	int			c1, c2;
	xy.GetRange(wks, c1, c2);
	Grid	grid;
	if ( !grid.Attach(wks) )
		return FALSE;	
	grid.ShowLabels(RCLT_PARAM, TRUE);
	
	int		nCount = stFitResults.vParams.GetSize();
	ASSERT(nCount == stFitResults.vsParamNames.GetSize());
	string		str;
	for ( int ii=0; ii<nCount; ++ii )
	{
		string	strTemp;
		strTemp.Format("%s = %g", stFitResults.vsParamNames[ii], stFitResults.vParams[ii]);
		str += strTemp;
		if ( ii != nCount - 1 )
			str += "\r\n";
	}
	
	Column colFitY;
	xy.GetYColumn(colFitY);
	colFitY.SetParameter(str);
	
	ORANGE rng;
    rng.r1 = 0;
    rng.c1 = colFitY.GetIndex();
    rng.r2 = -1;
    rng.c2 = rng.c1;
	wks.AutoSize(AS_INVALIDATE, 0, NULL, FALSE, &rng);
	
	return TRUE;
}
///------ End OUTPUT_QUICKFIT_PARAMETERS_TO_FIT_CURVE_COLUMN_PARAMETER_LABEL

///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
static bool	_get_param_show_list(vector<bool>& vbShowParam, int nNumParams, int nOption, const TreeNode& trROI)
{
	vbShowParam.SetSize(nNumParams);

	bool bShowParams = false;
	switch(nOption)
	{
	case PARAMETER_TABLE_NONE:
		vbShowParam = false;
		break;

	case PARAMETER_TABLE_ALL_PARAMS:
		vbShowParam = true;
		bShowParams = true;
		break;
		
	case PARAMETER_TABLE_FOLLOW_ROI_TAB:
		{
			TreeNode trParams;
			if( trROI )
				trParams = trROI.Params;
			if( trParams )
			{
				TreeNode trParam = trParams.FirstNode;
				for(int ii=0; ii<nNumParams; ii++)
				{
					vbShowParam[ii] = trParam.nVal;
					bShowParams = bShowParams | vbShowParam[ii];
					trParam = trParam.NextNode;
				}
			}
			else
			{
				vbShowParam = true;
				bShowParams = true;
			}
			
		}	
		break;
	}
	
	return bShowParams;
}
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB


/// Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
static string _replace_param_names_with_values(LPCSTR lpcszFormual, const vector<string>& vsParamNames, const vector& vParams, int nSignDigits);

static string _get_equation_fomula(bool bUseRealValue, LPCSTR lpcszFuncName, const QuickFitResults& stFitResults, int nOrder, int nSignDigits = 0)
{
	string 	strFormula;
	if ( 0 == nOrder )
	{
		Tree 	trFF;
		bool 	bRet = nlsf_load_fdf_tree(trFF, lpcszFuncName);
		ASSERT(bRet);
		strFormula = nlsf_get_formula(trFF);			
	}
	else
	{
		int nParams = stFitResults.vsParamNames.GetSize();
		for(int ii = 0; ii < nParams; ii++)
		{
			string strTerm = stFitResults.vsParamNames[ii];
			if(ii > 0)
			{
				strTerm += "*x";
				if(ii > 1)
					strTerm += "^" + ii;
				strFormula += " + ";
			}
			strFormula += strTerm;
		}
		strFormula = (string)"y = " + strFormula;
	}
	if( bUseRealValue )
	{
		strFormula = _replace_param_names_with_values(strFormula, stFitResults.vsParamNames, stFitResults.vParams, nSignDigits);
	}
	///Sophy 4/7/2010 REMOVE_LINEFEED_CARRIAGERETURN_ON_OUTPUT_EQUATION_FORMULA
	strFormula.Remove('\n');
	strFormula.Remove('\r');
	///end REMOVE_LINEFEED_CARRIAGERETURN_ON_OUTPUT_EQUATION_FORMULA
	return strFormula;
}

///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
//static TreeNode _construct_report_tree(const TreeNode& trGUI, const DataRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFuncName, int nOrder, int nSignDigits = 0, const DataRange& oy = NULL)
static TreeNode _construct_report_tree(const TreeNode& trGUI, const TreeNode& trROI, const DataRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFuncName, int nOrder, int nSignDigits = 0, const DataRange& oy = NULL)
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
{
	GETN_TREE(trReport)
	trReport.SetAttribute(STR_TR2WKS_NO_RENAME_SNAME_ATTRIB, 1);
	if( tree_is_true(trGUI.Function) )
	{
		GETN_STR(FuncName, TABLE_LABEL_FUNCTION, _get_function_name(lpcszFuncName, nOrder))
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	/// Hong 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	//if( tree_is_true(trGUI.Input) )
	//{
		//GETN_STR(Input, TABLE_LABEL_INPUT, iy.GetDescription())
		//GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	//}	
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	/*
	if( tree_is_true(trGUI.Input) )
	{
		vector<UINT>		vnUIDs;
		if ( 0 < iy.GetPlots(vnUIDs) )
		{
			DataPlot		dp;
			dp = Project.GetObject(vnUIDs[0]);
			string			strLegend;
			dp.GetLegend(strLegend);
			GETN_STR(Input, TABLE_LABEL_INPUT, strLegend);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
		else
			ASSERT(FALSE);
	}
	if ( tree_is_true(trGUI.InputRangeIndex) )
	{
		string		strRangeWithoutRowIndex, strRangeWithRowIndex;
		strRangeWithoutRowIndex = iy.GetDescription(GETLC_NO_ROWS);
		strRangeWithRowIndex = iy.GetDescription();
		strRangeWithRowIndex = strRangeWithRowIndex.Right(strRangeWithRowIndex.GetLength() - strRangeWithoutRowIndex.GetLength());
		GETN_STR(RowIndex, TABLE_LABEL_INPUT_ROW_INDEX, strRangeWithRowIndex);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	if( tree_is_true(trGUI.Output) && NULL != oy )	
	{
		GETN_STR(Output, TABLE_LABEL_OUTPUT, oy.GetDescription(GETLC_NO_ROWS))
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	*/
	if ( DATA_NONE != trGUI.Input.nVal )
	{
		/// Hong 02/21/10 QA80-14832 PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
		//GETN_STR(Input, TABLE_LABEL_INPUT, _get_data_display_str(iy, trGUI.Input.nVal));
		GETN_STR(Input, TABLE_LABEL_INPUT, _get_data_display_str(iy, trGUI.Input.nVal, true));
		/// end PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	if ( ADDRANGE_NONE != trGUI.InputRange.nVal )
	{
		GETN_STR(RowIndex, TABLE_LABEL_ADD_INPUT_RANGE, _get_range_display_str(iy, trGUI.InputRange.nVal));
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	if ( DATA_NONE != trGUI.Output.nVal && NULL != oy )
	{
		/// Hong 02/21/10 QA80-14832 PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
		//GETN_STR(Output, TABLE_LABEL_OUTPUT, _get_data_display_str(oy, trGUI.Output.nVal));
		GETN_STR(Output, TABLE_LABEL_OUTPUT, _get_data_display_str(oy, trGUI.Output.nVal, true));
		/// end PLOT_LEGEND_JUST_NEED_USE_DEFAULT_SETTING_SAID_CP
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	///Sophy 3/2/2010 FIX_EQUATION_NOT_OUTPUT_TO_WORKSHEET
	//if( tree_is_true(trGUI.Equation) )
	if ( tree_is_true(trGUI.EquationFormat) )
	///end FIX_EQUATION_NOT_OUTPUT_TO_WORKSHEET
	{
		GETN_STR(Equation, TABLE_LABEL_EQUATION, _get_equation_fomula(EQUATION_WITH_VALUES == trGUI.EquationFormat.nVal, lpcszFuncName, stFitResults, nOrder, nSignDigits));
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	if( tree_is_true(trGUI.Weighting) )
	{
		GETN_STR(Weighting, TABLE_LABEL_WEIGHTING, stFitResults.strWeighting)
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	//bool 		bIncludeParams = tree_is_true(trGUI.Value);
	//bool 		bIncludeParamsError = tree_is_true(trGUI.Error);
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	//bool		bIncludeParams = (PARAMETER_TABLE_NONE != trGUI.Params.nVal);
	//bool 		bIncludeParamsError = (PARAMETER_TABLE_SHOW_VALUE_AND_ERROR == trGUI.Params.nVal);
	vector<bool> vbShowParam;
	bool		bIncludeParams = _get_param_show_list(vbShowParam, stFitResults.vsParamNames.GetSize(), trGUI.Params.nVal, trROI);
	bool 		bIncludeParamsError = bIncludeParams && trGUI.ShowError.nVal;
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	if ( bIncludeParams || bIncludeParamsError )
	{
		int 	nNumParams = stFitResults.vParams.GetSize();		
		for ( int nn = 0; nn < nNumParams; nn++ )
		{
			///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
			if( !vbShowParam[nn] )
				continue;
			///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
			string strParamName = stFitResults.vsParamNames[nn];			
			if ( bIncludeParams )
			{
				///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
				//GETN_STR(Param, strParamName, _convert_float_to_str(stFitResults.vParams[nn], nSignDigits));
				GETN_NUM(Parm, strParamName, stFitResults.vParams[nn]);
				GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_SIGNDIGITS_ATTRIB, nSignDigits);
				///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
				GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
			}
			string	strParaErrLabel;
			strParaErrLabel.Format("%s-%s", strParamName, TABLE_LABEL_ERROR);
			if ( bIncludeParamsError )
			{
				///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
				//GETN_STR(ParamError, strParaErrLabel, _convert_float_to_str(stFitResults.vErrors[nn], nSignDigits));
				GETN_NUM(ParamError, strParaErrLabel, stFitResults.vErrors[nn]);
				GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_SIGNDIGITS_ATTRIB, nSignDigits);
				///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
				GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_ERROR);
			}
		}
	}
	if( tree_is_true(trGUI.ReduChisq) )
	{
		///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
		//GETN_STR(ReduChisq, TABLE_LABEL_REDUCE_CHISQ, _convert_float_to_str(stFitResults.stRegStats.ReducedChiSq, nSignDigits));
		GETN_NUM(ReduChisq, TABLE_LABEL_REDUCE_CHISQ, stFitResults.stRegStats.ReducedChiSq);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_SIGNDIGITS_ATTRIB, nSignDigits);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
		///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
	}	
	///Sophy 2/1/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	//if( tree_is_true(trGUI.AdjR) )
	if ( tree_is_true(trGUI.AdjR) && tree_is_visible(trGUI.AdjR) )
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	{
		///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
		//GETN_STR(AdjR, TABLE_LABEL_ADJ_RSQR, _convert_float_to_str(stFitResults.stRegStats.AdjRSq, nSignDigits));
		GETN_NUM(AdjR, TABLE_LABEL_ADJ_RSQR, stFitResults.stRegStats.AdjRSq);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_SIGNDIGITS_ATTRIB, nSignDigits);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
		///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
	}
	///Sophy 2/1/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	if ( tree_is_true(trGUI.RSqr) && tree_is_visible(trGUI.RSqr) )
	{
		///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
		//GETN_STR(RSqr, STR_R_SQR, _convert_float_to_str(stFitResults.stRegStats.RSqCOD, nSignDigits));
		GETN_NUM(RSqr, STR_R_SQR, stFitResults.stRegStats.RSqCOD);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_SIGNDIGITS_ATTRIB, nSignDigits);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
		///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
	}
	if ( tree_is_true(trGUI.Correlation) && tree_is_visible(trGUI.Correlation) )
	{
		///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
		//GETN_STR(Correlation, STR_PEARSON_R, _convert_float_to_str(stFitResults.stRegStats.Correlation, nSignDigits));
		GETN_NUM(Correlation, STR_PEARSON_R, stFitResults.stRegStats.Correlation);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_SIGNDIGITS_ATTRIB, nSignDigits);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
		///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
	}
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	TreeNode	trNumIter = trGUI.NumIter;
	//if ( trNumIter && tree_is_true(trNumIter) && tree_is_visible(trNumIter) )
	if ( 0 == nOrder )
	{
		GETN_NUM(NumIter, TABLE_LABEL_NUM_OF_ITER, stFitResults.nNumIteration);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
	}
	TreeNode	trFitStatus = trGUI.FitStatus;
	//if ( trFitStatus && tree_is_true(trFitStatus) && tree_is_visible(trFitStatus) )
	if ( 0 == nOrder )
	{
		GETN_NUM(FitOutcome, TABLE_LABEL_FIT_STATUS, stFitResults.nFitOutcome);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);
		GETN_STR(FitOutcomeStr, _L("Fit Message"), stFitResults.strFitOutcome);
		GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_CSTRING);
	}
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	
	return trReport;
}
/// end QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS

bool quick_fit_output_report(GraphLayer& gl, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFuncName, int nOrder, bool bFromApplyButton/* = false*/, bool bFromROI/* = true*/, bool bReplaceLastOutput/* = false*/)
{
	if( !gl )
		return false;
	GraphPage gp;
	gp = gl.GetPage();
	
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	Tree trSettingsInROI;
	if( bFromROI )
		GetQuickFitToolSettings(trSettingsInROI);	
	*/
	Tree tr;
	if( bFromROI )
		GetQuickFitToolSettings(tr);
	else
	{
		quick_fit_get_preference_settings(tr);
		quickfit_update_on_mode_function_change(tr);		///Sophy 3/2/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI

	}
	///End USE_COMMON_REPLACE_CHECK
	
	// get table reference settings from theme file
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	Tree tr1;
	// TreeNode trTable = _get_table_preference_settings(tr1);
	TreeNode trTable;
	if( bFromROI )
		trTable = trSettingsInROI.Table;
	else
		trTable = _get_table_preference_settings(tr1);		
	}
	*/
	TreeNode trTable = tr.Table;
	///End USE_COMMON_REPLACE_CHECK
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	/*
	// get output reference settings from theme file
	Tree tr2;
	//TreeNode trOutput = _get_output_preference_settings(tr2);
	TreeNode trOutput;
	if( bFromROI )
		trOutput = trSettingsInROI.Output;
	else
		trOutput = _get_output_preference_settings(tr1);
	*/
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	Tree tr2;
	TreeNode trOutput;
	if( bFromROI )
		trOutput = trSettingsInROI.Report;
	else
		trOutput = _get_report_preference_settings(tr2);
	*/
	TreeNode trOutput = tr.Report;
	///End USE_COMMON_REPLACE_CHECK
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	/*
	Tree tr3;
	TreeNode trROI;
	if( bFromROI )
		trROI = trSettingsInROI.ROI;
	else
		trROI = _get_ROI_preference_settings(tr3);
	*/
	TreeNode trROI = tr.ROI;
	///End USE_COMMON_REPLACE_CHECK
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	
	//// build output string table
	//vector<string> vsSubTables;
	//string strTable = _get_table_str(true, trTable, stFitResults, lpcszFuncName, nOrder, trOutput.SignDigits.nVal, &vsSubTables);
	
	// add text table on Graph	
	GraphObject goTextBox;
	/// Iris 01/07/2010 ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	Tree trStorage;
	if( gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) && trStorage.TextBoxName && !trStorage.TextBoxName.IsEmpty() )
	{
		goTextBox = gl.GraphObjects(trStorage.TextBoxName.strVal);
	}
	///End ADD_OPTION_TO_SEL_ALWAYS_NEW_TEXTBOX_OR_OVERWRITE_EXISTING
	
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	/*
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	ASSERT(tr.ReplaceLastOutput);
	bool bReplaceLastOutput = true;
	if( tr.ReplaceLastOutput )
		bReplaceLastOutput = tr.ReplaceLastOutput.nVal;
	///End USE_COMMON_REPLACE_CHECK
	*/
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	//string strTextBoxName = _quick_fit_output_text_table(trTable, gl, iy, stFitResults, lpcszFuncName, nOrder, UPDATE_TEXT_BOX_FROM_QUICK_FIT, goTextBox, bFromApplyButton, NULL, trTable.SignDigits.nVal);
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//string strTextBoxName = _quick_fit_output_text_table(trTable, trROI, gl, iy, stFitResults, lpcszFuncName, nOrder, UPDATE_TEXT_BOX_FROM_QUICK_FIT, goTextBox, bFromApplyButton, NULL, trTable.SignDigits.nVal);
	string strTextBoxName = _quick_fit_output_text_table(trTable, trROI, gl, iy, stFitResults, lpcszFuncName, nOrder, UPDATE_TEXT_BOX_FROM_QUICK_FIT, goTextBox, bReplaceLastOutput, bFromApplyButton, NULL, trTable.SignDigits.nVal);
	///End USE_COMMON_REPLACE_CHECK
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	
	// Output to Script window or Reuslt Log
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	//string strTable = _get_table_str(false, trOutput, iy, stFitResults, lpcszFuncName, nOrder, UPDATE_TEXT_BOX_FROM_QUICK_FIT, trOutput.SignDigits.nVal);
	string strTable = _get_table_str(false, trOutput, trROI, iy, stFitResults, lpcszFuncName, nOrder, UPDATE_TEXT_BOX_FROM_QUICK_FIT, trOutput.SignDigits.nVal);
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	strTable += STR_NEXT_LINE; // append more empty line as separator for each output
	
	
	DataPlot dpSrc, dpFit;
	XYRange oy;
	if( _get_quick_fit_source_plot(dpSrc, &dpFit) )
	{
		dpFit.GetDataRange(oy);
	}

	switch(trOutput.OutputTo.nVal)
	{
	case OUTPUT_TO_NONE:
		break;

	case OUTPUT_TO_SCRIPT_WND:
		LT_execute("type -a");
		strTable.Write(WRITE_SCRIPT_WINDOW);
		break;
		
	case OUTPUT_TO_RESULT_LOG:
		Project.OutStringToResultsLog(strTable, true, gp.GetName());
		break;
	/// Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
	case OUTPUT_TO_WORKSHEET:
	{
		///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
		//TreeNode		trReport = _construct_report_tree(trTable, iy, stFitResults, lpcszFuncName, nOrder, 0, oy);
		/// Hong 01/28/10 QA80-14832 FIX_SETTING_IN_REPORT_TAB_FAIL_CORRECT_APPLIED
		//TreeNode		trReport = _construct_report_tree(trTable, trROI, iy, stFitResults, lpcszFuncName, nOrder, 0, oy);
		///Sophy 3/3/2010 QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
		//TreeNode		trReport = _construct_report_tree(trOutput, trROI, iy, stFitResults, lpcszFuncName, nOrder, 0, oy);
		TreeNode		trReport = _construct_report_tree(trOutput, trROI, iy, stFitResults, lpcszFuncName, nOrder, trOutput.SignDigits.nVal, oy);
		///end QUICKFIT_REPORT_TO_WKS_SHOULD_APPLY_SIGNIFICANT_SETTINGS
		/// end FIX_SETTING_IN_REPORT_TAB_FAIL_CORRECT_APPLIED
		///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
		string			strWksName = trOutput.WksName.strVal;
		/// Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
		okutil_arg_copy(&strWksName);
		/// end FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
		
		///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
		//out_tree_to_wks(trReport, strWksName);
		out_tree_to_wks(trReport, strWksName, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
		///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	}
		break;
	/// end QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
	default:
		ASSERT(false);
		break;
	}
	
	if( !bFromApplyButton )
	{		
		///------ Folger 12/30/09 GRAPHLAYER_UID_FIX
		/// Since GraphLayer will not have any uid by default. Without uid, Reuid when open files in VC cannot be proceeded.
		gl.GetUID(TRUE);
		///------ End GRAPHLAYER_UID_FIX

		// put TextBox name to layer storage			
		Tree trStorage;
		gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage);
		trStorage.TextBoxName.strVal = strTextBoxName;		
		gl.PutBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage);
		
	}
	
	///------ Folger 01/12/09 QA81-14832 OUTPUT_QUICKFIT_PARAMETERS_TO_FIT_CURVE_COLUMN_PARAMETER_LABEL
	_output_parameters_info_to_fit_curve_column(oy, stFitResults);
	///------ End OUTPUT_QUICKFIT_PARAMETERS_TO_FIT_CURVE_COLUMN_PARAMETER_LABEL
	
	/// Iris 2/01/2010 IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND
	if( !stFitResults.bGoodFit && !stFitResults.strFitOutcome.IsEmpty() )
	{
		LT_execute("type -a");
		stFitResults.strFitOutcome.Write(WRITE_SCRIPT_WINDOW);
	}
	///End IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND
	
	return true;
}

/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
/*
///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
bool	quick_fit_replace_existing_curve()
{
	Tree		tr;
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	//quick_fit_get_preference_settings(tr);	
	if( !GetQuickFitToolSettings(tr) )
	{
		quick_fit_get_preference_settings(tr);
	}
	///End NEW_QUICKFIT_ROI_XF_DLG
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS	
	//TreeNode	trOutput = tr.Output;
	//if ( trOutput )
		//return trOutput.ReplaceExistingCurve.nVal;	
	/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	//TreeNode	trN = tr.FitCurve;
	TreeNode	trN = tr;
	///End USE_COMMON_REPLACE_CHECK
	if ( trN )
		/// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
		//return trN.ReplaceExistingCurve.nVal;
		return trN.ReplaceLastOutput.nVal;
		///End USE_COMMON_REPLACE_CHECK
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	ASSERT(FALSE);
	return FALSE;
}
///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
*/
///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU

static bool _is_long_str_cell(LPCSTR lpcszCellValue)
{
	string strCell(lpcszCellValue);
	strCell.TrimLeft('-'); // - sign not effect length too much, so remove before checking.
	
	const int nLongSize = 6;
	if(lstrlen(strCell) > nLongSize)
		return true;
	return false;	
}

static bool _is_exist_long_param_name(const vector<string> vsParamNames)
{
	for(int nn = 0; nn < vsParamNames.GetSize(); nn++)
	{
		if( _is_long_str_cell(vsParamNames[nn]) )
			return true;
	}		
	return false;
}

///------ Folger 01/27/10 REPORT_STRINGS_HAVE_EXTRA_TABS_WHEN_PASTE_TO_EXCEL
static	void	_check_make_same_col_width(vector<string>& vs)
{
	int		nMaxLength = 0;
	for ( int ii=0; ii<vs.GetSize(); ++ii )
	{
		int		nLen = vs[ii].GetLength();
		if ( nLen > nMaxLength )
			nMaxLength = nLen;
	}

	for ( ii=0; ii<vs.GetSize(); ++ii )
	{
		int		nLen = vs[ii].GetLength();
		if ( nLen < nMaxLength )
		{
			int		nFillSpace = (nMaxLength - nLen);
						
			string	str(' ', nFillSpace);
			vs[ii] += str;
		}
	}
}
///------ End REPORT_STRINGS_HAVE_EXTRA_TABS_WHEN_PASTE_TO_EXCEL

static string _replace_param_names_with_values(LPCSTR lpcszFormual, const vector<string>& vsParamNames, const vector& vParams, int nSignDigits)
{
	string strFormual(lpcszFormual);
	
	for(int nn = 0; nn < vsParamNames.GetSize(); nn++)
	{
		string strValue = _convert_float_to_str(vParams[nn], nSignDigits);
		int num = strFormual.Replace(vsParamNames[nn], strValue);
		if( num < 1 )
		{
			ASSERT(0);
			error_report("_replace_param_names_with_values, param name not match!");
		}
		
		strFormual.Replace("+ -", "- ");
		strFormual.Replace("+-", "-");
	}
	return strFormual;
}

static string _get_function_name(LPCSTR lpcszFuncName, int nOrder)
{
	string strFunctionName(lpcszFuncName);
	if( 0 == nOrder )
		return strFunctionName;
	
	/// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
	/*
	vector<string> vsFuncNames; // same as menu
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG, clean code	
	//vsFuncNames.Add(STR_LINE_FUNCTION);
	//vsFuncNames.Add(STR_QUADRATIC_FUNCTION);
	//vsFuncNames.Add(STR_CUBIC_FUNCTION);	
	vsFuncNames.Add(LINEAR_FIT_MRU_NAME);
	vsFuncNames.Add(QUADRATIC_FIT_MRU_NAME);
	vsFuncNames.Add(CUBIC_FIT_MRU_NAME);
	///End NEW_QUICKFIT_ROI_XF_DLG
	
	int nFunc = nOrder - 1;
	ASSERT( nFunc >=0 && nFunc < vsFuncNames.GetSize() );
	return vsFuncNames[nFunc];
	*/
	//----Iris 1/27/2010 CHANGE_POLY_FUNCTION_LIST
	//return quick_fit_get_lr_function_name(nOrder);
	strFunctionName = quick_fit_get_lr_function_name(nOrder);
	if( nOrder > NUM_FIXED_POLY_FUNC ) // not Line, Quadratic, Cubie
		strFunctionName += " " + STR_POLY;
	return strFunctionName;
	//----End CHANGE_POLY_FUNCTION_LIST

	///End USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
}

static string _get_input_output_str(bool bTextBox, int nIndex, LPCSTR lpcszDesc)
{
	string strInput;
	if( bTextBox )
	{
		strInput.Format("\l(%d) %s", nIndex, lpcszDesc);
	}
	else
	{
		strInput.Format("%s", lpcszDesc);
	}	
	return strInput;
}

//vsSubTables include the string table for each part: basic info, stats result and param results.
///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
//static string _get_table_str(bool bTextBox, const TreeNode& trGUI, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFunc, int nOrder, int nUpdatedFrom, int nSignDigits = 0)
static string _get_table_str(bool bTextBox, const TreeNode& trGUI, const TreeNode& trROI, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFunc, int nOrder, int nUpdatedFrom, int nSignDigits = 0)
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
{

	string str, strTable;
	string strNextLine = STR_NEXT_LINE, strNextCol = STR_NEXT_COL;	

	//if( pvsSubTables )
	//	pvsSubTables->SetSize(0);
	
	// 1. Basic Information
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	// Date and Time
	string strBasicInfo;
	if( tree_is_true(trGUI.DateTime) )
	{
		SYSTEMTIME sysTime;
	    GetSystemTime(&sysTime);    
	    double dDateTime;
	    SystemTimeToJulianDate(&dDateTime, &sysTime);
	    str = TABLE_LABEL_DATETIME + ": " + get_date_str(dDateTime);
	    strBasicInfo += str;
	}   
	
	// Model
	if( tree_is_true(trGUI.FuncName) )
	{
	    str = TABLE_LABEL_FUNCTION + ": " + _get_function_name(lpcszFunc, nOrder);
	    strBasicInfo += strNextLine + str;		
	}
	*/    
    time_t aclock;
    time(&aclock);  // Get time in seconds 
 
 	struct tm *pTime;
    pTime = localtime( &aclock );  // Convert time to struct  
    
	SYSTEMTIME sysTime;
    tm_to_systemtime(pTime, &sysTime);
    
    double dDateTime;
    SystemTimeToJulianDate(&dDateTime, &sysTime);
	
    string strBasicInfo;
    /// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	//strBasicInfo = _L("Quick Fit");
	//strBasicInfo += " (" + _get_function_name(lpcszFunc, nOrder) + ")";	
	if( tree_is_true(trGUI.Function) )
	{
		string strFuncName = _get_function_name(lpcszFunc, nOrder);
		if( 0 == nOrder )
		{
			strBasicInfo += STR_FUNC_NAME_NL + " (" + strFuncName + ")";
		}
		else
		{
			/// Iris 2/04/2010 SHOW_APPARENT_FIT_IN_LABEL
			if( stFitResults.bIsApparentFit )
			{
				strBasicInfo += STR_APPARENT_FIT + " ";
			}
			///End SHOW_APPARENT_FIT_IN_LABEL
			strBasicInfo += strFuncName;
		}
	}
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	strBasicInfo += " (" + get_date_str(dDateTime) + ")";
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME

	// Input Data & Output
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//if( tree_is_true(trGUI.Input) || tree_is_true(trGUI.Output) )
	if( DATA_NONE != trGUI.Input.nVal || DATA_NONE != trGUI.Output.nVal || ADDRANGE_NONE != trGUI.InputRange.nVal )
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	{
		DataPlot dpSrc, dpFit;
		if ( _get_quick_fit_source_plot(dpSrc, &dpFit) )
		{
			/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
			bool		bIncludeLegendSymbol = bTextBox && trGUI.Legend.nVal;
			/// end IMPROVE_GUI_OF_INPUT_OUTPUT
			DataRange oy;
			dpFit.GetDataRange(oy);
			
			string strSrc = iy.GetDescription();
			string strFit = oy.GetDescription(GETLC_NO_ROWS);
			int nSrc = dpSrc.GetIndex() + 1;
			int nFit = dpFit.GetIndex() + 1;
			
			// Input
			string strInput;
			/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
			//if( tree_is_true(trGUI.Input) )
			//{
				//strInput = "\r\nInput:" + _get_input_output_str(bTextBox, nSrc, strSrc);
			if( DATA_NONE != trGUI.Input.nVal )
			{
				strInput = "\r\nInput:" + _get_input_output_str(bIncludeLegendSymbol, nSrc, _get_data_display_str(iy, trGUI.Input.nVal, !bTextBox));
			/// end IMPROVE_GUI_OF_INPUT_OUTPUT
				strBasicInfo += strInput;
			}
			
			// Range
			if ( ADDRANGE_NONE != trGUI.InputRange.nVal )
				strBasicInfo += "\r\nRange:" + _get_range_display_str(iy, trGUI.InputRange.nVal);
			
			// Output
			string strOutput;
			/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
			//if( tree_is_true(trGUI.Output) )
			//{
				//if( !strInput.IsEmpty() )
					//strBasicInfo += "\r\n";
				//
				//strOutput = "Output:" + _get_input_output_str(bTextBox, nFit, strFit);			
			if( tree_is_true(trGUI.Output) )
			{
				strOutput = "\r\nOutput:" + _get_input_output_str(bIncludeLegendSymbol, nFit, _get_data_display_str(oy, trGUI.Output.nVal, !bTextBox));
			/// end IMPROVE_GUI_OF_INPUT_OUTPUT
				strBasicInfo += strOutput;
			}
		}
	}
	
	// Equation
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	//if( !bTextBox || tree_is_true(trGUI.Equation) )
	if( EQUATION_NONE != trGUI.EquationFormat.nVal )
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	{
		/// Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
		/*
		string strFormula;
		if(0 == nOrder)
		{
			Tree trFF;
			bool bRet = nlsf_load_fdf_tree(trFF, lpcszFunc);
			ASSERT(bRet);
			strFormula = nlsf_get_formula(trFF);			
		}
		else
		{
			str.Empty();
			int nParams = stFitResults.vParams.GetSize();
			for(int ii = 0; ii < nParams; ii++)
			{
				string strTerm = stFitResults.vsParamNames[ii];
				if(ii > 0)
				{
					strTerm += "*x";
					if(ii > 1)
						strTerm += "^" + ii;
					str += " + ";
				}
				str += strTerm;
			}
			strFormula = (string)"y = " + str;
		}
		
		if( EQUATION_WITH_VALUES == trGUI.EquationFormat.nVal )
		{
			strFormula = _replace_param_names_with_values(strFormula, stFitResults.vsParamNames, stFitResults.vParams, nSignDigits);
		}
		*/
		string strFormula = _get_equation_fomula(EQUATION_WITH_VALUES == trGUI.EquationFormat.nVal, lpcszFunc, stFitResults, nOrder, nSignDigits);
		/// end QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
		
		//----- Iris 12/30/2009 to fix "When doing Boltzman Fit, there is an extended charactor before y in Equation in Script window"
		strFormula.TrimLeft();
		strFormula.TrimRight();
		//-----
	    str = TABLE_LABEL_EQUATION + ": " + strFormula;
	    strBasicInfo += strNextLine + str;			
	}
	//if( pvsSubTables )
	//	pvsSubTables->Add(strBasicInfo);
	
	// Weighting 
	if( tree_is_true(trGUI.Weighting) )
	{
		strBasicInfo += strNextLine + TABLE_LABEL_WEIGHTING + + ": " + stFitResults.strWeighting;
	}
	
	strTable += strBasicInfo; // the end of Basic Info
	
	// 2. Parameter value and error
	string strParams;
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	/*
	bool bValue = tree_is_true(trGUI.Value);
	bool bError = tree_is_true(trGUI.Error);
	if( !bTextBox || bValue || bError )
	*/
	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	//bool bValue = (PARAMETER_TABLE_NONE != trGUI.Params.nVal);
	//bool bError = (PARAMETER_TABLE_SHOW_VALUE_AND_ERROR == trGUI.Params.nVal);
	vector<bool> vbShowParam;
	bool bValue = _get_param_show_list(vbShowParam, stFitResults.vsParamNames.GetSize(), trGUI.Params.nVal, trROI);
	bool bError = bValue && trGUI.ShowError.nVal;
	///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	if( bValue || bError )
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	{		
		//----- Iris 2/04/2010 In order to keep the Value and Error text in parameter table of label box is aligned,
		// and keep the str in script wnd can be copy/paste to excel with format.
		// Use separate codes to generate report str for text lable and Script Wnd/Result Log.
		if( bTextBox ) 
		//-----
		{
			// build "Value" "Error" title
			bool bExistLongName = _is_exist_long_param_name(stFitResults.vsParamNames);
			string str1stColSep = bExistLongName? strNextCol + strNextCol : strNextCol;
			string str2ndColSep = bValue? strNextCol + strNextCol : str1stColSep;
			str = " ";
			/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
			//if(!bTextBox || bValue)
			if(bValue)
			///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
				str += str1stColSep + TABLE_LABEL_VALUE;
				
			/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
			//if(!bTextBox || bError)
			if(bError)
			///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
				str += str2ndColSep + TABLE_LABEL_ERROR;
			strParams += strNextLine + str; 
			
			// build param name with value and error
			int nNumParams = stFitResults.vParams.GetSize();		
			for(int nn = 0; nn < nNumParams; nn++)
			{
				///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
				if( !vbShowParam[nn] )
					continue;
				///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
				string strParamName = stFitResults.vsParamNames[nn];			
				if( bExistLongName )
					str1stColSep = _is_long_str_cell(strParamName)? strNextCol : strNextCol + strNextCol;
				else
					str1stColSep = strNextCol;			
				
				str = strParamName;
				/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
				//if( !bTextBox || bValue )
				if(bValue)
				///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
				{
					string strValue = _convert_float_to_str(stFitResults.vParams[nn], nSignDigits);
					str += str1stColSep + strValue;
					
					str2ndColSep = _is_long_str_cell(strValue)? strNextCol : strNextCol + strNextCol;
				}
				
				str2ndColSep = bValue? str2ndColSep : str1stColSep;
				/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
				//if( !bTextBox || bError )		
				if(bError)
				///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
					str += str2ndColSep + _convert_float_to_str(stFitResults.vErrors[nn], nSignDigits);
				
				strParams += strNextLine + str;
			}
		}
		else
		{
			///------ Folger 01/27/10 REPORT_STRINGS_HAVE_EXTRA_TABS_WHEN_PASTE_TO_EXCEL
			vector<string>		vsNames(1);
			vsNames.Append(stFitResults.vsParamNames);
			_check_make_same_col_width(vsNames);
			vector<string>		vsValues;
			vector<string>		vsErrors;
			int					nNumParams = stFitResults.vParams.GetSize();
	
			if ( bValue )
			{
				vsValues.SetSize(nNumParams + 1);
				vsValues[0] = TABLE_LABEL_VALUE;
				for ( int ii=0; ii<nNumParams; ++ii )
				{
					vsValues[ii + 1] = _convert_float_to_str(stFitResults.vParams[ii], nSignDigits);
				}
				_check_make_same_col_width(vsValues);
			}
	
			if ( bError )
			{
				vsErrors.SetSize(nNumParams + 1);
				vsErrors[0] = TABLE_LABEL_ERROR;
				for ( int ii=0; ii<nNumParams; ++ii )
				{
					vsErrors[ii + 1] = _convert_float_to_str(stFitResults.vErrors[ii], nSignDigits);
				}
				_check_make_same_col_width(vsErrors);
			}
	
			str.Empty();
			for ( int ii=0; ii<nNumParams + 1; ++ii )
			{
				if( ii > 0 && !vbShowParam[ii-1] )
					continue;
	
				str += STR_NEXT_LINE + vsNames[ii];
	
				if ( bValue )
					str += STR_NEXT_COL + vsValues[ii];
				if ( bError )
					str += STR_NEXT_COL + vsErrors[ii];
			}
	
			strParams += STR_NEXT_COL + str;
			///------ End REPORT_STRINGS_HAVE_EXTRA_TABS_WHEN_PASTE_TO_EXCEL
		}
	}
	
	// to keep Error column aligned in Result Log and Script Wnd
	if( !bTextBox )
	{
		string strOld = TABLE_LABEL_VALUE + STR_NEXT_COL + STR_NEXT_COL + TABLE_LABEL_ERROR;
		string strNew = TABLE_LABEL_VALUE + STR_NEXT_COL + TABLE_LABEL_ERROR;
		strParams.Replace(strOld, strNew);			
	}
	
	//if( pvsSubTables )
	//	pvsSubTables->Add(strParams);
	if( !strParams.IsEmpty()  )
	{
		if( !strTable.IsEmpty() )
			strTable += strNextLine; // add one empty line to separate			
		strTable += strParams;
	}
	
		
	// 3. Stats result
	string strStats;
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	//if( !bTextBox || tree_is_true(trGUI.ReduChisq) )
	if( tree_is_true(trGUI.ReduChisq) )
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	{
	    str = TABLE_LABEL_REDUCE_CHISQ + STR_NEXT_COL + _convert_float_to_str(stFitResults.stRegStats.ReducedChiSq, nSignDigits);
	    strStats += strNextLine + str;			
	}	
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	//if( !bTextBox || tree_is_true(trGUI.AdjR) )
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	//if( tree_is_true(trGUI.AdjR) )
	if( tree_is_true(trGUI.AdjR) && tree_is_visible(trGUI.AdjR) )
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	{
	    str = TABLE_LABEL_ADJ_RSQR + STR_NEXT_COL + _convert_float_to_str(stFitResults.stRegStats.AdjRSq, nSignDigits);
	    strStats += strNextLine + str;			
	}
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	if ( tree_is_true(trGUI.RSqr) && tree_is_visible(trGUI.RSqr) )
	{
		str = STR_R_SQR + STR_NEXT_COL + _convert_float_to_str(stFitResults.stRegStats.RSqCOD, nSignDigits);
		strStats += strNextLine + str;
	}
	if ( tree_is_true(trGUI.Correlation) && tree_is_visible(trGUI.Correlation) )
	{
		str = STR_PEARSON_R + STR_NEXT_COL + _convert_float_to_str(stFitResults.stRegStats.Correlation, nSignDigits);
		strStats += strNextLine + str;
	}
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	
	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	TreeNode	trNumIter = trGUI.NumIter;
	//if ( trNumIter && tree_is_true(trNumIter) && tree_is_visible(trNumIter) )
	if ( 0 == nOrder )
	{
		str.Format("%s%s%d", TABLE_LABEL_NUM_OF_ITER, STR_NEXT_COL, stFitResults.nNumIteration);
		strStats += strNextLine + str;
	}
	TreeNode	trFitStatus = trGUI.FitStatus;
	//if ( trFitStatus && tree_is_true(trFitStatus) && tree_is_visible(trFitStatus) )
	if ( 0 == nOrder )
	{
		str.Format("%s%s%s(%d)", TABLE_LABEL_FIT_STATUS, STR_NEXT_COL, stFitResults.strFitOutcome, stFitResults.nFitOutcome);
		strStats += strNextLine + str;
	}
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	
	//if( pvsSubTables )
	//	pvsSubTables->Add(strStats);
	if( !strStats.IsEmpty() )
		strTable += strNextLine + strStats;
	
	// Not want show fit outcome in string table, so if fit outcome is not empty, 
	// will insert at the last line in part 2 stats result for Script window output.
	//----- Iris 1/22/2010 Max said fit outcome should always appear in Script window.
	/*
	if( !bTextBox )
	{
		strTable += STR_NEXT_LINE + stFitResults.strFitOutcome;
	}		
	*/
	/// Iris 2/01/2010 IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND
	/*
	if( !stFitResults.strFitOutcome.IsEmpty() && !bTextBox )
	{
		LT_execute("type -a");
		stFitResults.strFitOutcome.Write(WRITE_SCRIPT_WINDOW);
	}
	*/
	///End IMPROVE_FIT_OUTCOME_OUTPUT_MSG_IN_SCRIPT_WND
	//-----
	return strTable;
}
////////////////////////////////////////////////////////
////////////////////////////////////////////////////////
////////////////////Output Table End////////////////////
////////////////////////////////////////////////////////
////////////////////////////////////////////////////////


static bool _get_fit_curve_x_data(const vector& vX, vector& vFitX, const GraphLayer& gl, DWORD dwCntrl)
{
	// get output reference settings from theme file
	Tree tr;
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//TreeNode trOutput = _get_output_preference_settings(tr);	
	TreeNode trOutput;
	if(	!GetQuickFitToolSettings(tr) )
	{
		trOutput = _get_fit_curve_preference_settings(tr);
	}
	else
	{
		trOutput = tr.FitCurve;
	}
	///End REARRANGE_PREFERENCE_DLG_TABS

	FitResultCurveDataOptions stfitOptions;
	if( dwCntrl & NLSF_QUICKFIT_ROI_PREVIEW )
	{
		#define MIN_POINT_FOR_PREVIEW		100

		stfitOptions.DataType = FIT_CURVE_SAME_AS_SOURCE_GRAPH;
		stfitOptions.N = max(vX.GetSize(), MIN_POINT_FOR_PREVIEW);
		stfitOptions.Range = FIT_CURVE_CUSTOM;
		double dMin, dMax;
		vX.GetMinMax(dMin, dMax);
		stfitOptions.Min = dMin;
		stfitOptions.Max = dMax;
		stfitOptions.RangeMargin = 0;
	}
	else
	{
		bool bROI = (dwCntrl & NLSF_QUICKFIT_ROI_RESULT);
		switch(trOutput.FitCurve.nVal)
		{
		case FIT_CURVE_TYPE_SAME_AS_INPUT:
			stfitOptions.DataType = FIT_CURVE_SAME_AS_DATA;
			break;
		case FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE:
			stfitOptions.DataType = FIT_CURVE_SAME_AS_SOURCE_GRAPH;
			break;
		case FIT_CURVE_TYPE_UNIFORM:
			stfitOptions.DataType = FIT_CURVE_UNIFORM_LINEAR;
			break;
		default:
			ASSERT(0);
			break;
		}
		
		stfitOptions.N = atoi(trOutput.NumPoints.strVal);
		stfitOptions.Range = FIT_CURVE_CUSTOM;
		double dMin, dMax;
		vX.GetMinMax(dMin, dMax);
		//if( bROI )
		{
			stfitOptions.Min = dMin;
			stfitOptions.Max = dMax;
		}
		//else
		{
			/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
			/*
			/// Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG
			//stfitOptions.Min = (trOutput.XAutoFrom && trOutput.XAutoFrom.nVal) ? dMin : atof(trOutput.XFrom.strVal);
			//stfitOptions.Max = (trOutput.XAutoTo && trOutput.XAutoTo.nVal) ? dMax : atof(trOutput.XTo.strVal);
			TreeNode trXFrom = trOutput.XFrom, trXTo = trOutput.XTo;
			stfitOptions.Min = (trXFrom && octree_get_auto_support(&trXFrom)) ? dMin : atof(trXFrom.strVal);
			stfitOptions.Max = (trXTo && octree_get_auto_support(&trXTo)) ? dMax : atof(trXTo.strVal);
			///End NEW_QUICKFIT_ROI_XF_DLG	
			*/
			///End REARRANGE_PREFERENCE_DLG_TABS
		}
		stfitOptions.RangeMargin = 0;	
	}
	
	return get_data_by_fitted_curve_options(vX, vFitX, stfitOptions, gl, true, NULL, NULL, true);	
}

/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
//static void _computer_y_by_x(const QuickFitResults& stFitResults, LPCSTR lpcszFunc, const vector& vFindInput, vector& vFindOutput)
static void _computer_y_by_x(const vector& vParamValues, LPCSTR lpcszFunc, const vector& vFindInput, vector& vFindOutput)
///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
{
	for( int nn = 0; nn < vFindInput.GetSize(); nn++)
	{
		double dY = NANUM;
		/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		//if( compute_y_by_x(lpcszFunc, stFitResults.vParams.GetSize(), stFitResults.vParams, vFindInput[nn], &dY) )
		if( compute_y_by_x(lpcszFunc, vParamValues.GetSize(), vParamValues, vFindInput[nn], &dY) )
		///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		{				
			vFindOutput.Add(dY);
		}
		else
		{
			vFindOutput.Add(NANUM);
		}
	}	
}

///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
#define	STR_FINDY	_L("Find Y")
#define	STR_FINDX	_L("Find X")
///end QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS

#define STR_QUICKFIT_FINDXY_DLG_NAME	"Quick Fit Find X/Y"		///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT

QuickFitFindXYDlg::QuickFitFindXYDlg() : ResizeDialog(IDD_QUICK_FIT_FINDXY, "ODlg8")
{
	m_bHasDoFinding = false; /// Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY	
}

int QuickFitFindXYDlg::DoModalEx(HWND hWndParent)
{
	InitMsgMap();
	int nRet = ResizeDialog::DoModal(hWndParent);		
	return nRet;
}

BOOL QuickFitFindXYDlg::OnInitDialog()	
{
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	/*
	if( _get_quick_fit_source_plot(m_dpSource) )
	{
		m_dpSource.GetParent(m_gl);
	}		
	///Sophy 1/13/2010 SUPPORT_FINDXY_BEFORE_OUTPUT_RESULT
	else
	{
		QuickFitPlotInfo qfInfo;
		m_gl = Project.ActiveLayer();
		if ( m_gl && quick_fit_source_plot_info_access(qfInfo, m_gl) )
			m_dpSource = Project.GetObject(qfInfo.nUID);
	}
	///end SUPPORT_FINDXY_BEFORE_OUTPUT_RESULT
	Tree trStorage;
	if( !m_dpSource || !m_gl || !m_gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) )
	{
		error_msg_box(XF_QUICKFIT_FINDXY_NO_VALID_GRAPH);
		ASSERT(0); // Error! Should not go to here since FindXY... menu should be disable.
		return false; 
	}		
	m_stFitResults = (QuickFitResults)trStorage.Results;
	*/
	m_gl = Project.ActiveLayer();	
	string strRect;
	if( !get_gl_quick_fit_rect_go_name(m_gl, strRect) )
	{
		ASSERT(false);
		return error_report("Fail to find QuickFit ROI object name in FindXY dialog");
	}
	GraphObject goRect = m_gl.GraphObjects(strRect);
	if( !goRect )
	{
		ASSERT(false);
		return error_report("Fail to find QuickFit ROI object in FindXY dialog");
	}	
	
	if( !find_intersect_dataplot(goRect, m_dpSource, m_i1, m_i2) )
	{
		ASSERT(false);
		return error_report("Fail to get source data plot in FindXY dialog");
	}
	
	QuickFitTool qtool(strRect);
	Tree tr;
	if( !qtool.AccessFitResults(tr, true) || !tr.ParamValues.IsValid() )
	{
		ASSERT(false);
		return error_report("Fail to get fit param values in FindXY dialog");	
	}
	m_vParamValues = tr.ParamValues.dVals;
	ASSERT(m_vParamValues.GetSize());
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	
	/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT
	/*	
	m_nOrder = trStorage.Order.nVal;
	m_strFunctionName = _get_function_name(trStorage.FunctionName.strVal, m_nOrder);
	*/
	Tree trROISettings;
	if( !GetQuickFitToolSettings(trROISettings) )
		ASSERT(false);
	m_strFunctionName = trROISettings.func.strVal;
	m_nOrder = quick_fit_get_order(trROISettings.mode.nVal, m_strFunctionName);
	///End IMPROVE_FINDXY_OUTPUT
	
	// get input wks from input range
	DataRange drIn;
	m_dpSource.GetDataRange(drIn);	
	
	//----Iris 2/05/2010 no place use c1 and c2, so comment out
	//int c1, c2;
	//drIn.GetRange(m_wks, c1, c2);
	//----
	
	m_btnFindX = GetItem(IDC_BTN_FINDX);
	m_btnFindY = GetItem(IDC_BTN_FINDY);
	///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
	m_btnOutput = GetItem(IDC_BTN_FINDXY_OUTPUT);
	m_btnFind = GetItem(IDC_BTN_FINDXY);
	m_bFindX = false; //default find Y;
	m_btnFind.Enable = m_btnOutput.Enable = false;
	///end QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
	m_btnFindXOutput = GetItem(IDC_BTN_FINDX_OUTPUT);
	m_btnFindYOutput = GetItem(IDC_BTN_FINDY_OUTPUT);
	
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	//// find x
	//m_edInY = GetItem(IDC_FINDX_Y);
	//m_edOutX = GetItem(IDC_FINDX_X);
	//
	//// find y
	//m_edInX = GetItem(IDC_FINDY_X);
	//m_edOutY = GetItem(IDC_FINDY_Y);
	m_edX = GetItem(IDC_FINDXY_X);
	m_edY = GetItem(IDC_FINDXY_Y);
	
	m_btnOutputScript = GetItem(IDC_FINDXY_OUTPUT_TO_SCRIPT_WINDOW);
	m_btnOutputResultLog = GetItem(IDC_FINDXY_OUTPUT_TO_RESULT_LOG);	///Sophy 1/15/2010 QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	m_btnOutputWorksheet = GetItem(IDC_FINDXY_OUTPUT_TO_WORKSHEET);
	m_edOutputWks = GetItem(IDC_FINDXY_WORKSHEET);
	loadSettings();

	///Sophy 1/15/2010 QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG
	m_txtRangeHints = GetItem(IDC_FINDXY_RANGE_HINT);
	updateRangeInfo();
	///end QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG
	// hint
	RichEdit edHint = GetItem(IDC_FINDXY_HINT);
	if(edHint)
	{
		edHint.Enable = false;
		edHint.Text = _L("Enter semicolon separated values to find multiple values");
		edHint.SetTextColor(0, -1, color_index_to_rgb(SYSCOLOR_BLUE));
	}
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//_get_output_preference_settings(m_trOutput);
	//----- Iris 2/05/2010, no palce use m_trOutput, significant digits always use Origin default setting, so comment out.
	//_get_report_preference_settings(m_trOutput); // used to get significant digits
	//-----
	///End REARRANGE_PREFERENCE_DLG_TABS

	return true;	
}

///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
BOOL QuickFitFindXYDlg::OnDestroy()
{
	saveSettings();
	return true;
}
///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT

bool QuickFitFindXYDlg::onClickFindButton(bool bFindX)
{
	vector vecToFind;
	if( !getFindXYInput(bFindX, vecToFind) )
		return false;
	
	if( !findxy(bFindX, vecToFind) )
		return false;
	
	displayFinding(bFindX);	
	
	m_bHasDoFinding = true; /// Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY
	return true;
}

bool QuickFitFindXYDlg::onclickOutputButton(bool bFindX)
{
	if( !m_bHasDoFinding ) /// Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY
	{
		onClickFindButton(bFindX);
	}
	outputFinding(bFindX);
	///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	CheckEnableGoToWorksheet();
	///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	return true;
}

BOOL QuickFitFindXYDlg::OnClickFindXButton(Control ctrl)
{
	onClickFindButton(true);
	return true;
}

BOOL QuickFitFindXYDlg::OnClickFindYButton(Control ctrl)
{
	onClickFindButton(false);
	return true;
}

BOOL QuickFitFindXYDlg::OnClickFindXOutputButton(Control ctrl)
{
	onclickOutputButton(true);
	return true;
}

BOOL QuickFitFindXYDlg::OnClickFindYOutputButton(Control ctrl)
{
	onclickOutputButton(false);
	return true;
}

///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
BOOL QuickFitFindXYDlg::OnClickFindXYOutputButton(Control ctrl)
{
	ROIToolOptionAccessHelper clHelper(ROI_OPTION_IGNORE_EVENT);
	return onclickOutputButton(m_bFindX);
}

BOOL QuickFitFindXYDlg::OnClickFindXYButton(Control ctrl)
{	
	ROIToolOptionAccessHelper clHelper(ROI_OPTION_IGNORE_EVENT);
	return onClickFindButton(m_bFindX);
}

BOOL QuickFitFindXYDlg::OnXYValueChange(Control ctrl)
{
	if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_IGNORE_EVENT) ) //if Y field is changed by code, should be ignored.
		return FALSE;
	
	if ( GetDlgCtrlID(ctrl.GetSafeHwnd()) == GetDlgCtrlID(m_edX.GetSafeHwnd()) )
	{
		m_bFindX = false;
	}
	else if ( GetDlgCtrlID(ctrl.GetSafeHwnd()) == GetDlgCtrlID(m_edY.GetSafeHwnd()) )
	{
		m_bFindX = true;
	}
	else
		ASSERT(FALSE);
	
	string strText = ctrl.Text;
	m_btnOutput.Enable = m_btnFind.Enable = strText.GetLength() > 0;

	m_btnFind.Text = m_bFindX ? STR_FINDX : STR_FINDY;	
	m_bHasDoFinding = false; /// Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY
	return TRUE;
}
///end QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS

	
///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
BOOL QuickFitFindXYDlg::OnClickFindXYOutputTo(Control ctrl)
{
	bool bOutputToWks = m_btnOutputWorksheet.Value;
	m_edOutputWks.Enable = bOutputToWks;
	///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	CheckEnableGoToWorksheet();
	///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	
	return true;
}

void QuickFitFindXYDlg::loadSettings()
{
	int nOutputTo = LoadSetting("OutputTo", 0, STR_QUICKFIT_FINDXY_DLG_NAME);
	/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT
	/*
	m_btnOutputScript.Value = nOutputTo == 0;
	m_btnOutputResultLog.Value= nOutputTo == 1;	///Sophy 1/15/2010 QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	m_btnOutputWorksheet.Value = nOutputTo == 2;	
	m_edOutputWks.Enable = nOutputTo == 1;
	*/
	m_btnOutputScript.Value = (FINDXY_OUTPUT_TO_SCRIPT_WND == nOutputTo);
	m_btnOutputResultLog.Value= (FINDXY_OUTPUT_TO_RESULT_LOG == nOutputTo);
	m_btnOutputWorksheet.Value = (FINDXY_OUTPUT_TO_WKS == nOutputTo);
	m_edOutputWks.Enable = m_btnOutputWorksheet.Value;
	///End IMPROVE_FINDXY_OUTPUT

	string strWks;
	dlg_load_registry(STR_QUICKFIT_FINDXY_DLG_NAME, "OutputWksName", strWks, "[FindXY]Result");
	if( strWks.IsEmpty() )
		strWks = "FindXY";
	m_edOutputWks.Text = strWks;

	///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	CheckEnableGoToWorksheet();
	///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
}

void QuickFitFindXYDlg::saveSettings()
{
	///Sophy 1/15/2010 QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	int nOutput = 0; //default treated as script window.
	if ( m_btnOutputScript.Value == 1 )
		nOutput = 0;
	else if ( m_btnOutputResultLog.Value == 1 )
		nOutput = 1;
	else if ( m_btnOutputWorksheet.Value == 1 )
		nOutput = 2;
	///end QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	
	SaveSetting("OutputTo", nOutput, STR_QUICKFIT_FINDXY_DLG_NAME);
	
	dlg_save_to_registry(STR_QUICKFIT_FINDXY_DLG_NAME, "OutputWksName", m_edOutputWks.Text);
}
///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT

bool QuickFitFindXYDlg::getFindXYInput(bool bFindX, vector& vecToFind)
{
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	//string strToFind = bFindX? m_edInY.Text : m_edInX.Text;
	string strToFind = bFindX? m_edY.Text : m_edX.Text;
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	strToFind.TrimLeft();
	strToFind.TrimRight();
	/// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
	strToFind.Remove('[');
	strToFind.Remove(']');
	///End FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X

	///Sophy 1/18/2010 SURPLUS_SPACES_MAKE_MISSING_VALUES_IN_VECTOR
	//strToFind.GetTokens(vecToFind, ' ');
	///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	//strToFind.GetTokens(vecToFind);
	if ( bFindX || (OKCOLTYPE_DATE != m_nXFormat && OKCOLTYPE_TIME != m_nXFormat) ) //not date time
	{
		strToFind.GetTokens(vecToFind, ';');
	}
	else
	{
		vector<string> vsValues;
		strToFind.GetTokens(vsValues, ';');
		double dDate;
		for ( int ii = 0; ii < vsValues.GetSize(); ii++ )
		{
			if ( LDF_OBJ_CUSTOM == m_nXSubFormat && OKCOLTYPE_DATE == m_nXFormat )
			{
				if ( str_to_date_custom(vsValues[ii], m_strCustomFmt, &dDate) )
					vecToFind.Add(dDate);
				else
					xf_warning_msg_box(_L("Invalid date string found!"), false, 'E');
			}
			else if ( OKCOLTYPE_DATE == m_nXFormat )
			{
				dDate =  str_to_date(vsValues[ii], m_nXSubFormat);
				if ( !is_missing_value(dDate) )
					vecToFind.Add(dDate);
				else
					xf_warning_msg_box(_L("Invalid date string found!"), false, 'E');
			}
			else
			{
				dDate = str_to_time_ex(vsValues[ii], m_nXSubFormat);
				if ( !is_missing_value(dDate) )
					vecToFind.Add(dDate);
				else
					xf_warning_msg_box(_L("Invalid time string found!"), false, 'E');
			}
		}
	}
	///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	///end SURPLUS_SPACES_MAKE_MISSING_VALUES_IN_VECTOR
	
	return (vecToFind.GetSize() > 0);
}

void QuickFitFindXYDlg::displayFinding(bool bFindX)
{
	vector vecFinding;
	vecFinding = m_vFindXYOutput;
	
	vector<string> vsFormat;
	vsFormat.SetSize(vecFinding.GetSize());
	string strFormat = "*";
	
	///Sophy 1/22/2010 DISPLAY_RESULT_ACCORDING_TO_ORIGIN_SETTINGS
	//int nSignDigits = m_trOutput.Output.SignDigits.nVal;
	/// Iris 1/23/2010 CORRECT_SOPHY_FINDXY_SIGN_DIGITS_CODES, "*" already is Origin sign digits system setting
	/*
	OriginSettings os;
	int nSignDigits;
	os.GetValue("NUMERIC.NUMSIGDIGITS", nSignDigits);
	///end DISPLAY_RESULT_ACCORDING_TO_ORIGIN_SETTINGS
	if(0 != nSignDigits)
		strFormat += nSignDigits;
	*/
	int nSignDigits = 0;
	///End CORRECT_SOPHY_FINDXY_SIGN_DIGITS_CODES
	for(int nn=0; nn<vsFormat.GetSize(); nn++)
		vsFormat[nn] = strFormat;
	
	vector<string> vsFinding;
	///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	//okutil_convert_double_vector_to_string_vector(&vecFinding, &vsFinding, vecFinding.GetSize(), &vsFormat);
	if ( !bFindX || (OKCOLTYPE_DATE != m_nXFormat && OKCOLTYPE_TIME != m_nXFormat) )
		okutil_convert_double_vector_to_string_vector(&vecFinding, &vsFinding, vecFinding.GetSize(), &vsFormat);
	else
	{
		for ( int ii = 0; ii < vecFinding.GetSize(); ii++ )
		{
			vsFinding.Add(_get_result_value_by_format(vecFinding[ii], nSignDigits, m_nXFormat, m_nXSubFormat, m_strCustomFmt));
		}			
	}
	///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	
	/// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
	for(int ii = 0; ii < vsFinding.GetSize(); ii++)
	{
		string strGroupBegin;
		string strGroupEnd;
		if( m_vnFindingGroupIndex.GetSize() > 0 && ii < m_vnFindingGroupIndex.GetSize() )
		{
			if( ii == 0 && ii + 1 < m_vnFindingGroupIndex.GetSize() && m_vnFindingGroupIndex[ii] == m_vnFindingGroupIndex[ii+1] 
				|| ii > 0 && ii +1 < m_vnFindingGroupIndex.GetSize() && m_vnFindingGroupIndex[ii] != m_vnFindingGroupIndex[ii-1] && m_vnFindingGroupIndex[ii] == m_vnFindingGroupIndex[ii+1] )
			{
				strGroupBegin = "[";
			}
			if( ii > 0 && ii == m_vnFindingGroupIndex.GetSize()-1 && m_vnFindingGroupIndex[ii] == m_vnFindingGroupIndex[ii-1] 
				|| ii > 0 && ii < m_vnFindingGroupIndex.GetSize()-1 &&  m_vnFindingGroupIndex[ii] == m_vnFindingGroupIndex[ii-1] && m_vnFindingGroupIndex[ii] != m_vnFindingGroupIndex[ii+1])
			{
				strGroupEnd = "]";
			}
		}	
		vsFinding[ii] = strGroupBegin + vsFinding[ii] + strGroupEnd;
	}
	///End FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X

	string strFinding = str_combine(vsFinding, ";");
	
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	//if( bFindX )
	//{
		//m_edOutX.Text = strFinding;
	//}
	//else
	//{
		//m_edOutY.Text = strFinding;
	//}
	if( bFindX )
	{
		m_edX.Text = strFinding;
	}
	else
	{
		m_edY.Text = strFinding;
	}
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
}

int QuickFitFindXYDlg::getOutputWindow()
{
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT, always output to script window
	//return m_trOutput.Output.OutputTo ? m_trOutput.Output.OutputTo.nVal : OUTPUT_TO_SCRIPT_WND;
	///Sophy 1/15/2010 QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	//return OUTPUT_TO_SCRIPT_WND;
	int nOutput = OUTPUT_TO_SCRIPT_WND;
	if ( m_btnOutputScript.Value == 1 )
		nOutput = OUTPUT_TO_SCRIPT_WND;
	else if ( m_btnOutputResultLog.Value == 1 )
		nOutput = OUTPUT_TO_RESULT_LOG;
	/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
	else if ( m_btnOutputWorksheet.Value )
		nOutput = OUTPUT_TO_WORKSHEET;
	///End IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
	return nOutput;
	///end QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
}

/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
/*
///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
Worksheet QuickFitFindXYDlg::getOutPutWorksheet()
{
	ASSERT(m_btnOutputWorksheet.Value);
	ASSERT(m_wks);

	WorksheetPage wp = m_wks.GetPage();
	string strWks = m_edOutputWks.Text;
	if( strWks.IsEmpty() )
	{
		strWks = "FindXY";
		m_edOutputWks.Text = strWks;
	}

	Worksheet wks = wp.Layers(strWks);
	if(!wks)
	{
		int nLayer = wp.AddLayer(strWks);
		if(nLayer >= 0)
		{
			wks = wp.Layers(nLayer);
			m_edOutputWks.Text = wks.GetName();
		}
	}

	return wks;
}
///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
*/
///End IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES

///Sophy 1/15/2010 QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG
bool QuickFitFindXYDlg::updateRangeInfo()
{
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	/*
	QuickFitPlotInfo qfInfo;
	if ( !m_dpSource || !m_gl || !quick_fit_source_plot_info_access(qfInfo, m_gl) )
		return false;
	
	int nFrom = qfInfo.nFrom, nTo = qfInfo.nTo;
	*/
	int nFrom = m_i1, nTo = m_i2;
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES

	vector vX, vY;
	if ( m_dpSource.GetDataPoints(nFrom, nTo, vX, vY) <= 0 )
		return false;
	double dMinX, dMaxX, dMinY, dMaxY;
	vX.GetMinMax(dMinX, dMaxX);
	vY.GetMinMax(dMinY, dMaxY);
	string strRangeHints;
	///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	XYRange xySrc;
	if ( m_dpSource.GetDataRange(xySrc) )
	{
		Column colX;
		xySrc.GetXColumn(colX);
		string strXFrom, strXTo;
		string strFmt = "*";
		m_nXFormat = OKCOLTYPE_TEXT_NUMERIC;
		m_nXSubFormat = 0; //decimal:1000
		if ( colX )
		{
			m_nXFormat = colX.GetFormat();
			m_nXSubFormat = colX.GetSubFormat();
			///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
			//if ( OKCOLTYPE_DATE == m_nXFormat )
			//{
				//if( LDF_OBJ_CUSTOM == m_nXSubFormat )
				//{
					//m_strCustomFmt = colX.GetCustomDisplay();
					//char buffer[MAXLINE];
					//date_to_str_custom(dMinX, m_strCustomFmt, buffer);
					//strXFrom = buffer;
					//date_to_str_custom(dMaxX, m_strCustomFmt, buffer);
					//strXTo = buffer;
				//}
				//else
				//{
					//strXFrom = get_date_str(dMinX, m_nXSubFormat);
					//strXTo = get_date_str(dMaxX, m_nXSubFormat);
				//}
				//
			//}
			//else if ( OKCOLTYPE_TIME == m_nXFormat )
			//{
				//strXFrom = get_time_str(dMinX, m_nXSubFormat);
				//strXTo = get_time_str(dMaxX, m_nXSubFormat);
			//}
			//else
			//{
				//strXFrom = ftoa(dMinX, strFmt);
				//strXTo = ftoa(dMaxX, strFmt);
			//}
			m_strCustomFmt = colX.GetCustomDisplay();
		}
		strXFrom = _get_result_value_by_format(dMinX, 0, m_nXFormat, m_nXSubFormat, m_strCustomFmt);
		strXTo = _get_result_value_by_format(dMaxX, 0, m_nXFormat, m_nXSubFormat, m_strCustomFmt);
		///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
		strRangeHints.Format("X Range = [%s, %s]\r\nY Range = [%s, %s]", strXFrom, strXTo, ftoa(dMinY, strFmt), ftoa(dMaxY, strFmt));
	}
	///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	m_txtRangeHints.Text = strRangeHints;
	return true;
}
///end QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG

/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
void QuickFitFindXYDlg::outputReportSheet(bool bFindX, LPCSTR lpcszInfo)
{
	for(int index=0; index < m_vFindXYInput.GetSize(); index++)
	{
		double dInput = m_vFindXYInput[index];
		double dOutput = m_vFindXYOutput[index];
		
		GETN_TREE(trReport)
		trReport.SetAttribute(STR_TR2WKS_NO_RENAME_SNAME_ATTRIB, 1);
		
		if( bFindX )
		{
			GETN_NUM(FoundX, _L("Found X"), dOutput)
			/// Iris 1/25/2010 FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
			/*
			GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_DOUBLE);
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_X);				
			*/
			setXColumnFormat(GETN_CURRENT_SUBNODE);
			///End FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
			
			GETN_NUM(InputY, _L("Specified Y"), dInput)
			/// Iris 1/25/2010 FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
			/*
			GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_DOUBLE);
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);	
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_COMMENTS_LABEL_ATTRIB, lpcszInfo);
			*/
			setYColumnFormat(GETN_CURRENT_SUBNODE, lpcszInfo);
			///End FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
		}
		else
		{
			GETN_NUM(InputX, _L("Specified X"), dInput)
			/// Iris 1/25/2010 FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
			/*
			GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_DOUBLE);	
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_X);				
			*/
			setXColumnFormat(GETN_CURRENT_SUBNODE);
			///End FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
			
			GETN_NUM(FoundY, _L("Found Y"), dOutput)
			/// Iris 1/25/2010 FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
			/*
			GETN_CURRENT_SUBNODE.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_DOUBLE);			
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);	
			GETN_CURRENT_SUBNODE.SetAttribute(STR_COL_COMMENTS_LABEL_ATTRIB, lpcszInfo);
			*/
			setYColumnFormat(GETN_CURRENT_SUBNODE, lpcszInfo);
			///End FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
		}
		
		string	strWksName = m_edOutputWks.Text;
		///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
		//out_tree_to_wks(trReport, strWksName);
		out_tree_to_wks(trReport, strWksName, CREATE_HIDDEN | CREATE_LOAD_1ST_LAYER_ONLY);
		///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	}

}
///End IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES

/// Iris 1/25/2010 FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
void QuickFitFindXYDlg::setXColumnFormat(TreeNode& trN)
{
	trN.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_DOUBLE);
	trN.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_X);
	
	if( OKCOLTYPE_DATE == m_nXFormat || OKCOLTYPE_TIME == m_nXFormat )
	{				
		trN.SetAttribute(STR_COL_FORMAT_ATTRIB, m_nXFormat);
		trN.SetAttribute(STR_COL_SUBFORMAT_ATTRIB, m_nXSubFormat);
		trN.SetAttribute(STR_COL_CUSTOM_DISPLAY_ATTRIB, m_strCustomFmt);
	}	
}

void QuickFitFindXYDlg::setYColumnFormat(TreeNode& trN, LPCSTR lpcszInfo)
{
	trN.SetAttribute(STR_TYPE_ATTRIB, TNVAL_TYPE_DOUBLE);
	trN.SetAttribute(STR_COL_DESIGNATION_ATTRIB, OKDATAOBJ_DESIGNATION_Y);	
	trN.SetAttribute(STR_COL_COMMENTS_LABEL_ATTRIB, lpcszInfo);
	
}
///End FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL

///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
void	QuickFitFindXYDlg::CheckEnableGoToWorksheet()
{
	Button	btn = GetItem(IDC_BTN_GO_TO_REPORT);
	BOOL	bEnable = m_edOutputWks.Enable;
	if ( bEnable )
	{
		Worksheet	wks(m_edOutputWks.Text);
		bEnable = wks.IsValid();
	}
	btn.Enable = bEnable;
}

BOOL	QuickFitFindXYDlg::OnClickGoToWorksheet(Control ctrl)
{
	Worksheet	wks(m_edOutputWks.Text);
	ASSERT(wks);
	wks.CheckShowActivate();
	return TRUE;
}

BOOL	QuickFitFindXYDlg::OnOutputWorksheetChange(Control ctrl)
{
	CheckEnableGoToWorksheet();
	return TRUE;
}
///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG

void QuickFitFindXYDlg::outputFinding(bool bFindX)
{
	vector vInput, vOutput;

	vInput = m_vFindXYInput;
	vOutput = m_vFindXYOutput;
	if(vInput.GetSize() == 0)
		return;
	/// Iris 2/03/2010 QA81-15078 FIX_FINDXY_BUG
	if( vOutput.GetSize() <= 0 )
	{
		string str = _L("Not fount X/Y.");
		LT_execute("type -a");
		str.Write(WRITE_SCRIPT_WINDOW);	
		return;
	}
	///End FIX_FINDXY_BUG
	
	/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
	/*
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT, output to worksheet
	if( m_btnOutputWorksheet.Value )
	{
		Worksheet wks = getOutPutWorksheet();
		if(!wks)
		{
			error_report("Invalid Output Worksheet for Find X/Y");
			return;
		}
		if(wks.GetNumCols() < 4)
		{
			wks.SetSize(-1, 4);
			wks.SetColDesignations("XYXY");

			string strRange;
			XYRange xyRange;
			m_dpSource.GetDataRange(xyRange);
			if( xyRange )
				strRange = get_input_data_range_string(xyRange);

			string strComments;

			Column colFindY(wks, 1);
			strComments.Format(_L("FindY of %s Quick Fit on %s"), m_strFunctionName, strRange);
			colFindY.SetComments(strComments);
	
			Column colFindX(wks, 3);
			strComments.Format(_L("FindX of %s Quick Fit on %s"), m_strFunctionName, strRange);
			colFindX.SetComments(strComments);
		}

		Dataset dsX, dsY;
		if(bFindX)
		{
			dsX.Attach(wks, 2);
			dsY.Attach(wks, 3);
		}
		else
		{
			dsX.Attach(wks, 0);
			dsY.Attach(wks, 1);
		}

		if( dsX.GetSize() != dsY.GetSize() )
		{
			if( dsX.GetSize() > dsY.GetSize() )
			{
				dsY.SetSize(dsX.GetSize());
			}
			else
			{
				dsX.SetSize(dsY.GetSize());
			}
		}
		dsX.Append(vInput);
		dsY.Append(vOutput);

		return;
	}
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	*/
	///End IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES

	/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT
	string strFunc;
	if(m_nOrder > 0) // linear function
	{
		strFunc = m_strFunctionName;
	}
	else
	{
		strFunc = m_strFunctionName + " Fit";
	}
	///End IMPROVE_FINDXY_OUTPUT
	
	string strRange;
	XYRange xyRange;
	m_dpSource.GetDataRange(xyRange);
	if( xyRange )
		strRange = get_input_data_range_string(xyRange);
	
	string strComments, str = _L("%s of %s on %s");
	strComments.Format(str, bFindX? _L("FindX") : _L("FindY"), strFunc, strRange);
	
	string strOutput;
	if(bFindX)
	{
		strOutput =	strComments + STR_NEXT_LINE +
					"Y\t\tX" + STR_NEXT_LINE;
	}
	else
	{
		strOutput = strComments + STR_NEXT_LINE + 
					"X\t\tY" + STR_NEXT_LINE;
	}

	///Sophy 1/22/2010 DISPLAY_RESULT_ACCORDING_TO_ORIGIN_SETTINGS
	//int nSignDigits = m_trOutput.Output.SignDigits.nVal;
	/// Iris 1/23/2010 CORRECT_SOPHY_FINDXY_SIGN_DIGITS_CODES
	/*
	OriginSettings os;
	int nSignDigits;
	os.GetValue("NUMERIC.NUMSIGDIGITS", nSignDigits);
	*/
	int nSignDigits = 0;
	///End CORRECT_SOPHY_FINDXY_SIGN_DIGITS_CODES
	///end DISPLAY_RESULT_ACCORDING_TO_ORIGIN_SETTINGS
	for(int ii=0; ii<vInput.GetSize(); ii++)
	{
		///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
		//strOutput += ftoa(vInput[ii]) + "\t\t" + _convert_float_to_str(vOutput[ii], nSignDigits) + STR_NEXT_LINE;
		if ( bFindX )
			strOutput += ftoa(vInput[ii]) + "\t\t" + _get_result_value_by_format(vOutput[ii], nSignDigits, m_nXFormat, m_nXSubFormat, m_strCustomFmt) + STR_NEXT_LINE;
		else
			strOutput += _get_result_value_by_format(vInput[ii], nSignDigits, m_nXFormat, m_nXSubFormat, m_strCustomFmt) + "\t\t" + _convert_float_to_str(vOutput[ii], nSignDigits) + STR_NEXT_LINE;
		///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	}

	switch( getOutputWindow() )
	{
	case OUTPUT_TO_NONE: // if none will output findxy to script window		
	case OUTPUT_TO_SCRIPT_WND:
		LT_execute("type -a");
		strOutput.Write(WRITE_SCRIPT_WINDOW);
		break;

	case OUTPUT_TO_RESULT_LOG:
		Project.OutStringToResultsLog(strOutput, false);
		break;
		
	case OUTPUT_TO_WORKSHEET:
		outputReportSheet(bFindX, strComments); 
		break;

	default:
		ASSERT(false);
	}
}

bool QuickFitFindXYDlg::findxy(bool bFindX, const vector& vecToFind)
{
	/// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
	vecToFind.TrimLeft(TRUE);
	vecToFind.TrimRight(TRUE);
	///End FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
	m_vFindXYInput = vecToFind;
	m_vFindXYOutput.RemoveAll();
	m_vnFindingGroupIndex.RemoveAll(); /// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X

	string strFuncName = 0 == m_nOrder? m_strFunctionName : "POLY";
	if( bFindX )
	{
		// get source x data		
		vector vSourceX;
		m_dpSource.GetDataPoints(0, -1, vSourceX, NULL);		
		
		// get fit xy
		vector vFitX, vFitY;
		_get_fit_curve_x_data(vSourceX, vFitX, m_gl, 0);
		/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		//_computer_y_by_x(m_stFitResults, strFuncName, vFitX, vFitY);
		_computer_y_by_x(m_vParamValues, strFuncName, vFitX, vFitY);
		///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		
		// find x by y
		PFN_STR_INT_DOUBLE_DOUBLE_DOUBLEP pFunc = Project.FindFunction("compute_y_by_x", "OriginLab\\nlsf_utils.c");
		int nInputOffset = 0; /// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
		for( int nn = 0; nn < vecToFind.GetSize(); nn++)
		{
			/// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
			//int nNumXs = 1;
			//vector vx(nNumXs);
			vector vx(FINDX_MAX_NUM);
			vector<int> vxi(FINDX_MAX_NUM);
			///End FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
			if( OE_NOERROR == ocmath_find_xs(vecToFind[nn], vFitX.GetSize(), vFitX, vFitY, FINDX_MAX_NUM, vx, strFuncName, 
				/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
				//m_stFitResults.vParams.GetSize(), m_stFitResults.vParams, pFunc, vxi, 1E-5) ) //change default tolerance from 1e-8 to 1e-5 so speed up finding(as in NLFit operation).
				m_vParamValues.GetSize(), m_vParamValues, pFunc, vxi, 1E-5) )
				///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
			{
				/// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
				vector<uint> vnIndex;
				if( vxi.Find(vnIndex, -vFitX.GetSize()) > 0 )
				{
					vector<int> vn;
					vn = vnIndex;
					vxi.RemoveAt(vn);
					vx.RemoveAt(vn);
				}
				/// Iris 2/03/2010 QA81-15078 FIX_FINDXY_BUG
				if( vx.GetSize() == 0 ) // all are NANUM
				{
					vx.Add(NANUM);
				}				
				else
				///End FIX_FINDXY_BUG	
				{
					vector<int> vnGroupIndex(vx.GetSize());
					vnGroupIndex = (nn+1);
					m_vnFindingGroupIndex.Append(vnGroupIndex);
					
					int nDupCount = vx.GetSize()-1;
					if( nDupCount > 0 ) /// Iris 2/03/2010 QA81-15078 FIX_FINDXY_BUG
					{
						m_vFindXYInput.InsertAt(nn+nInputOffset+1, vecToFind[nn], nDupCount);
						nInputOffset += nDupCount;
					}
				}
				///End FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X				
				
				m_vFindXYOutput.Append(vx);
			}
		}
	}
	else
	{
		/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		//_computer_y_by_x(m_stFitResults, strFuncName, vecToFind, m_vFindXYOutput);
		_computer_y_by_x(m_vParamValues, strFuncName, vecToFind, m_vFindXYOutput);
		///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	}	
	/// Iris 2/03/2010 FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
	//return (m_vFindXYInput.GetSize() == m_vFindXYOutput.GetSize());
	return true;
	///End FIND_X_FROM_Y_NEED_SUPPORT_FIND_MULTI_X
}
/*	
bool QuickFitFindXYDlg::outputToWks(bool bFindX)
{
	// prepare findxy columns
	XYRange drFindXY;
	int nXCol = m_wks.AddCol();
	m_wks.Columns(nXCol).SetType(OKDATAOBJ_DESIGNATION_X);
	int nYCol = m_wks.AddCol();
	drFindXY.Add(m_wks, nXCol, "X");
	drFindXY.Add(m_wks, nYCol, "Y");	
	
	// set column Long Name and Data
	string strXLN, strYLN;
	if( bFindX )
	{
		strXLN = _L("X Value");
		strYLN = _L("Specified Y Value");
		drFindXY.SetData(&m_stFitResults.vFindXYInput, &m_stFitResults.vFindXYOutput);
	}
	else
	{
		strXLN = _L("Specified X Value");
		strYLN = _L("Y Value");
		drFindXY.SetData(&m_stFitResults.vFindXYOutput, &m_stFitResults.vFindXYInput);
	}
	
	Column colX, colY;
	m_wks.Columns(nXCol).SetLongName(strXLN);
	m_wks.Columns(nYCol).SetLongName(strYLN);
	return true;
}
*/

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////// class QuickFitTool /////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TABLE_NAME "Table"
#define STR_IS_OUTPUT_STORAGE	"trHasOutput"

///------ Folger 01/12/09 QA81-14832 QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU
class	QuickFitROIObjsCleanupHelper
{
public:
	QuickFitROIObjsCleanupHelper(LPCSTR lpcszLayer, LPCSTR lpcszObjName)
	{
		m_strObjName = lpcszObjName;
		m_strLayer = lpcszLayer;
		string		strScript;
		strScript.Format("layer -o %s { run.section(graph_controls, ShowObjects, %s %d); }", m_strLayer, m_strObjName, 0);
		LT_execute(strScript);
	}
	~QuickFitROIObjsCleanupHelper()
	{
		string		strScript;
		///Sophy 1/25/2010 LT_COMMAND_TO_REMOVE_ALL_LINKED_OBJECTS
		//strScript.Format("run.section(graph_controls, DestroyObjects, %s);", m_strObjName);
		///Sophy 3/3/2010 ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
		//strScript.Format("run.section(graph_controls, DelayDestroy, %s);", m_strObjName);
		strScript.Format(";layer -o %s { label -rc %s; }", m_strLayer, m_strObjName);
		///end ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
		///end LT_COMMAND_TO_REMOVE_ALL_LINKED_OBJECTS
		LT_execute(strScript);
	}
	
private:
	string	m_strObjName;
	string	m_strLayer;	///Sophy 3/3/2010 ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
};
///------ End QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU


///Sophy 1/13/2010 CLEAN_ROI_TOOLS
enum {
	QFT_OBJ_FIRST = GOT_OBJ_TOTAL,
	QFT_OBJ_FITCURVE,
};

#define	STR_DO_FUNCITON	_L("Change Function")
#define	STR_DO_NLFIT	_L("Switch to NLFit...")
///------ Folger 03/19/10 QA81-15218 ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
#define	STR_DO_LINEARFIT		_L("Switch to Linear Fit...")
#define	STR_DO_POLYNOMIALFIT	_L("Switch to Polynomial Fit...")
///------ End ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
#define	STR_DO_FINDXY	_L("Find X/Y...")
//#define	STR_UPDATE_FUNCTION_LIST	_L("Edit Function List...") /// Iris 1/26/2010 moved to .h file
///end CLEAN_ROI_TOOLS

///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
void	quick_fit_set_attributes(TreeNode& tr)
{
	tr.SetAttribute(STR_THEME_SAVE_AS_CUSTOM_MAKE_TREE_ATTRIB, "quick_fit_theme_save_as_custom_make_tree");
	//tr.SetAttribute(STR_THEME_SAVE_AS_CUSTOM_NAME, "quick_fit_theme_save_as_custom_name");
}

///------ Folger 02/02/10 QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
// static bool OnNoROIChange(TreeNode& tr, int nRow, int nCol, TreeNode& trNode, DWORD nEventInfo, int nCntrlType, WndContainer& getNContainer)
// {
// 	TreeNode	trThemeName = tr.ThemeName;
// 	if ( !trThemeName )
// 	{
// 		ASSERT(FALSE);
// 		return false;
// 	}
// 	
// 	if ( trNode )
// 	{
// 		int		nIndex = trThemeName.strVal.Find(STR_NO_ROI_SPECIFIER);
// 		if ( trNode.nVal )
// 		{
// 			if ( nIndex < 0 )
// 				trThemeName.strVal += STR_NO_ROI_SPECIFIER;
// 		}
// 		else
// 		{
// 			if ( nIndex >= 0 )
// 				trThemeName.strVal = trThemeName.strVal.Left(nIndex);
// 		}
// 	}
// 
// 	return true;
// }
///------ End QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN

void	quick_fit_theme_save_as_custom_make_tree(TreeNode& tr)
{
	///------ Folger 02/02/10 QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
	//string		strHint = _L("If checked, when user use the theme, Quick fit will be done on active dataset without turning on ROI Box.");
	string		strHint = _L("When selecting theme from menu, hold CTRL key down to perform fit to entire data range (without adding ROI box to graph), or hold Shift key down to open dialog and edit theme.");
	///------ End QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
	
	GETN_USE(tr);
	///------ Folger 02/02/10 QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
	//GETN_CHECK(NoROI, _L("Quick Fit Without ROI Box"), 0)						GETN_OPTION_EVENT_EX(OnNoROIChange)
	///------ End QUICKFIT_SUPPORT_WITHOUT_ROI_BOX_WITH_CNTRL_KEY_DOWN
	GETN_STR(Hint, strHint, "")		GETN_HINT
}

string&		quick_fit_current_theme()
{
	static	string		l_str = THEME_FILENAME_LAST_USED;
	return l_str;
}
///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI

#define STR_QUICK_FIT_ADDTOOL_FIT_RESULT_STORAGE		"QuickFitROIFitResult" /// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES

///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
class	GetNVsGUIUpdateHelper
{
public:
	GetNVsGUIUpdateHelper(TreeNode& trGUI, LPCSTR lpcszXFName)
	{
		XFBase		xf(lpcszXFName);
		xf.GetGUI(m_tr, m_trGetN);
		
		m_trGUI = trGUI;
		CopyValuesAndAttributes(m_trGetN, m_trGUI);
	}

	~GetNVsGUIUpdateHelper()
	{
		CopyValuesAndAttributes(m_trGUI, m_trGetN);
	}

	TreeNode&		GetN()
	{
		return m_trGetN;
	}

private:
	void			CopyValuesAndAttributes(TreeNode& trDes, TreeNode& trSrc)
	{
		tree_copy_values_by_id(trSrc, trDes);
		octree_copy_atts_by_id(&trSrc, &trDes, STR_SHOW_ATTRIB);
		octree_copy_atts_by_id(&trSrc, &trDes, STR_COMBO_ATTRIB);
	}

private:
	Tree			m_tr;
	TreeNode		m_trGetN;
	TreeNode		m_trGUI;
};
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU


class QuickFitTool : public GraphObjCurveTool
{
public:
	QuickFitTool(LPCSTR lpcszMainObjName = NULL) : GraphObjCurveTool(lpcszMainObjName)
	{
		m_vnObjIDs.Add(QFT_OBJ_FITCURVE);
		m_vsObjNames.Add("FitCurve");
	}
	
	bool	GetMainObjName(string& strName)
	{
		if(m_go)
		{
			strName = m_go.GetName();
			return true;
		}
		return false;
	}
	
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	bool AccessFitResults(TreeNode& tr, BOOL bGet = true)
	{
		if( bGet )
		{
			return m_go.GetBinaryStorage(STR_QUICK_FIT_ADDTOOL_FIT_RESULT_STORAGE, tr);
		}
		else
		{
			m_go.PutBinaryStorage(STR_QUICK_FIT_ADDTOOL_FIT_RESULT_STORAGE, tr);			
		}				
		return true;
	}
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	//BOOL	ApplySettings(TreeNode& trROISettings = NULL, bool bRefresh = false)
	BOOL	ApplySettings(TreeNode& trROISettings = NULL, bool bRefresh = false, bool bPositionChanged = false)
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	{
		/// Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
// 		Tree tr;
// 		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
// 		if( !GetGUITree(tr) )
// 		{
// 			ASSERT(0);
// 			return false;
// 		}
// 		///End NEW_QUICKFIT_ROI_XF_DLG
// 		
// 		TreeNode trTmpSettings;
// 		if(trROISettings)
// 		{
// 			trTmpSettings = trROISettings;
// 			/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
// 			/*
// 			/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
// 			tree_copy_values_by_id(trTmpSettings, tr.ROI);
// 			///End NEW_QUICKFIT_ROI_XF_DLG
// 			*/
// 			///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
// 		}
// 		else
// 		{
// 			/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
// 			//trTmpSettings = get_ROI_preference_settings(tr);
// 			trTmpSettings = tr.ROI;
// 			///End NEW_QUICKFIT_ROI_XF_DLG
// 		}
// 		/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
// 		//SetGUITree(tr);/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
// 		///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
// 		
// 		///Sophy 1/13/2010 CLEAN_ROI_TOOLS
// 		//if(GetAttachment(CTP_TOP, m_goTop) > 0)
// 		//{
// 			//bool bShow = trTmpSettings.ShowTop ? ROI_TOP_SHOW_NONE != trTmpSettings.ShowTop.nVal : true;
// 			//m_goTop.Show = bShow;
// 		//}		
// 		//
// 		//if( CreateAttachedFreeLine(&m_goFitCurve, _QF_TOOL_POS_ID_FITCURVE, GROBJ_TN_POLYLINE) > 0 )
// 		//{
// 			//int nColor = trTmpSettings.FitLineColor ? trTmpSettings.FitLineColor.nVal : SYSCOLOR_BLUE;
// 			//set_go_color(m_goFitCurve, nColor)
// 		//}
// 		{
// 			//---- CPY 2/22/2010 FIT_LINE_AUTO_COLOR_LEAD_TO_BLACK_FIT_ON_BLACK_DATA
// 			/*
// 			/// Iris 2/21/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
// 			if( nColor == INDEX_COLOR_AUTOMATIC )
// 			{
// 				trTmpSettings.FitLineColor.GetAttribute(STR_ATTRIB_AUTO_COLOR, nColor);
// 				
// 				if( !m_dp )
// 					GetData();
// 				int nSourcePlotColor = get_plot_color(m_dp);
// 				if( nSourcePlotColor == nColor )
// 				{
// 					nColor = nSourcePlotColor + 1;
// 				}
// 				
// 				trTmpSettings.FitLineColor.SetAttribute(STR_ATTRIB_AUTO_COLOR, nColor);
// 			}
// 			///End ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
// 			*/
// 			int nColor;
// 			checkGetFitLineColor(nColor, trTmpSettings);
// 			//---- end FIT_LINE_AUTO_COLOR_LEAD_TO_BLACK_FIT_ON_BLACK_DATA
// 			set_go_color(m_goFitCurve, nColor);
// 		}
// 		///end CLEAN_ROI_TOOLS
// 		
// 		/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
// 		/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
// 		//quickfit_get_auto_x_range(trTmpSettings.leftx, trTmpSettings.rightx);
// 		/////------ End SUPPORT_AUTO_FOR_X_SCALE
// 		///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
// 		
// 		/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
// 		if( bPositionChanged )
// 		{			
// 			///Sophy 2/3/2010 SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
// 			//double x0 = atof(trTmpSettings.leftx.strVal);
// 			//double x1 = atof(trTmpSettings.rightx.strVal);		
// 			double x0 = get_value_by_format(m_dp, trTmpSettings.XScale.leftx.strVal);
// 			double x1 = get_value_by_format(m_dp, trTmpSettings.XScale.rightx.strVal);
// 			///end SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
// 			if( CheckSetMainObjectXPosition(x0, x1) )
// 			{
// 				///Sophy 2/3/2010 SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
// 				//trTmpSettings.leftx.strVal = ftoa(x0, "*");
// 				//trTmpSettings.rightx.strVal = ftoa(x1, "*");
// 				trTmpSettings.XScale.leftx.strVal = get_value_by_format(m_dp, x0);
// 				trTmpSettings.XScale.rightx.strVal = get_value_by_format(m_dp, x1);
// 				///end SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
// 			}			
// 		}
// 		
// 		/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
// 		bool bDisable = trTmpSettings.XScale.fixscale && trTmpSettings.XScale.fixscale.nVal;
// 		disable_go_move(m_go, true, true, false, !bDisable);
// 		///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
// 		
// 		tree_copy_values_by_id(trTmpSettings, tr.ROI);
// 		SetGUITree(tr);
// 		///End ADD_LEFTX_RIGHTX_IN_ROI_TAB	
// 		
// 		
// 		if(bRefresh)
// 			updatePreviewCurve();
// 
// 		return GraphObjCurveTool::UpdateROIGUI();
		DWORD dwCtrl = QFAPPLYCTRL_UPDATE_ROI_GUI | QFAPPLYCTRL_UPDATE_GO_MOVABILITY;
		if ( bRefresh )
			dwCtrl |= QFAPPLYCTRL_REFRESH_PREVIEW;
		if ( bPositionChanged )
			dwCtrl |= QFAPPLYCTRL_POSITION_CHANGED;
		return DoApplySettings(trROISettings, dwCtrl);
		/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	}	
	
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	//bool GetQuickFitSettings(string& strFunc, string& strCateg, QuickFitPlotInfo& qfInfo)
	bool GetQuickFitSettings(QuickFitPlotInfo& qfInfo, string& strFunc, string& strCateg, vector& vParams, vector<string>& vstrParamNames)
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	{
		Tree trGUI;
		GetGUITree(trGUI);
		
		/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
		/*
		if ( trGUI.order.nVal != 0 )
			return false; //can not do nlfit.
		*/
		///------ Folger 03/19/10 QA81-15218 ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
		//if( trGUI.mode.nVal == QUICK_FIT_MODE_LR )
			//return false;
		///------ End ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
		///End ADD_QUICK_FIT_MODE
		
		strFunc = trGUI.func.strVal;
		strCateg = STR_QUICK_FIT_NLF_SECTION;	
		getFitRangeInfo(qfInfo);
		
		/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		Tree trFitResult;
		if( !AccessFitResults(trFitResult, true) )
		{
			ASSERT(0);
		}
		else
		{
			vParams = trFitResult.ParamValues.dVals;
			vstrParamNames = trFitResult.ParamNames.strVals;
		}
		///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		return true;
	}

	///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	virtual	double	GetVersion()
	{
		return 8.103;
	}

	virtual	BOOL		MakeTree(TreeNode& tr)
	{
		quick_fit_get_preference_settings(tr);
		return TRUE;
	}
	///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	
protected:
	
	///Sophy 8/6/2010 NO_DELAY_ON_SCALE_CHANGE_WHEN_QUICK_FIT_UPDATE_RESULT
	//virtual
	BOOL IsDelayUpdate(){ return FALSE; }
	///end NO_DELAY_ON_SCALE_CHANGE_WHEN_QUICK_FIT_UPDATE_RESULT

	//virtaul
	string GetSignature()
	{
		return "xf_" XFNAME;
	}	
	
	///Sophy 2/24/2010 QUICKFIT_TOP_LABEL_POSITION_AFTER_CHANGE_X_FROM_TO_AND_RESCALE
	//quick fit ROI rectangle is attached to scale, so when scale changed, no need to update result, what's more, when call UpdateTopLabel will result in wrong position for top label
	//because it will update the label content while in VC it might be moving the position when detect IsUpdateRunning, will not move the label with the main rectangle.
	//virtual
	BOOL OnRescale(){ return TRUE; }
	///end QUICKFIT_TOP_LABEL_POSITION_AFTER_CHANGE_X_FROM_TO_AND_RESCALE
	//virtual 
	BOOL OnMove()
	{
		if(!OnPreMove()) return false;
		
		if( updatePreviewCurve() )
		{
			drawLineObjs();
		}
		//GraphObject goTable;
		//if( m_gl && _get_last_text_box_object(m_gl, goTable) )
		//{			
			//goTable.Text = _L("Click the plus sign to update the result on current ROI");
		//}
		
		/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
		if ( QUERY_ROI_TOOL_OPTION(ROI_OPTION_ON_MOVE_EVENT) )
		{
			Tree trGUI;
			if( GetGUITree(trGUI) )
			{
				Tree tr;
				tr = m_go.GetFormat(FPB_DATA, FOB_SPECIAL, true, true);
				
				vector vx;
				vx = tr.Root.Data.X.dVals;
				if( vx.GetSize() > 2 )
				{
					/// Iris 2/10/2010 QA81-15099 FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO
					// to fix after move ROI, the format not keep in From/To edit box
					//trGUI.ROI.leftx.strVal = ftoa(vx[0], "*");
					//trGUI.ROI.rightx.strVal = ftoa(vx[1], "*");
					trGUI.ROI.XScale.leftx.strVal = get_value_by_format(m_dp, vx[0]);
					trGUI.ROI.XScale.rightx.strVal = get_value_by_format(m_dp, vx[1]);	
					///End FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO
					SetGUITree(trGUI);
				}
				else
				{
					ASSERT(false);
				}
			}
		}
		///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	
		return GraphObjCurveTool::OnMove();
	}

	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB	
	//virtual 
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	//bool CheckGetMainObjectXPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1)
	///Sophy 3/5/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	//bool CheckGetMainObjectXPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& bFixWidth)
	bool CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& bFixWidth, double& y0, double& y1)
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	{		
		/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
		TreeNode trFixWidth = trGUI.ROI.XScale.fixscale;
		bFixWidth = trFixWidth && trFixWidth.nVal;
		///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX

		if( bFixWidth )
		{
			TreeNode trLeftX = trGUI.ROI.XScale.leftx;
			TreeNode trRightX = trGUI.ROI.XScale.rightx;
			if( !trLeftX || !trRightX )
			{
				ASSERT(false);
				return false;
			}		
	
			/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
			/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
			//quickfit_get_auto_x_range(trLeftX, trRightX);
			/////------ End SUPPORT_AUTO_FOR_X_SCALE
			///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	
			///Sophy 2/3/2010 SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
			//x0 = trLeftX.dVal;		
			//x1 = trRightX.dVal;
			x0 = get_value_by_format(m_dp, trLeftX.strVal);
			x1 = get_value_by_format(m_dp, trRightX.strVal);
			///end SUPPORT_DISPLAY_DATATIME_DATA_IN_PREFERENCE_DLG
			
			/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
			// when Fix checkbox is checed, no need take care if specified range is out
			/*
			// too small or too large, will auto adjust range
			double dx = fabs(m_gl.X.To - m_gl.X.From);
			double dsubx = fabs(x1 - x0);
			if( dsubx < dx * 0.02
				|| dsubx > dx )
			{
				quick_fit_get_rect_ROI_init_x_range(m_gl, x0, x1);
			}
			*/
			///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
		}
		else
		{
			quick_fit_get_rect_ROI_init_x_range(m_gl, x0, x1);
		}
		
		return true;		
	}
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//bool 	DoOutput()
	//{
		//return outputQuickFitResult();
	//}
	bool 	DoOutput(bool bUpdateLastOutput)
	{
		return outputQuickFitResult(bUpdateLastOutput);
	}
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	
	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	//virtual
	bool	IsCloneMainObj()
	{
		Tree trGUI;
		if ( GetGUITree(trGUI) )
		{
			int nClone = trGUI.ROI.cloneROI.nVal;
			return (1 == nClone);
		}
		return false;
	}
	///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	bool	DoEdit(HWND hWndParent = NULL)
	{		
		Tree trGUI;
		if(!GetGUITree(trGUI))
			return false;
		
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		/*
		string strFunc = trGUI.func.strVal;
		int nOrder = trGUI.order.nVal;
		*/
		///End NEW_QUICKFIT_ROI_XF_DLG
		
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		//if ( OpenQuickFitOutputPreferDlg(true, nOrder, strFunc) )		
		if( OpenQuickFitOutputPreferDlg(trGUI) )
		///End NEW_QUICKFIT_ROI_XF_DLG
		{			
			/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
			SetGUITree(trGUI);
			//ApplySettings(NULL, true);
			///End NEW_QUICKFIT_ROI_XF_DLG
			return true;
		}
		return false;
	}
	//--- CPY 1/20/10 QUICK_FIT_FAILED_COMPILE_WITHOUT_DEVKIT, maybe no longer used
	/*
	//virtual
	bool	DoSaveTheme()
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return false;
		QuickFitOutputReferDlg dlg(trGUI);
		return dlg.SaveTheme();
	}
	*/
	//---
	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	//virtual
	bool	UpdateThemeTree(TreeNode& trThemeTree)
	{
		///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
		if ( !GraphObjCurveTool::UpdateThemeTree(trThemeTree) )
			return false;
		///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

		string strFunctionName;
		string strHints = _L("Both function and settings in Preferences dialog will be saved. The theme name will appear in menu.");
		
		Tree trGUI;
		GetGUITree(trGUI);
		
		///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
		string		strTheme;
		if ( !trThemeTree.GetAttribute(STR_DEFAULT_THEME_NAME, strTheme) )
			trThemeTree.SetAttribute(STR_DEFAULT_THEME_NAME, trGUI.func.strVal);
		///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

		trThemeTree.SetAttribute(STR_HINT_BOOK_SHEET_THEME, strHints);
		///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
		quick_fit_set_attributes(trThemeTree);
		///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI
		return true;
	}
	///end DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL
	//----- Iris 1/19/2010 not used, so comment out
	/*
	///Sophy 1/7/2010 ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION
	//virtual
	bool	DoFunction()
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) )
			return false;
		
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG, clean codes		
		//const int nPolyFunctionCount = 3;
		//vector<string> vsItems;
		//vsItems.Add(LINEAR_FIT_MRU_NAME);
		//vsItems.Add(QUADRATIC_FIT_MRU_NAME);
		//vsItems.Add(CUBIC_FIT_MRU_NAME);
		//
		//vector<string> vsFavors;
		//okutil_get_favor_nlsf_functions(&vsFavors);
		//vsItems.Append(vsFavors);		
		const int nPolyFunctionCount = NUM_FIXED_POLY_FUNC;
		vector<string> vsItems;		
		quick_fit_get_func_list(vsItems);
		///End NEW_QUICKFIT_ROI_XF_DLG
		
		Menu pm;
		int nFunctions = vsItems.GetSize();
		for ( int iFunc = 0; iFunc < nFunctions; iFunc++ )
		{
			pm.Add(vsItems[iFunc], iFunc + 1);
		}
		int nCurFuncIndex = vsItems.Find(trGUI.func.strVal);
		if ( nCurFuncIndex < 0 )
			nCurFuncIndex = trGUI.order.nVal - 1;
		
		int nCmdID = 0;
		POINT pt;
		int XAdj = m_goFunction.Width * 0.1, YAdj = m_goFunction.Height * 0.07;
		GetCursorPos(&pt);
		pm.TrackPopupMenu(TPM_LEFTBUTTON | TPM_LEFTALIGN  , pt.x + XAdj, pt.y - YAdj, GetWindow(), &nCmdID);
		if ( nCmdID != 0 )
		{
			if ( nCmdID > nPolyFunctionCount )
			{
				trGUI.func.strVal = vsItems[nCmdID - 1];
				trGUI.order.nVal = 0;
			}
			else
			{
				trGUI.func.strVal = "";
				trGUI.order.nVal = nCmdID;
			}
			
			SetGUITree(trGUI);
			if ( nCmdID - 1 != nCurFuncIndex )
				OnMove(); //as to update result.
		}
		return true;
	}
	*/
	//-----
	
	//virtual
	TreeNode	GetFillColorNode(const TreeNode& trGUI)
	{
		TreeNode trColor;
		if ( trGUI )
			trColor = trGUI.ROI.RectColor;
		ASSERT(trColor);
		return trColor;
	}	
	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	//virtual
	TreeNode	GetToolNameNode(const TreeNode& trGUI)
	{
		TreeNode trToolName;
		if ( trGUI )
			trToolName = trGUI.ROI.toolname;
		ASSERT(trToolName);
		return trToolName;
	}
	///end SHOW_TOOLNAME_FOR_ROI_TOOLS
	///Sophy 1/25/2010 SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	//virtual
	string		GetToolName(){ return TOOLNAME; }
	///end SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	//virtual
	bool	SetFunction(int nIndex)
	{
		if ( nIndex < 0 )
			return false;
		vector<string> vsItems;
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG, clean codes	
		/*
		const int nPolyFunctionCount = 3;
		vsItems.Add(LINEAR_FIT_MRU_NAME);
		vsItems.Add(QUADRATIC_FIT_MRU_NAME);
		vsItems.Add(CUBIC_FIT_MRU_NAME);
		
		vector<string> vsFavors;
		okutil_get_favor_nlsf_functions(&vsFavors);
		vsItems.Append(vsFavors);	
		const int nPolyFunctionCount = NUM_FIXED_POLY_FUNC;
		*/
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//quick_fit_get_func_list(vsItems, QUICK_FIT_ALL_MODE_FUNCS, NUM_FIXED_POLY_FUNC);
		int nNumPolyFuncs;
		quick_fit_get_func_list(vsItems, QUICK_FIT_ALL_MODE_FUNCS, &nNumPolyFuncs);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		///End NEW_QUICKFIT_ROI_XF_DLG

		Tree trGUI;
		if( !GetGUITree(trGUI) )
		{
			ASSERT(false);
			return false;
		}
		
		/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
		/*
		if ( nIndex >= nPolyFunctionCount )
		{
			trGUI.func.strVal = vsItems[nIndex];
			trGUI.order.nVal = 0;
		}
		else
		{
			trGUI.func.strVal = "";
			trGUI.order.nVal = nIndex + 1;
		}
		*/
		trGUI.func.strVal = vsItems[nIndex];
		trGUI.mode.nVal = nIndex < nNumPolyFuncs? QUICK_FIT_MODE_LR : QUICK_FIT_MODE_NL;
		///End ADD_QUICK_FIT_MODE
		
		///Sophy 2/2/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
		quick_fit_update_output_choice_on_mode_change(trGUI, trGUI.Report);
		quick_fit_update_output_choice_on_mode_change(trGUI, trGUI.Table);
		///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

		/// Kenny 02/08/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
		///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
		//quick_fit_update_roi_show_top(trGUI.ROI.ShowTop, trGUI.Table);
		quick_fit_update_output_choice_on_mode_change(trGUI, trGUI.ROI.ShowTop);
		///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
		/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI

		SetGUITree(trGUI);		

		roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);	///Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES

		return true;
	}
	///end ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION

	///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	virtual	bool	UpdateROIGUI()
	{
		/// Iris 2/25/2010 TO_PREVENT_MOVE_ROI_WHEN_LOAD_THEME
		//return ApplySettings(NULL, true, true);
		bool bXPosChanged = true; // keep old logic
		Tree trGUI;
		if( GetGUITree(trGUI) )
		{		
			if( quick_fit_check_update_roi_x_position(trGUI.ROI) ) // return true if updated trGUI
				SetGUITree(trGUI);			
			bXPosChanged = trGUI.ROI.XScale.fixscale.nVal;
		}
		return ApplySettings(NULL, true, bXPosChanged);
		///End TO_PREVENT_MOVE_ROI_WHEN_LOAD_THEME
	}
	
	virtual	void	UpdateGUIOnThemeChange(TreeNode& trGUI)
	{
		GraphObjCurveTool::UpdateGUIOnThemeChange(trGUI);

		GetNVsGUIUpdateHelper		clHelper(trGUI, GetXFName());
		///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
		//quickfit_update_on_mode_function_change(clHelper.GetN(), -2);
		quickfit_update_on_mode_function_change(clHelper.GetN(), QFROI_UPDATESHOWTOP_SEL_IGNORE);
		///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	}

	virtual	bool	DoFunction()
	{
		XFBase		xf(GetXFName());
		Tree		tr;
		TreeNode	trGetN;
		xf.GetGUI(tr, trGetN);
		
		GETN_TREE(tr1)
		tr1.Replace(trGetN, true, true, true);
		TreeNode	trMode = tr1.mode;
		TreeNode	trFunc = tr1.func;
		if ( !trMode || !trFunc )
		{
			ASSERT(FALSE);
			return false;
		}

		tree_set_attribute_to_all_nodes(tr1, STR_SHOW_ATTRIB, "0", true);
		trMode.Show = 1;
		trFunc.Show = 1;

		Tree		trGUI;
		GetGUITree(trGUI);
		tree_copy_values_by_id(trGUI, tr1);

		trMode.SetAttribute(STR_ATTRIB_HANDLER_RC, (DWORD)quickfit_on_mode_change);
		trFunc.SetAttribute(STR_ATTRIB_HANDLER_RC, (DWORD)quickfit_on_func_change_ex);

		if ( GetNBox(tr1, NULL, STR_DO_FUNCITON, "") )
		{
			tree_copy_values_by_id(tr1, trGUI);
			octree_copy_atts_by_id(&tr1, &trGUI, STR_SHOW_ATTRIB);
			SetGUITree(trGUI);
			UpdateROIGUI();
			InvalidateResults();
			return true;
		}
		
		return false;
	}
	///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU



	/// Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	enum
	{
		QFAPPLYCTRL_REFRESH_PREVIEW			= 0x0001,
		QFAPPLYCTRL_POSITION_CHANGED		= 0x0002,
		QFAPPLYCTRL_UPDATE_GO_MOVABILITY	= 0x0004,
		QFAPPLYCTRL_UPDATE_ROI_GUI			= 0x0008,
	};

	BOOL DoApplySettings(TreeNode& trROISettings = NULL, DWORD dwCtrl = 0)
	{
		Tree tr;
		if ( !GetGUITree(tr) )
		{
			ASSERT(0);
			return false;
		}

		TreeNode trTmpSettings;
		if (trROISettings)
		{
			trTmpSettings = trROISettings;
		}
		else
		{
			trTmpSettings = tr.ROI;
		}

		int nColor;
		checkGetFitLineColor(nColor, trTmpSettings);
		set_go_color(m_goFitCurve, nColor);

		if ( dwCtrl & QFAPPLYCTRL_POSITION_CHANGED )
		{				
			double x0 = get_value_by_format(m_dp, trTmpSettings.XScale.leftx.strVal);
			double x1 = get_value_by_format(m_dp, trTmpSettings.XScale.rightx.strVal);
			if( CheckSetMainObjectXPosition(x0, x1) )
			{
				trTmpSettings.XScale.leftx.strVal = get_value_by_format(m_dp, x0);
				trTmpSettings.XScale.rightx.strVal = get_value_by_format(m_dp, x1);
			}			
		}

		if ( dwCtrl & QFAPPLYCTRL_UPDATE_GO_MOVABILITY )
		{
			bool bDisable = trTmpSettings.XScale.fixscale && trTmpSettings.XScale.fixscale.nVal;
			disable_go_move(m_go, true, true, false, !bDisable);
		}

		tree_copy_values_by_id(trTmpSettings, tr.ROI);
		SetGUITree(tr);

		if ( dwCtrl & QFAPPLYCTRL_REFRESH_PREVIEW )
			updatePreviewCurve();

		BOOL bRet = TRUE;
		if ( dwCtrl & QFAPPLYCTRL_UPDATE_ROI_GUI )
			bRet = GraphObjCurveTool::UpdateROIGUI();

		return bRet;
	}
	/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR

	///Sophy 1/13/2010 CLEAN_ROI_TOOLS
	/*
	BOOL Init()
	{
		if(!GraphObjCurveTool::Init())
			return false;

		if(CreateAttachment(GROBJ_TN_TEXT, CTP_TOP, &m_goTop, "Area=0000\ndx=0000") < 0)
			return false;

		if(CreateAttachedFreeLine(&m_goFitCurve, _QF_TOOL_POS_ID_FITCURVE, GROBJ_TN_POLYLINE, SYSCOLOR_BLUE) < 0)
			return false;

		///Sophy 1/7/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
		//CreateAttachment(GROT_TEXT, CTP_RIGHT_TOP, &m_goAction, " + ", 16);
		//string strScript;
		//strScript.Format("run.section(graph_controls, InvokeEvent, %s %s);", XFNAME, "quickfit_tool_output_btn_click");
		//set_LT_script(m_goAction, strScript, GRCT_MOUSEUP, 1);
		//
		//CreateAttachment(GROT_TEXT, CTP_RIGHT_BOTTOM, &m_goEdit, "...", 16);
		//strScript.Format("run.section(graph_controls, InvokeEvent, %s %s);", XFNAME, "quickfit_tool_edit_btn_click");
		//set_LT_script(m_goEdit, strScript, GRCT_MOUSEUP, 1);
		///end CLEAN_CODE_FOR_ROI_TOOLS
		
		ApplySettings();

		return true;
	}
	*/
	///end CLEAN_ROI_TOOLS
	

protected:
	
	///Sophy 1/13/2010 CLEAN_ROI_TOOLS
	virtual int CreateAttachments()
	{
		int nRet = GraphObjCurveTool::CreateAttachments();
		if ( 0 != nRet )
			return nRet;
			
		///Sophy 2/12/2010 MORE_CLEAN_CODE_TO_RESET_LABEL_POSITION
		//Tree trGUI;
		//if ( GetGUITree(trGUI) && trGUI )
		//{
			//int nParams = 0;
			//string strFunc = trGUI.func.strVal;
			//int nOrder = quick_fit_get_order(trGUI.mode.nVal, strFunc);
			//if ( 0 == nOrder )
			//{
				//nParams = nlsf_get_number_of_params(strFunc, NULL);
			//}
			//else
			//{
				//nParams = nOrder + 1;
			//}
			//int nLines = (nParams + 1)/2;
			//UpdateTopLabel(NULL, m_goLabel.Height * nLines);
		//}
		roi_tool_option_access(ROI_OPTION_RESET_LABEL_POS, ROI_OP_SET);
		///end MORE_CLEAN_CODE_TO_RESET_LABEL_POSITION
		GraphObject go;
		if ( 0 > CreateAttachment(go, QFT_OBJ_FITCURVE, CTP_FREE_1, GROBJ_TN_POLYLINE) )
			return -1;
		set_go_selectable(go, false); //forbit moving polyline object.
		//------Iris 1/23/2010 to fix "The drawing inside the roi looks realy bad now I see something like dashed line. "
		//go.SetReverseVideo(true); /// Iris 1/21/2010 SET_FIT_LINE_REVERSE_VIDEO
		//------

		return 0;
	}
	
	virtual	int	GetAttachments()
	{
		int nRet = GraphObjCurveTool::GetAttachments();
		if ( 0 != nRet )
			return nRet;
		
		nRet = GetAttachment(m_goFitCurve, QFT_OBJ_FITCURVE);
		if ( 0 != nRet )
			return nRet;

		return nRet;
	}
	///end CLEAN_ROI_TOOLS

	/// Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	virtual BOOL OnPlotChanged()
	{
		return DoApplySettings();
	}
	/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR

	virtual BOOL OnDestroy()
	{
		if(IsValidGrObj())
		{	
			if(getDataRange() && m_gl)
			{
				_set_gl_quick_fit_rect_go_name(m_gl);			// clear the info
				
				//----Iris 12/30/209 since always output a new text box now, no need real time update text box when move rect tool, so no need put results back here.
				/*
				// update text table
				Tree trStorage;
				if( m_gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) )
				{
					QuickFitResults stFitResults;
					stFitResults = trStorage.Results;
					string strFunctionName = trStorage.FunctionName.strVal;
					int nOrder =  trStorage.Order.nVal;
					
					GraphObject goTable;
					if( trStorage.TextBoxName && !trStorage.TextBoxName.IsEmpty() )
					{
						goTable = m_gl.GraphObjects(trStorage.TextBoxName.strVal);
					}
					
					if( goTable )
					{	
						Tree tr1;
						TreeNode trTable = _get_table_preference_settings(tr1);
						
						XYRange iy(m_dr);					
						_quick_fit_output_text_table(trTable, m_gl, iy, stFitResults, strFunctionName, nOrder, UPDATE_TEXT_BOX_FROM_ROI, goTable);
					}
				}
				*/
				//----
			}
		}
		
		return GraphObjCurveTool::OnDestroy();
	}
	bool	MakePrintable(GraphObject& go) { return set_go_printable(go); }

	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//virtual
	bool AddUpdateLastOutputSubmenu(Menu& pm, uint& nPosition)
	{
		DWORD dwFlags = MF_STRING;
		DataPlot dpSource, dpFit;
		if( !GetSelectedPlot(dpSource) || !_get_quick_fit_plot(dpSource, dpFit) )
		{
			dwFlags |= MF_GRAYED;
		}
		pm.Add(STR_UPDATE_LAST_OUTPUT, GOT_BTN_UPDATE_LAST_OUTPUT, dwFlags); 
		nPosition++;
		return true;
	}
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
		
	BOOL	InvalidateResults()
	{
		return OnMove();
	}
	
	///Sophy 1/7/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	//virtual
	string	GetXFName(){ return XFNAME; }
	///end CLEAN_CODE_FOR_ROI_TOOLS
	
	//virtual
	string	GetPreferenceTitle(){ return TOOL_PREFERENCES_TITLE; }
	///Sophy 1/13/2010 CLEAN_ROI_TOOLS
	/*
	///Sophy 1/7/2010 ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION
	//virtual
	int		CreateAdvancedButtons(LPCSTR lpcszXFName, DWORD dwCtrl = GOT_BTN_PLOTS | GOT_BTN_OUTPUT | GOT_BTN_EDIT | GOT_BTN_CLOSE)
	{
		int nNumBtns = GraphObjCurveTool::CreateAdvancedButtons(lpcszXFName, dwCtrl);
#ifndef	_ROI_TOOL_NEW_MENU_	
		string strScript;
		check_create_attachment(m_go, m_goFunction, " F ", GROT_TEXT, CTP_RIGHT_TOP, CJ_VIEW_X_GAP_N | CJ_VIEW_Y_GAP_XXXL);
		strScript.Format("run.section(graph_controls, GraphToolEvent, %s %s %d %d);", lpcszXFName, m_go.GetName(), OE_BUTTONCLICK, GOT_BTN_FUNCTION);
		set_LT_script(m_goFunction, strScript, GRCT_MOUSEUP, 1);
		nNumBtns++;
#else
		//do nothing.
#endif	//_ROI_TOOL_NEW_MENU_
		return nNumBtns;
	}
	*/
	///end CLEAN_ROI_TOOLS
	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	//virtual
	BOOL	GetReportWorksheet(Worksheet& wksReport)
	{
		Tree trGUI;
		if ( !GetGUITree(trGUI) || OUTPUT_TO_WORKSHEET != trGUI.Report.OutputTo.nVal )
			return FALSE;
		string strWorksheet = trGUI.Report.WksName.strVal;
		/// Hong 02/02/10 QA80-14801 FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
		okutil_arg_copy(&strWorksheet);
		/// end FITTING_REPORT_BOOK_SHEET_NAME_SUPPORT_SUBSTITUTION
		wksReport.Attach(strWorksheet);
		return wksReport.IsValid();
	}
	///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	
	//virtual
	bool	UpdateContextMenu(Menu& pm, uint& nPosition)
	{
		bool bRet = true;
		bRet &= addFitFunctions(pm, nPosition);
		bRet &= pm.Add(NULL, 0, MF_SEPARATOR); nPosition++;
		bRet &= addFit(pm); nPosition++;
		bRet &= addFindXY(pm); nPosition++;
		return bRet;
	}
	///end ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION
	
	///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	//virtual
	bool	DoFit()
	{
		///------ Folger 01/12/09 QA81-14832 QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU
		UndoBlock	ub;
		///Sophy 3/3/2010 ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
		//QuickFitROIObjsCleanupHelper	clHelper(m_go.GetName());
		string	strLayer;
		m_gl.GetRangeString(strLayer);
		QuickFitROIObjsCleanupHelper	clHelper(strLayer, m_go.GetName());
		///end ROI_OBJS_FAIL_TO_CLEAN_UP_WHEN_LAYER_NOT_ACTIVE
		///------ End QUICKFIT_ROI_OBJECTS_SHOULD_BE_REMOVED_AFTER_OPEN_NLFIT_FROM_CONTEXT_MENU
		DWORD dwCtrl = LTXF_FROM_CONTEXT_MENU;
		DWORD dwParam = (DWORD)this;

		///------ Folger 03/19/10 QA81-15218 ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU		
		//LPCSTR lpcszClassName = "FitNL";
		//LPCSTR lpcszName = "Fitting:FitNL (User)";
		Tree trGUI;
		GetGUITree(trGUI);

		LPCSTR lpcszClassName = NULL;
		LPCSTR lpcszName = NULL;
		int		nOrder = quick_fit_get_order(trGUI.mode.nVal, trGUI.func.strVal);
		switch ( nOrder )
		{
		case 0:
			lpcszClassName = STR_FITTEROPERATION_CLASS_FITNL;
			lpcszName = "Fitting:FitNL (User)";
			break;

		case 1:
			lpcszClassName = STR_FITTEROPERATION_CLASS_FITLINEAR;
			lpcszName = "Fitting:FitLinear (User)";
			break;

		default:
			lpcszClassName = STR_FITTEROPERATION_CLASS_FITPOLYNOMIAL;
			lpcszName = "Fitting:FitPolynomial (User)";
			break;
		}
		///------ End ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
		
		///Sophy 1/12/2010 ADD_DATAMARKERS_WHEN_SWITCH_TO_NLFIT
		QuickFitPlotInfo qfInfo;
		getFitRangeInfo(qfInfo);
		DataPlot dpAddMarkers;
		if ( !isFullRangePlot(qfInfo) )
		{
			vector<int> vBegins;
			vector<int> vEnds;
			vBegins.Add(qfInfo.nFrom);
			vEnds.Add(qfInfo.nTo);
			dpAddMarkers = Project.GetObject(qfInfo.nUID);
			dpAddMarkers.AddDataMarkers(vBegins, vEnds);
		}
		///end ADD_DATAMARKERS_WHEN_SWITCH_TO_NLFIT
		bool	bRet = do_AU_command(lpcszClassName, TRUE, NULL, -1, NULL, lpcszName, dwCtrl, dwParam);
		if ( !bRet )
		{
			if ( dpAddMarkers )
			{
				dpAddMarkers.RemoveDataMarker(qfInfo.nFrom, qfInfo.nTo);
			}
		}

		return bRet;
	}
	
	///Sophy 1/13/2010 SUPPORT_FINDXY_BEFORE_OUTPUT_RESULT
	//virtual
	bool	DoFindXY()
	{
		/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		//checkUpdateFitInfo();
		///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		OpenQuickFitFindXYDlg();
		return true;
	}
	///end SUPPORT_FINDXY_BEFORE_OUTPUT_RESULT
	///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
	
	///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	//virtual
	bool	DoUpdateList()
	{
		///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
		//return OpenQuickFitEditDlg();
		string	strFunc;
		bool	bRet = OpenQuickFitEditDlg(NULL, QUICK_FIT_MODE_NL, &strFunc);
		if ( bRet && !strFunc.IsEmpty() )
		{
			vector<string>		vsItems;
			quick_fit_get_func_list(vsItems);
			SetFunction(vsItems.Find(strFunc));
			OnMove();
		}
		return bRet;
		///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
	}
	///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI

private:
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	/*
	///Sophy 1/13/2010 SUPPORT_FINDXY_BEFORE_OUTPUT_RESULT
	bool checkUpdateFitInfo()
	{
		Tree trStorage;
		if ( !m_gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, trStorage) )
		{
			QuickFitPlotInfo qfInfo;
			getFitRangeInfo(qfInfo);
			
			Tree trGUI;
			if(!GetGUITree(trGUI))
			{
				ASSERT(false);
			}
			XYRange iy;
			m_dp.GetDataRange(iy, m_i1, m_i2);
			string strFunc = trGUI.func.strVal;
			/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
			//int nOrder = trGUI.order.nVal;
			int nOrder = quick_fit_get_order(trGUI.mode.nVal, strFunc);
			///End ADD_QUICK_FIT_MODE
			QuickFitResults		stFitResults;
			vector		vX, vY, vW;
			if ( !iy.GetData(vY, vX, &vW) || vX.GetSize() == 0 || vY.GetSize() == 0 )
				return false;
			
			if ( NLSF_QUICKFIT_ERROR_NONE != nlsf_quick_fit(m_gl, stFitResults, m_vPrevX, m_vPrevY, strFunc, nOrder, iy, NLSF_QUICKFIT_ROI_RESULT) )
				return false;

			quick_fit_source_plot_info_access(qfInfo, m_gl, FALSE);
			
		}
		return true;
	}
	///end SUPPORT_FINDXY_BEFORE_OUTPUT_RESULT
	*/
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	
	///Sophy 1/14/2010 FULL_RANGE_PLOT_SHOULD_IGNORE_ROW_RANGE
	bool isFullRangePlot(const QuickFitPlotInfo& qfInfo)
	{
		if ( (0 == qfInfo.nFrom) && (-1 == qfInfo.nTo) )
			return true;
		
		DataPlot dp;
		dp = Project.GetObject(qfInfo.nUID);
		if ( !dp )
			return false;
		XYRange xyRange;
		dp.GetDataRange(xyRange);
		if ( !xyRange )
			return false;
		vector vX, vY;
		if ( xyRange.GetData(vY, vX) )
		{
			if ( (0 == qfInfo.nFrom) && ((vY.GetSize() - 1 )== qfInfo.nTo) )
				return true;
		}
		return false;
	}
	///end FULL_RANGE_PLOT_SHOULD_IGNORE_ROW_RANGE
	
	void getFitRangeInfo(QuickFitPlotInfo& qfInfo)
	{
		/// Iris 2/01/2010 NEED_DISPLAY_SOURCE_DATA_POINTS_WHEN_CHOOSE_SAVE_AS_INPUT_DATA_IN_XF_DLG
		/*
		Tree trInfo;
		int nPlotIndex;
		if ( tree_get_binary_storage(trInfo, m_go, ATTACHED_GRAPH_OBJECTS_INFO) && trInfo.curPlotIndex )
			nPlotIndex = trInfo.curPlotIndex.nVal;
		else
			nPlotIndex = m_gl.DataPlots().GetIndex();
		*/
		///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
		//int nPlotIndex = quickf_fit_get_source_data_plot_index_from_ROI(m_go);
		int nPlotIndex = get_source_data_plot_index_from_ROI(m_go);
		///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
		///End NEED_DISPLAY_SOURCE_DATA_POINTS_WHEN_CHOOSE_SAVE_AS_INPUT_DATA_IN_XF_DLG
		
		qfInfo.nUID = m_gl.DataPlots(nPlotIndex).GetUID();
		GetData();
		qfInfo.nFrom = m_i1;
		qfInfo.nTo = m_i2;
		if ( isFullRangePlot(qfInfo) )
		{
			qfInfo.nTo = -1;
		}
	}
	
	bool updatePreviewCurve()
	{
		///Sophy 1/25/2010 SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
		//if( !getDataRange() )
				//return false;
		if ( !getDataRange() )
		{
			m_goFitCurve.Show(false);
			return false;
		}
		else
			m_goFitCurve.Show(true);
		///end SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS

		Tree trGUI;
		if(!GetGUITree(trGUI))
		{
			ASSERT(false);
		}

		XYRange iy(m_dr);		
		string strFunc = trGUI.func.strVal;
		/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
		//int nOrder = trGUI.order.nVal;
		int nOrder = quick_fit_get_order(trGUI.mode.nVal, strFunc);
		///End ADD_QUICK_FIT_MODE

		QuickFitResults		stFitResults;
		vector		vX, vY, vW;
		if ( !iy.GetData(vY, vX, &vW) || vX.GetSize() == 0 || vY.GetSize() == 0 )
			return false;
		
		if ( NLSF_QUICKFIT_ERROR_NONE != nlsf_quick_fit(m_gl, stFitResults, m_vPrevX, m_vPrevY, strFunc, nOrder, iy, NLSF_QUICKFIT_ROI_PREVIEW) )
			return false;

		// update top show text
			updateTopText(stFitResults);
		
		/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
		Tree trFitResult;
		trFitResult.ParamValues.dVals = stFitResults.vParams;
		trFitResult.ParamNames.strVals = stFitResults.vsParamNames;
		AccessFitResults(trFitResult, false);
		///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES

		return true;
	}
	
	bool updateTopText(const QuickFitResults& stFitResults)
	{
			Tree tr;
			/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
			//quick_fit_get_preference_settings(tr);
			if( !GetGUITree(tr) )
			{
				ASSERT(0);
				return false;
			}
			///End NEW_QUICKFIT_ROI_XF_DLG
			
			string strText;
			/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
			//int nSignDigits = tr.Output.SignDigits.nVal;
			int nSignDigits = tr.ROI.SignDigits.nVal;
			///End REARRANGE_PREFERENCE_DLG_TABS
			/// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
			//switch(tr.ROI.ShowTop.nVal)
			///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
			//quick_fit_update_roi_show_top(tr.ROI.ShowTop, tr.Table);
			//int nShowTop = quick_fit_get_roi_show_top_enum(tr.ROI.ShowTop);
			//switch (nShowTop)
			///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
			//{
			//case ROI_TOP_SHOW_NONE:
				//break;
				//
			//case ROI_TOP_SHOW_REDUCED_CHI_SQR:
				//strText = 	STR_SHOW_TOP_REDUCE_CHISQ + " = " + _convert_float_to_str(stFitResults.stRegStats.ReducedChiSq, nSignDigits);
				//break;
				//
			//case ROI_TOP_SHOW_ADJ_R_SQR:
				//strText = 	STR_SHOW_TOP_ADJ_R_SQUARE + " = " + _convert_float_to_str(stFitResults.stRegStats.AdjRSq, nSignDigits);
				//break;
				//
			///// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
			//case ROI_TOP_SHOW_PEARSON_R:
				//strText = 	STR_PEARSON_R + " = " + _convert_float_to_str(stFitResults.stRegStats.Correlation, nSignDigits);
				//break;
//
			//case ROI_TOP_SHOW_R_SQUARE:
				//strText = 	STR_R_SQR + " = " + _convert_float_to_str(stFitResults.stRegStats.RSqCOD, nSignDigits);
				//break;
//#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
			///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
				//
			//case ROI_TOP_SHOW_PARAM:
				///// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
				///*
				//int nParamIndex = tr.ROI.ParamIndex.nVal;
				//if( nParamIndex >= stFitResults.vParams.GetSize() )
					//nParamIndex = stFitResults.vParams.GetSize() - 1; // last param
				//*/
				/////Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
				////for(int nParamIndex = 0; nParamIndex < stFitResults.vParams.GetSize(); nParamIndex++)
				////{
					////strText += stFitResults.vsParamNames[nParamIndex] + " = " + _convert_float_to_str(stFitResults.vParams[nParamIndex], nSignDigits);
					////if( nParamIndex != stFitResults.vParams.GetSize() -1 )
					////{
						////strText += (nParamIndex+1) % 2 == 0 ? STR_NEXT_LINE : ", ";
					////}
				////}
				//int nCount = 0;
				//TreeNode trParam = tr.ROI.Params.FirstNode;
				//for(int nParamIndex = 0; nParamIndex < stFitResults.vParams.GetSize(); nParamIndex++)
				//{
					//if( trParam && trParam.nVal )
					//{
						//if( nCount > 0 )
						//{
							//strText += (nCount % 2 == 0) ? STR_NEXT_LINE : ", ";
						//}
						//strText += stFitResults.vsParamNames[nParamIndex] + " = " + _convert_float_to_str(stFitResults.vParams[nParamIndex], nSignDigits);
						//
						//nCount++;
					//}
					//trParam = trParam.NextNode;
				//}
				/////End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
				/////End SHOW_ALL_PARAMS_ON_ROI_TOP
				//break;
				//
			//default:
				//ASSERT(0);
				//break;				
			//}
			int nCount = 0;
			if ( tr.ROI.ShowTop.ReduChisq.Show && tr.ROI.ShowTop.ReduChisq.nVal )
			{
				if( nCount > 0 )
					strText +=	STR_NEXT_LINE;
				strText += 	STR_SHOW_TOP_REDUCE_CHISQ + " = " + _convert_float_to_str(stFitResults.stRegStats.ReducedChiSq, nSignDigits);
				nCount++;
			}
				
			if ( tr.ROI.ShowTop.AdjR.Show && tr.ROI.ShowTop.AdjR.nVal )
			{
				if( nCount > 0 )
					strText +=	STR_NEXT_LINE;
				strText += 	STR_SHOW_TOP_ADJ_R_SQUARE + " = " + _convert_float_to_str(stFitResults.stRegStats.AdjRSq, nSignDigits);
				nCount++;
			}
				
#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
			if ( tr.ROI.ShowTop.RSqr.Show && tr.ROI.ShowTop.RSqr.nVal )
			{
				if( nCount > 0 )
					strText +=	STR_NEXT_LINE;
				strText += 	STR_R_SQR + " = " + _convert_float_to_str(stFitResults.stRegStats.RSqCOD, nSignDigits);
				nCount++;
			}
			
			if ( tr.ROI.ShowTop.Correlation.Show && tr.ROI.ShowTop.Correlation.nVal )
			{
				if( nCount > 0 )
					strText +=	STR_NEXT_LINE;
				strText += 	STR_PEARSON_R + " = " + _convert_float_to_str(stFitResults.stRegStats.Correlation, nSignDigits);
				nCount++;
			}
#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
				
			//ROI_TOP_SHOW_PARAM:
				/// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
				/*
				int nParamIndex = tr.ROI.ParamIndex.nVal;
				if( nParamIndex >= stFitResults.vParams.GetSize() )
					nParamIndex = stFitResults.vParams.GetSize() - 1; // last param
				*/
				///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
				//for(int nParamIndex = 0; nParamIndex < stFitResults.vParams.GetSize(); nParamIndex++)
				//{
					//strText += stFitResults.vsParamNames[nParamIndex] + " = " + _convert_float_to_str(stFitResults.vParams[nParamIndex], nSignDigits);
					//if( nParamIndex != stFitResults.vParams.GetSize() -1 )
					//{
						//strText += (nParamIndex+1) % 2 == 0 ? STR_NEXT_LINE : ", ";
					//}
				//}
				int nCountParam = 0;
				TreeNode trParam = tr.ROI.Params.FirstNode;
				for(int nParamIndex = 0; nParamIndex < stFitResults.vParams.GetSize(); nParamIndex++)
				{
					if( trParam && trParam.nVal )
					{
						//if( nCount > 0 )
						//{
							//strText += (nCount % 2 == 0) ? STR_NEXT_LINE : ", ";
						//}
						if ( 0 == nCountParam )
						{
							strText +=	(nCount > 0) ? STR_NEXT_LINE : "";
						}
						else
						if ( nCountParam > 0 )
						{
							strText += (nCountParam % 2 == 0) ? STR_NEXT_LINE : ", ";
						}
						strText += stFitResults.vsParamNames[nParamIndex] + " = " + _convert_float_to_str(stFitResults.vParams[nParamIndex], nSignDigits);
						
						//nCount++;
						nCountParam++;
					}
					trParam = trParam.NextNode;
				}
				///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
				///End SHOW_ALL_PARAMS_ON_ROI_TOP
			///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
			///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
			if( strText.IsEmpty() )
			{
				m_goLabel.Show = false;
				return true;
			}
			m_goLabel.Show = true;
			///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
			UpdateTopLabel(strText);
			return true;
	}
	
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//bool outputQuickFitResult()
	bool outputQuickFitResult(bool bUpdateLastOutput)
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	{		
		if( !getDataRange() )
			return false;		
		
		Tree trGUI;
		if(!GetGUITree(trGUI))
		{
			ASSERT(false);
			return false;
		}

		GraphLayer gl;
		m_dp.GetParent(gl);
		GraphPage gp = gl.GetPage();
		string strRange;
		///Sophy 1/14/2010 FULL_RANGE_PLOT_SHOULD_IGNORE_ROW_RANGE
		//strRange.Format("[%s]%d!%d[%d:%d]", gp.GetName(), gl.GetIndex()+1, m_dp.GetIndex()+1, m_i1+1, m_i2+1);
		QuickFitPlotInfo qfInfo;
		getFitRangeInfo(qfInfo);
		if ( isFullRangePlot(qfInfo) )
		{
			strRange.Format("[%s]%d!%d", gp.GetName(), gl.GetIndex()+1, m_dp.GetIndex()+1);
		}
		else
			strRange.Format("[%s]%d!%d[%d:%d]", gp.GetName(), gl.GetIndex()+1, m_dp.GetIndex()+1, m_i1+1, m_i2+1);
		///end FULL_RANGE_PLOT_SHOULD_IGNORE_ROW_RANGE
		
		string str = "QuickFit iy:=%s order:=%d";
		string strCommand;
		/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
		//int nOrder = trGUI.order.nVal;
		int nOrder = quick_fit_get_order(trGUI.mode.nVal, trGUI.func.strVal);
		///End ADD_QUICK_FIT_MODE
		if(0 == nOrder)
		{
			str += " func:=%s";
			strCommand.Format(str, strRange, nOrder, trGUI.func.strVal)
		}
		else
		{
			strCommand.Format(str, strRange, nOrder);
		}
		strCommand += " roi:=1";
		//---- CPY 2/22/2010 FIT_LINE_AUTO_COLOR_LEAD_TO_BLACK_FIT_ON_BLACK_DATA
		//strCommand += " color:=" + trGUI.ROI.FitLineColor.nVal; /// Iris 1/29/2010 SET_QUICK_FIT_CURVE_COLOR
		int nColor;
		checkGetFitLineColor(nColor);
		strCommand += " color:=" + nColor; 
		//----
		
		/// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
		TreeNode trOutputTo = trGUI.FitCurve.OutputFitCurveTo;
		if( trOutputTo )
		{			
			///Sophy 3/1/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
			//bool bNewBook = OUTPUT_FIT_CURVE_TO_NEW_BOOK == trOutputTo.nVal? true : false;
			//bool bNewSheet = OUTPUT_FIT_CURVE_TO_INPUT_SHEET == trOutputTo.nVal? false: true;
			//
			//string strBook, strSheet;
			//strBook = strSheet = "<input>";
			//string strNew = "<new name:=%s>";
			//if( bNewBook )
				//strBook.Format(strNew, STR_NEW_FIT_CURVE_BOOK_NAME);
			//if( bNewSheet )
				//strSheet.Format(strNew, STR_NEW_FIT_CURVE_SHEET_NAME);
			//
			//string strOutputRange;
			//strOutputRange.Format("[%s]%s!%s", strBook, strSheet, "<new>");
			string strOutputRange = get_output_range_str(trOutputTo.nVal);
			///end UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
			strCommand += " oy:=" + strOutputRange;				
		}
		///End ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
		
		/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
		strCommand += " replace:=" + (int)bUpdateLastOutput;
		///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
		
		LT_execute(strCommand);
		
		//-----Iris 12/30/2009 remove preview data plot when output
		m_vPrevX.SetSize(2);
		m_vPrevY.SetSize(2);
		m_vPrevX = NANUM;
		m_vPrevY = NANUM;
		drawLineObjs();
		//-----
		
		return true;
	}
	
	void drawLineObjs()
	{
		//if(CreateAttachedFreeLine(&m_goFitCurve, _QF_TOOL_POS_ID_FITCURVE, GROBJ_TN_POLYLINE) > 0)
		//{
			ASSERT(m_vPrevX.GetSize() == m_vPrevY.GetSize());

			if(1 < m_vPrevX.GetSize())
				m_goFitCurve.SetPoints(m_vPrevX, m_vPrevY);
			else
				error_report("Create free line fail in drawLineObjs");
		//}

		m_gp.Refresh();
	}
	
	bool getDataRange()
	{
		if(!GetData())
		{
			error_report("GetData() form Grobj error!");
			return false;
		}
		
		if(!m_dp.GetDataRange(m_dr, m_i1, m_i2))
		{
			error_report("GetDataRange from dataplot error!");
			return false;
		}
		return true;
	}
	
	bool addFit(Menu& pm)
	{
		///Sophy 1/18/2010 DISABLE_SWITCH_TO_NLFIT_DLG_WHEN_USE_POLYNOMIAL_FUNCTIONS
		//return pm.Add(STR_DO_NLFIT, GOT_BTN_FIT);
		DWORD dwFlags = MF_STRING;
		Tree trGUI;
		GetGUITree(trGUI);
		/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
		/*
		if ( trGUI.order.nVal != 0 )
			dwFlags |= MF_GRAYED;
		*/
		///------ Folger 03/19/10 QA81-15218 ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
		//if( trGUI.mode.nVal == QUICK_FIT_MODE_LR )
			////dwFlags |= MF_GRAYED;
		///End ADD_QUICK_FIT_MODE
		//return pm.Add(STR_DO_NLFIT, GOT_BTN_FIT, dwFlags);
		string	str = STR_DO_NLFIT;
		if ( QUICK_FIT_MODE_LR == trGUI.mode.nVal )
		{
			str = 1 == quick_fit_get_order(QUICK_FIT_MODE_LR, trGUI.func.strVal) ? STR_DO_LINEARFIT : STR_DO_POLYNOMIALFIT;
		}
		return pm.Add(str, GOT_BTN_FIT, dwFlags);
		///------ End ADD_LINEAR_FIT_AND_POLYNOMIAL_FIT_TO_QUICKFIT_CONTEXT_MENU
		///end DISABLE_SWITCH_TO_NLFIT_DLG_WHEN_USE_POLYNOMIAL_FUNCTIONS
	}
	
	bool addFindXY(Menu& pm)
	{
		return pm.Add(STR_DO_FINDXY, GOT_BTN_FINDXY);
	}
	
	bool addFitFunctions(Menu& pm, uint& nPosition)
	{
		///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
		/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG, clean codes
		/*
		const int nPolyFunctionCount = 3;
		vector<string> vsItems;
		vsItems.Add(LINEAR_FIT_MRU_NAME);
		vsItems.Add(QUADRATIC_FIT_MRU_NAME);
		vsItems.Add(CUBIC_FIT_MRU_NAME);
		
		vector<string> vsFavors;
		okutil_get_favor_nlsf_functions(&vsFavors);
		vsItems.Append(vsFavors);
		const int nPolyFunctionCount = NUM_FIXED_POLY_FUNC;
		*/
		vector<string> vsItems;
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//quick_fit_get_func_list(vsItems, QUICK_FIT_ALL_MODE_FUNCS, NUM_FIXED_POLY_FUNC);
		int nNumPolyFuncs = 0;
		quick_fit_get_func_list(vsItems, QUICK_FIT_ALL_MODE_FUNCS, &nNumPolyFuncs);
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		///End NEW_QUICKFIT_ROI_XF_DLG
		int nFunctions = vsItems.GetSize();

		Tree trGUI;
		GetGUITree(trGUI);
		/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
		/*
		int nCurFunction = 0;
		if ( trGUI.order.nVal == 0 )
			nCurFunction = vsItems.Find(trGUI.func.strVal);
		else
			nCurFunction = trGUI.order.nVal - 1;
		*/
		int nCurFunction = vsItems.Find(trGUI.func.strVal);
		///End ADD_QUICK_FIT_MODE
		Menu subMenu;
		for ( int iFunc = 0; iFunc < nFunctions; iFunc++ )
		{
			DWORD dwFlags = (iFunc == nCurFunction ? (MF_STRING | MF_CHECKED) : MF_STRING);
			subMenu.Add(vsItems[iFunc], (GOT_BTN_FUNCTION | (iFunc + 1)), dwFlags);
			
			///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
			//if( iFunc == NUM_FIXED_POLY_FUNC-1 ) // add separator after the last poly function
			if( iFunc == nNumPolyFuncs - 1 )
			///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
				subMenu.Add(NULL, 0, MF_SEPARATOR);
		}

		///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
		subMenu.Add(NULL, 0, MF_SEPARATOR);
		subMenu.Add(STR_UPDATE_FUNCTION_LIST, GOT_BTN_UPDATE_LIST);
		///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
		if ( nPosition > 0 )
			pm.InsertPopup(nPosition - 1, STR_DO_FUNCITON, subMenu, GOT_BTN_FUNCTION); //insert before "Expand to Full Plot Range"
		else
			pm.AddPopup(STR_DO_FUNCITON, subMenu, GOT_BTN_FUNCTION);
		/*
		string		strDoFuncWithThreeDots = STR_DO_FUNCITON + STR_THREE_DOTS;
		if ( nPosition > 0 )
			pm.InsertMenu(nPosition - 1, MF_STRING | MF_BYPOSITION, GOT_BTN_FUNCTION, strDoFuncWithThreeDots);
		else
			pm.Add(strDoFuncWithThreeDots, GOT_BTN_FUNCTION);
		*/
		///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
		
		nPosition++;
		return true;
	}


	//---- CPY 2/22/2010 FIT_LINE_AUTO_COLOR_LEAD_TO_BLACK_FIT_ON_BLACK_DATA
	//return true if auto and updated nColor and tr
	bool checkGetFitLineColor(int& nColor, TreeNode& tr=NULL)
	{
		nColor = SYSCOLOR_BLUE;
		TreeNode trTmpSettings;
		Tree trGUI;
		bool bUpdateTree = true;
		if(!tr)
		{
			if( !GetGUITree(trGUI) )
				return false;

			trTmpSettings = trGUI.ROI;
			bUpdateTree = false;// not passed in, no need to update it
		}
		else
			trTmpSettings = tr;

		bool bTreeHasLineColor = trTmpSettings.FitLineColor ? true:false;
		if(bTreeHasLineColor)
			nColor = trTmpSettings.FitLineColor.nVal;
		
		if( !bTreeHasLineColor || nColor != INDEX_COLOR_AUTOMATIC )
			return false;
		
		if(!trTmpSettings.FitLineColor.GetAttribute(STR_ATTRIB_AUTO_COLOR, nColor))
			nColor = SYSCOLOR_BLUE;

		if( !m_dp )
			GetData();

		/// Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
// 		int nSourcePlotColor = get_plot_color(m_dp);
// 		if( nSourcePlotColor == nColor )
// 		{
// 			nColor = nSourcePlotColor + 1;
// 		}
		nColor = quickfit_get_fit_line_auto_color(nColor, m_dp);
		/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
		if(bUpdateTree)			
			trTmpSettings.FitLineColor.SetAttribute(STR_ATTRIB_AUTO_COLOR, nColor);
		return true;
	}
	//---- end FIT_LINE_AUTO_COLOR_LEAD_TO_BLACK_FIT_ON_BLACK_DATA

	///------ Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
	virtual	BOOL	IsExpandable()
	{
		Tree	trGUI;
		GetGUITree(trGUI);
		TreeNode	trFixedScale = trGUI.ROI.XScale.fixscale;
		return !(trFixedScale && trFixedScale.nVal);
	}

	virtual	void	DoExpand(DataPlot& dp)
	{
		/// Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
		/*
		vector vX, vY;
		dp.GetDataPoints(0, -1, vX, vY);
		double dMinX, dMaxX, dMinY, dMaxY;
		
		/// Set Rect Position
		vX.GetMinMax(dMinX, dMaxX);
		vY.GetMinMax(dMinY, dMaxY);			
		get_min_max_inc(dMinX, dMaxX, m_gl.X.Type, 0.04);
		get_min_max_inc(dMinY, dMaxY, m_gl.Y.Type, 0.01);
		*/
		double dMinX, dMaxX, dMinY, dMaxY;
		BeforeExpandRect(dp, dMinX, dMaxX, dMinY, dMaxY);
		///End TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
		
		vector vx(4), vy(4);
		vx[0] = dMinX, vx[1] = dMaxX; vx[2] = dMaxX; vx[3] = dMinX;
		vy[0] = dMinY, vy[1] = dMinY; vy[2] = dMaxY; vy[3] = dMaxY;
		Tree	tr;
		tr.Root.Data.X.dVals = vx;
		tr.Root.Data.Y.dVals = vy;
		int nErr = m_go.UpdateThemeIDs(tr.Root);
		if(nErr == 0)
		{
			m_go.ApplyFormat(tr, true, true);
		}
		else
		{
			ASSERT(FALSE);
		}
		
		/// Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
		/*
		/// Set Layer Scale
		vX.GetMinMax(dMinX, dMaxX);
		vY.GetMinMax(dMinY, dMaxY);
		get_min_max_inc(dMinX, dMaxX, m_gl.X.Type, 0.08);
		get_min_max_inc(dMinY, dMaxY, m_gl.Y.Type, 0.02);
		m_gl.X.From = dMinX;
		m_gl.X.To = dMaxX;
		m_gl.Y.From = dMinY;
		m_gl.Y.To = dMaxY;
		*/
		///End TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	}
	///------ End ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY

private:
	//GraphObject				m_goEdit;///Sophy 1/7/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	PolylineGraphObject		m_goFitCurve;
	GraphObject				m_goFunction;	///Sophy 1/7/2010 ROI_QUICK_FIT_BUTTON_TO_SUPPORT_CHANGE_FIT_FUNCTION

	
	//GraphObject				m_goAction;///Sophy 1/7/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	DataRange				m_dr;
	
	vector					m_vPrevX;
	vector					m_vPrevY;
};

enum{
	_QF_TOOL_POS_ID_FITCURVE,
};
///Sophy 1/7/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
/*
void quickfit_tool_output_btn_click(string strGrName)
{
	GraphObject go = get_master_gr(Project.ActiveLayer().GraphObjects(strGrName));
	ASSERT(go);

	if(go)
	{
		QuickFitTool qtool(go.GetName());
		if(!qtool.IsValidLayer())
		{
			error_report("invalid layer!");
			return;
		}
		qtool.DoOutput();
	}
}

void quickfit_tool_edit_btn_click(string strGrName)
{
	GraphObject go = get_master_gr(Project.ActiveLayer().GraphObjects(strGrName));
	ASSERT(go);

	if(go)
	{
		QuickFitTool qtool(go.GetName());
		if(!qtool.IsValidLayer())
		{
			error_report("invalid layer!");
			return;
		}
		qtool.DoEdit();
	}
	
}
*/
///end CLEAN_CODE_FOR_ROI_TOOLS
//must be in the form of XFNAME_events

class	QuickFitToolCreator
{
public:
	QuickFitToolCreator()
	{
		m_pTool = new QuickFitTool();
	}
	~QuickFitToolCreator()
	{
		NICE_SAFE_REMOVAL(m_pTool);
	}
	
	QuickFitTool*		GetTool()
	{
		return m_pTool;
	}
private:
	QuickFitTool*	m_pTool;
};

void addtool_quickfit_events(string strGrName, int nEvent, int nMsg = 0)
{
	QuickFitToolCreator	l_creator;
	graphobjtool_events(*l_creator.GetTool(), strGrName, nEvent, nMsg);
}

#define STR_QUICK_FIT_ADDTOOL_RECT_STORAGE		"QuickFitRectName"

static bool _set_gl_quick_fit_rect_go_name(GraphLayer& gl, LPCSTR lpcszRect = NULL)
{
	if(!gl)
		return false;
	if(lpcszRect == NULL)
	{
		gl.SetMemory(STR_QUICK_FIT_ADDTOOL_RECT_STORAGE, NULL);
	}
	else
	{
		GraphObject go = gl.GraphObjects(lpcszRect);
		if(!go)
			return false;
		Tree tr;
		tr.Rect.strVal = lpcszRect;
		gl.PutBinaryStorage(STR_QUICK_FIT_ADDTOOL_RECT_STORAGE, tr);
	}
	
	return true;
}

bool get_gl_quick_fit_rect_go_name(GraphLayer& gl, string& strRect)
{
	if(!gl)
		return false;
	Tree tr;	
	if( !gl.GetBinaryStorage(STR_QUICK_FIT_ADDTOOL_RECT_STORAGE, tr) || !tr.Rect)
		return false;
	
	strRect = tr.Rect.strVal;
	GraphObject go = gl.GraphObjects(strRect);
	return go.IsValid();
}

bool GetQuickFitToolSettings(TreeNode& trGUI)
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return false;
	
	string strRect;
	if( get_gl_quick_fit_rect_go_name(gl, strRect) )
	{
		QuickFitTool qtool(strRect);
		Tree tr;
		if( qtool.GetTree(tr) )
		{
			trGUI = tr.GUI;
			return true;
		}
	}
	return false;	
}

///Kyle 03/12/2010 FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL
static void _check_if_scale_changed_and_apply_settings(QuickFitTool& qtool, TreeNode& trGUI)
{
	int nn;
	bool bXPosChanged;
	if( trGUI.ROI.XScale.GetAttribute(STR_FORCE_APPLY_ROI_X_POS_ATTRIB, nn) && 1 == nn )
	{
		bXPosChanged = true;
	}
	else
	{
		bXPosChanged = trGUI.ROI.XScale.fixscale.nVal;
	}
	qtool.ApplySettings(NULL, true, bXPosChanged);
}
///End FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL

void AddToolQuickFit(TreeNode& trGUI)
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return;

	string strRect;
	if( get_gl_quick_fit_rect_go_name(gl, strRect) )
	{
		QuickFitTool qtool(strRect);
		Tree tr;
		qtool.GetTree(tr);

		///Sophy 2/25/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
		//tr.GUI.Replace(trGUI.Clone(), true, true, false);
		tr.GUI.Replace(trGUI.Clone(), true, true, true); //need to keep version attribute for checking.
		///end ///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
		///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
		qtool.UpdateThemeFileInGUITree(tr.GUI);
		///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
		qtool.SetTree(tr);
		graphobjtool_events(qtool, strRect, OE_MOVE);
		/// Iris 2/25/2010 TO_PREVENT_MOVE_ROI_WHEN_LOAD_THEME
		//qtool.ApplySettings(NULL, true, true);  /// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
		///Kyle 03/12/2010 FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL
		/*
		int nn;
		bool bXPosChanged;
		if( trGUI.ROI.XScale.GetAttribute(STR_FORCE_APPLY_ROI_X_POS_ATTRIB, nn) && 1 == nn )
		{
			bXPosChanged = true;
		}
		else
		{
			bXPosChanged = trGUI.ROI.XScale.fixscale.nVal; // if Fix checkbox is checked, then apply x pos from theme, else keep ROI the current position.
		}
		qtool.ApplySettings(NULL, true, bXPosChanged);
		*/
		_check_if_scale_changed_and_apply_settings(qtool, trGUI);
		///End FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL
		///End TO_PREVENT_MOVE_ROI_WHEN_LOAD_THEME
	}
	else
	{
		QuickFitTool qtool;
		int nErr = qtool.Create(XFNAME, 0, trGUI);
		if(nErr < 0)
		{
			XF_THROW(XFERR_INVALID_GRAPH_LAYER);
			return;
		}
		if(nErr)
			error_report("addtool_quickfit failed Init");
		else
		{
			string strRect;
			qtool.GetMainObjName(strRect);
			_set_gl_quick_fit_rect_go_name(gl, strRect);
			///Kyle 03/12/2010 FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL
			//qtool.ApplySettings(NULL, true);
			_check_if_scale_changed_and_apply_settings(qtool, trGUI);
			///End FIX_FAIL_TO_APPLY_SPECIFIED_SCALE_FOR_NEW_OPEN_QUICK_FIT_TOOL
		}
	}
}



void OpenQuickFitFindXYDlg()
{
	QuickFitFindXYDlg dlg;
	dlg.DoModalEx();
}

/// Iris 1/22/2010 COMMENT_OUT_UNUSEFUL_CODES
/*
///------ Folger 01/14/09 QA81-14832 SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
void	ExecuteQuickFitTheme(string strThemeFile, BOOL bROI)
{
	Tree	tr;
	quick_fit_get_preference_settings(tr, strThemeFile);
	
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	//string	strFunction = tr.Function.strVal;
	//tr.Function.strVal.Empty();
	string	strFunction = tr.func.strVal;
	tr.func.strVal.Empty();
	///End NEW_QUICKFIT_ROI_XF_DLG
	save_preference_settings(tr);
	
	int		nOrder = atoi(strFunction);
	if ( nOrder > 0 )
	{
		strFunction.Empty();
	}
	else
	{
		nOrder = 0;
	}
	
	string	strScript;
	strScript.Format("%s func:=\"%s\" order:=%d;", bROI ? "addtool_quickfit" : "quickfit", strFunction, nOrder);
	LT_execute(strScript);
}
///------ End SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
*/
///End COMMENT_OUT_UNUSEFUL_CODES

/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
int	check_get_quick_fit_result(GraphLayer& gl, QuickFitPlotInfo& stPlotInfo, string& strFunc, vector& vParams, string* pstrCateg = NULL, vector<string>* pvstrParamNames = NULL, bool bNLFitOnly = true)
{
	if ( !gl )
		return -1;
	
	Tree			tr;
	if ( !gl.GetBinaryStorage(QUICK_FIT_STORAGE_NAME, tr) )
		return -2;
	
	QuickFitResults	stFitResults;
	stFitResults = tr.Results;
	int 			nOrder = tr.Order.nVal;
	if ( bNLFitOnly && 0 != nOrder )
		return -3;
	
	/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	//nInputPlotUID = stFitResults.nInputPlotUID;
	DataPlot	dpSrc;
	if( !_get_quick_fit_source_plot(dpSrc, NULL, gl, &stPlotInfo.nFrom, &stPlotInfo.nTo) )
		return -4;
	stPlotInfo.nUID = dpSrc.GetUID(TRUE);
	/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
	strFunc = tr.FunctionName.strVal;
	vParams = stFitResults.vParams;
	if ( pstrCateg && bNLFitOnly )
		*pstrCateg = STR_QUICK_FIT_NLF_SECTION;
	if ( pvstrParamNames )
		*pvstrParamNames = stFitResults.vsParamNames;
	
	return 0;
}
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME

///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
//bool	check_get_quick_fit_settings(DWORD dwQuickFitToolPtr, string& strFunc, string& strCateg, QuickFitPlotInfo& qfInfo)
bool	check_get_quick_fit_settings(DWORD dwQuickFitToolPtr, QuickFitPlotInfo& qfInfo, string& strFunc, string& strCateg, vector& vParams, vector<string>& vstrParamNames)
///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
{
	QuickFitTool* pTool = (QuickFitTool*)dwQuickFitToolPtr;
	if ( NULL == pTool )
		return false;
	
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	//return pTool->GetQuickFitSettings(strFunc, strCateg, qfInfo);
	return pTool->GetQuickFitSettings(qfInfo, strFunc, strCateg, vParams, vstrParamNames);
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
}
///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU

/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
//int	quick_fit_get_func_list(vector<string>& vsFuncs)
///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
//int	quick_fit_get_func_list(vector<string>& vsFuncs, int nFuncMode, int nMaxOrder)
int	quick_fit_get_func_list(vector<string>& vsFuncs, int nFuncMode, int* pnNumPolyFuncs)
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
///End ADD_QUICK_FIT_MODE
{ 
	///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
	if( pnNumPolyFuncs )
		*pnNumPolyFuncs = 0; 
	///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		
	vsFuncs.RemoveAll();
	if( QUICK_FIT_LR_MODE_FUNCS & nFuncMode ) /// Iris 1/19/2010 ADD_QUICK_FIT_MODE
	{
		/// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
		/*
		vsFuncs.Add(LINEAR_FIT_MRU_NAME);
		vsFuncs.Add(QUADRATIC_FIT_MRU_NAME);
		vsFuncs.Add(CUBIC_FIT_MRU_NAME);
		*/
		///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		//_get_lr_function_list(vsFuncs, nMaxOrder);
		_get_lr_function_list(vsFuncs);
		if( pnNumPolyFuncs )
			*pnNumPolyFuncs = vsFuncs.GetSize();
		///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
		///End USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
	}
	if(QUICK_FIT_NL_MODE_FUNCS & nFuncMode) /// Iris 1/19/2010 ADD_QUICK_FIT_MODE
	{
		vector<string>		vsFavoriteFunctions;
		okutil_get_favor_nlsf_functions(&vsFavoriteFunctions);
		vsFuncs.Append(vsFavoriteFunctions);
	}
	return vsFuncs.GetSize();
}

///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
int quick_fit_get_func_param_list(vector<string>& vsParams, int nOrder, LPCSTR lpcszFunc)
{
	vsParams.SetSize(0);
	if( 0 == nOrder )
	{
		nlsf_get_param_names(lpcszFunc, STR_QUICK_FIT_NLF_SECTION, vsParams);
	}
	else
	{
		int nParams = nOrder + 1;
		for(int ii=0; ii < nParams; ii++)
		{
			if( 0 == ii )
				vsParams.Add("Intercept");
			else
			{
				if( 2 == nParams )
					vsParams.Add("Slope");
				else
					vsParams.Add("B"+ii);
			}
		}
	}

	return vsParams.GetSize();
}
///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

int quick_fit_get_order(int nFitMode, LPCSTR lpcszFunc)
{
	if( QUICK_FIT_MODE_LR == nFitMode )
	{
		/// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
		/*
		if( 0 == strcmp(LINEAR_FIT_MRU_NAME, lpcszFunc) )
			return 1;
		
		if( 0 == strcmp(QUADRATIC_FIT_MRU_NAME, lpcszFunc) )
			return 2;
		
		if( 0 == strcmp(CUBIC_FIT_MRU_NAME, lpcszFunc) )
			return 3;
		*/
		/// Iris 2/05/2010 FIX_FAIL_SET_FUNC_IN_JOS
		//if( 0 == strcmp(POLY_LINEAR_FIT_FUNC_NAME, lpcszFunc) )
		if( compare_string_localization(POLY_LINEAR_FIT_FUNC_NAME, lpcszFunc) )
		///End FIX_FAIL_SET_FUNC_IN_JOS
			return 1;
		
		/// Iris 2/05/2010 FIX_FAIL_SET_FUNC_IN_JOS
		//if( 0 == strcmp(POLY_QUADRATIC_FIT_FUNC_NAME, lpcszFunc) )
		if( compare_string_localization(POLY_QUADRATIC_FIT_FUNC_NAME, lpcszFunc) )
		///End FIX_FAIL_SET_FUNC_IN_JOS
			return 2;
		
		/// Iris 2/05/2010 FIX_FAIL_SET_FUNC_IN_JOS
		//if( 0 == strcmp(POLY_CUBIC_FIT_FUNC_NAME, lpcszFunc) )
		if( compare_string_localization(POLY_CUBIC_FIT_FUNC_NAME, lpcszFunc) )
		///End FIX_FAIL_SET_FUNC_IN_JOS		
			return 3;
		
		// too hard code, if have time should improve 
		string strOrder(lpcszFunc);
		strOrder.TrimRight(STR_MULTI_POLY_FUNC_NAME);
		ASSERT(is_numeric(strOrder));
		return atoi(strOrder);
		///End USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
	}
	else
	{
		ASSERT(QUICK_FIT_MODE_NL == nFitMode);
		return 0;
	}
}

/// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
string quick_fit_get_lr_function_name(int nOrder, bool bAddPolyPostfix)
{
	string str;
	/// Iris 1/22/2010 KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
	if( nOrder > 0 && nOrder <= NUM_FIXED_POLY_FUNC )
	{
		switch(nOrder)
		{
		case 1:
			str = POLY_LINEAR_FIT_FUNC_NAME;
			break;
			
		case 2:
			str = POLY_QUADRATIC_FIT_FUNC_NAME;
			break;
			
		case 3:
			str = POLY_CUBIC_FIT_FUNC_NAME;
			break;
		}
		
	}
	///End KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
	else
	{
		str = nOrder;
		str += STR_MULTI_POLY_FUNC_NAME;
	}
	
	if( bAddPolyPostfix )
		str += " " + STR_POLY;
	return str;
}

///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
/*
/// Iris 1/22/2010 KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
//static void _get_lr_function_list(vector<string>& vsFuncs)
static void _get_lr_function_list(vector<string>& vsFuncs, int nMaxOrder = NUM_POLY_FUNC_MAX_ORDER)
///End KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
{
	vsFuncs.RemoveAll();
	/// Iris 1/22/2010 KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME	
	//for(int nn = NUM_POLY_FUNC_MIN_ORDER; nn <= NUM_POLY_FUNC_MAX_ORDER; nn++)
	for(int nn = NUM_POLY_FUNC_MIN_ORDER; nn <= nMaxOrder; nn++)
	///End KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
	{
		vsFuncs.Add(quick_fit_get_lr_function_name(nn));
	}
}
///End USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
*/
#define CH_ORDER_SEP			','
static string _get_lr_defaul_order_strlist()
{
	string strDefaultOrders;
	for(int nOrder = 1; nOrder <= NUM_POLY_FUNC_MAX_ORDER; nOrder++)
	{
		strDefaultOrders += (string)nOrder + CH_ORDER_SEP;
	}
	strDefaultOrders.TrimRight(CH_ORDER_SEP);
	return strDefaultOrders;
}

static int _get_lr_defaul_order_list(vector<int>& vnOrders)
{
	string strList = _get_lr_defaul_order_strlist();
	
	vector vdOrders;
	strList.GetTokens(vdOrders, CH_ORDER_SEP);
	vnOrders = vdOrders;	
	return vnOrders.GetSize();
}

static void _get_lr_favorite_order_list(vector<int>& vnOrders)
{	
	INIFile iniFile("Origin.ini");
	string strDefaultOrders = _get_lr_defaul_order_strlist();
	string strOrders = iniFile.ReadString(STR_QUICK_FIT_REGRESSION_SECTION, STR_QUICK_FIT_REGRESSION_KEY, strDefaultOrders);
	
	vector vdOrders;
	strOrders.GetTokens(vdOrders, CH_ORDER_SEP);
	vnOrders = vdOrders;
}


static void _get_lr_function_list(vector<string>& vsFuncs)
{
	vector<int> vnOrders;
	_get_lr_favorite_order_list(vnOrders);
	
	vsFuncs.RemoveAll();
	for(int nn = 0; nn < vnOrders.GetSize(); nn++)
	{
		vsFuncs.Add( quick_fit_get_lr_function_name(vnOrders[nn]) );
	}	
}
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS

/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
bool quick_fit_get_rect_ROI_init_x_range(GraphLayer& gl, double& dLeftX, double& dRightX)
{
	if( !gl )
		return false;
	
	double dx = fabs(gl.X.To - gl.X.From);
	/// Iris 2/10/2010 QA81-15099 FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO
	/*
	dLeftX = gl.X.From + dx * 0.2;
	dRightX = gl.X.From + dx * 0.7;	
	*/
	double min = dx * 0.2;
	double max = dx * 0.7;
	double from = gl.X.From;
	double to = gl.X.To;
	dLeftX = (from < to? from : to) + (from < to ? min : max);
	dRightX = (from < to? from : to) + (from < to ? max : min);
	///End FIX_BAD_ROI_INIT_POS_WHEN_LAYER_FROM_LARGE_THAN_TO
	return true;
}
///End ADD_LEFTX_RIGHTX_IN_ROI_TAB

///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
#define		STR_MORE_FUNCTIONS		STR_MORE_EX + STR_THREE_DOTS
#define		STR_CURRENT_FUNCTION	"CurrFunc"

///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
//static void _edit_func_list_button_event(TreeNode& tr, WndContainer& DynaCntrlContainer)
static void _edit_func_list_button_event(TreeNode& tr, WndContainer& DynaCntrlContainer, string* pstrSelectedFunc)
///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
{
	TreeNode	trMode = tr.mode;
	if ( !trMode )
	{
		ASSERT(FALSE);
		return;
	}

	HWND hwnd = DynaCntrlContainer.GetSafeHwnd();
	///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
	//if( OpenQuickFitEditDlg(hwnd, trMode.nVal) )
	if( OpenQuickFitEditDlg(hwnd, trMode.nVal, pstrSelectedFunc) )
	///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
	{
		quickfit_update_function_list(tr);
	}
}

void	quickfit_on_func_change(TreeNode& tr, WndContainer& DynaCntrlContainer)
{
	TreeNode	trFunc = tr.func;
	if ( !trFunc )
	{
		ASSERT(FALSE);
		return;
	}

	/// Iris 2/05/2010 FIX_FAIL_SET_FUNC_IN_JOS
	//if ( trFunc.strVal.Compare(STR_MORE_FUNCTIONS) == 0 )
	if( compare_string_localization(trFunc.strVal, STR_MORE_FUNCTIONS) )
	///End FIX_FAIL_SET_FUNC_IN_JOS
	{
		string		strFunc;
		trFunc.GetAttribute(STR_CURRENT_FUNCTION, strFunc);
		trFunc.strVal = strFunc;
		///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
		//_edit_func_list_button_event(tr, DynaCntrlContainer);
		string		strSelectedFunc;
		_edit_func_list_button_event(tr, DynaCntrlContainer, &strSelectedFunc);
		if ( !strSelectedFunc.IsEmpty() )
		{
			trFunc.strVal = strSelectedFunc;
			trFunc.SetAttribute(STR_CURRENT_FUNCTION, strSelectedFunc);
		}
		///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
	}
	else
	{
		trFunc.SetAttribute(STR_CURRENT_FUNCTION, trFunc.strVal);
	}
}

void	quickfit_update_function_list(TreeNode& tr)
{
	TreeNode	trMode = tr.mode;
	TreeNode	trFunc = tr.func;
	if ( !trMode || !trFunc )
	{
		ASSERT(FALSE);
		return;
	}

	int nFuncMode = (QUICK_FIT_MODE_LR == trMode.nVal) ? QUICK_FIT_LR_MODE_FUNCS : QUICK_FIT_NL_MODE_FUNCS;
	
	vector<string> vsFuncs;
	int		nCount = quick_fit_get_func_list(vsFuncs, nFuncMode);

	if ( 0 == nCount )
		vsFuncs.Add(" ");
	
	vsFuncs.Add(STR_MORE_FUNCTIONS);
	
	string strFuncList;
	strFuncList.SetTokens(vsFuncs, '|'); 
	if( vsFuncs.GetSize() <= 1 )
		strFuncList += "|";
	trFunc.SetAttribute(STR_COMBO_ATTRIB, strFuncList);
	
	if( trFunc.IsEmpty() || vsFuncs.Find(trFunc.strVal) < 0 )
	{
		trFunc.strVal = vsFuncs[0];
	}
	
	trFunc.SetAttribute(STR_CURRENT_FUNCTION, trFunc.strVal);
}

static	void _quick_fit_update_param_list(TreeNode& trGetN)
{
	vector<string> vsParams;
	string strFunc = trGetN.func.strVal;
	int nOrder = quick_fit_get_order(trGetN.mode.nVal, strFunc);
	quick_fit_get_func_param_list(vsParams, nOrder, strFunc);
	TreeNode trParams = trGetN.trroi.Params;
	///Sophy 3/2/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
	if ( !trParams )
		trParams = trGetN.ROI.Params;
	ASSERT(trParams);
	if ( !trParams )
		return;
	///end UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
	TreeNode trParam = trParams.FirstNode;
	
	for(int ii=0; ii < vsParams.GetSize(); ii++)
	{
		trParam.SetAttribute(STR_LABEL_ATTRIB, vsParams[ii]);
		trParam.Show = true;
		trParam = trParam.NextNode;
	}
	
	while(trParam)
	{
		trParam.Show = false;
		trParam = trParam.NextNode;
	}
}

void	quickfit_update_on_mode_function_change(TreeNode& tr, int nSelRoiTop/* = -1*/)
{
	_quick_fit_update_param_list(tr);
	///Sophy 3/2/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
	//quick_fit_update_output_choice_on_mode_change(tr, tr.trtable);
	//quick_fit_update_output_choice_on_mode_change(tr, tr.trreport);
	TreeNode trReport, trTable, trROI;
	trReport = tr.trreport ? tr.trreport : tr.Report;
	trTable = tr.trtable ? tr.trtable : tr.Table;
	trROI = tr.trroi ? tr.trroi : tr.ROI;
	///end UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
	quick_fit_update_output_choice_on_mode_change(tr, trTable);
	quick_fit_update_output_choice_on_mode_change(tr, trReport);
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//quick_fit_update_roi_show_top(tr.trroi.ShowTop, tr.trtable, nSelRoiTop);
	///Sophy 3/2/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
	//quick_fit_update_output_choice_on_mode_change(tr, tr.trroi.ShowTop);
	quick_fit_update_output_choice_on_mode_change(tr, trROI.ShowTop);
	///end UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
}

static	bool quickfit_on_mode_change(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	quickfit_update_function_list(trGUI);
	quickfit_update_on_mode_function_change(trGUI);
	return true;
}

static	bool quickfit_on_func_change_ex(TreeNode& trGUI, int nRow, int nCol, TreeNode& trNode, DWORD dwCntrl, int nType, WndContainer& theDlg)
{
	quickfit_on_func_change(trGUI, theDlg);
	quickfit_update_on_mode_function_change(trGUI);
	return true;
}
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU


/// Hong 02/20/10 QA80-14832 CENTRALIZE_CODE
bool	quickfit_get_source_dataplot(DataPlot& dp, GraphLayer& glSrc/* = NULL*/)
{
	GraphLayer		gl = Project.ActiveLayer();
	if( !gl )
		return false;
	
	if ( glSrc )
		glSrc = gl;
	
	/// Iris 2/20/2010 QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT
	//dp = gl.DataPlots();
	dp = gl.DataPlots(get_selected_data_plot());
	///End QUICKFIT_SHOULD_USE_SELECTED_PLOT_NOT_ACTIVE_PLOT_AS_INPUT
	
	string 			strRect;
	if ( get_gl_quick_fit_rect_go_name(gl, strRect) )
	{
		GraphObject	goRect = gl.GraphObjects(strRect);
		if ( goRect )
			///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
			//dp = gl.DataPlots(quickf_fit_get_source_data_plot_index_from_ROI(goRect));
			dp = gl.DataPlots(get_source_data_plot_index_from_ROI(goRect));
			///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
	}
	
	return dp.IsValid();
}
/// end CENTRALIZE_CODE


/// Iris 2/25/2010 TO_PREVENT_MOVE_ROI_WHEN_LOAD_THEME
bool quick_fit_check_update_roi_x_position(TreeNode& trROI)
{
	if( trROI.XScale.fixscale.nVal ) // Fixed checkbox default is unchecked, if it is fixed load from theme, should use x position settings in theme.
		return false; // trROI not changed
	
	GraphLayer gl = Project.ActiveLayer();
	string strRect;
	///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT, centralize this code to GraphObjTools.h as check_get_roi_x_position()
	/*
	if( !get_gl_quick_fit_rect_go_name(gl, strRect) ) // if not QuickFit ROI on graph
	{
		quickfit_get_auto_x_range(trROI.XScale.leftx, trROI.XScale.rightx); // get init x position		
	}
	else
	{
		// get fixed status and then current ROI position, then update GUI
		GraphObject go = gl.GraphObjects(strRect);
		ASSERT(go);
		if( go )
		{			
			FRECT rr;
			if( get_go_rect(go, rr) )
			{
				DataPlot dp = gl.DataPlots(quickf_fit_get_source_data_plot_index_from_ROI(go));
				ASSERT(dp);
				
				if( dp )
				{
					trROI.XScale.leftx.strVal = get_value_by_format(dp, rr.left);
					trROI.XScale.rightx.strVal = get_value_by_format(dp, rr.right);
				}
			}
		}		
	}
	*/
	if( !get_gl_quick_fit_rect_go_name(gl, strRect) )
		strRect.Empty();

	string strLeft, strRight;
	if( check_get_roi_x_position(gl, strLeft, strRight, strRect) )
	{
		trROI.XScale.leftx.strVal = strLeft;
		trROI.XScale.rightx.strVal = strRight;
	}
	///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
	return true; // x postion settings in trROI changed
}
///End TO_PREVENT_MOVE_ROI_WHEN_LOAD_THEME

///Sophy 3/1/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
string	get_output_range_str(int nOutputType)
{
	bool bNewBook = OUTPUT_FIT_CURVE_TO_NEW_BOOK == nOutputType ? true : false;
	bool bNewSheet = OUTPUT_FIT_CURVE_TO_INPUT_SHEET == nOutputType ? false: true;
	
	string strBook, strSheet;
	strBook = strSheet = "<input>";
	string strNew = "<new name:=%s>";
	if( bNewBook )
		strBook.Format(strNew, STR_NEW_FIT_CURVE_BOOK_NAME);
	if( bNewSheet )
		strSheet.Format(strNew, STR_NEW_FIT_CURVE_SHEET_NAME);
	
	string strOutputRange;
	strOutputRange.Format("[%s]%s!%s", strBook, strSheet, "<new>");
	return strOutputRange;
}
///end UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI


/// Kenny 03/04/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
int quickfit_get_fit_line_auto_color(int nDefaultColor /*= SYSCOLOR_BLUE*/, const DataPlot& srcDataPlot /*= NULL*/)
{
	int nColor = nDefaultColor;
	DataPlot dp;
	if ( srcDataPlot && srcDataPlot.IsValid() )
		dp = srcDataPlot;
	else
		quickfit_get_source_dataplot(dp);

	if ( dp.IsValid() )
	{
		int nSourcePlotColor = get_plot_color(dp);
		///------ Folger 09/19/2010 ORG-1095-P1 QUICK_FIT_CURVE_COLOR_FOLLOW_SOURCE_IF_SCATTER
		if ( IDM_PLOT_SCATTER == dp.GetPlotType() )
		{
			nColor = nSourcePlotColor;
		}
		else
		///------ End QUICK_FIT_CURVE_COLOR_FOLLOW_SOURCE_IF_SCATTER
		if( nSourcePlotColor == nColor )
		{
			nColor = nSourcePlotColor + 1;
		}
	}
	return nColor;
}
/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
